/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityMobs;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;

public class EntityCreeper
extends EntityMobs {
    int field_764_a;
    int field_763_b;
    int field_766_c;
    int field_765_d;

    public EntityCreeper(World world) {
        super(world);
        this.scoreYield = 50;
        this.field_766_c = 30;
        this.field_765_d = -1;
        this.texture = "/mob/creeper.png";
    }

    @Override
    public void addNBTTag(NBTTagCompound nbttagcompound) {
        super.addNBTTag(nbttagcompound);
    }

    @Override
    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        super.removeNBTTag(nbttagcompound);
    }

    @Override
    protected void updateEntityActionState() {
        this.field_763_b = this.field_764_a;
        if (this.field_764_a > 0 && this.field_765_d < 0) {
            --this.field_764_a;
        }
        if (this.field_765_d >= 0) {
            this.field_765_d = 2;
        }
        super.updateEntityActionState();
        if (this.field_765_d != 1) {
            this.field_765_d = -1;
        }
    }

    @Override
    protected String hurtSound() {
        return "mob.creeper";
    }

    @Override
    protected String deathSound() {
        return "mob.creeperdeath";
    }

    @Override
    public void died(Entity entity) {
        super.died(entity);
        if (entity instanceof EntitySkeleton) {
            this.func_367_b(Item.record13.swiftedIndex + this.rand.nextInt(2), 1);
        }
    }

    @Override
    protected void attackEntity(Entity entity, float f) {
        if (this.field_765_d <= 0 && f < 3.0f || this.field_765_d > 0 && f < 7.0f) {
            if (this.field_764_a == 0) {
                this.worldObj.playSoundAtEntity(this, "random.fuse", 1.0f, 0.5f);
            }
            this.field_765_d = 1;
            ++this.field_764_a;
            if (this.field_764_a == this.field_766_c) {
                this.worldObj.func_676_a(this, this.posX, this.posY, this.posZ, 3.0f);
                this.func_395_F();
            }
            this.hasAttacked = true;
        }
    }

    public float func_440_b(float f) {
        return ((float)this.field_763_b + (float)(this.field_764_a - this.field_763_b) * f) / (float)(this.field_766_c - 2);
    }

    @Override
    protected int deathDropItem() {
        return Item.gunpowder.swiftedIndex;
    }
}

