/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockStairs
extends Block {
    private Block field_452_a;

    protected BlockStairs(int i, Block block) {
        super(i, block.textureIndex, block.material);
        this.field_452_a = block;
        this.setBreakability(block.field_374_bd);
        this.setHardness(block.hardness / 3.0f);
        this.setSound(block.stepSound);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean func_242_c() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 10;
    }

    @Override
    public boolean isVertexInBlock(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return super.isVertexInBlock(iblockaccess, i, j, k, l);
    }

    @Override
    public void setCollisionBlock(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList<AxisAlignedBB> arraylist) {
        int l = world.getBlockSomethingIDK(i, j, k);
        if (l == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 2) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.field_1026_y) {
            return;
        }
        if (world.getMaterialXYZ(i, j + 1, k).isSolidMaterial()) {
            world.setBlock(i, j, k, this.field_452_a.blockID);
        } else {
            this.func_276_h(world, i, j, k);
            this.func_276_h(world, i + 1, j - 1, k);
            this.func_276_h(world, i - 1, j - 1, k);
            this.func_276_h(world, i, j - 1, k - 1);
            this.func_276_h(world, i, j - 1, k + 1);
            this.func_276_h(world, i + 1, j + 1, k);
            this.func_276_h(world, i - 1, j + 1, k);
            this.func_276_h(world, i, j + 1, k - 1);
            this.func_276_h(world, i, j + 1, k + 1);
        }
        this.field_452_a.onNeighborBlockChange(world, i, j, k, l);
    }

    private void func_276_h(World world, int i, int j, int k) {
        if (!this.func_278_j(world, i, j, k)) {
            return;
        }
        int byte0 = -1;
        if (this.func_278_j(world, i + 1, j + 1, k)) {
            byte0 = 0;
        }
        if (this.func_278_j(world, i - 1, j + 1, k)) {
            byte0 = 1;
        }
        if (this.func_278_j(world, i, j + 1, k + 1)) {
            byte0 = 2;
        }
        if (this.func_278_j(world, i, j + 1, k - 1)) {
            byte0 = 3;
        }
        if (byte0 < 0) {
            if (this.func_277_i(world, i + 1, j, k) && !this.func_277_i(world, i - 1, j, k)) {
                byte0 = 0;
            }
            if (this.func_277_i(world, i - 1, j, k) && !this.func_277_i(world, i + 1, j, k)) {
                byte0 = 1;
            }
            if (this.func_277_i(world, i, j, k + 1) && !this.func_277_i(world, i, j, k - 1)) {
                byte0 = 2;
            }
            if (this.func_277_i(world, i, j, k - 1) && !this.func_277_i(world, i, j, k + 1)) {
                byte0 = 3;
            }
        }
        if (byte0 < 0) {
            if (this.func_278_j(world, i - 1, j - 1, k)) {
                byte0 = 0;
            }
            if (this.func_278_j(world, i + 1, j - 1, k)) {
                byte0 = 1;
            }
            if (this.func_278_j(world, i, j - 1, k - 1)) {
                byte0 = 2;
            }
            if (this.func_278_j(world, i, j - 1, k + 1)) {
                byte0 = 3;
            }
        }
        if (byte0 >= 0) {
            world.func_691_b(i, j, k, byte0);
        }
    }

    private boolean func_277_i(World world, int i, int j, int k) {
        return world.getMaterialXYZ(i, j, k).isSolidMaterial();
    }

    private boolean func_278_j(World world, int i, int j, int k) {
        int l = world.getBlock(i, j, k);
        if (l == 0) {
            return false;
        }
        return Block.allBlocks[l].getRenderType() == 10;
    }

    @Override
    public void func_247_b(World world, int i, int j, int k, Random random) {
    }

    @Override
    public void func_233_b(World world, int i, int j, int k, EntityPlayer entityplayer) {
    }

    @Override
    public void onBreak(World world, int i, int j, int k, int l) {
        EntityItem entityitem = new EntityItem(world, i, j, k, new ItemStack(this.blockID));
        entityitem.field_805_c = 10;
        world.addNewEntity(entityitem);
        this.field_452_a.onBreak(world, i, j, k, l);
    }

    @Override
    public float func_241_c(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.field_452_a.func_241_c(iblockaccess, i, j, k);
    }

    @Override
    public float func_227_a(Entity entity) {
        return this.field_452_a.func_227_a(entity);
    }

    @Override
    public int func_234_g() {
        return this.field_452_a.func_234_g();
    }

    @Override
    public int createBlockEntity(int i, Random random) {
        return this.blockID;
    }

    @Override
    public int dropChance(Random random) {
        return 1;
    }

    @Override
    public int getTextureIndex(int i, int j) {
        return this.field_452_a.getTextureIndex(i, j);
    }

    @Override
    public int getTextureIndex(int i) {
        return this.field_452_a.getTextureIndex(i);
    }

    @Override
    public int getTextureIndex(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.field_452_a.getTextureIndex(iblockaccess, i, j, k, l);
    }

    @Override
    public int func_206_a() {
        return this.field_452_a.func_206_a();
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return this.field_452_a.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public void func_257_a(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
        this.field_452_a.func_257_a(world, i, j, k, entity, vec3d);
    }

    @Override
    public boolean renderAsNormalBlock() {
        return this.field_452_a.renderAsNormalBlock();
    }

    @Override
    public boolean func_224_a(int i, boolean flag) {
        return this.field_452_a.func_224_a(i, flag);
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        return this.field_452_a.canPlace(world, i, j, k);
    }

    @Override
    public void onPlace(World world, int i, int j, int k) {
        this.onNeighborBlockChange(world, i, j, k, 0);
        this.field_452_a.onPlace(world, i, j, k);
    }

    @Override
    public void onRemove(World world, int i, int j, int k) {
    }

    @Override
    public void dropBlockAsItem(World world, int i, int j, int k, int l, float f) {
    }

    @Override
    public void func_259_b_(World world, int i, int j, int k, int l) {
    }

    @Override
    public void func_254_a(World world, int i, int j, int k, Entity entity) {
    }

    @Override
    public void update(World world, int i, int j, int k, Random random) {
        this.field_452_a.update(world, i, j, k, random);
    }

    @Override
    public boolean func_250_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return this.field_452_a.func_250_a(world, i, j, k, entityplayer);
    }

    @Override
    public void func_239_c(World world, int i, int j, int k) {
    }
}

