/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.enums.EnumMobType;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.List;
import java.util.Random;

public class BlockPressurePlate
extends Block {
    private EnumMobType field_467_a;

    protected BlockPressurePlate(int i, int j, EnumMobType enummobtype) {
        super(i, j, Material.rock);
        this.field_467_a = enummobtype;
        this.setTickRandomly(true);
        float f = 0.0625f;
        this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
    }

    public int func_206_a() {
        return 20;
    }

    public AxisAlignedBB func_221_d(World world, int i, int j, int k) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean func_242_c() {
        return false;
    }

    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k);
    }

    public void onPlace(World world, int i, int j, int k) {
    }

    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        boolean flag = false;
        if (!world.isBlockNormalCube(i, j - 1, k)) {
            flag = true;
        }
        if (flag) {
            this.func_259_b_(world, i, j, k, world.getBlockSomethingIDK(i, j, k));
            world.setBlock(i, j, k, 0);
        }
    }

    public void update(World world, int i, int j, int k, Random random) {
        if (world.getBlockSomethingIDK(i, j, k) == 0) {
            return;
        }
        this.func_318_h(world, i, j, k);
    }

    public void func_236_b(World world, int i, int j, int k, Entity entity) {
        if (world.getBlockSomethingIDK(i, j, k) == 1) {
            return;
        }
        this.func_318_h(world, i, j, k);
    }

    private void func_318_h(World world, int i, int j, int k) {
        boolean flag = world.getBlockSomethingIDK(i, j, k) == 1;
        boolean flag1 = false;
        float f = 0.125f;
        List<Entity> list = null;
        if (this.field_467_a == EnumMobType.everything) {
            list = world.func_659_b(null, AxisAlignedBB.func_1161_b((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (this.field_467_a == EnumMobType.mobs) {
            list = world.func_657_a(EntityLiving.class, AxisAlignedBB.func_1161_b((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (this.field_467_a == EnumMobType.players) {
            list = world.func_657_a(EntityPlayer.class, AxisAlignedBB.func_1161_b((float)i + f, j, (float)k + f, (float)(i + 1) - f, (double)j + 0.25, (float)(k + 1) - f));
        }
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            world.func_691_b(i, j, k, 1);
            world.triggerUpdate(i, j, k, this.blockID);
            world.triggerUpdate(i, j - 1, k, this.blockID);
            world.setBlock(i, j, k, i, j, k);
            world.playSound((double)i + 0.5, (double)j + 0.1, (double)k + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!flag1 && flag) {
            world.func_691_b(i, j, k, 0);
            world.triggerUpdate(i, j, k, this.blockID);
            world.triggerUpdate(i, j - 1, k, this.blockID);
            world.setBlock(i, j, k, i, j, k);
            world.playSound((double)i + 0.5, (double)j + 0.1, (double)k + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (flag1) {
            world.func_681_h(i, j, k, this.blockID);
        }
    }

    public void onRemove(World world, int i, int j, int k) {
        int l = world.getBlockSomethingIDK(i, j, k);
        if (l > 0) {
            world.triggerUpdate(i, j, k, this.blockID);
            world.triggerUpdate(i, j - 1, k, this.blockID);
        }
        super.onRemove(world, i, j, k);
    }

    public void func_238_a(IBlockAccess iblockaccess, int i, int j, int k) {
        boolean flag = iblockaccess.getBlockSomethingIDK(i, j, k) == 1;
        float f = 0.0625f;
        if (flag) {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.03125f, 1.0f - f);
        } else {
            this.setBlockBounds(f, 0.0f, f, 1.0f - f, 0.0625f, 1.0f - f);
        }
    }

    public boolean func_231_b(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return iblockaccess.getBlockSomethingIDK(i, j, k) > 0;
    }

    public boolean func_228_c(World world, int i, int j, int k, int l) {
        if (world.getBlockSomethingIDK(i, j, k) == 0) {
            return false;
        }
        return l == 1;
    }

    public boolean func_209_d() {
        return true;
    }

    public void func_237_e() {
        float f = 0.5f;
        float f1 = 0.125f;
        float f2 = 0.5f;
        this.setBlockBounds(0.5f - f, 0.5f - f1, 0.5f - f2, 0.5f + f, 0.5f + f1, 0.5f + f2);
    }
}

