/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFlower;
import java.util.Random;

public class BlockCrops
extends BlockFlower {
    protected BlockCrops(int i, int j) {
        super(i, j);
        this.textureIndex = j;
        this.setTickRandomly(true);
        float f = 0.5f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
    }

    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        return i == Block.tilledField.blockID;
    }

    public void update(World world, int i, int j, int k, Random random) {
        float f;
        int l;
        super.update(world, i, j, k, random);
        if (world.func_618_j(i, j + 1, k) >= 9 && (l = world.getBlockSomethingIDK(i, j, k)) < 7 && random.nextInt((int)(100.0f / (f = this.func_270_i(world, i, j, k)))) == 0) {
            world.func_691_b(i, j, k, ++l);
        }
    }

    private float func_270_i(World world, int i, int j, int k) {
        float f = 1.0f;
        int l = world.getBlock(i, j, k - 1);
        int i1 = world.getBlock(i, j, k + 1);
        int j1 = world.getBlock(i - 1, j, k);
        int k1 = world.getBlock(i + 1, j, k);
        int l1 = world.getBlock(i - 1, j, k - 1);
        int i2 = world.getBlock(i + 1, j, k - 1);
        int j2 = world.getBlock(i + 1, j, k + 1);
        int k2 = world.getBlock(i - 1, j, k + 1);
        boolean flag = j1 == this.blockID || k1 == this.blockID;
        boolean flag1 = l == this.blockID || i1 == this.blockID;
        boolean flag2 = l1 == this.blockID || i2 == this.blockID || j2 == this.blockID || k2 == this.blockID;
        int l2 = i - 1;
        while (l2 <= i + 1) {
            int i3 = k - 1;
            while (i3 <= k + 1) {
                int j3 = world.getBlock(l2, j - 1, i3);
                float f1 = 0.0f;
                if (j3 == Block.tilledField.blockID) {
                    f1 = 1.0f;
                    if (world.getBlockSomethingIDK(l2, j - 1, i3) > 0) {
                        f1 = 3.0f;
                    }
                }
                if (l2 != i || i3 != k) {
                    f1 /= 4.0f;
                }
                f += f1;
                ++i3;
            }
            ++l2;
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        return f;
    }

    public int getTextureIndex(int i, int j) {
        if (j < 0) {
            j = 7;
        }
        return this.textureIndex + j;
    }

    public int getRenderType() {
        return 6;
    }

    public void onBreak(World world, int i, int j, int k, int l) {
        super.onBreak(world, i, j, k, l);
        int i1 = 0;
        while (i1 < 3) {
            if (world.field_1037_n.nextInt(15) <= l) {
                float f = 0.7f;
                float f1 = world.field_1037_n.nextFloat() * f + (1.0f - f) * 0.5f;
                float f2 = world.field_1037_n.nextFloat() * f + (1.0f - f) * 0.5f;
                float f3 = world.field_1037_n.nextFloat() * f + (1.0f - f) * 0.5f;
                EntityItem entityitem = new EntityItem(world, (float)i + f1, (float)j + f2, (float)k + f3, new ItemStack(Item.seeds));
                entityitem.field_805_c = 10;
                world.addNewEntity(entityitem);
            }
            ++i1;
        }
    }

    public int createBlockEntity(int i, Random random) {
        System.out.println("Get resource: " + i);
        if (i == 7) {
            return Item.wheat.swiftedIndex;
        }
        return -1;
    }

    public int dropChance(Random random) {
        return 1;
    }
}

