/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.item.ItemTool;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;

public class ItemPickaxe
extends ItemTool {
    private static Block[] pickaxeBreakList = new Block[]{Block.cobblestone, Block.stairDouble, Block.stairSingle, Block.stone, Block.cobblestoneMossy, Block.oreIron, Block.blockSteel, Block.oreCoal, Block.blockGold, Block.oreGold, Block.oreDiamond, Block.blockDiamond, Block.ice, Block.oreRedstone, Block.oreRedstoneGlowing, Block.stoneOvenIdle, Block.stoneOvenActive, Block.brick, Block.minecartTrack};
    private int miningPower;

    public ItemPickaxe(int i, int miningPower) {
        super(i, 2, miningPower, pickaxeBreakList);
        this.isGold = i == 27 || i == 28 || i == 29 || i == 30;
        this.miningPower = miningPower;
    }

    public boolean breaking(Block block) {
        if (block == Block.glass || block == Block.ice) {
            return this.isGold;
        }
        if (block == Block.obsidian) {
            return this.miningPower >= 3;
        }
        if (block == Block.blockDiamond || block == Block.oreDiamond) {
            return this.miningPower >= 2;
        }
        if (block == Block.blockGold || block == Block.oreGold) {
            return this.miningPower >= 2;
        }
        if (block == Block.blockSteel || block == Block.oreIron) {
            return this.miningPower >= 1;
        }
        if (block == Block.oreRedstone || block == Block.oreRedstoneGlowing) {
            return this.miningPower >= 2;
        }
        if (block.material == Material.rock) {
            return true;
        }
        return block.material == Material.iron;
    }
}

