/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityAnimals;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.WorldClient;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.nbt.NBTTagCompound;

public class EntitySheep
extends EntityAnimals {
    int field_754_i = 0;
    public boolean isSheared = false;

    public EntitySheep(World world) {
        super(world);
        this.scoreYield = 10;
        this.field_754_i = 0;
        this.texture = "/mob/sheep.png";
        this.setBounds(0.9f, 1.3f);
    }

    public boolean attacked(Entity entity, int i) {
        if (!this.isSheared && entity instanceof EntityLiving && !(this.worldObj instanceof WorldClient)) {
            this.isSheared = true;
            int j = 1 + this.rand.nextInt(3);
            int k = 0;
            while (k < j) {
                EntityItem entityitem = this.dropItem(Block.cloth.blockID, 1, 1.0f);
                entityitem.motionY += (double)(this.rand.nextFloat() * 0.05f);
                entityitem.motionX += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                entityitem.motionZ += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                this.field_754_i = this.rand.nextInt(1200);
                ++k;
            }
        }
        return super.attacked(entity, i);
    }

    public void entityMove() {
        super.entityMove();
        if (this.isSheared && --this.field_754_i <= 0) {
            this.worldObj.func_623_a(this, "mob.chickenplop", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            this.isSheared = false;
        }
    }

    public void addNBTTag(NBTTagCompound nbttagcompound) {
        super.addNBTTag(nbttagcompound);
        nbttagcompound.setBool("Sheared", this.isSheared);
    }

    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        super.removeNBTTag(nbttagcompound);
        this.isSheared = nbttagcompound.tag("Sheared");
    }

    protected String idleSound() {
        return "mob.sheep";
    }

    protected String hurtSound() {
        return "mob.sheep";
    }

    protected String deathSound() {
        return "mob.sheep";
    }
}

