/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityCreature;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.IMobs;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntityMobs
extends EntityCreature
implements IMobs {
    protected int maxHealth = 2;
    public double currentSpeed;

    public EntityMobs(World world) {
        super(world);
        this.health = 20;
        this.currentSpeed = 0.5;
        this.isRunning = true;
    }

    public void entityMove() {
        float f = this.func_382_a(1.0f);
        if (f > 0.5f) {
            this.field_701_U += 2;
        }
        super.entityMove();
    }

    public void enterWater() {
        super.enterWater();
        if (this.worldObj.difficulty == 0) {
            this.func_395_F();
        }
    }

    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.worldObj.func_609_a(this, 16.0);
        if (entityplayer != null && this.canEntityBeSeen(entityplayer)) {
            return entityplayer;
        }
        return null;
    }

    public boolean attacked(Entity entity, int i) {
        if (super.attacked(entity, i)) {
            if (this.field_617_ae == entity || this.field_616_af == entity) {
                return true;
            }
            if (entity != this) {
                this.entityToAttack = entity;
            }
            return true;
        }
        return false;
    }

    protected void attackEntity(Entity entity, float f) {
        if ((double)f < 2.5 && entity.boundingBox.field_1702_e > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.field_1702_e) {
            this.attackTime = 20;
            entity.attacked(this, this.maxHealth);
        }
    }

    protected float getBlockPathWeight(int i, int j, int k) {
        return 0.5f - this.worldObj.func_598_c(i, j, k);
    }

    public void addNBTTag(NBTTagCompound nbttagcompound) {
        super.addNBTTag(nbttagcompound);
    }

    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        super.removeNBTTag(nbttagcompound);
    }

    public boolean func_433_a() {
        int k;
        int j;
        int i = MathHelper.floor_double(this.posX);
        if (this.worldObj.getBlockLighting(EnumSkyBlock.Sky, i, j = MathHelper.floor_double(this.boundingBox.minY), k = MathHelper.floor_double(this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int l = this.worldObj.func_618_j(i, j, k);
        return l <= this.rand.nextInt(8) && super.func_433_a();
    }

    public double getRealMoveSpeed() {
        return this.currentSpeed;
    }
}

