/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class World
implements IBlockAccess {
    public static final int NORMAL = 0;
    public static final int FLOATING = 1;
    public static final int CORRUPTION = 2;
    public static final int DESERT = 3;
    public static final HashMap<Integer, String> TYPENAMES = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "NORMAL");
            this.put(1, "FLOATING");
            this.put(2, "CORRUPTION");
            this.put(3, "DESERT");
        }
    };
    public float cloudHeight;
    private List<MetadataChunkBlock> field_1025_z;
    public List<Entity> field_1050_a;
    private List<?> field_1024_A;
    private TreeSet<NextTickListEntry> field_1023_B;
    private Set<NextTickListEntry> field_1022_C;
    public List field_1049_b;
    public long worldTime;
    public boolean snowCovered;
    private long field_1021_D;
    private long field_1020_E;
    private long field_1019_F;
    public int field_1046_e;
    protected int field_1045_f;
    protected int field_1044_g;
    public boolean field_1043_h;
    public static float[] field_1042_i = new float[16];
    private final long field_1018_G;
    protected int field_1041_j;
    public List<EntityPlayer> playerEntities;
    public int difficulty;
    public Object field_1038_m;
    public Random field_1037_n;
    public int spawnX;
    public int spawnY;
    public int spawnZ;
    public boolean field_1033_r;
    protected List<IWorldAccess> field_1032_s;
    public IChunkProvider chunkProvider;
    public File field_1031_t;
    public long randomSeed;
    private NBTTagCompound nbtCompoundPlayer;
    public long sizeOnDisk;
    public final String field_1028_w;
    public boolean field_1027_x;
    private ArrayList<AxisAlignedBB> field_1015_J;
    private Set<ChunkCoordIntPair> field_1014_K;
    private int field_1013_L;
    private List<Entity> field_1012_M;
    public boolean field_1026_y;
    public boolean cheatsDisabled;
    public int worldType;

    static {
        float f2 = 0.05f;
        int i2 = 0;
        while (i2 <= 15) {
            float f1 = 1.0f - (float)i2 / 15.0f;
            World.field_1042_i[i2] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f2) + f2;
            ++i2;
        }
    }

    public static NBTTagCompound func_629_a(File file, String s2) {
        File file1 = new File(file, "saves");
        File file2 = new File(file1, s2);
        if (!file2.exists()) {
            return null;
        }
        File file3 = new File(file2, "level.dat");
        if (file3.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(new FileInputStream(file3));
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_743_k("Data");
                return nbttagcompound1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static void func_615_b(File file, String s2) {
        File file1 = new File(file, "saves");
        File file2 = new File(file1, s2);
        if (!file2.exists()) {
            return;
        }
        World.func_653_a(file2.listFiles());
        file2.delete();
    }

    private static void func_653_a(File[] afile) {
        int i2 = 0;
        while (i2 < afile.length) {
            if (afile[i2].isDirectory()) {
                World.func_653_a(afile[i2].listFiles());
            }
            afile[i2].delete();
            ++i2;
        }
    }

    public World(File file, String s2, boolean snow, boolean cheatsDisabled, int worldType) {
        this(file, s2, new Random().nextLong(), snow, cheatsDisabled, worldType);
    }

    public World(String s2) {
        this.field_1025_z = new ArrayList<MetadataChunkBlock>();
        this.field_1050_a = new ArrayList<Entity>();
        this.field_1024_A = new ArrayList();
        this.field_1023_B = new TreeSet();
        this.field_1022_C = new HashSet<NextTickListEntry>();
        this.field_1049_b = new ArrayList();
        this.worldTime = 0L;
        this.snowCovered = false;
        this.field_1021_D = 0x88BBFFL;
        this.field_1020_E = 12638463L;
        this.field_1019_F = 0xFFFFFFL;
        this.field_1046_e = 0;
        this.field_1045_f = new Random().nextInt();
        this.field_1044_g = 1013904223;
        this.field_1043_h = false;
        this.field_1018_G = System.currentTimeMillis();
        this.field_1041_j = 40;
        this.playerEntities = new ArrayList<EntityPlayer>();
        this.field_1037_n = new Random();
        this.field_1033_r = false;
        this.field_1032_s = new ArrayList<IWorldAccess>();
        this.randomSeed = 0L;
        this.sizeOnDisk = 0L;
        this.field_1015_J = new ArrayList();
        this.field_1014_K = new HashSet<ChunkCoordIntPair>();
        this.field_1013_L = this.field_1037_n.nextInt(12000);
        this.field_1012_M = new ArrayList<Entity>();
        this.field_1026_y = false;
        this.field_1028_w = s2;
        this.chunkProvider = this.func_610_a(this.field_1031_t);
        this.func_644_f();
    }

    public World(File file, String s2, long l2, boolean snowCovereds, boolean cheatsDisableds, int worldTypes) {
        this.cheatsDisabled = cheatsDisableds;
        this.field_1025_z = new ArrayList<MetadataChunkBlock>();
        this.field_1050_a = new ArrayList<Entity>();
        this.field_1024_A = new ArrayList();
        this.field_1023_B = new TreeSet();
        this.field_1022_C = new HashSet<NextTickListEntry>();
        this.field_1049_b = new ArrayList();
        this.worldTime = 0L;
        this.snowCovered = snowCovereds;
        this.worldType = worldTypes;
        this.field_1021_D = 0x88BBFFL;
        this.field_1020_E = 12638463L;
        this.field_1019_F = 0xFFFFFFL;
        this.field_1046_e = 0;
        this.field_1045_f = new Random().nextInt();
        this.field_1044_g = 1013904223;
        this.field_1043_h = false;
        this.field_1018_G = System.currentTimeMillis();
        this.field_1041_j = 40;
        this.playerEntities = new ArrayList<EntityPlayer>();
        this.field_1037_n = new Random();
        this.field_1033_r = false;
        this.field_1032_s = new ArrayList<IWorldAccess>();
        this.randomSeed = 0L;
        this.sizeOnDisk = 0L;
        this.field_1015_J = new ArrayList();
        this.field_1014_K = new HashSet<ChunkCoordIntPair>();
        this.field_1013_L = this.field_1037_n.nextInt(12000);
        this.field_1012_M = new ArrayList<Entity>();
        this.field_1026_y = false;
        this.field_1028_w = s2;
        file.mkdirs();
        this.field_1031_t = new File(file, s2);
        this.field_1031_t.mkdirs();
        try {
            File file1 = new File(this.field_1031_t, "session.lock");
            try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));){
                dataoutputstream.writeLong(this.field_1018_G);
            }
        }
        catch (IOException ioexception) {
            throw new RuntimeException("Failed to check session lock, aborting");
        }
        File file2 = new File(this.field_1031_t, "level.dat");
        boolean bl2 = this.field_1033_r = !file2.exists();
        if (file2.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(new FileInputStream(file2));
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_743_k("Data");
                this.randomSeed = nbttagcompound1.func_764_f("RandomSeed");
                this.spawnX = nbttagcompound1.func_756_e("SpawnX");
                this.spawnY = nbttagcompound1.func_756_e("SpawnY");
                this.spawnZ = nbttagcompound1.func_756_e("SpawnZ");
                this.worldTime = nbttagcompound1.func_764_f("Time");
                this.sizeOnDisk = nbttagcompound1.func_764_f("SizeOnDisk");
                this.snowCovered = nbttagcompound1.tag("SnowCovered");
                this.cheatsDisabled = nbttagcompound1.tag("cheatsDisabled");
                this.worldType = nbttagcompound1.tag("isFloating") ? 1 : nbttagcompound1.func_756_e("WorldType");
                if (nbttagcompound1.func_751_b("Player")) {
                    this.nbtCompoundPlayer = nbttagcompound1.func_743_k("Player");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean flag = false;
        if (this.randomSeed == 0L) {
            this.randomSeed = l2;
            flag = true;
        }
        this.chunkProvider = this.func_610_a(this.field_1031_t);
        if (flag) {
            this.field_1027_x = true;
            this.spawnX = 0;
            this.spawnY = 64;
            this.spawnZ = 0;
            while (!this.func_703_f(this.spawnX, this.spawnZ)) {
                this.spawnX += this.field_1037_n.nextInt(64) - this.field_1037_n.nextInt(64);
                this.spawnZ += this.field_1037_n.nextInt(64) - this.field_1037_n.nextInt(64);
            }
            this.field_1027_x = false;
        }
        this.func_644_f();
    }

    protected IChunkProvider func_610_a(File file) {
        if (this.worldType == 1) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderSky(this, this.randomSeed));
        }
        if (this.worldType == 2) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderCorruption(this, this.randomSeed));
        }
        if (this.worldType == 3) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderDesert(this, this.randomSeed));
        }
        return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderGenerate(this, this.randomSeed));
    }

    public void func_622_a() {
        if (this.spawnY <= 0) {
            this.spawnY = 64;
        }
        while (this.func_614_g(this.spawnX, this.spawnZ) == 0) {
            this.spawnX += this.field_1037_n.nextInt(8) - this.field_1037_n.nextInt(8);
            this.spawnZ += this.field_1037_n.nextInt(8) - this.field_1037_n.nextInt(8);
        }
    }

    private boolean func_703_f(int i2, int j2) {
        int k2 = this.func_614_g(i2, j2);
        if (this.worldType == 1 || this.worldType == 2 || this.worldType == 3) {
            return k2 == Block.grass.blockID;
        }
        return k2 == Block.sand.blockID;
    }

    private int func_614_g(int i2, int j2) {
        int k2 = 63;
        while (this.getBlock(i2, k2 + 1, j2) != 0) {
            ++k2;
        }
        return this.getBlock(i2, k2, j2);
    }

    public void func_608_a(EntityPlayer entityplayer) {
        try {
            if (this.nbtCompoundPlayer != null) {
                entityplayer.func_368_e(this.nbtCompoundPlayer);
                this.nbtCompoundPlayer = null;
            }
            this.func_674_a(entityplayer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void func_639_a(boolean flag, IProgressUpdate iprogressupdate) {
        if (!this.chunkProvider.unknownBoolean2()) {
            return;
        }
        if (iprogressupdate != null) {
            iprogressupdate.func_594_b("Saving level");
        }
        this.func_669_m();
        if (iprogressupdate != null) {
            iprogressupdate.func_595_d("Saving chunks");
        }
        this.chunkProvider.booleanProgress(flag, iprogressupdate);
    }

    private void func_669_m() {
        this.func_663_l();
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setLong("RandomSeed", this.randomSeed);
        nbttagcompound.setInteger("SpawnX", this.spawnX);
        nbttagcompound.setInteger("SpawnY", this.spawnY);
        nbttagcompound.setInteger("SpawnZ", this.spawnZ);
        nbttagcompound.setLong("Time", this.worldTime);
        nbttagcompound.setLong("SizeOnDisk", this.sizeOnDisk);
        nbttagcompound.setBool("SnowCovered", this.snowCovered);
        nbttagcompound.setBool("cheatsDisabled", this.cheatsDisabled);
        nbttagcompound.setInteger("WorldType", this.worldType);
        nbttagcompound.setLong("LastPlayed", System.currentTimeMillis());
        EntityPlayer entityplayer = null;
        if (this.playerEntities.size() > 0) {
            entityplayer = this.playerEntities.get(0);
        }
        if (entityplayer != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            entityplayer.func_363_d(nbttagcompound1);
            nbttagcompound.func_763_a("Player", nbttagcompound1);
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.func_762_a("Data", nbttagcompound);
        try {
            File file = new File(this.field_1031_t, "level.dat_new");
            File file1 = new File(this.field_1031_t, "level.dat_old");
            File file2 = new File(this.field_1031_t, "level.dat");
            CompressedStreamTools.func_1143_a(nbttagcompound2, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean func_650_a(int i2) {
        if (!this.chunkProvider.unknownBoolean2()) {
            return true;
        }
        if (i2 == 0) {
            this.func_669_m();
        }
        return this.chunkProvider.booleanProgress(false, null);
    }

    @Override
    public int getBlock(int i2, int j2, int k2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return 0;
        }
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= 128) {
            return 0;
        }
        return this.func_704_b(i2 >> 4, k2 >> 4).func_1008_a(i2 & 0xF, j2, k2 & 0xF);
    }

    public boolean func_630_d(int i2, int j2, int k2) {
        if (j2 < 0 || j2 >= 128) {
            return false;
        }
        return this.func_620_h(i2 >> 4, k2 >> 4);
    }

    public boolean func_640_a(int i2, int j2, int k2, int l2, int i1, int j1) {
        if (i1 < 0 || j2 >= 128) {
            return false;
        }
        i2 >>= 4;
        j2 >>= 4;
        k2 >>= 4;
        l2 >>= 4;
        i1 >>= 4;
        j1 >>= 4;
        int k1 = i2;
        while (k1 <= l2) {
            int l1 = k2;
            while (l1 <= j1) {
                if (!this.func_620_h(k1, l1)) {
                    return false;
                }
                ++l1;
            }
            ++k1;
        }
        return true;
    }

    private boolean func_620_h(int i2, int j2) {
        return this.chunkProvider.unknownBoolean(i2, j2);
    }

    public Chunk func_673_a(int i2, int j2) {
        return this.func_704_b(i2 >> 4, j2 >> 4);
    }

    public Chunk func_704_b(int i2, int j2) {
        return this.chunkProvider.getChunkAt(i2, j2);
    }

    public boolean func_643_a(int i2, int j2, int k2, int l2, int i1) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return false;
        }
        if (j2 < 0) {
            return false;
        }
        if (j2 >= 128) {
            return false;
        }
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        return chunk.func_1010_a(i2 & 0xF, j2, k2 & 0xF, l2, i1);
    }

    public boolean func_634_a(int i2, int j2, int k2, int l2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return false;
        }
        if (j2 < 0) {
            return false;
        }
        if (j2 >= 128) {
            return false;
        }
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        return chunk.func_1022_a(i2 & 0xF, j2, k2 & 0xF, l2);
    }

    @Override
    public Material getMaterialXYZ(int i2, int j2, int k2) {
        int l2 = this.getBlock(i2, j2, k2);
        if (l2 == 0) {
            return Material.air;
        }
        return Block.allBlocks[l2].material;
    }

    @Override
    public int func_602_e(int i2, int j2, int k2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return 0;
        }
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= 128) {
            return 0;
        }
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        return chunk.func_1021_b(i2 &= 0xF, j2, k2 &= 0xF);
    }

    public void func_691_b(int i2, int j2, int k2, int l2) {
        this.func_635_c(i2, j2, k2, l2);
    }

    public boolean func_635_c(int i2, int j2, int k2, int l2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return false;
        }
        if (j2 < 0) {
            return false;
        }
        if (j2 >= 128) {
            return false;
        }
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        chunk.func_1009_b(i2 &= 0xF, j2, k2 &= 0xF, l2);
        return true;
    }

    public boolean setBlock(int i2, int j2, int k2, int l2) {
        if (this.func_634_a(i2, j2, k2, l2)) {
            this.func_617_e(i2, j2, k2, l2);
            return true;
        }
        return false;
    }

    public boolean func_688_b(int i2, int j2, int k2, int l2, int i1) {
        if (this.func_643_a(i2, j2, k2, l2, i1)) {
            this.func_617_e(i2, j2, k2, l2);
            return true;
        }
        return false;
    }

    public void func_665_h(int i2, int j2, int k2) {
        int l2 = 0;
        while (l2 < this.field_1032_s.size()) {
            this.field_1032_s.get(l2).func_934_a(i2, j2, k2);
            ++l2;
        }
    }

    protected void func_617_e(int i2, int j2, int k2, int l2) {
        this.func_665_h(i2, j2, k2);
        this.triggerUpdate(i2, j2, k2, l2);
    }

    public void func_680_f(int i2, int j2, int k2, int l2) {
        if (k2 > l2) {
            int i1 = l2;
            l2 = k2;
            k2 = i1;
        }
        this.func_701_b(i2, k2, j2, i2, l2, j2);
    }

    public void func_701_b(int i2, int j2, int k2, int l2, int i1, int j1) {
        int k1 = 0;
        while (k1 < this.field_1032_s.size()) {
            this.field_1032_s.get(k1).func_937_b(i2, j2, k2, l2, i1, j1);
            ++k1;
        }
    }

    public void triggerUpdate(int i2, int j2, int k2, int l2) {
        this.func_655_l(i2 - 1, j2, k2, l2);
        this.func_655_l(i2 + 1, j2, k2, l2);
        this.func_655_l(i2, j2 - 1, k2, l2);
        this.func_655_l(i2, j2 + 1, k2, l2);
        this.func_655_l(i2, j2, k2 - 1, l2);
        this.func_655_l(i2, j2, k2 + 1, l2);
    }

    private void func_655_l(int i2, int j2, int k2, int l2) {
        if (this.field_1043_h || this.field_1026_y) {
            return;
        }
        Block block = Block.allBlocks[this.getBlock(i2, j2, k2)];
        if (block != null) {
            block.onNeighborBlockChange(this, i2, j2, k2, l2);
        }
    }

    public boolean func_647_i(int i2, int j2, int k2) {
        return this.func_704_b(i2 >> 4, k2 >> 4).func_1007_c(i2 & 0xF, j2, k2 & 0xF);
    }

    public int func_618_j(int i2, int j2, int k2) {
        return this.func_699_a(i2, j2, k2, true);
    }

    public int func_699_a(int i2, int j2, int k2, boolean flag) {
        int l2;
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return 15;
        }
        if (flag && ((l2 = this.getBlock(i2, j2, k2)) == Block.stairSingle.blockID || l2 == Block.tilledField.blockID)) {
            int j1 = this.func_699_a(i2, j2 + 1, k2, false);
            int k1 = this.func_699_a(i2 + 1, j2, k2, false);
            int l1 = this.func_699_a(i2 - 1, j2, k2, false);
            int i22 = this.func_699_a(i2, j2, k2 + 1, false);
            int j22 = this.func_699_a(i2, j2, k2 - 1, false);
            if (k1 > j1) {
                j1 = k1;
            }
            if (l1 > j1) {
                j1 = l1;
            }
            if (i22 > j1) {
                j1 = i22;
            }
            if (j22 > j1) {
                j1 = j22;
            }
            return j1;
        }
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= 128) {
            int i1 = 15 - this.field_1046_e;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        return chunk.func_1019_c(i2 &= 0xF, j2, k2 &= 0xF, this.field_1046_e);
    }

    public boolean func_708_k(int i2, int j2, int k2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return false;
        }
        if (j2 < 0) {
            return false;
        }
        if (j2 >= 128) {
            return true;
        }
        if (!this.func_620_h(i2 >> 4, k2 >> 4)) {
            return false;
        }
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        return chunk.func_1007_c(i2 &= 0xF, j2, k2 &= 0xF);
    }

    public int func_666_c(int i2, int j2) {
        if (i2 < -32000000 || j2 < -32000000 || i2 >= 32000000 || j2 > 32000000) {
            return 0;
        }
        if (!this.func_620_h(i2 >> 4, j2 >> 4)) {
            return 0;
        }
        Chunk chunk = this.func_704_b(i2 >> 4, j2 >> 4);
        return chunk.func_999_b(i2 & 0xF, j2 & 0xF);
    }

    public void func_631_a(EnumSkyBlock enumskyblock, int i2, int j2, int k2, int l2) {
        int i1;
        if (!this.func_630_d(i2, j2, k2)) {
            return;
        }
        if (enumskyblock == EnumSkyBlock.Sky) {
            if (this.func_708_k(i2, j2, k2)) {
                l2 = 15;
            }
        } else if (enumskyblock == EnumSkyBlock.Block && Block.field_339_t[i1 = this.getBlock(i2, j2, k2)] > l2) {
            l2 = Block.field_339_t[i1];
        }
        if (this.func_641_a(enumskyblock, i2, j2, k2) != l2) {
            this.func_616_a(enumskyblock, i2, j2, k2, i2, j2, k2);
        }
    }

    public int func_641_a(EnumSkyBlock enumskyblock, int i2, int j2, int k2) {
        if (j2 < 0 || j2 >= 128 || i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return enumskyblock.field_1722_c;
        }
        int l2 = i2 >> 4;
        int i1 = k2 >> 4;
        if (!this.func_620_h(l2, i1)) {
            return 0;
        }
        Chunk chunk = this.func_704_b(l2, i1);
        return chunk.func_1025_a(enumskyblock, i2 & 0xF, j2, k2 & 0xF);
    }

    public void func_664_b(EnumSkyBlock enumskyblock, int i2, int j2, int k2, int l2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return;
        }
        if (j2 < 0) {
            return;
        }
        if (j2 >= 128) {
            return;
        }
        if (!this.func_620_h(i2 >> 4, k2 >> 4)) {
            return;
        }
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        chunk.func_1011_a(enumskyblock, i2 & 0xF, j2, k2 & 0xF, l2);
        int i1 = 0;
        while (i1 < this.field_1032_s.size()) {
            this.field_1032_s.get(i1).func_934_a(i2, j2, k2);
            ++i1;
        }
    }

    @Override
    public float func_598_c(int i2, int j2, int k2) {
        return field_1042_i[this.func_618_j(i2, j2, k2)];
    }

    public boolean func_624_b() {
        return this.field_1046_e < 4;
    }

    public MovingObjectPosition func_645_a(Vec3D vec3d, Vec3D vec3d1) {
        return this.func_642_a(vec3d, vec3d1, false);
    }

    public MovingObjectPosition func_642_a(Vec3D vec3d, Vec3D vec3d1, boolean flag) {
        if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
            return null;
        }
        if (Double.isNaN(vec3d1.xCoord) || Double.isNaN(vec3d1.yCoord) || Double.isNaN(vec3d1.zCoord)) {
            return null;
        }
        int i2 = MathHelper.floor_double(vec3d1.xCoord);
        int j2 = MathHelper.floor_double(vec3d1.yCoord);
        int k2 = MathHelper.floor_double(vec3d1.zCoord);
        int l2 = MathHelper.floor_double(vec3d.xCoord);
        int i1 = MathHelper.floor_double(vec3d.yCoord);
        int j1 = MathHelper.floor_double(vec3d.zCoord);
        int k1 = 20;
        while (k1-- >= 0) {
            MovingObjectPosition movingobjectposition;
            if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
                return null;
            }
            if (l2 == i2 && i1 == j2 && j1 == k2) {
                return null;
            }
            double d2 = 999.0;
            double d1 = 999.0;
            double d22 = 999.0;
            if (i2 > l2) {
                d2 = (double)l2 + 1.0;
            }
            if (i2 < l2) {
                d2 = (double)l2 + 0.0;
            }
            if (j2 > i1) {
                d1 = (double)i1 + 1.0;
            }
            if (j2 < i1) {
                d1 = (double)i1 + 0.0;
            }
            if (k2 > j1) {
                d22 = (double)j1 + 1.0;
            }
            if (k2 < j1) {
                d22 = (double)j1 + 0.0;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec3d1.xCoord - vec3d.xCoord;
            double d7 = vec3d1.yCoord - vec3d.yCoord;
            double d8 = vec3d1.zCoord - vec3d.zCoord;
            if (d2 != 999.0) {
                d3 = (d2 - vec3d.xCoord) / d6;
            }
            if (d1 != 999.0) {
                d4 = (d1 - vec3d.yCoord) / d7;
            }
            if (d22 != 999.0) {
                d5 = (d22 - vec3d.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i2 > l2 ? 4 : 5;
                vec3d.xCoord = d2;
                vec3d.yCoord += d7 * d3;
                vec3d.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j2 > i1 ? 0 : 1;
                vec3d.xCoord += d6 * d4;
                vec3d.yCoord = d1;
                vec3d.zCoord += d8 * d4;
            } else {
                byte0 = k2 > j1 ? 2 : 3;
                vec3d.xCoord += d6 * d5;
                vec3d.yCoord += d7 * d5;
                vec3d.zCoord = d22;
            }
            Vec3D vec3d2 = Vec3D.func_1248_b(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
            vec3d2.xCoord = MathHelper.floor_double(vec3d.xCoord);
            l2 = (int)vec3d2.xCoord;
            if (byte0 == 5) {
                --l2;
                vec3d2.xCoord += 1.0;
            }
            vec3d2.yCoord = MathHelper.floor_double(vec3d.yCoord);
            i1 = (int)vec3d2.yCoord;
            if (byte0 == 1) {
                --i1;
                vec3d2.yCoord += 1.0;
            }
            vec3d2.zCoord = MathHelper.floor_double(vec3d.zCoord);
            j1 = (int)vec3d2.zCoord;
            if (byte0 == 3) {
                --j1;
                vec3d2.zCoord += 1.0;
            }
            int l1 = this.getBlock(l2, i1, j1);
            int i22 = this.func_602_e(l2, i1, j1);
            Block block = Block.allBlocks[l1];
            if (l1 <= 0 || !block.func_224_a(i22, flag) || (movingobjectposition = block.func_255_a(this, l2, i1, j1, vec3d, vec3d1)) == null) continue;
            return movingobjectposition;
        }
        return null;
    }

    public void func_623_a(Entity entity, String s2, float f2, float f1) {
        int i2 = 0;
        while (i2 < this.field_1032_s.size()) {
            this.field_1032_s.get(i2).func_940_a(s2, entity.posX, entity.posY - (double)entity.eyeHeight, entity.posZ, f2, f1);
            ++i2;
        }
    }

    public void func_684_a(double d2, double d1, double d22, String s2, float f2, float f1) {
        int i2 = 0;
        while (i2 < this.field_1032_s.size()) {
            this.field_1032_s.get(i2).func_940_a(s2, d2, d1, d22, f2, f1);
            ++i2;
        }
    }

    public void func_670_a(String s2, int i2, int j2, int k2) {
        int l2 = 0;
        while (l2 < this.field_1032_s.size()) {
            this.field_1032_s.get(l2).func_933_a(s2, i2, j2, k2);
            ++l2;
        }
    }

    public void func_694_a(String s2, double d2, double d1, double d22, double d3, double d4, double d5) {
        int i2 = 0;
        while (i2 < this.field_1032_s.size()) {
            try {
                this.field_1032_s.get(i2).func_939_a(s2, d2, d1, d22, d3, d4, d5);
            }
            catch (Exception ex2) {
                System.out.println("Tried to render non-existant entity! Left server?");
            }
            ++i2;
        }
    }

    public boolean func_674_a(Entity entity) {
        int i2 = MathHelper.floor_double(entity.posX / 16.0);
        int j2 = MathHelper.floor_double(entity.posZ / 16.0);
        boolean flag = false;
        if (entity instanceof EntityPlayer) {
            flag = true;
        }
        if (flag || this.func_620_h(i2, j2)) {
            if (entity instanceof EntityPlayer) {
                this.playerEntities.add((EntityPlayer)entity);
                System.out.println("Player count: " + this.playerEntities.size());
            }
            this.func_704_b(i2, j2).func_1000_a(entity);
            this.field_1050_a.add(entity);
            this.func_606_b(entity);
            return true;
        }
        return false;
    }

    protected void func_606_b(Entity entity) {
        int i2 = 0;
        while (i2 < this.field_1032_s.size()) {
            this.field_1032_s.get(i2).func_941_a(entity);
            ++i2;
        }
    }

    protected void func_678_c(Entity entity) {
        int i2 = 0;
        while (i2 < this.field_1032_s.size()) {
            this.field_1032_s.get(i2).func_938_b(entity);
            ++i2;
        }
    }

    public void func_607_d(Entity entity) {
        entity.func_395_F();
        if (entity instanceof EntityPlayer) {
            this.playerEntities.remove((EntityPlayer)entity);
            System.out.println("Player count: " + this.playerEntities.size());
        }
    }

    public void func_613_a(IWorldAccess iworldaccess) {
        this.field_1032_s.add(iworldaccess);
    }

    public void func_672_b(IWorldAccess iworldaccess) {
        this.field_1032_s.remove(iworldaccess);
    }

    public List<AxisAlignedBB> func_697_a(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_1015_J.clear();
        int i2 = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j2 = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = i1;
            while (l1 < j1) {
                if (this.func_630_d(k1, 64, l1)) {
                    int i22 = k2 - 1;
                    while (i22 < l2) {
                        Block block = Block.allBlocks[this.getBlock(k1, i22, l1)];
                        if (block != null) {
                            block.func_230_a(this, k1, i22, l1, axisalignedbb, this.field_1015_J);
                        }
                        ++i22;
                    }
                }
                ++l1;
            }
            ++k1;
        }
        double d2 = 0.25;
        List<Entity> list = this.func_659_b(entity, axisalignedbb.func_1177_b(d2, d2, d2));
        int j22 = 0;
        while (j22 < list.size()) {
            AxisAlignedBB axisalignedbb1 = list.get(j22).func_372_f_();
            if (axisalignedbb1 != null && axisalignedbb1.func_1178_a(axisalignedbb)) {
                this.field_1015_J.add(axisalignedbb1);
            }
            if ((axisalignedbb1 = entity.func_383_b_(list.get(j22))) != null && axisalignedbb1.func_1178_a(axisalignedbb)) {
                this.field_1015_J.add(axisalignedbb1);
            }
            ++j22;
        }
        return this.field_1015_J;
    }

    public int func_671_a(float f2) {
        float f1 = this.func_619_c(f2);
        float f22 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f);
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        return (int)(f22 * 11.0f);
    }

    public Vec3D func_626_b(float f2) {
        float f1 = this.func_619_c(f2);
        float f22 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        float f3 = (float)(this.field_1021_D >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_1021_D >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_1021_D & 0xFFL) / 255.0f;
        return Vec3D.func_1248_b(f3 *= f22, f4 *= f22, f5 *= f22);
    }

    public float func_619_c(float f2) {
        int i2 = (int)(this.worldTime % 24000L);
        float f1 = ((float)i2 + f2) / 24000.0f - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f22 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f22 + (f1 - f22) / 3.0f;
        return f1;
    }

    public Vec3D func_628_d(float f2) {
        float f1 = this.func_619_c(f2);
        float f22 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        float f3 = (float)(this.field_1019_F >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_1019_F >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_1019_F & 0xFFL) / 255.0f;
        return Vec3D.func_1248_b(f3 *= f22 * 0.9f + 0.1f, f4 *= f22 * 0.9f + 0.1f, f5 *= f22 * 0.85f + 0.15f);
    }

    public Vec3D func_686_e(float f2) {
        float f1 = this.func_619_c(f2);
        float f22 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        float f3 = (float)(this.field_1020_E >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_1020_E >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_1020_E & 0xFFL) / 255.0f;
        return Vec3D.func_1248_b(f3 *= f22 * 0.94f + 0.06f, f4 *= f22 * 0.94f + 0.06f, f5 *= f22 * 0.91f + 0.09f);
    }

    public int func_685_d(int i2, int j2) {
        Chunk chunk = this.func_673_a(i2, j2);
        i2 &= 0xF;
        j2 &= 0xF;
        for (int k2 = 127; k2 > 0; --k2) {
            int l2 = chunk.func_1008_a(i2, k2, j2);
            if (l2 == 0 || !Block.allBlocks[l2].material.blocksMovement() && !Block.allBlocks[l2].material.func_879_d()) {
                continue;
            }
            return k2 + 1;
        }
        return -1;
    }

    public int func_696_e(int i2, int j2) {
        return this.func_673_a(i2, j2).func_999_b(i2 & 0xF, j2 & 0xF);
    }

    public float func_679_f(float f2) {
        float f1 = this.func_619_c(f2);
        float f22 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.75f);
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        return f22 * f22 * 0.5f;
    }

    public void func_681_h(int i2, int j2, int k2, int l2) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(i2, j2, k2, l2);
        int byte0 = 8;
        if (this.func_640_a(i2 - byte0, j2 - byte0, k2 - byte0, i2 + byte0, j2 + byte0, k2 + byte0)) {
            if (l2 > 0) {
                nextticklistentry.func_900_a((long)Block.allBlocks[l2].func_206_a() + this.worldTime);
            }
            if (!this.field_1022_C.contains(nextticklistentry)) {
                this.field_1022_C.add(nextticklistentry);
                this.field_1023_B.add(nextticklistentry);
            }
        }
    }

    public void func_633_c() {
        this.field_1050_a.removeAll(this.field_1024_A);
        int i2 = 0;
        while (i2 < this.field_1024_A.size()) {
            Entity entity = (Entity)this.field_1024_A.get(i2);
            int i1 = entity.field_657_ba;
            int k1 = entity.field_654_bc;
            if (entity.field_621_aZ && this.func_620_h(i1, k1)) {
                this.func_704_b(i1, k1).func_1015_b(entity);
            }
            ++i2;
        }
        int j2 = 0;
        while (j2 < this.field_1024_A.size()) {
            this.func_678_c((Entity)this.field_1024_A.get(j2));
            ++j2;
        }
        this.field_1024_A.clear();
        int k2 = 0;
        while (k2 < this.field_1050_a.size()) {
            block12: {
                Entity entity1;
                block11: {
                    entity1 = this.field_1050_a.get(k2);
                    if (entity1.field_616_af == null) break block11;
                    if (!entity1.field_616_af.hasDied && entity1.field_616_af.field_617_ae == entity1) break block12;
                    entity1.field_616_af.field_617_ae = null;
                    entity1.field_616_af = null;
                }
                if (!entity1.hasDied) {
                    this.func_667_e(entity1);
                }
                if (entity1.hasDied) {
                    int j1 = entity1.field_657_ba;
                    int l1 = entity1.field_654_bc;
                    if (entity1.field_621_aZ && this.func_620_h(j1, l1)) {
                        this.func_704_b(j1, l1).func_1015_b(entity1);
                    }
                    this.field_1050_a.remove(k2--);
                    this.func_678_c(entity1);
                }
            }
            ++k2;
        }
        int l2 = 0;
        while (l2 < this.field_1049_b.size()) {
            TileEntity tileentity = (TileEntity)this.field_1049_b.get(l2);
            tileentity.func_475_b();
            ++l2;
        }
    }

    protected void func_667_e(Entity entity) {
        int j2;
        int byte0;
        int i2 = MathHelper.floor_double(entity.posX);
        if (!this.func_640_a(i2 - (byte0 = 16), 0, (j2 = MathHelper.floor_double(entity.posZ)) - byte0, i2 + byte0, 128, j2 + byte0)) {
            return;
        }
        entity.field_638_aI = entity.posX;
        entity.field_637_aJ = entity.posY;
        entity.field_636_aK = entity.posZ;
        entity.headYaw = entity.rotationYaw;
        entity.headPitch = entity.rotationPitch;
        if (entity.field_616_af != null) {
            entity.func_350_p();
        } else {
            entity.enterWater();
        }
        int k2 = MathHelper.floor_double(entity.posX / 16.0);
        int l2 = MathHelper.floor_double(entity.posY / 16.0);
        int i1 = MathHelper.floor_double(entity.posZ / 16.0);
        if (!entity.field_621_aZ || entity.field_657_ba != k2 || entity.field_656_bb != l2 || entity.field_654_bc != i1) {
            if (entity.field_621_aZ && this.func_620_h(entity.field_657_ba, entity.field_654_bc)) {
                this.func_704_b(entity.field_657_ba, entity.field_654_bc).func_1016_a(entity, entity.field_656_bb);
            }
            if (this.func_620_h(k2, i1)) {
                this.func_704_b(k2, i1).func_1000_a(entity);
            } else {
                entity.field_621_aZ = false;
                System.out.println("Removing entity because it's not in a chunk!!");
                entity.func_395_F();
            }
        }
        if (entity.field_617_ae != null) {
            if (entity.field_617_ae.hasDied || entity.field_617_ae.field_616_af != entity) {
                entity.field_617_ae.field_616_af = null;
                entity.field_617_ae = null;
            } else {
                this.func_667_e(entity.field_617_ae);
            }
        }
        if (Double.isNaN(entity.posX) || Double.isInfinite(entity.posX)) {
            entity.posX = entity.field_638_aI;
        }
        if (Double.isNaN(entity.posY) || Double.isInfinite(entity.posY)) {
            entity.posY = entity.field_637_aJ;
        }
        if (Double.isNaN(entity.posZ) || Double.isInfinite(entity.posZ)) {
            entity.posZ = entity.field_636_aK;
        }
        if (Double.isNaN(entity.rotationPitch) || Double.isInfinite(entity.rotationPitch)) {
            entity.rotationPitch = entity.headPitch;
        }
        if (Double.isNaN(entity.rotationYaw) || Double.isInfinite(entity.rotationYaw)) {
            entity.rotationYaw = entity.headYaw;
        }
    }

    public boolean func_604_a(AxisAlignedBB axisalignedbb) {
        List<Entity> list = this.func_659_b(null, axisalignedbb);
        int i2 = 0;
        while (i2 < list.size()) {
            Entity entity = list.get(i2);
            if (!entity.hasDied && entity.field_618_ad) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean func_662_b(AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j2 = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        if (axisalignedbb.field_1698_a < 0.0) {
            --i2;
        }
        if (axisalignedbb.minY < 0.0) {
            --k2;
        }
        if (axisalignedbb.field_1704_c < 0.0) {
            --i1;
        }
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    Block block = Block.allBlocks[this.getBlock(k1, l1, i22)];
                    if (block != null && block.material.func_879_d()) {
                        return true;
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean func_605_c(AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j2 = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    int j22 = this.getBlock(k1, l1, i22);
                    if (j22 == Block.fire.blockID || j22 == Block.lavaMoving.blockID || j22 == Block.lavaStill.blockID) {
                        return true;
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean func_682_a(AxisAlignedBB axisalignedbb, Material material, Entity entity) {
        int i2 = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j2 = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        boolean flag = false;
        Vec3D vec3d = Vec3D.func_1248_b(0.0, 0.0, 0.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    double d1;
                    Block block = Block.allBlocks[this.getBlock(k1, l1, i22)];
                    if (block != null && block.material == material && (double)l2 >= (d1 = (double)((float)(l1 + 1) - BlockFluids.func_288_b(this.func_602_e(k1, l1, i22))))) {
                        flag = true;
                        block.func_257_a(this, k1, l1, i22, entity, vec3d);
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        if (vec3d.func_1253_c() > 0.0) {
            vec3d = vec3d.func_1252_b();
            double d2 = 0.004;
            entity.motionX += vec3d.xCoord * d2;
            entity.motionY += vec3d.yCoord * d2;
            entity.motionZ += vec3d.zCoord * d2;
        }
        return flag;
    }

    public boolean func_689_a(AxisAlignedBB axisalignedbb, Material material) {
        int i2 = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j2 = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    Block block = Block.allBlocks[this.getBlock(k1, l1, i22)];
                    if (block != null && block.material == material) {
                        return true;
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean func_707_b(AxisAlignedBB axisalignedbb, Material material) {
        int i2 = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j2 = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        int k1 = i2;
        while (k1 < j2) {
            int l1 = k2;
            while (l1 < l2) {
                int i22 = i1;
                while (i22 < j1) {
                    Block block = Block.allBlocks[this.getBlock(k1, l1, i22)];
                    if (block != null && block.material == material) {
                        int j22 = this.func_602_e(k1, l1, i22);
                        double d2 = l1 + 1;
                        if (j22 < 8) {
                            d2 = (double)(l1 + 1) - (double)j22 / 8.0;
                        }
                        if (d2 >= axisalignedbb.minY) {
                            return true;
                        }
                    }
                    ++i22;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public void func_676_a(Entity entity, double d2, double d1, double d22, float f2) {
        new Explosion().func_901_a(this, entity, d2, d1, d22, f2);
    }

    public float func_675_a(Vec3D vec3d, AxisAlignedBB axisalignedbb) {
        double d2 = 1.0 / ((axisalignedbb.field_1703_d - axisalignedbb.field_1698_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.field_1702_e - axisalignedbb.minY) * 2.0 + 1.0);
        double d22 = 1.0 / ((axisalignedbb.field_1701_f - axisalignedbb.field_1704_c) * 2.0 + 1.0);
        int i2 = 0;
        int j2 = 0;
        float f2 = 0.0f;
        while (f2 <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f22 = 0.0f;
                while (f22 <= 1.0f) {
                    double d3 = axisalignedbb.field_1698_a + (axisalignedbb.field_1703_d - axisalignedbb.field_1698_a) * (double)f2;
                    double d4 = axisalignedbb.minY + (axisalignedbb.field_1702_e - axisalignedbb.minY) * (double)f1;
                    double d5 = axisalignedbb.field_1704_c + (axisalignedbb.field_1701_f - axisalignedbb.field_1704_c) * (double)f22;
                    if (this.func_645_a(Vec3D.func_1248_b(d3, d4, d5), vec3d) == null) {
                        ++i2;
                    }
                    ++j2;
                    f22 = (float)((double)f22 + d22);
                }
                f1 = (float)((double)f1 + d1);
            }
            f2 = (float)((double)f2 + d2);
        }
        return (float)i2 / (float)j2;
    }

    public void func_612_i(int i2, int j2, int k2, int l2) {
        if (l2 == 0) {
            --j2;
        }
        if (l2 == 1) {
            ++j2;
        }
        if (l2 == 2) {
            --k2;
        }
        if (l2 == 3) {
            ++k2;
        }
        if (l2 == 4) {
            --i2;
        }
        if (l2 == 5) {
            ++i2;
        }
        if (this.getBlock(i2, j2, k2) == Block.fire.blockID) {
            this.func_684_a((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, "random.fizz", 0.5f, 2.6f + (this.field_1037_n.nextFloat() - this.field_1037_n.nextFloat()) * 0.8f);
            this.setBlock(i2, j2, k2, 0);
        }
    }

    public Entity func_661_a(Class<?> class1) {
        return null;
    }

    public String func_687_d() {
        return "All: " + this.field_1050_a.size();
    }

    @Override
    public TileEntity genTileEntityWorld(int i2, int j2, int k2) {
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        if (chunk != null) {
            return chunk.genTileEntity(i2 & 0xF, j2, k2 & 0xF);
        }
        return null;
    }

    public void func_654_a(int i2, int j2, int k2, TileEntity tileentity) {
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        if (chunk != null) {
            chunk.func_1005_a(i2 & 0xF, j2, k2 & 0xF, tileentity);
        }
    }

    public void func_692_l(int i2, int j2, int k2) {
        Chunk chunk = this.func_704_b(i2 >> 4, k2 >> 4);
        if (chunk != null) {
            chunk.func_1023_e(i2 & 0xF, j2, k2 & 0xF);
        }
    }

    @Override
    public boolean isBlockNormalCube(int i2, int j2, int k2) {
        Block block = Block.allBlocks[this.getBlock(i2, j2, k2)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public boolean isWater(int i2, int j2, int k2) {
        Block block = Block.allBlocks[this.getBlock(i2, j2, k2)];
        if (block == null) {
            return false;
        }
        return block.material == Material.water;
    }

    public void func_651_a(IProgressUpdate iprogressupdate) {
        this.func_639_a(true, iprogressupdate);
    }

    public boolean func_638_e() {
        int i2 = 1000;
        while (this.field_1025_z.size() > 0) {
            if (--i2 <= 0) {
                return true;
            }
            this.field_1025_z.remove(this.field_1025_z.size() - 1).func_865_a(this);
        }
        return false;
    }

    public void func_616_a(EnumSkyBlock enumskyblock, int i2, int j2, int k2, int l2, int i1, int j1) {
        this.func_627_a(enumskyblock, i2, j2, k2, l2, i1, j1, true);
    }

    public void func_627_a(EnumSkyBlock enumskyblock, int i2, int j2, int k2, int l2, int i1, int j1, boolean flag) {
        int k1 = (l2 + i2) / 2;
        int l1 = (j1 + k2) / 2;
        if (!this.func_630_d(k1, 64, l1)) {
            return;
        }
        int i22 = this.field_1025_z.size();
        if (flag) {
            int j22 = 4;
            if (j22 > i22) {
                j22 = i22;
            }
            int k22 = 0;
            while (k22 < j22) {
                MetadataChunkBlock metadatachunkblock = this.field_1025_z.get(this.field_1025_z.size() - k22 - 1);
                if (metadatachunkblock.field_1299_a == enumskyblock && metadatachunkblock.func_866_a(i2, j2, k2, l2, i1, j1)) {
                    return;
                }
                ++k22;
            }
        }
        this.field_1025_z.add(new MetadataChunkBlock(enumskyblock, i2, j2, k2, l2, i1, j1));
    }

    public void func_644_f() {
        int i2 = this.func_671_a(1.0f);
        if (i2 != this.field_1046_e) {
            this.field_1046_e = i2;
        }
    }

    public void func_649_g() {
        this.chunkProvider.unknownBoolean1();
        int i2 = this.func_671_a(1.0f);
        if (i2 != this.field_1046_e) {
            this.field_1046_e = i2;
            int j2 = 0;
            while (j2 < this.field_1032_s.size()) {
                this.field_1032_s.get(j2).func_936_e();
                ++j2;
            }
        }
        ++this.worldTime;
        if (this.worldTime % (long)this.field_1041_j == 0L) {
            this.func_639_a(false, null);
        }
        this.func_700_a(false);
        this.func_652_h();
    }

    protected void func_652_h() {
        this.field_1014_K.clear();
        int i2 = 0;
        while (i2 < this.playerEntities.size()) {
            EntityPlayer entityplayer = this.playerEntities.get(i2);
            int j2 = MathHelper.floor_double(entityplayer.posX / 16.0);
            int l2 = MathHelper.floor_double(entityplayer.posZ / 16.0);
            int byte0 = 9;
            int j1 = -byte0;
            while (j1 <= byte0) {
                int j22 = -byte0;
                while (j22 <= byte0) {
                    this.field_1014_K.add(new ChunkCoordIntPair(j1 + j2, j22 + l2));
                    ++j22;
                }
                ++j1;
            }
            ++i2;
        }
        if (this.field_1013_L > 0) {
            --this.field_1013_L;
        }
        for (ChunkCoordIntPair chunkcoordintpair : this.field_1014_K) {
            int k2 = chunkcoordintpair.field_189_a * 16;
            int i1 = chunkcoordintpair.field_188_b * 16;
            Chunk chunk = this.func_704_b(chunkcoordintpair.field_189_a, chunkcoordintpair.field_188_b);
            if (this.field_1013_L == 0) {
                EntityPlayer entityplayer1;
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                int k1 = this.field_1045_f >> 2;
                int k22 = k1 & 0xF;
                int j3 = k1 >> 8 & 0xF;
                int i4 = k1 >> 16 & 0x7F;
                int l4 = chunk.func_1008_a(k22, i4, j3);
                if (l4 == 0 && this.func_618_j(k22 += k2, i4, j3 += i1) <= this.field_1037_n.nextInt(8) && this.func_641_a(EnumSkyBlock.Sky, k22, i4, j3) <= 0 && (entityplayer1 = this.func_683_a((double)k22 + 0.5, (double)i4 + 0.5, (double)j3 + 0.5, 8.0)) != null && entityplayer1.func_360_d((double)k22 + 0.5, (double)i4 + 0.5, (double)j3 + 0.5) > 4.0) {
                    this.func_684_a((double)k22 + 0.5, (double)i4 + 0.5, (double)j3 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.field_1037_n.nextFloat() * 0.2f);
                    this.field_1013_L = this.field_1037_n.nextInt(12000) + 6000;
                }
            }
            if (this.snowCovered && this.field_1037_n.nextInt(4) == 0) {
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                int l1 = this.field_1045_f >> 2;
                int l2 = l1 & 0xF;
                int k3 = l1 >> 8 & 0xF;
                int j4 = this.func_685_d(l2 + k2, k3 + i1);
                if (j4 >= 0 && j4 < 128 && chunk.func_1025_a(EnumSkyBlock.Block, l2, j4, k3) < 10) {
                    int i5 = chunk.func_1008_a(l2, j4 - 1, k3);
                    if (chunk.func_1008_a(l2, j4, k3) == 0 && Block.snow.func_243_a(this, l2 + k2, j4, k3 + i1)) {
                        this.setBlock(l2 + k2, j4, k3 + i1, Block.snow.blockID);
                    }
                    if (i5 == Block.waterStill.blockID && chunk.func_1021_b(l2, j4 - 1, k3) == 0) {
                        this.setBlock(l2 + k2, j4 - 1, k3 + i1, Block.ice.blockID);
                    }
                }
            }
            int i22 = 0;
            while (i22 < 80) {
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                int i3 = this.field_1045_f >> 2;
                int l3 = i3 & 0xF;
                int k4 = i3 >> 8 & 0xF;
                int j5 = i3 >> 16 & 0x7F;
                byte byte1 = chunk.blocks[l3 << 11 | k4 << 7 | j5];
                if (Block.field_344_o[byte1]) {
                    Block.allBlocks[byte1].update(this, l3 + k2, j5, k4 + i1, this.field_1037_n);
                }
                ++i22;
            }
        }
    }

    public boolean func_700_a(boolean flag) {
        int i2 = this.field_1023_B.size();
        if (i2 != this.field_1022_C.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (i2 > 1000) {
            i2 = 1000;
        }
        int j2 = 0;
        while (j2 < i2) {
            int k2;
            NextTickListEntry nextticklistentry = this.field_1023_B.first();
            if (!flag && nextticklistentry.field_1364_e > this.worldTime) break;
            this.field_1023_B.remove(nextticklistentry);
            this.field_1022_C.remove(nextticklistentry);
            int byte0 = 8;
            if (this.func_640_a(nextticklistentry.field_1361_a - byte0, nextticklistentry.field_1360_b - byte0, nextticklistentry.field_1366_c - byte0, nextticklistentry.field_1361_a + byte0, nextticklistentry.field_1360_b + byte0, nextticklistentry.field_1366_c + byte0) && (k2 = this.getBlock(nextticklistentry.field_1361_a, nextticklistentry.field_1360_b, nextticklistentry.field_1366_c)) == nextticklistentry.field_1365_d && k2 > 0) {
                Block.allBlocks[k2].update(this, nextticklistentry.field_1361_a, nextticklistentry.field_1360_b, nextticklistentry.field_1366_c, this.field_1037_n);
            }
            ++j2;
        }
        return this.field_1023_B.size() != 0;
    }

    public void func_677_m(int i2, int j2, int k2) {
        int byte0 = 16;
        Random random = new Random();
        int l2 = 0;
        while (l2 < 1000) {
            int k1;
            int j1;
            int i1 = i2 + this.field_1037_n.nextInt(byte0) - this.field_1037_n.nextInt(byte0);
            int l1 = this.getBlock(i1, j1 = j2 + this.field_1037_n.nextInt(byte0) - this.field_1037_n.nextInt(byte0), k1 = k2 + this.field_1037_n.nextInt(byte0) - this.field_1037_n.nextInt(byte0));
            if (l1 > 0) {
                Block.allBlocks[l1].func_247_b(this, i1, j1, k1, random);
            }
            ++l2;
        }
    }

    public List<Entity> func_659_b(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_1012_M.clear();
        int i2 = MathHelper.floor_double((axisalignedbb.field_1698_a - 2.0) / 16.0);
        int j2 = MathHelper.floor_double((axisalignedbb.field_1703_d + 2.0) / 16.0);
        int k2 = MathHelper.floor_double((axisalignedbb.field_1704_c - 2.0) / 16.0);
        int l2 = MathHelper.floor_double((axisalignedbb.field_1701_f + 2.0) / 16.0);
        int i1 = i2;
        while (i1 <= j2) {
            int j1 = k2;
            while (j1 <= l2) {
                if (this.func_620_h(i1, j1)) {
                    this.func_704_b(i1, j1).func_994_a(entity, axisalignedbb, this.field_1012_M);
                }
                ++j1;
            }
            ++i1;
        }
        return this.field_1012_M;
    }

    public List<Entity> func_657_a(Class<?> class1, AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor_double((axisalignedbb.field_1698_a - 2.0) / 16.0);
        int j2 = MathHelper.floor_double((axisalignedbb.field_1703_d + 2.0) / 16.0);
        int k2 = MathHelper.floor_double((axisalignedbb.field_1704_c - 2.0) / 16.0);
        int l2 = MathHelper.floor_double((axisalignedbb.field_1701_f + 2.0) / 16.0);
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        int i1 = i2;
        while (i1 <= j2) {
            int j1 = k2;
            while (j1 <= l2) {
                if (this.func_620_h(i1, j1)) {
                    this.func_704_b(i1, j1).func_1013_a(class1, axisalignedbb, arraylist);
                }
                ++j1;
            }
            ++i1;
        }
        return arraylist;
    }

    public List<Entity> func_658_i() {
        return this.field_1050_a;
    }

    public void func_698_b(int i2, int j2, int k2, TileEntity tileentity) {
        if (this.func_630_d(i2, j2, k2)) {
            this.func_673_a(i2, k2).func_1006_f();
        }
        int l2 = 0;
        while (l2 < this.field_1032_s.size()) {
            this.field_1032_s.get(l2).func_935_a(i2, j2, k2, tileentity);
            ++l2;
        }
    }

    public int func_621_b(Class<?> class1) {
        int i2 = 0;
        int j2 = 0;
        while (j2 < this.field_1050_a.size()) {
            Entity entity = this.field_1050_a.get(j2);
            if (class1.isAssignableFrom(entity.getClass())) {
                ++i2;
            }
            ++j2;
        }
        return i2;
    }

    public void func_636_a(List list) {
        this.field_1050_a.addAll(list);
        int i2 = 0;
        while (i2 < list.size()) {
            this.func_606_b((Entity)list.get(i2));
            ++i2;
        }
    }

    public void func_632_b(List list) {
        this.field_1024_A.addAll(list);
    }

    public void func_656_j() {
        while (this.chunkProvider.unknownBoolean1()) {
        }
    }

    public boolean func_695_a(int i2, int j2, int k2, int l2, boolean flag) {
        int i1 = this.getBlock(j2, k2, l2);
        Block block = Block.allBlocks[i1];
        Block block1 = Block.allBlocks[i2];
        AxisAlignedBB axisalignedbb = block1.func_221_d(this, j2, k2, l2);
        if (flag) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.func_604_a(axisalignedbb)) {
            return false;
        }
        if (block == Block.waterMoving || block == Block.waterStill || block == Block.lavaMoving || block == Block.lavaStill || block == Block.fire || block == Block.snow) {
            return true;
        }
        return i2 > 0 && block == null && block1.func_243_a(this, j2, k2, l2);
    }

    public PathEntity getPathEntityToEntity(Entity entity, Entity entity1, float f2) {
        int i2 = MathHelper.floor_double(entity.posX);
        int j2 = MathHelper.floor_double(entity.posY);
        int k2 = MathHelper.floor_double(entity.posZ);
        int l2 = (int)(f2 + 16.0f);
        int i1 = i2 - l2;
        int j1 = j2 - l2;
        int k1 = k2 - l2;
        int l1 = i2 + l2;
        int i22 = j2 + l2;
        int j22 = k2 + l2;
        ChunkCache chunkcache = new ChunkCache(this, i1, j1, k1, l1, i22, j22);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, entity1, f2);
    }

    public PathEntity func_637_a(Entity entity, int i2, int j2, int k2, float f2) {
        int l2 = MathHelper.floor_double(entity.posX);
        int i1 = MathHelper.floor_double(entity.posY);
        int j1 = MathHelper.floor_double(entity.posZ);
        int k1 = (int)(f2 + 8.0f);
        int l1 = l2 - k1;
        int i22 = i1 - k1;
        int j22 = j1 - k1;
        int k22 = l2 + k1;
        int l22 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this, l1, i22, j22, k22, l22, i3);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, i2, j2, k2, f2);
    }

    public boolean func_668_j(int i2, int j2, int k2, int l2) {
        int i1 = this.getBlock(i2, j2, k2);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].func_228_c(this, i2, j2, k2, l2);
    }

    public boolean func_646_n(int i2, int j2, int k2) {
        if (this.func_668_j(i2, j2 - 1, k2, 0)) {
            return true;
        }
        if (this.func_668_j(i2, j2 + 1, k2, 1)) {
            return true;
        }
        if (this.func_668_j(i2, j2, k2 - 1, 2)) {
            return true;
        }
        if (this.func_668_j(i2, j2, k2 + 1, 3)) {
            return true;
        }
        if (this.func_668_j(i2 - 1, j2, k2, 4)) {
            return true;
        }
        return this.func_668_j(i2 + 1, j2, k2, 5);
    }

    public boolean func_706_k(int i2, int j2, int k2, int l2) {
        if (this.isBlockNormalCube(i2, j2, k2)) {
            return this.func_646_n(i2, j2, k2);
        }
        int i1 = this.getBlock(i2, j2, k2);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].func_231_b(this, i2, j2, k2, l2);
    }

    public boolean func_625_o(int i2, int j2, int k2) {
        if (this.func_706_k(i2, j2 - 1, k2, 0)) {
            return true;
        }
        if (this.func_706_k(i2, j2 + 1, k2, 1)) {
            return true;
        }
        if (this.func_706_k(i2, j2, k2 - 1, 2)) {
            return true;
        }
        if (this.func_706_k(i2, j2, k2 + 1, 3)) {
            return true;
        }
        if (this.func_706_k(i2 - 1, j2, k2, 4)) {
            return true;
        }
        return this.func_706_k(i2 + 1, j2, k2, 5);
    }

    public EntityPlayer func_609_a(Entity entity, double d2) {
        return this.func_683_a(entity.posX, entity.posY, entity.posZ, d2);
    }

    public EntityPlayer func_683_a(double d2, double d1, double d22, double d3) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        int i2 = 0;
        while (i2 < this.playerEntities.size()) {
            EntityPlayer entityplayer1 = this.playerEntities.get(i2);
            double d5 = entityplayer1.func_360_d(d2, d1, d22);
            if ((d3 < 0.0 || d5 < d3 * d3) && (d4 == -1.0 || d5 < d4)) {
                d4 = d5;
                entityplayer = entityplayer1;
            }
            ++i2;
        }
        return entityplayer;
    }

    public void func_693_a(int i2, int j2, int k2, int l2, int i1, int j1, byte[] abyte0) {
        int k1 = i2 >> 4;
        int l1 = k2 >> 4;
        int i22 = i2 + l2 - 1 >> 4;
        int j22 = k2 + j1 - 1 >> 4;
        int k22 = 0;
        int l22 = j2;
        int i3 = j2 + i1;
        if (l22 < 0) {
            l22 = 0;
        }
        if (i3 > 128) {
            i3 = 128;
        }
        int j3 = k1;
        while (j3 <= i22) {
            int k3 = i2 - j3 * 16;
            int l3 = i2 + l2 - j3 * 16;
            if (k3 < 0) {
                k3 = 0;
            }
            if (l3 > 16) {
                l3 = 16;
            }
            int i4 = l1;
            while (i4 <= j22) {
                int j4 = k2 - i4 * 16;
                int k4 = k2 + j1 - i4 * 16;
                if (j4 < 0) {
                    j4 = 0;
                }
                if (k4 > 16) {
                    k4 = 16;
                }
                k22 = this.func_704_b(j3, i4).func_1004_a(abyte0, k3, l22, j4, l3, i3, k4, k22);
                this.func_701_b(j3 * 16 + k3, l22, i4 * 16 + j4, j3 * 16 + l3, i3, i4 * 16 + k4);
                ++i4;
            }
            ++j3;
        }
    }

    public void func_660_k() {
    }

    public void func_663_l() {
        try {
            File file = new File(this.field_1031_t, "session.lock");
            try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));){
                if (datainputstream.readLong() != this.field_1018_G) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
        }
        catch (IOException ioexception) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    public void func_648_a(long l2) {
        this.worldTime = l2;
    }

    public void func_705_f(Entity entity) {
        int i2 = MathHelper.floor_double(entity.posX / 16.0);
        int j2 = MathHelper.floor_double(entity.posZ / 16.0);
        int byte0 = 2;
        int k2 = i2 - byte0;
        while (k2 <= i2 + byte0) {
            int l2 = j2 - byte0;
            while (l2 <= j2 + byte0) {
                this.func_704_b(k2, l2);
                ++l2;
            }
            ++k2;
        }
        if (!this.field_1050_a.contains(entity)) {
            System.out.println("REINSERTING PLAYER!");
            this.field_1050_a.add(entity);
        }
    }

    public String getProviderGenProgress() {
        return this.chunkProvider.getGenProgress();
    }
}

