/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class EntitySkeleton
extends EntityMobs {
    public EntitySkeleton(World world) {
        super(world);
        this.scoreYield = 40;
        this.texture = "/mob/skeleton.png";
        this.currentSpeed = 0.5;
    }

    @Override
    protected String idleSound() {
        return "mob.skeleton";
    }

    @Override
    protected String hurtSound() {
        return "mob.skeletonhurt";
    }

    @Override
    protected String deathSound() {
        return "mob.skeletonhurt";
    }

    @Override
    public void entityMove() {
        float f2;
        if (this.worldObj.func_624_b() && (f2 = this.func_382_a(1.0f)) > 0.5f && this.worldObj.func_647_i(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) && this.rand.nextFloat() * 30.0f < (f2 - 0.4f) * 2.0f) {
            this.fire = 300;
        }
        super.entityMove();
    }

    @Override
    protected void attackEntity(Entity entity, float f2) {
        if (f2 < 10.0f) {
            double d2 = entity.posX - this.posX;
            double d1 = entity.posZ - this.posZ;
            if (this.attackTime == 0) {
                EntityArrow entityarrow = new EntityArrow(this.worldObj, this);
                entityarrow.posY += (double)1.4f;
                double d22 = entity.posY - (double)0.2f - entityarrow.posY;
                float f1 = MathHelper.func_1109_a(d2 * d2 + d1 * d1) * 0.2f;
                this.worldObj.func_623_a(this, "random.bow", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.8f));
                this.worldObj.func_674_a(entityarrow);
                entityarrow.func_408_a(d2, d22 + (double)f1, d1, 0.6f, 12.0f);
                this.attackTime = 30;
            }
            this.rotationYaw = (float)(Math.atan2(d1, d2) * 180.0 / 3.1415927410125732) - 90.0f;
            this.hasAttacked = true;
        }
    }

    @Override
    public void addNBTTag(NBTTagCompound nbttagcompound) {
        super.addNBTTag(nbttagcompound);
    }

    @Override
    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        super.removeNBTTag(nbttagcompound);
    }

    @Override
    protected int deathDropItem() {
        if (new Random().nextBoolean()) {
            return Item.bone.swiftedIndex;
        }
        return Item.arrow.swiftedIndex;
    }

    @Override
    public double getRealMoveSpeed() {
        return this.currentSpeed;
    }
}

