/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import java.util.Random;

public abstract class Entity {
    private static int field_655_a = 0;
    public int entityId;
    public double field_619_ac = 1.0;
    public boolean field_618_ad = false;
    public Entity field_617_ae;
    public Entity field_616_af;
    protected World worldObj;
    public double field_614_ah;
    public double field_613_ai;
    public double field_612_aj;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;
    public float rotationYaw;
    public float rotationPitch;
    public float headYaw;
    public float headPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.func_1168_a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean field_599_aw;
    public boolean field_598_ax;
    public boolean field_597_ay = false;
    public boolean field_596_az = true;
    public boolean hasDied = false;
    public float eyeHeight = 0.0f;
    public float width = 0.6f;
    public float height = 1.8f;
    public float field_642_aE = 0.0f;
    public float field_641_aF = 0.0f;
    protected boolean field_640_aG = true;
    protected float fallDistance = 0.0f;
    private int field_653_b = 1;
    public double field_638_aI;
    public double field_637_aJ;
    public double field_636_aK;
    public float headSneakHeight = 0.0f;
    public float field_634_aM = 0.0f;
    public boolean field_633_aN = false;
    public float field_632_aO = 0.0f;
    public boolean field_631_aP = false;
    protected Random rand;
    public int field_629_aR = 0;
    public int field_628_aS = 1;
    public int fire = 0;
    protected int field_626_aU = 300;
    protected boolean hasSplashed = false;
    public int field_624_aW = 0;
    public int air = 300;
    private boolean field_651_c = true;
    public String field_622_aY;
    private double field_649_d;
    private double field_647_e;
    public boolean field_621_aZ = false;
    public int field_657_ba;
    public int field_656_bb;
    public int field_654_bc;
    public int field_652_bd;
    public int field_650_be;
    public int field_648_bf;

    public Entity(World world) {
        this.entityId = field_655_a++;
        this.rand = new Random();
        this.worldObj = world;
        this.func_347_a(0.0, 0.0, 0.0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entity) {
            return ((Entity)obj).entityId == this.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.entityId;
    }

    protected void func_374_q() {
        if (this.worldObj == null) {
            return;
        }
        while (!(this.posY <= 0.0)) {
            this.func_347_a(this.posX, this.posY, this.posZ);
            if (this.worldObj.func_697_a(this, this.boundingBox).size() == 0) break;
            this.posY += 1.0;
        }
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.rotationPitch = 0.0f;
    }

    public void func_395_F() {
        this.hasDied = true;
    }

    protected void func_371_a(float f2, float f1) {
        this.width = f2;
        this.height = f1;
    }

    protected void func_376_c(float f2, float f1) {
        this.rotationYaw = f2;
        this.rotationPitch = f1;
    }

    public void func_347_a(double d2, double d1, double d22) {
        this.posX = d2;
        this.posY = d1;
        this.posZ = d22;
        float f2 = this.width / 2.0f;
        float f1 = this.height;
        this.boundingBox.func_1165_c(d2 - (double)f2, d1 - (double)this.eyeHeight + (double)this.headSneakHeight, d22 - (double)f2, d2 + (double)f2, d1 - (double)this.eyeHeight + (double)this.headSneakHeight + (double)f1, d22 + (double)f2);
    }

    public void func_346_d(float f2, float f1) {
        float f22 = this.rotationPitch;
        float f3 = this.rotationYaw;
        this.rotationYaw = (float)((double)this.rotationYaw + (double)f2 * 0.15);
        this.rotationPitch = (float)((double)this.rotationPitch - (double)f1 * 0.15);
        if (this.rotationPitch < -90.0f) {
            this.rotationPitch = -90.0f;
        }
        if (this.rotationPitch > 90.0f) {
            this.rotationPitch = 90.0f;
        }
        this.headPitch += this.rotationPitch - f22;
        this.headYaw += this.rotationYaw - f3;
    }

    public void enterWater() {
        this.inWater();
    }

    public void inWater() {
        if (this.field_616_af != null && this.field_616_af.hasDied) {
            this.field_616_af = null;
        }
        ++this.field_629_aR;
        this.field_642_aE = this.field_641_aF;
        this.field_614_ah = this.posX;
        this.field_613_ai = this.posY;
        this.field_612_aj = this.posZ;
        this.headPitch = this.rotationPitch;
        this.headYaw = this.rotationYaw;
        if (this.isInWater()) {
            if (!this.hasSplashed && !this.field_651_c) {
                float f2 = MathHelper.func_1109_a(this.motionX * this.motionX * (double)0.2f + this.motionY * this.motionY + this.motionZ * this.motionZ * (double)0.2f) * 0.2f;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                this.worldObj.func_623_a(this, "random.splash", f2, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                float f1 = MathHelper.floor_double(this.boundingBox.minY);
                int i2 = 0;
                while ((float)i2 < 1.0f + this.width * 20.0f) {
                    float f22 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.func_694_a("bubble", this.posX + (double)f22, f1 + 1.0f, this.posZ + (double)f4, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                    ++i2;
                }
                int j2 = 0;
                while ((float)j2 < 1.0f + this.width * 20.0f) {
                    float f3 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    float f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.func_694_a("splash", this.posX + (double)f3, f1 + 1.0f, this.posZ + (double)f5, this.motionX, this.motionY, this.motionZ);
                    ++j2;
                }
            }
            this.fallDistance = 0.0f;
            this.hasSplashed = true;
            this.fire = 0;
        } else {
            this.hasSplashed = false;
        }
        if (this.fire > 0) {
            if (this.fire % 20 == 0) {
                this.attacked(null, 1);
            }
            --this.fire;
        }
        if (this.handleLavaMovement()) {
            this.attacked(null, 10);
            this.fire = 600;
        }
        if (this.posY < -64.0) {
            this.func_369_E();
        }
        this.field_651_c = false;
    }

    protected void func_369_E() {
        this.func_395_F();
    }

    public boolean func_403_b(double d2, double d1, double d22) {
        AxisAlignedBB axisalignedbb = this.boundingBox.func_1166_c(d2, d1, d22);
        List<AxisAlignedBB> list = this.worldObj.func_697_a(this, axisalignedbb);
        if (list.size() > 0) {
            return false;
        }
        return !this.worldObj.func_662_b(axisalignedbb);
    }

    public void func_349_c(double d2, double d1, double d22) {
        boolean flag;
        if (this.field_633_aN) {
            this.boundingBox.func_1174_d(d2, d1, d22);
            this.posX = (this.boundingBox.field_1698_a + this.boundingBox.field_1703_d) / 2.0;
            this.posY = this.boundingBox.minY + (double)this.eyeHeight - (double)this.headSneakHeight;
            this.posZ = (this.boundingBox.field_1704_c + this.boundingBox.field_1701_f) / 2.0;
            return;
        }
        double d3 = this.posX;
        double d4 = this.posZ;
        double d5 = d2;
        double d6 = d1;
        double d7 = d22;
        AxisAlignedBB axisalignedbb = this.boundingBox.func_1160_c();
        boolean bl2 = flag = this.onGround && this.func_381_o();
        if (flag) {
            double d8 = 0.05;
            while (d2 != 0.0 && this.worldObj.func_697_a(this, this.boundingBox.func_1166_c(d2, -1.0, 0.0)).size() == 0) {
                d2 = d2 < d8 && d2 >= -d8 ? 0.0 : (d2 > 0.0 ? (d2 -= d8) : (d2 += d8));
                d5 = d2;
            }
            while (d22 != 0.0 && this.worldObj.func_697_a(this, this.boundingBox.func_1166_c(0.0, -1.0, d22)).size() == 0) {
                d22 = d22 < d8 && d22 >= -d8 ? 0.0 : (d22 > 0.0 ? (d22 -= d8) : (d22 += d8));
                d7 = d22;
            }
        }
        List<AxisAlignedBB> list = this.worldObj.func_697_a(this, this.boundingBox.func_1170_a(d2, d1, d22));
        int i2 = 0;
        while (i2 < list.size()) {
            d1 = list.get(i2).func_1172_b(this.boundingBox, d1);
            ++i2;
        }
        this.boundingBox.func_1174_d(0.0, d1, 0.0);
        if (!this.field_596_az && d6 != d1) {
            d22 = 0.0;
            d1 = 0.0;
            d2 = 0.0;
        }
        boolean flag1 = this.onGround || d6 != d1 && d6 < 0.0;
        int j2 = 0;
        while (j2 < list.size()) {
            d2 = list.get(j2).func_1163_a(this.boundingBox, d2);
            ++j2;
        }
        this.boundingBox.func_1174_d(d2, 0.0, 0.0);
        if (!this.field_596_az && d5 != d2) {
            d22 = 0.0;
            d1 = 0.0;
            d2 = 0.0;
        }
        int k2 = 0;
        while (k2 < list.size()) {
            d22 = list.get(k2).func_1162_c(this.boundingBox, d22);
            ++k2;
        }
        this.boundingBox.func_1174_d(0.0, 0.0, d22);
        if (!this.field_596_az && d7 != d22) {
            d22 = 0.0;
            d1 = 0.0;
            d2 = 0.0;
        }
        if (this.field_634_aM > 0.0f && flag1 && this.headSneakHeight < 0.05f && (d5 != d2 || d7 != d22)) {
            double d9 = d2;
            double d11 = d1;
            double d13 = d22;
            d2 = d5;
            d1 = this.field_634_aM;
            d22 = d7;
            AxisAlignedBB axisalignedbb1 = this.boundingBox.func_1160_c();
            this.boundingBox.func_1171_b(axisalignedbb);
            List<AxisAlignedBB> list1 = this.worldObj.func_697_a(this, this.boundingBox.func_1170_a(d2, d1, d22));
            int j22 = 0;
            while (j22 < list1.size()) {
                d1 = list1.get(j22).func_1172_b(this.boundingBox, d1);
                ++j22;
            }
            this.boundingBox.func_1174_d(0.0, d1, 0.0);
            if (!this.field_596_az && d6 != d1) {
                d22 = 0.0;
                d1 = 0.0;
                d2 = 0.0;
            }
            int k22 = 0;
            while (k22 < list1.size()) {
                d2 = list1.get(k22).func_1163_a(this.boundingBox, d2);
                ++k22;
            }
            this.boundingBox.func_1174_d(d2, 0.0, 0.0);
            if (!this.field_596_az && d5 != d2) {
                d22 = 0.0;
                d1 = 0.0;
                d2 = 0.0;
            }
            int l2 = 0;
            while (l2 < list1.size()) {
                d22 = list1.get(l2).func_1162_c(this.boundingBox, d22);
                ++l2;
            }
            this.boundingBox.func_1174_d(0.0, 0.0, d22);
            if (!this.field_596_az && d7 != d22) {
                d22 = 0.0;
                d1 = 0.0;
                d2 = 0.0;
            }
            if (d9 * d9 + d13 * d13 >= d2 * d2 + d22 * d22) {
                d2 = d9;
                d1 = d11;
                d22 = d13;
                this.boundingBox.func_1171_b(axisalignedbb1);
            } else {
                this.headSneakHeight = (float)((double)this.headSneakHeight + 0.5);
            }
        }
        this.posX = (this.boundingBox.field_1698_a + this.boundingBox.field_1703_d) / 2.0;
        this.posY = this.boundingBox.minY + (double)this.eyeHeight - (double)this.headSneakHeight;
        this.posZ = (this.boundingBox.field_1704_c + this.boundingBox.field_1701_f) / 2.0;
        this.field_599_aw = d5 != d2 || d7 != d22;
        this.field_598_ax = d6 != d1;
        this.onGround = d6 != d1 && d6 < 0.0;
        boolean bl3 = this.field_597_ay = this.field_599_aw || this.field_598_ax;
        if (this.onGround) {
            if (this.fallDistance > 0.0f) {
                this.func_400_c(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d1 < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d1);
        }
        if (d5 != d2) {
            this.motionX = 0.0;
        }
        if (d6 != d1) {
            this.motionY = 0.0;
        }
        if (d7 != d22) {
            this.motionZ = 0.0;
        }
        double d10 = this.posX - d3;
        double d12 = this.posZ - d4;
        this.field_641_aF = (float)((double)this.field_641_aF + (double)MathHelper.func_1109_a(d10 * d10 + d12 * d12) * 0.6);
        if (this.field_640_aG && !flag) {
            int l2 = MathHelper.floor_double(this.posX);
            int j1 = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.eyeHeight);
            int l1 = MathHelper.floor_double(this.posZ);
            int i3 = this.worldObj.getBlock(l2, j1, l1);
            if (this.field_641_aF > (float)this.field_653_b && i3 > 0) {
                ++this.field_653_b;
                StepSound stepsound = Block.allBlocks[i3].stepSound;
                if (this.worldObj.getBlock(l2, j1 + 1, l1) == Block.snow.blockID) {
                    stepsound = Block.snow.stepSound;
                    this.worldObj.func_623_a(this, stepsound.func_1145_d(), stepsound.func_1147_b() * 0.15f, stepsound.func_1144_c());
                } else if (!Block.allBlocks[i3].material.func_879_d()) {
                    this.worldObj.func_623_a(this, stepsound.func_1145_d(), stepsound.func_1147_b() * 0.15f, stepsound.func_1144_c());
                }
                Block.allBlocks[i3].func_254_a(this.worldObj, l2, j1, l1, this);
            }
        }
        int i1 = MathHelper.floor_double(this.boundingBox.field_1698_a);
        int k1 = MathHelper.floor_double(this.boundingBox.minY);
        int i22 = MathHelper.floor_double(this.boundingBox.field_1704_c);
        int j3 = MathHelper.floor_double(this.boundingBox.field_1703_d);
        int k3 = MathHelper.floor_double(this.boundingBox.field_1702_e);
        int l3 = MathHelper.floor_double(this.boundingBox.field_1701_f);
        int i4 = i1;
        while (i4 <= j3) {
            int j4 = k1;
            while (j4 <= k3) {
                int k4 = i22;
                while (k4 <= l3) {
                    int l4 = this.worldObj.getBlock(i4, j4, k4);
                    if (l4 > 0) {
                        Block.allBlocks[l4].func_236_b(this.worldObj, i4, j4, k4, this);
                    }
                    ++k4;
                }
                ++j4;
            }
            ++i4;
        }
        this.headSneakHeight *= 0.4f;
        boolean flag2 = this.isInWater();
        if (this.worldObj.func_605_c(this.boundingBox)) {
            this.func_355_a(1);
            if (!flag2) {
                ++this.fire;
                if (this.fire == 0) {
                    this.fire = 300;
                }
            }
        } else if (this.fire <= 0) {
            this.fire = -this.field_628_aS;
        }
        if (flag2 && this.fire > 0) {
            this.worldObj.func_623_a(this, "random.fizz", 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
            this.fire = -this.field_628_aS;
        }
    }

    public boolean func_381_o() {
        return false;
    }

    public AxisAlignedBB func_372_f_() {
        return null;
    }

    protected void func_355_a(int i2) {
        this.attacked(null, i2);
    }

    protected void func_400_c(float f2) {
    }

    public boolean isInWater() {
        return this.worldObj.func_682_a(this.boundingBox.func_1177_b(0.0, -0.4f, 0.0), Material.water, this);
    }

    public boolean headSpaceMaterial(Material material) {
        int k2;
        int j2;
        double d2 = this.posY + (double)this.func_373_s();
        int i2 = MathHelper.floor_double(this.posX);
        int l2 = this.worldObj.getBlock(i2, j2 = MathHelper.func_1110_d(MathHelper.floor_double(d2)), k2 = MathHelper.floor_double(this.posZ));
        if (l2 != 0 && Block.allBlocks[l2].material == material) {
            float f2 = BlockFluids.func_288_b(this.worldObj.func_602_e(i2, j2, k2)) - 0.1111111f;
            float f1 = (float)(j2 + 1) - f2;
            return d2 < (double)f1;
        }
        return false;
    }

    protected float func_373_s() {
        return 0.0f;
    }

    public boolean handleLavaMovement() {
        return this.worldObj.func_689_a(this.boundingBox.func_1177_b(0.0, -0.4f, 0.0), Material.lava);
    }

    public void func_351_a(float f2, float f1, float f22) {
        float f3 = MathHelper.func_1113_c(f2 * f2 + f1 * f1);
        if (f3 < 0.01f) {
            return;
        }
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        f3 = f22 / f3;
        float f4 = MathHelper.sin(this.rotationYaw * 3.141593f / 180.0f);
        float f5 = MathHelper.cos(this.rotationYaw * 3.141593f / 180.0f);
        this.motionX += (double)((f2 *= f3) * f5 - (f1 *= f3) * f4);
        this.motionZ += (double)(f1 * f5 + f2 * f4);
    }

    public float func_382_a(float f2) {
        int i2 = MathHelper.floor_double(this.posX);
        double d2 = (this.boundingBox.field_1702_e - this.boundingBox.minY) * 0.66;
        int j2 = MathHelper.floor_double(this.posY - (double)this.eyeHeight + d2);
        int k2 = MathHelper.floor_double(this.posZ);
        return this.worldObj.func_598_c(i2, j2, k2);
    }

    public void setWorld(World world) {
        this.worldObj = world;
    }

    public void func_399_b(double d2, double d1, double d22, float f2, float f1) {
        this.field_614_ah = this.posX = d2;
        this.field_613_ai = this.posY = d1;
        this.field_612_aj = this.posZ = d22;
        this.rotationYaw = f2;
        this.rotationPitch = f1;
        this.headSneakHeight = 0.0f;
        double d3 = this.headYaw - f2;
        if (d3 < -180.0) {
            this.headYaw += 360.0f;
        }
        if (d3 >= 180.0) {
            this.headYaw -= 360.0f;
        }
        this.func_347_a(this.posX, this.posY, this.posZ);
    }

    public void spawnNewEntity(double d2, double d1, double d22, float f2, float f1) {
        this.field_614_ah = this.posX = d2;
        this.field_613_ai = this.posY = d1 + (double)this.eyeHeight;
        this.field_612_aj = this.posZ = d22;
        this.rotationYaw = f2;
        this.rotationPitch = f1;
        this.func_347_a(this.posX, this.posY, this.posZ);
    }

    public float getDistanceToEntity(Entity entity) {
        float f2 = (float)(this.posX - entity.posX);
        float f1 = (float)(this.posY - entity.posY);
        float f22 = (float)(this.posZ - entity.posZ);
        return MathHelper.func_1113_c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double func_360_d(double d2, double d1, double d22) {
        double d3 = this.posX - d2;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d22;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double func_361_e(double d2, double d1, double d22) {
        double d3 = this.posX - d2;
        double d4 = this.posY - d1;
        double d5 = this.posZ - d22;
        return MathHelper.func_1109_a(d3 * d3 + d4 * d4 + d5 * d5);
    }

    public double func_387_e(Entity entity) {
        double d2 = this.posX - entity.posX;
        double d1 = this.posY - entity.posY;
        double d22 = this.posZ - entity.posZ;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public void func_362_b(EntityPlayer entityplayer) {
    }

    public void func_380_f(Entity entity) {
        if (entity.field_617_ae == this || entity.field_616_af == this) {
            return;
        }
        double d2 = entity.posX - this.posX;
        double d1 = entity.posZ - this.posZ;
        double d22 = MathHelper.func_1107_a(d2, d1);
        if (d22 >= (double)0.01f) {
            d22 = MathHelper.func_1109_a(d22);
            d2 /= d22;
            d1 /= d22;
            double d3 = 1.0 / d22;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d2 *= d3;
            d1 *= d3;
            d2 *= (double)0.05f;
            d1 *= (double)0.05f;
            this.entityMove(-(d2 *= (double)(1.0f - this.field_632_aO)), 0.0, -(d1 *= (double)(1.0f - this.field_632_aO)));
            entity.entityMove(d2, 0.0, d1);
        }
    }

    public void entityMove(double d2, double d1, double d22) {
        this.motionX += d2;
        this.motionY += d1;
        this.motionZ += d22;
    }

    public boolean attacked(Entity entity, int i2) {
        return false;
    }

    public boolean func_401_c_() {
        return false;
    }

    public boolean func_385_d_() {
        return false;
    }

    public void func_364_b(Entity entity, int i2) {
    }

    public boolean func_390_a(Vec3D vec3d) {
        double d2 = this.posX - vec3d.xCoord;
        double d1 = this.posY - vec3d.yCoord;
        double d22 = this.posZ - vec3d.zCoord;
        double d3 = d2 * d2 + d1 * d1 + d22 * d22;
        return this.func_384_a(d3);
    }

    public boolean func_384_a(double d2) {
        double d1 = this.boundingBox.func_1164_b();
        return d2 < (d1 *= 64.0 * this.field_619_ac) * d1;
    }

    public String func_356_x() {
        return null;
    }

    public boolean func_358_c(NBTTagCompound nbttagcompound) {
        String s2 = this.func_389_H();
        if (this.hasDied || s2 == null) {
            return false;
        }
        nbttagcompound.setString("id", s2);
        this.func_363_d(nbttagcompound);
        return true;
    }

    public void func_363_d(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_762_a("Pos", this.func_375_a(new double[]{this.posX, this.posY, this.posZ}));
        nbttagcompound.func_762_a("Motion", this.func_375_a(new double[]{this.motionX, this.motionY, this.motionZ}));
        nbttagcompound.func_762_a("Rotation", this.func_377_a(new float[]{this.rotationYaw, this.rotationPitch}));
        nbttagcompound.setFloat("FallDistance", this.fallDistance);
        nbttagcompound.func_749_a("Fire", (short)this.fire);
        nbttagcompound.func_749_a("Air", (short)this.air);
        nbttagcompound.setBool("OnGround", this.onGround);
        this.addNBTTag(nbttagcompound);
    }

    public void func_368_e(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.func_753_l("Pos");
        NBTTagList nbttaglist1 = nbttagcompound.func_753_l("Motion");
        NBTTagList nbttaglist2 = nbttagcompound.func_753_l("Rotation");
        this.func_347_a(0.0, 0.0, 0.0);
        this.motionX = ((NBTTagDouble)nbttaglist1.func_741_a((int)0)).doubleValue;
        this.motionY = ((NBTTagDouble)nbttaglist1.func_741_a((int)1)).doubleValue;
        this.motionZ = ((NBTTagDouble)nbttaglist1.func_741_a((int)2)).doubleValue;
        this.field_638_aI = this.posX = ((NBTTagDouble)nbttaglist.func_741_a((int)0)).doubleValue;
        this.field_614_ah = this.posX;
        this.field_637_aJ = this.posY = ((NBTTagDouble)nbttaglist.func_741_a((int)1)).doubleValue;
        this.field_613_ai = this.posY;
        this.field_636_aK = this.posZ = ((NBTTagDouble)nbttaglist.func_741_a((int)2)).doubleValue;
        this.field_612_aj = this.posZ;
        this.headYaw = this.rotationYaw = ((NBTTagFloat)nbttaglist2.func_741_a((int)0)).floatValue;
        this.headPitch = this.rotationPitch = ((NBTTagFloat)nbttaglist2.func_741_a((int)1)).floatValue;
        this.fallDistance = nbttagcompound.func_752_g("FallDistance");
        this.fire = nbttagcompound.func_745_d("Fire");
        this.air = nbttagcompound.func_745_d("Air");
        this.onGround = nbttagcompound.tag("OnGround");
        this.func_347_a(this.posX, this.posY, this.posZ);
        this.removeNBTTag(nbttagcompound);
    }

    protected final String func_389_H() {
        return EntityList.func_1083_b(this);
    }

    protected abstract void removeNBTTag(NBTTagCompound var1);

    protected abstract void addNBTTag(NBTTagCompound var1);

    protected NBTTagList func_375_a(double[] ad2) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] ad1 = ad2;
        int i2 = ad1.length;
        int j2 = 0;
        while (j2 < i2) {
            double d2 = ad1[j2];
            nbttaglist.func_742_a(new NBTTagDouble(d2));
            ++j2;
        }
        return nbttaglist;
    }

    protected NBTTagList func_377_a(float[] af2) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] af1 = af2;
        int i2 = af1.length;
        int j2 = 0;
        while (j2 < i2) {
            float f2 = af1[j2];
            nbttaglist.func_742_a(new NBTTagFloat(f2));
            ++j2;
        }
        return nbttaglist;
    }

    public float func_392_h_() {
        return this.height / 2.0f;
    }

    public EntityItem func_367_b(int i2, int j2) {
        return this.func_394_a(i2, j2, 0.0f);
    }

    public EntityItem func_394_a(int i2, int j2, float f2) {
        EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY + (double)f2, this.posZ, new ItemStack(i2, j2));
        entityitem.field_805_c = 10;
        this.worldObj.func_674_a(entityitem);
        return entityitem;
    }

    public boolean isEntityAlive() {
        return !this.hasDied;
    }

    public boolean func_345_I() {
        int i2 = MathHelper.floor_double(this.posX);
        int j2 = MathHelper.floor_double(this.posY + (double)this.func_373_s());
        int k2 = MathHelper.floor_double(this.posZ);
        return this.worldObj.isBlockNormalCube(i2, j2, k2);
    }

    public boolean checkRide(EntityPlayer entityplayer) {
        return false;
    }

    public AxisAlignedBB func_383_b_(Entity entity) {
        return null;
    }

    public void func_350_p() {
        if (this.field_616_af.hasDied) {
            this.field_616_af = null;
            return;
        }
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.enterWater();
        this.field_616_af.func_366_i_();
        this.field_647_e += (double)(this.field_616_af.rotationYaw - this.field_616_af.headYaw);
        this.field_649_d += (double)(this.field_616_af.rotationPitch - this.field_616_af.headPitch);
        while (this.field_647_e >= 180.0) {
            this.field_647_e -= 360.0;
        }
        while (this.field_647_e < -180.0) {
            this.field_647_e += 360.0;
        }
        while (this.field_649_d >= 180.0) {
            this.field_649_d -= 360.0;
        }
        while (this.field_649_d < -180.0) {
            this.field_649_d += 360.0;
        }
        double d2 = this.field_647_e * 0.5;
        double d1 = this.field_649_d * 0.5;
        float f2 = 10.0f;
        if (d2 > (double)f2) {
            d2 = f2;
        }
        if (d2 < (double)(-f2)) {
            d2 = -f2;
        }
        if (d1 > (double)f2) {
            d1 = f2;
        }
        if (d1 < (double)(-f2)) {
            d1 = -f2;
        }
        this.field_647_e -= d2;
        this.field_649_d -= d1;
        this.rotationYaw = (float)((double)this.rotationYaw + d2);
        this.rotationPitch = (float)((double)this.rotationPitch + d1);
    }

    protected void func_366_i_() {
        this.field_617_ae.func_347_a(this.posX, this.posY + this.func_402_h() + this.field_617_ae.func_388_v(), this.posZ);
    }

    public double func_388_v() {
        return this.eyeHeight;
    }

    public double func_402_h() {
        return (double)this.height * 0.75;
    }

    public void rideMount(Entity entity) {
        this.field_649_d = 0.0;
        this.field_647_e = 0.0;
        if (this.field_616_af == entity) {
            this.field_616_af.field_617_ae = null;
            this.field_616_af = null;
            this.spawnNewEntity(entity.posX, entity.boundingBox.minY + (double)entity.height, entity.posZ, this.rotationYaw, this.rotationPitch);
            return;
        }
        if (this.field_616_af != null) {
            this.field_616_af.field_617_ae = null;
        }
        if (entity.field_617_ae != null) {
            entity.field_617_ae.field_616_af = null;
        }
        this.field_616_af = entity;
        entity.field_617_ae = this;
    }

    public void func_378_a(double d2, double d1, double d22, float f2, float f1, int i2) {
        this.func_347_a(d2, d1, d22);
        this.func_376_c(f2, f1);
    }

    public double getRealMoveSpeed() {
        return 0.5;
    }

    public float getEyeHeight() {
        return this.eyeHeight;
    }
}

