/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.util.HashMap;
import org.json.Kim;
import org.json.zip.JSONzip;
import org.json.zip.Keep;
import org.json.zip.PostMortem;

class MapKeep
extends Keep {
    private Object[] list;
    private HashMap<Object, Integer> map;

    public MapKeep(int bits) {
        super(bits);
        this.list = new Object[this.capacity];
        this.map = new HashMap(this.capacity);
    }

    private void compact() {
        int from = 0;
        int to = 0;
        while (from < this.capacity) {
            Object key = this.list[from];
            long usage = MapKeep.age(this.uses[from]);
            if (usage > 0L) {
                this.uses[to] = usage;
                this.list[to] = key;
                this.map.put(key, new Integer(to));
                ++to;
            } else {
                this.map.remove(key);
            }
            ++from;
        }
        if (to < this.capacity) {
            this.length = to;
        } else {
            this.map.clear();
            this.length = 0;
        }
        this.power = 0;
    }

    public int find(Object key) {
        Integer o2 = this.map.get(key);
        return o2 instanceof Integer ? o2 : -1;
    }

    @Override
    public boolean postMortem(PostMortem pm) {
        MapKeep that = (MapKeep)pm;
        if (this.length != that.length) {
            JSONzip.log(String.valueOf(this.length) + " <> " + that.length);
            return false;
        }
        int i2 = 0;
        while (i2 < this.length) {
            boolean b2;
            if (this.list[i2] instanceof Kim) {
                b2 = ((Kim)this.list[i2]).equals(that.list[i2]);
            } else {
                Object o2 = this.list[i2];
                Object q2 = that.list[i2];
                if (o2 instanceof Number) {
                    o2 = o2.toString();
                }
                if (q2 instanceof Number) {
                    q2 = q2.toString();
                }
                b2 = o2.equals(q2);
            }
            if (!b2) {
                JSONzip.log("\n[" + i2 + "]\n " + this.list[i2] + "\n " + that.list[i2] + "\n " + this.uses[i2] + "\n " + that.uses[i2]);
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void register(Object value) {
        if (this.length >= this.capacity) {
            this.compact();
        }
        this.list[this.length] = value;
        this.map.put(value, new Integer(this.length));
        this.uses[this.length] = 1L;
        ++this.length;
    }

    @Override
    public Object value(int integer) {
        return this.list[integer];
    }
}

