/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');

    public static String escape(String string) {
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        int length = string.length();
        while (i2 < length) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                default: {
                    sb.append(c2);
                }
            }
            ++i2;
        }
        return sb.toString();
    }

    public static void noSpace(String string) throws JSONException {
        int length = string.length();
        if (length == 0) {
            throw new JSONException("Empty string.");
        }
        int i2 = 0;
        while (i2 < length) {
            if (Character.isWhitespace(string.charAt(i2))) {
                throw new JSONException("'" + string + "' contains a space character.");
            }
            ++i2;
        }
    }

    private static boolean parse(XMLTokener x2, JSONObject context, String name) throws JSONException {
        String string;
        JSONObject jsonobject = null;
        Object token = x2.nextToken();
        if (token == BANG) {
            char c2 = x2.next();
            if (c2 == '-') {
                if (x2.next() == '-') {
                    x2.skipPast("-->");
                    return false;
                }
                x2.back();
            } else if (c2 == '[') {
                token = x2.nextToken();
                if ("CDATA".equals(token) && x2.next() == '[') {
                    String string2 = x2.nextCDATA();
                    if (string2.length() > 0) {
                        context.accumulate("content", string2);
                    }
                    return false;
                }
                throw x2.syntaxError("Expected 'CDATA['");
            }
            int i2 = 1;
            do {
                if ((token = x2.nextMeta()) == null) {
                    throw x2.syntaxError("Missing '>' after '<!'.");
                }
                if (token == LT) {
                    ++i2;
                    continue;
                }
                if (token != GT) continue;
                --i2;
            } while (i2 > 0);
            return false;
        }
        if (token == QUEST) {
            x2.skipPast("?>");
            return false;
        }
        if (token == SLASH) {
            token = x2.nextToken();
            if (name == null) {
                throw x2.syntaxError("Mismatched close tag " + token);
            }
            if (!token.equals(name)) {
                throw x2.syntaxError("Mismatched " + name + " and " + token);
            }
            if (x2.nextToken() != GT) {
                throw x2.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw x2.syntaxError("Misshaped tag");
        }
        String tagName = (String)token;
        token = null;
        jsonobject = new JSONObject();
        while (true) {
            if (token == null) {
                token = x2.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = x2.nextToken();
            if (token == EQ) {
                token = x2.nextToken();
                if (!(token instanceof String)) {
                    throw x2.syntaxError("Missing value");
                }
                jsonobject.accumulate(string, XML.stringToValue((String)token));
                token = null;
                continue;
            }
            jsonobject.accumulate(string, "");
        }
        if (token == SLASH) {
            if (x2.nextToken() != GT) {
                throw x2.syntaxError("Misshaped tag");
            }
            if (jsonobject.length() > 0) {
                context.accumulate(tagName, jsonobject);
            } else {
                context.accumulate(tagName, "");
            }
            return false;
        }
        if (token == GT) {
            while (true) {
                if ((token = x2.nextContent()) == null) {
                    if (tagName != null) {
                        throw x2.syntaxError("Unclosed tag " + tagName);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.length() <= 0) continue;
                    jsonobject.accumulate("content", XML.stringToValue(string));
                    continue;
                }
                if (token == LT && XML.parse(x2, jsonobject, tagName)) break;
            }
            if (jsonobject.length() == 0) {
                context.accumulate(tagName, "");
            } else if (jsonobject.length() == 1 && jsonobject.opt("content") != null) {
                context.accumulate(tagName, jsonobject.opt("content"));
            } else {
                context.accumulate(tagName, jsonobject);
            }
            return false;
        }
        throw x2.syntaxError("Misshaped tag");
    }

    public static Object stringToValue(String string) {
        if ("".equals(string)) {
            return string;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string)) {
            return JSONObject.NULL;
        }
        if ("0".equals(string)) {
            return new Integer(0);
        }
        try {
            char initial = string.charAt(0);
            boolean negative = false;
            if (initial == '-') {
                initial = string.charAt(1);
                negative = true;
            }
            if (initial == '0' && string.charAt(negative ? 2 : 1) == '0') {
                return string;
            }
            if (initial >= '0' && initial <= '9') {
                if (string.indexOf(46) >= 0) {
                    return Double.valueOf(string);
                }
                if (string.indexOf(101) < 0 && string.indexOf(69) < 0) {
                    Long myLong = new Long(string);
                    if (myLong == (long)myLong.intValue()) {
                        return new Integer(myLong.intValue());
                    }
                    return myLong;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        JSONObject jo2 = new JSONObject();
        XMLTokener x2 = new XMLTokener(string);
        while (x2.more() && x2.skipPast("<")) {
            XML.parse(x2, jo2, null);
        }
        return jo2;
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String tagName) throws JSONException {
        String string;
        StringBuffer sb = new StringBuffer();
        if (object instanceof JSONObject) {
            if (tagName != null) {
                sb.append('<');
                sb.append(tagName);
                sb.append('>');
            }
            JSONObject jo2 = (JSONObject)object;
            Iterator<String> keys = jo2.keys();
            while (keys.hasNext()) {
                int i2;
                int length;
                JSONArray ja2;
                String key = keys.next().toString();
                Object value = jo2.opt(key);
                if (value == null) {
                    value = "";
                }
                String string2 = value instanceof String ? (String)value : null;
                if ("content".equals(key)) {
                    if (value instanceof JSONArray) {
                        ja2 = (JSONArray)value;
                        length = ja2.length();
                        i2 = 0;
                        while (i2 < length) {
                            if (i2 > 0) {
                                sb.append('\n');
                            }
                            sb.append(XML.escape(ja2.get(i2).toString()));
                            ++i2;
                        }
                        continue;
                    }
                    sb.append(XML.escape(value.toString()));
                    continue;
                }
                if (value instanceof JSONArray) {
                    ja2 = (JSONArray)value;
                    length = ja2.length();
                    i2 = 0;
                    while (i2 < length) {
                        value = ja2.get(i2);
                        if (value instanceof JSONArray) {
                            sb.append('<');
                            sb.append(key);
                            sb.append('>');
                            sb.append(XML.toString(value));
                            sb.append("</");
                            sb.append(key);
                            sb.append('>');
                        } else {
                            sb.append(XML.toString(value, key));
                        }
                        ++i2;
                    }
                    continue;
                }
                if ("".equals(value)) {
                    sb.append('<');
                    sb.append(key);
                    sb.append("/>");
                    continue;
                }
                sb.append(XML.toString(value, key));
            }
            if (tagName != null) {
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
            }
            return sb.toString();
        }
        if (object.getClass().isArray()) {
            object = new JSONArray(object);
        }
        if (object instanceof JSONArray) {
            JSONArray ja3 = (JSONArray)object;
            int length = ja3.length();
            int i3 = 0;
            while (i3 < length) {
                sb.append(XML.toString(ja3.opt(i3), tagName == null ? "array" : tagName));
                ++i3;
            }
            return sb.toString();
        }
        String string3 = string = object == null ? "null" : XML.escape(object.toString());
        return tagName == null ? "\"" + string + "\"" : (string.length() == 0 ? "<" + tagName + "/>" : "<" + tagName + ">" + string + "</" + tagName + ">");
    }
}

