/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class BlockSponge
extends Block {
    static final byte radius = 2;

    protected BlockSponge(int i2) {
        super(i2, Material.sponge);
        this.field_378_bb = 48;
    }

    @Override
    public void onPlace(World world, int a2, int b2, int c2) {
        super.onPlace(world, a2, b2, c2);
        int x2 = a2 - 2;
        while (x2 <= a2 + 2) {
            int y2 = b2 - 2;
            while (y2 <= b2 + 2) {
                int z2 = c2 - 2;
                while (z2 <= c2 + 2) {
                    if (world.getBlock(x2, y2, z2) == Block.waterStill.blockID || world.getBlock(x2, y2, z2) == Block.waterMoving.blockID) {
                        world.setBlock(x2, y2, z2, 0);
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    public void dropWater(World world, int x2, int y2, int z2) {
        int i2 = y2;
        while (i2 > y2 - 3) {
            if (world.getBlock(x2, i2, z2) != 0 && world.getBlock(x2, i2, z2) != Block.waterMoving.blockID || !BlockSponge.getSurroundSponge(world, x2, i2, z2)) break;
            --i2;
        }
    }

    public void flowWater(World world, int x2, int y2, int z2, int sx, int sy, int sz) {
        int radius = 3;
        if (!(world.getBlock(x2, y2, z2) != 0 && world.getBlock(x2, y2, z2) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2))) {
            this.dropWater(world, x2, y2, z2);
            if (!(x2 + 1 >= sx + radius || world.getBlock(x2 + 1, y2, z2) != 0 && world.getBlock(x2 + 1, y2, z2) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2 + 1, y2, z2))) {
                world.triggerUpdate(x2 + 1, y2, z2, 1);
            }
            if (!(z2 + 1 >= sz + radius || world.getBlock(x2, y2, z2 + 1) != 0 && world.getBlock(x2, y2, z2 + 1) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2 + 1))) {
                world.triggerUpdate(x2, y2, z2 + 1, 1);
            }
            if (!(x2 - 1 <= sx - radius || world.getBlock(x2 - 1, y2, z2) != 0 && world.getBlock(x2 - 1, y2, z2) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2 - 1, y2, z2))) {
                world.triggerUpdate(x2 - 1, y2, z2, 1);
            }
            if (!(z2 - 1 <= sz - radius || world.getBlock(x2, y2, z2 - 1) != 0 && world.getBlock(x2, y2, z2 - 1) != Block.waterMoving.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2 - 1))) {
                world.triggerUpdate(x2, y2, z2 + 1, 1);
            }
        }
    }

    @Override
    public void update(World world, int a2, int b2, int c2, Random random) {
        super.update(world, a2, b2, c2, random);
        int x2 = a2 - 2;
        while (x2 <= a2 + 2) {
            int y2 = b2 - 2;
            while (y2 <= b2 + 2) {
                int z2 = c2 - 2;
                while (z2 <= c2 + 2) {
                    if (world.getBlock(x2, y2, z2) == Block.waterStill.blockID || world.getBlock(x2, y2, z2) == Block.waterMoving.blockID) {
                        world.setBlock(x2, y2, z2, 0);
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    public void fillWater(World world, int x2, int y2, int z2) {
        int radius = 3;
        int x1 = x2 - radius;
        while (x1 <= x2 + radius) {
            int y1 = y2;
            while (y1 > y2 - radius) {
                int z1 = z2 - radius;
                while (z1 <= z2 + radius) {
                    if (!(world.getBlock(x1, y1, z1) != 0 && world.getBlock(x1, y1, z1) != Block.waterMoving.blockID && world.getBlock(x1, y1, z1) != Block.waterStill.blockID || BlockSponge.getSurroundSponge(world, x2, y2, z2))) {
                        world.setBlock(x1, y1, z1, Block.waterStill.blockID);
                    }
                    ++z1;
                }
                --y1;
            }
            ++x1;
        }
    }

    public static boolean getSurroundSponge(World world, int x2, int y2, int z2) {
        int x1 = x2 - 2;
        while (x1 <= x2 + 2) {
            int y1 = y2 - 2;
            while (y1 <= y2 + 2) {
                int z1 = z2 - 2;
                while (z1 <= z2 + 2) {
                    if (world.getBlock(x1, y1, z1) == Block.sponge.blockID) {
                        return true;
                    }
                    ++z1;
                }
                ++y1;
            }
            ++x1;
        }
        return false;
    }

    @Override
    public void onBreak(World world, int a2, int b2, int c2, int bid) {
        super.onBreak(world, a2, b2, c2, bid);
        int radius = 3;
        int x2 = a2 - radius;
        while (x2 <= a2 + radius) {
            int y2 = b2 + radius;
            while (y2 > b2 - radius) {
                int z2 = c2 - radius;
                while (z2 <= c2 + radius) {
                    if (world.getBlock(x2, y2, z2) == Block.waterStill.blockID || world.getBlock(x2, y2, z2) == Block.waterMoving.blockID) {
                        this.flowWater(world, x2, y2, z2, a2, b2, c2);
                    }
                    ++z2;
                }
                --y2;
            }
            ++x2;
        }
    }
}

