/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class Packet {
    private static Map<Integer, Class<?>> packetIdToClassMap = new HashMap();
    private static Map<Class<?>, Integer> packetClassToIdMap = new HashMap();
    public boolean packetBooleanUnknown = false;

    static {
        Packet.registerPacket(0, Packet0KeepAlive.class);
        Packet.registerPacket(1, Packet1Login.class);
        Packet.registerPacket(2, Packet2Handshake.class);
        Packet.registerPacket(3, Packet3Chat.class);
        Packet.registerPacket(4, Packet4UpdateTime.class);
        Packet.registerPacket(5, Packet5PlayerInventory.class);
        Packet.registerPacket(6, Packet6SpawnPosition.class);
        Packet.registerPacket(10, Packet10Flying.class);
        Packet.registerPacket(11, Packet11PlayerPosition.class);
        Packet.registerPacket(12, Packet12PlayerLook.class);
        Packet.registerPacket(13, Packet13PlayerLookMove.class);
        Packet.registerPacket(14, Packet14BlockDig.class);
        Packet.registerPacket(15, Packet15Place.class);
        Packet.registerPacket(16, Packet16BlockItemSwitch.class);
        Packet.registerPacket(17, Packet17AddToInventory.class);
        Packet.registerPacket(18, Packet18ArmAnimation.class);
        Packet.registerPacket(20, Packet20NamedEntitySpawn.class);
        Packet.registerPacket(21, Packet21PickupSpawn.class);
        Packet.registerPacket(22, Packet22Collect.class);
        Packet.registerPacket(23, Packet23VehicleSpawn.class);
        Packet.registerPacket(24, Packet24MobSpawn.class);
        Packet.registerPacket(29, Packet29DestroyEntity.class);
        Packet.registerPacket(30, Packet30Entity.class);
        Packet.registerPacket(31, Packet31RelEntityMove.class);
        Packet.registerPacket(32, Packet32EntityLook.class);
        Packet.registerPacket(33, Packet33RelEntityMoveLook.class);
        Packet.registerPacket(34, Packet34EntityTeleport.class);
        Packet.registerPacket(50, Packet50PreChunk.class);
        Packet.registerPacket(51, Packet51MapChunk.class);
        Packet.registerPacket(52, Packet52MultiBlockChange.class);
        Packet.registerPacket(53, Packet53BlockChange.class);
        Packet.registerPacket(59, Packet59ComplexEntity.class);
        Packet.registerPacket(60, Packet60HurtEntity.class);
        Packet.registerPacket(61, Packet61PlayerHealth.class);
        Packet.registerPacket(62, Packet62PlaySound.class);
        Packet.registerPacket(255, Packet255KickDisconnect.class);
    }

    static void registerPacket(int i2, Class<?> class1) {
        if (packetIdToClassMap.containsKey(i2)) {
            throw new IllegalArgumentException("Duplicate packet id:" + i2);
        }
        if (packetClassToIdMap.containsKey(class1)) {
            throw new IllegalArgumentException("Duplicate packet class:" + class1);
        }
        packetIdToClassMap.put(i2, class1);
        packetClassToIdMap.put(class1, i2);
    }

    public static Packet verifyId(int i2) {
        Class<?> class1;
        block3: {
            try {
                class1 = packetIdToClassMap.get(i2);
                if (class1 != null) break block3;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Skipping packet with id " + i2);
                return null;
            }
        }
        return (Packet)class1.newInstance();
    }

    public final int getId() {
        return packetClassToIdMap.get(this.getClass());
    }

    public static Packet onBaseIncoming(DataInputStream datainputstream) throws IOException {
        int i2 = datainputstream.read();
        if (i2 == -1) {
            return null;
        }
        Packet packet = Packet.verifyId(i2);
        if (packet == null) {
            throw new IOException("Bad packet id " + i2);
        }
        packet.onIncoming(datainputstream);
        return packet;
    }

    public static void sendToOutput(Packet packet, DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.write(packet.getId());
        packet.onOutgoing(dataoutputstream);
    }

    public abstract void onIncoming(DataInputStream var1) throws IOException;

    public abstract void onOutgoing(DataOutputStream var1) throws IOException;

    public abstract void handlePacket(NetHandler var1);

    public abstract int packetFunctionUnknown();

    static Class<?> _mthclass$(String s2) {
        try {
            return Class.forName(s2);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }
}

