/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import org.json.Kim;
import org.json.zip.JSONzip;
import org.json.zip.Keep;
import org.json.zip.PostMortem;

class TrieKeep
extends Keep {
    private int[] froms;
    private int[] thrus;
    private Node root;
    private Kim[] kims;

    public TrieKeep(int bits) {
        super(bits);
        this.froms = new int[this.capacity];
        this.thrus = new int[this.capacity];
        this.kims = new Kim[this.capacity];
        this.root = new Node();
    }

    public Kim kim(int integer) {
        Kim kim = this.kims[integer];
        int from = this.froms[integer];
        int thru = this.thrus[integer];
        if (from != 0 || thru != kim.length) {
            kim = new Kim(kim, from, thru);
            this.froms[integer] = 0;
            this.thrus[integer] = kim.length;
            this.kims[integer] = kim;
        }
        return kim;
    }

    public int length(int integer) {
        return this.thrus[integer] - this.froms[integer];
    }

    public int match(Kim kim, int from, int thru) {
        Node node = this.root;
        int best = -1;
        int at2 = from;
        while (at2 < thru) {
            if ((node = node.get(kim.get(at2))) == null) break;
            if (node.integer != -1) {
                best = node.integer;
            }
            ++from;
            ++at2;
        }
        return best;
    }

    public boolean postMortem(PostMortem pm) {
        boolean result = true;
        TrieKeep that = (TrieKeep)pm;
        if (this.length != that.length) {
            JSONzip.log("\nLength " + this.length + " <> " + that.length);
            return false;
        }
        if (this.capacity != that.capacity) {
            JSONzip.log("\nCapacity " + this.capacity + " <> " + that.capacity);
            return false;
        }
        int i2 = 0;
        while (i2 < this.length) {
            Kim thatkim;
            Kim thiskim = this.kim(i2);
            if (!thiskim.equals(thatkim = that.kim(i2))) {
                JSONzip.log("\n[" + i2 + "] " + thiskim + " <> " + thatkim);
                result = false;
            }
            ++i2;
        }
        return result && this.root.postMortem(that.root);
    }

    public void registerMany(Kim kim) {
        int length = kim.length;
        int limit = this.capacity - this.length;
        if (limit > 40) {
            limit = 40;
        }
        int until = length - 2;
        int from = 0;
        while (from < until) {
            int len = length - from;
            if (len > 10) {
                len = 10;
            }
            len += from;
            Node node = this.root;
            int at2 = from;
            while (at2 < len) {
                Node next = node.vet(kim.get(at2));
                if (next.integer == -1 && at2 - from >= 2) {
                    next.integer = this.length;
                    this.uses[this.length] = 1L;
                    this.kims[this.length] = kim;
                    this.froms[this.length] = from;
                    this.thrus[this.length] = at2 + 1;
                    ++this.length;
                    if (--limit <= 0) {
                        return;
                    }
                }
                node = next;
                ++at2;
            }
            ++from;
        }
    }

    public void registerOne(Kim kim) {
        int integer = this.registerOne(kim, 0, kim.length);
        if (integer != -1) {
            this.kims[integer] = kim;
        }
    }

    public int registerOne(Kim kim, int from, int thru) {
        if (this.length < this.capacity) {
            Node node = this.root;
            int at2 = from;
            while (at2 < thru) {
                node = node.vet(kim.get(at2));
                ++at2;
            }
            if (node.integer == -1) {
                int integer = this.length++;
                node.integer = integer;
                this.uses[integer] = 1L;
                this.kims[integer] = kim;
                this.froms[integer] = from;
                this.thrus[integer] = thru;
                return integer;
            }
        }
        return -1;
    }

    public void reserve() {
        if (this.capacity - this.length < 40) {
            int from = 0;
            int to = 0;
            this.root = new Node();
            while (from < this.capacity) {
                if (this.uses[from] > 1L) {
                    Kim kim = this.kims[from];
                    int thru = this.thrus[from];
                    Node node = this.root;
                    int at2 = this.froms[from];
                    while (at2 < thru) {
                        Node next;
                        node = next = node.vet(kim.get(at2));
                        ++at2;
                    }
                    node.integer = to;
                    this.uses[to] = TrieKeep.age(this.uses[from]);
                    this.froms[to] = this.froms[from];
                    this.thrus[to] = thru;
                    this.kims[to] = kim;
                    ++to;
                }
                ++from;
            }
            if (this.capacity - to < 40) {
                this.power = 0;
                this.root = new Node();
                to = 0;
            }
            this.length = to;
            while (to < this.capacity) {
                this.uses[to] = 0L;
                this.kims[to] = null;
                this.froms[to] = 0;
                this.thrus[to] = 0;
                ++to;
            }
        }
    }

    public Object value(int integer) {
        return this.kim(integer);
    }

    class Node
    implements PostMortem {
        private int integer = -1;
        private Node[] next = null;

        public Node get(int cell) {
            return this.next == null ? null : this.next[cell];
        }

        public Node get(byte cell) {
            return this.get(cell & 0xFF);
        }

        public boolean postMortem(PostMortem pm) {
            Node that = (Node)pm;
            if (that == null) {
                JSONzip.log("\nMisalign");
                return false;
            }
            if (this.integer != that.integer) {
                JSONzip.log("\nInteger " + this.integer + " <> " + that.integer);
                return false;
            }
            if (this.next == null) {
                if (that.next == null) {
                    return true;
                }
                JSONzip.log("\nNext is null " + this.integer);
                return false;
            }
            int i2 = 0;
            while (i2 < 256) {
                Node node = this.next[i2];
                if (node != null) {
                    if (!node.postMortem(that.next[i2])) {
                        return false;
                    }
                } else if (that.next[i2] != null) {
                    JSONzip.log("\nMisalign " + i2);
                    return false;
                }
                ++i2;
            }
            return true;
        }

        public void set(int cell, Node node) {
            if (this.next == null) {
                this.next = new Node[256];
            }
            this.next[cell] = node;
        }

        public void set(byte cell, Node node) {
            this.set(cell & 0xFF, node);
        }

        public Node vet(int cell) {
            Node node = this.get(cell);
            if (node == null) {
                node = new Node();
                this.set(cell, node);
            }
            return node;
        }

        public Node vet(byte cell) {
            return this.vet(cell & 0xFF);
        }
    }
}

