/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityDiggingFX;
import com.mojang.minecraft.entity.EntityFX;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.opengl.GL11;

public class EffectRenderer {
    protected World worldObj;
    private List<Object>[] fxLayers = new List[4];
    private RenderEngine renderer;
    private Random rand = new Random();
    protected Minecraft mc;

    public EffectRenderer(World world, RenderEngine renderengine, Minecraft minecraft) {
        if (world != null) {
            this.worldObj = world;
        }
        if (minecraft != null) {
            this.mc = minecraft;
        }
        this.renderer = renderengine;
        int i2 = 0;
        while (i2 < 4) {
            this.fxLayers[i2] = new ArrayList<Object>();
            ++i2;
        }
    }

    public void addEffect(EntityFX entityfx) {
        int i2 = entityfx.func_404_c();
        this.fxLayers[i2].add(entityfx);
    }

    public void updateEffects() {
        int i2 = 0;
        while (i2 < 4) {
            int j2 = 0;
            while (j2 < this.fxLayers[i2].size()) {
                EntityFX entityfx = (EntityFX)this.fxLayers[i2].get(j2);
                entityfx.onUpdate();
                if (entityfx.isDead) {
                    this.fxLayers[i2].remove(j2--);
                }
                ++j2;
            }
            ++i2;
        }
    }

    public void renderParticles(Entity entity, float f2) {
        float f1 = MathHelper.cos(entity.rotationYaw * 3.141593f / 180.0f);
        float f22 = MathHelper.sin(entity.rotationYaw * 3.141593f / 180.0f);
        float f3 = -f22 * MathHelper.sin(entity.rotationPitch * 3.141593f / 180.0f);
        float f4 = f1 * MathHelper.sin(entity.rotationPitch * 3.141593f / 180.0f);
        float f5 = MathHelper.cos(entity.rotationPitch * 3.141593f / 180.0f);
        EntityFX.field_660_l = entity.lastTickPosX + (entity.posX - entity.lastTickPosX) * (double)f2;
        EntityFX.field_659_m = entity.lastTickPosY + (entity.posY - entity.lastTickPosY) * (double)f2;
        EntityFX.field_658_n = entity.lastTickPosZ + (entity.posZ - entity.lastTickPosZ) * (double)f2;
        int i2 = 0;
        while (i2 < 3) {
            if (this.fxLayers[i2].size() != 0) {
                int j2 = 0;
                if (i2 == 0) {
                    j2 = this.renderer.getTex("/particles.png");
                }
                if (i2 == 1) {
                    j2 = this.renderer.getTex("/terrain.png");
                }
                if (i2 == 2) {
                    j2 = this.renderer.getTex("/gui/items.png");
                }
                GL11.glBindTexture((int)3553, (int)j2);
                Tessellator tessellator = Tessellator.instance;
                tessellator.startDrawingQuads();
                int k2 = 0;
                while (k2 < this.fxLayers[i2].size()) {
                    EntityFX entityfx = (EntityFX)this.fxLayers[i2].get(k2);
                    entityfx.renderParticle(tessellator, f2, f1, f5, f22, f3, f4);
                    ++k2;
                }
                tessellator.draw();
            }
            ++i2;
        }
    }

    public void func_1187_b(Entity entity, float f2) {
        int byte0 = 3;
        if (this.fxLayers[byte0].size() != 0) {
            Tessellator tessellator = Tessellator.instance;
            int i2 = 0;
            while (i2 < this.fxLayers[byte0].size()) {
                EntityFX entityfx = (EntityFX)this.fxLayers[byte0].get(i2);
                entityfx.renderParticle(tessellator, f2, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                ++i2;
            }
        }
    }

    public void clearEffects(World world) {
        this.worldObj = world;
        int i2 = 0;
        while (i2 < 4) {
            this.fxLayers[i2].clear();
            ++i2;
        }
    }

    public void addBlockDestroyEffects(int i2, int j2, int k2) {
        int l2 = this.worldObj.getBlockId(i2, j2, k2);
        if (l2 != 0 && this.mc.options.particles) {
            Block block = Block.allBlocks[l2];
            int i1 = 4;
            int j1 = 0;
            while (j1 < i1) {
                int k1 = 0;
                while (k1 < i1) {
                    int l1 = 0;
                    while (l1 < i1) {
                        double d2 = (double)i2 + ((double)j1 + 0.5) / (double)i1;
                        double d1 = (double)j2 + ((double)k1 + 0.5) / (double)i1;
                        double d22 = (double)k2 + ((double)l1 + 0.5) / (double)i1;
                        this.addEffect(new EntityDiggingFX(this.worldObj, d2, d1, d22, d2 - (double)i2 - 0.5, d1 - (double)j2 - 0.5, d22 - (double)k2 - 0.5, block));
                        ++l1;
                    }
                    ++k1;
                }
                ++j1;
            }
        }
    }

    public void addBlockHitEffects(int i2, int j2, int k2, int l2) {
        int i1 = this.worldObj.getBlockId(i2, j2, k2);
        if (i1 != 0 && this.mc.options.particles) {
            Block block = Block.allBlocks[i1];
            float f2 = 0.1f;
            double d2 = (double)i2 + this.rand.nextDouble() * (block.maxX - block.minX - (double)(f2 * 2.0f)) + (double)f2 + block.minX;
            double d1 = (double)j2 + this.rand.nextDouble() * (block.maxY - block.minY - (double)(f2 * 2.0f)) + (double)f2 + block.minY;
            double d22 = (double)k2 + this.rand.nextDouble() * (block.maxZ - block.minZ - (double)(f2 * 2.0f)) + (double)f2 + block.minZ;
            if (l2 == 0) {
                d1 = (double)j2 + block.minY - (double)f2;
            }
            if (l2 == 1) {
                d1 = (double)j2 + block.maxY + (double)f2;
            }
            if (l2 == 2) {
                d22 = (double)k2 + block.minZ - (double)f2;
            }
            if (l2 == 3) {
                d22 = (double)k2 + block.maxZ + (double)f2;
            }
            if (l2 == 4) {
                d2 = (double)i2 + block.minX - (double)f2;
            }
            if (l2 == 5) {
                d2 = (double)i2 + block.maxX + (double)f2;
            }
            this.addEffect(new EntityDiggingFX(this.worldObj, d2, d1, d22, 0.0, 0.0, 0.0, block).func_407_b(0.2f).func_405_d(0.6f));
        }
    }

    public String getStatistics() {
        return "" + (this.fxLayers[0].size() + this.fxLayers[1].size() + this.fxLayers[2].size());
    }
}

