/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.inventory;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemArmor;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;

public class InventoryPlayer
implements IInventory {
    public ItemStack[] mainInventory = new ItemStack[37];
    public ItemStack[] armorInventory = new ItemStack[4];
    public ItemStack[] craftingInventory = new ItemStack[4];
    public int currentItem = 0;
    EntityPlayer player;
    public ItemStack itemStack;
    public boolean inventoryChanged = false;

    public InventoryPlayer(EntityPlayer entityplayer) {
        this.player = entityplayer;
    }

    public ItemStack getCurrentItem() {
        if (this.currentItem < 9 && this.currentItem >= 0) {
            return this.mainInventory[this.currentItem];
        }
        return null;
    }

    private int getInventorySlotContainItem(int i2) {
        int j2 = 0;
        while (j2 < this.mainInventory.length) {
            if (this.mainInventory[j2] != null && this.mainInventory[j2].itemID == i2) {
                return j2;
            }
            ++j2;
        }
        return -1;
    }

    private int storeItemStack(int i2) {
        int j2 = 0;
        while (j2 < this.mainInventory.length) {
            if (this.mainInventory[j2] != null && this.mainInventory[j2].itemID == i2 && this.mainInventory[j2].stackSize < this.mainInventory[j2].getMaxStackSize() && this.mainInventory[j2].stackSize < this.getInventoryStackLimit()) {
                return j2;
            }
            ++j2;
        }
        return -1;
    }

    private int getFirstEmptyStack() {
        int i2 = 0;
        while (i2 < this.mainInventory.length) {
            if (this.mainInventory[i2] == null) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void setCurrentItem(int i2, int stackSize, boolean flag) {
        int j2;
        if (flag && i2 > 0) {
            this.mainInventory[this.currentItem] = new ItemStack(i2, stackSize);
        }
        if ((j2 = this.getInventorySlotContainItem(i2)) >= 0 && j2 < 36) {
            if (j2 >= 9 && !this.player.worldObj.multiplayerWorld) {
                ItemStack h2 = this.mainInventory[this.currentItem];
                this.mainInventory[this.currentItem] = this.mainInventory[j2];
                this.mainInventory[j2] = h2;
            } else {
                if (this.player.worldObj.multiplayerWorld && j2 >= 9) {
                    return;
                }
                this.currentItem = j2;
            }
            return;
        }
    }

    public void changeCurrentItem(int i2) {
        if (i2 > 0) {
            i2 = 1;
        }
        if (i2 < 0) {
            i2 = -1;
        }
        this.currentItem -= i2;
        while (this.currentItem < 0) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9) {
            this.currentItem -= 9;
        }
    }

    private int storePartialItemStack(ItemStack itemstack) {
        int l2;
        int i2 = itemstack.itemID;
        int j2 = itemstack.stackSize;
        int k2 = this.storeItemStack(i2);
        if (k2 < 0) {
            k2 = this.getFirstEmptyStack();
        }
        if (k2 < 0) {
            return j2;
        }
        if (this.mainInventory[k2] == null) {
            this.mainInventory[k2] = new ItemStack(i2, 0);
        }
        if ((l2 = j2) > this.mainInventory[k2].getMaxStackSize() - this.mainInventory[k2].stackSize) {
            l2 = this.mainInventory[k2].getMaxStackSize() - this.mainInventory[k2].stackSize;
        }
        if (l2 > this.getInventoryStackLimit() - this.mainInventory[k2].stackSize) {
            l2 = this.getInventoryStackLimit() - this.mainInventory[k2].stackSize;
        }
        if (l2 == 0) {
            return j2;
        }
        this.mainInventory[k2].stackSize += l2;
        this.mainInventory[k2].animationsToGo = 5;
        return j2 -= l2;
    }

    public void decrementAnimations() {
        int i2 = 0;
        while (i2 < this.mainInventory.length) {
            if (this.mainInventory[i2] != null && this.mainInventory[i2].animationsToGo > 0) {
                --this.mainInventory[i2].animationsToGo;
            }
            ++i2;
        }
    }

    public boolean consumeInventoryItem(int i2) {
        int j2 = this.getInventorySlotContainItem(i2);
        if (j2 < 0) {
            return false;
        }
        if (--this.mainInventory[j2].stackSize <= 0) {
            this.mainInventory[j2] = null;
        }
        return true;
    }

    public boolean addItemStackToInventory(ItemStack itemstack) {
        if (!itemstack.isItemDamaged()) {
            int i2;
            do {
                i2 = itemstack.stackSize;
                itemstack.stackSize = this.storePartialItemStack(itemstack);
            } while (itemstack.stackSize > 0 && itemstack.stackSize < i2);
            return itemstack.stackSize < i2;
        }
        int j2 = this.getFirstEmptyStack();
        if (j2 >= 0) {
            this.mainInventory[j2] = ItemStack.copyItemStack(itemstack);
            this.mainInventory[j2].animationsToGo = 5;
            itemstack.stackSize = 0;
            return true;
        }
        return false;
    }

    public ItemStack decrStackSize(int i2, int j2) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i2 >= this.mainInventory.length) {
            aitemstack = this.armorInventory;
            if ((i2 -= this.mainInventory.length) >= 4) {
                i2 -= 4;
                aitemstack = this.craftingInventory;
            }
        }
        if (aitemstack[i2] != null) {
            if (aitemstack[i2].stackSize <= j2) {
                ItemStack itemstack = aitemstack[i2];
                aitemstack[i2] = null;
                return itemstack;
            }
            ItemStack itemstack1 = aitemstack[i2].splitStack(j2);
            if (aitemstack[i2].stackSize == 0) {
                aitemstack[i2] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public int getSpongeCount() {
        int count = 0;
        if (this.armorInventory[0] != null && this.armorInventory[0].itemID == 374) {
            ++count;
        }
        if (this.armorInventory[1] != null && this.armorInventory[1].itemID == 373) {
            ++count;
        }
        if (this.armorInventory[2] != null && this.armorInventory[2].itemID == 372) {
            ++count;
        }
        if (this.armorInventory[3] != null && this.armorInventory[3].itemID == 371) {
            ++count;
        }
        return count;
    }

    public int getArmorCount(String type) {
        int baseID = 0;
        if (type.equalsIgnoreCase("leather")) {
            baseID = Item.helmetLeather.shiftedIndex;
        }
        if (type.equalsIgnoreCase("gold")) {
            baseID = Item.helmetGold.shiftedIndex;
        }
        if (type.equalsIgnoreCase("chain") || type.equalsIgnoreCase("chainmail")) {
            baseID = Item.helmetChain.shiftedIndex;
        }
        if (type.equalsIgnoreCase("steel") || type.equalsIgnoreCase("iron")) {
            baseID = Item.helmetSteel.shiftedIndex;
        }
        if (type.equalsIgnoreCase("diamond") || type.equalsIgnoreCase("emerald")) {
            baseID = Item.helmetDiamond.shiftedIndex;
        }
        if (type.equalsIgnoreCase("sponge")) {
            baseID = Item.helmetSponge.shiftedIndex;
        }
        int count = 0;
        if (this.armorInventory[0] != null && this.armorInventory[0].itemID == baseID + 3) {
            ++count;
        }
        if (this.armorInventory[1] != null && this.armorInventory[1].itemID == baseID + 2) {
            ++count;
        }
        if (this.armorInventory[2] != null && this.armorInventory[2].itemID == baseID + 1) {
            ++count;
        }
        if (this.armorInventory[3] != null && this.armorInventory[3].itemID == baseID) {
            ++count;
        }
        return count;
    }

    public void setInventorySlotContents(int i2, ItemStack itemstack) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i2 >= aitemstack.length) {
            i2 -= aitemstack.length;
            aitemstack = this.armorInventory;
            if (i2 >= 4) {
                i2 -= 4;
                aitemstack = this.craftingInventory;
            }
        }
        aitemstack[i2] = itemstack;
    }

    public float getStrVsBlock(Block block) {
        float f2 = 1.0f;
        if (this.mainInventory[this.currentItem] != null) {
            f2 *= this.mainInventory[this.currentItem].getStrVsBlock(block);
        }
        return f2;
    }

    public NBTTagList writeToNBT(NBTTagList nbttaglist) {
        int i2 = 0;
        while (i2 < this.mainInventory.length) {
            if (this.mainInventory[i2] != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setByte("Slot", (byte)i2);
                this.mainInventory[i2].writeToNBT(nbttagcompound);
                nbttaglist.setTag(nbttagcompound);
            }
            ++i2;
        }
        int j2 = 0;
        while (j2 < this.armorInventory.length) {
            if (this.armorInventory[j2] != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)(j2 + 100));
                this.armorInventory[j2].writeToNBT(nbttagcompound1);
                nbttaglist.setTag(nbttagcompound1);
            }
            ++j2;
        }
        int k2 = 0;
        while (k2 < this.craftingInventory.length) {
            if (this.craftingInventory[k2] != null) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.setByte("Slot", (byte)(k2 + 80));
                this.craftingInventory[k2].writeToNBT(nbttagcompound2);
                nbttaglist.setTag(nbttagcompound2);
            }
            ++k2;
        }
        return nbttaglist;
    }

    public void readFromNBT(NBTTagList nbttaglist) {
        this.mainInventory = new ItemStack[36];
        this.armorInventory = new ItemStack[4];
        this.craftingInventory = new ItemStack[4];
        int i2 = 0;
        while (i2 < nbttaglist.tagCount()) {
            NBTTagCompound nbttagcompound = (NBTTagCompound)nbttaglist.tagAt(i2);
            int j2 = nbttagcompound.getByte("Slot") & 0xFF;
            if (j2 >= 0 && j2 < this.mainInventory.length) {
                this.mainInventory[j2] = new ItemStack(nbttagcompound);
            }
            if (j2 >= 100 && j2 < this.armorInventory.length + 100) {
                System.out.println(String.valueOf(j2 - 100) + " || " + nbttagcompound);
                this.armorInventory[j2 - 100] = new ItemStack(nbttagcompound);
            }
            ++i2;
        }
    }

    public int getSizeInventory() {
        return this.mainInventory.length + 4;
    }

    public ItemStack getStackInSlot(int i2) {
        ItemStack[] aitemstack = this.mainInventory;
        if (i2 >= aitemstack.length) {
            i2 -= aitemstack.length;
            aitemstack = this.armorInventory;
            if (i2 >= 4) {
                i2 -= 4;
                aitemstack = this.craftingInventory;
            }
        }
        return aitemstack[i2];
    }

    public String getInvName() {
        return "Inventory";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public int getDamageVsEntity(Entity entity) {
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.getDamageVsEntity(entity);
        }
        return 1;
    }

    public boolean canHarvestBlock(Block canBreakWithHands) {
        if (canBreakWithHands.blockMaterial != Material.rock && canBreakWithHands.blockMaterial != Material.iron && canBreakWithHands.blockMaterial != Material.builtSnow && canBreakWithHands.blockMaterial != Material.snow && canBreakWithHands.blockMaterial != Material.glass && canBreakWithHands.blockMaterial != Material.ice) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.canHarvestBlock(canBreakWithHands);
        }
        return false;
    }

    public boolean canHarvestBlockGoldTouch(Block canBreakWithHands) {
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        if (itemstack != null) {
            return itemstack.isGold();
        }
        return false;
    }

    public ItemStack armorItemInSlot(int i2) {
        return this.armorInventory[i2];
    }

    public int getTotalArmorValue() {
        int armorNewDmg = 0;
        int armorDmg = 0;
        int armorMaxDmg = 0;
        int l2 = 0;
        while (l2 < this.armorInventory.length) {
            if (this.armorInventory[l2] != null && this.armorInventory[l2].getItem() instanceof ItemArmor && this.armorInventory[l2].itemID < 370) {
                int maxDmg = this.armorInventory[l2].getMaxDmg();
                int currDmg = this.armorInventory[l2].itemDamage;
                int newDmg = maxDmg - currDmg;
                armorDmg += newDmg;
                armorMaxDmg += maxDmg;
                int protLevel = ((ItemArmor)this.armorInventory[l2].getItem()).protectionLevel;
                armorNewDmg += protLevel;
            }
            ++l2;
        }
        if (armorMaxDmg == 0) {
            return 0;
        }
        return armorNewDmg;
    }

    public void damageArmor(int i2) {
        int j2 = 0;
        while (j2 < this.armorInventory.length) {
            if (this.armorInventory[j2] != null && this.armorInventory[j2].getItem() instanceof ItemArmor) {
                if (this.armorInventory[j2].itemID < 370) {
                    this.armorInventory[j2].damageItem(i2);
                }
                if (this.armorInventory[j2].stackSize == 0) {
                    this.armorInventory[j2].func_1097_a(this.player);
                    this.armorInventory[j2] = null;
                }
            }
            ++j2;
        }
    }

    public void dropAllItems() {
        int i2 = 0;
        while (i2 < this.mainInventory.length) {
            if (this.mainInventory[i2] != null) {
                this.player.dropInventory(this.mainInventory[i2], true);
                this.mainInventory[i2] = null;
            }
            ++i2;
        }
        int j2 = 0;
        while (j2 < this.armorInventory.length) {
            if (this.armorInventory[j2] != null) {
                this.player.dropInventory(this.armorInventory[j2], true);
                this.armorInventory[j2] = null;
            }
            ++j2;
        }
        j2 = 0;
        while (j2 < this.craftingInventory.length) {
            if (this.craftingInventory[j2] != null) {
                this.player.dropInventory(this.craftingInventory[j2], true);
                this.craftingInventory[j2] = null;
            }
            ++j2;
        }
    }

    public void onInventoryChanged() {
        this.inventoryChanged = true;
    }

    private boolean func_501_a(ItemStack itemstack, ItemStack itemstack1) {
        if (itemstack == null && itemstack1 == null) {
            return true;
        }
        if (itemstack == null || itemstack1 == null) {
            return false;
        }
        return itemstack.itemID == itemstack1.itemID && itemstack.stackSize == itemstack1.stackSize && itemstack.itemDamage == itemstack1.itemDamage;
    }

    public void setItemStack(ItemStack itemstack) {
        this.itemStack = itemstack;
        this.player.onItemStackChanged(itemstack);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.player.isDead) {
            return false;
        }
        return entityplayer.getDistanceSqToEntity(this.player) <= 64.0;
    }
}

