/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.controller;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityClientPlayerMP;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.networknew.NetClientHandler;
import com.mojang.minecraft.networknew.packet.Packet102WindowClick;
import com.mojang.minecraft.networknew.packet.Packet14BlockDig;
import com.mojang.minecraft.networknew.packet.Packet15Place;
import com.mojang.minecraft.networknew.packet.Packet16BlockItemSwitch;
import com.mojang.minecraft.networknew.packet.Packet7UseEntity;
import com.mojang.minecraft.player.controller.PlayerController;

public class PlayerControllerMP
extends PlayerController {
    private int currentBlockX = -1;
    private int currentBlockY = -1;
    private int currentBlockZ = -1;
    private float curBlockDamageMP = 0.0f;
    private float prevBlockDamageMP = 0.0f;
    private float h = 0.0f;
    private int blockHitDelay = 0;
    private boolean isHittingBlock = false;
    private NetClientHandler netClientHandler;
    private int currentPlayerItem = 0;

    public PlayerControllerMP(Minecraft minecraft, NetClientHandler netclienthandler) {
        super(minecraft);
        this.netClientHandler = netclienthandler;
    }

    public void flipPlayer(EntityPlayer entityplayer) {
        entityplayer.rotationYaw = -180.0f;
    }

    public boolean doDigBlock(int i2, int j2, int k2, int l2) {
        this.netClientHandler.addToSendQueue(new Packet14BlockDig(2, i2, j2, k2, l2));
        int i1 = this.mc.mcWorld.getBlockId(i2, j2, k2);
        int j1 = this.mc.mcWorld.getBlockMetadata(i2, j2, k2);
        boolean flag = super.doDigBlock(i2, j2, k2, l2);
        boolean flag1 = this.mc.thePlayer.checkBreakBlock(Block.allBlocks[i1]);
        boolean flag2 = this.mc.thePlayer.checkGoldTouch(Block.allBlocks[i1]);
        ItemStack itemstack = this.mc.thePlayer.getCurrentEquippedItem();
        if (itemstack != null) {
            itemstack.onDestroyBlock(i1, i2, j2, k2);
            if (itemstack.stackSize == 0) {
                itemstack.func_1097_a(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        if (flag && flag2) {
            Block.allBlocks[i1].dropBlockGoldTouch(this.mc.mcWorld, i2, j2, k2, j1, 1.0f);
        } else if (flag && flag1) {
            Block.allBlocks[i1].harvestBlock(this.mc.mcWorld, i2, j2, k2, j1);
        }
        return flag;
    }

    public boolean sendBlockRemoved(int i2, int j2, int k2, int l2) {
        int i1 = this.mc.mcWorld.getBlockId(i2, j2, k2);
        boolean flag = super.doDigBlock(i2, j2, k2, l2);
        ItemStack itemstack = this.mc.thePlayer.getCurrentEquippedItem();
        if (itemstack != null) {
            itemstack.onDestroyBlock(i1, i2, j2, k2);
            if (itemstack.stackSize == 0) {
                itemstack.func_1097_a(this.mc.thePlayer);
                this.mc.thePlayer.destroyCurrentEquippedItem();
            }
        }
        return flag;
    }

    public void clickBlock(int i2, int j2, int k2, int l2) {
        if (!this.isHittingBlock || i2 != this.currentBlockX || j2 != this.currentBlockY || k2 != this.currentBlockZ) {
            this.netClientHandler.addToSendQueue(new Packet14BlockDig(0, i2, j2, k2, l2));
            int i1 = this.mc.mcWorld.getBlockId(i2, j2, k2);
            if (i1 > 0 && this.curBlockDamageMP == 0.0f) {
                Block.allBlocks[i1].onBlockClicked(this.mc.mcWorld, i2, j2, k2, this.mc.thePlayer);
            }
            if (i1 > 0 && Block.allBlocks[i1].blockStrength(this.mc.thePlayer) >= 1.0f) {
                this.sendBlockRemoved(i2, j2, k2, l2);
            } else {
                this.isHittingBlock = true;
                this.currentBlockX = i2;
                this.currentBlockY = j2;
                this.currentBlockZ = k2;
                this.curBlockDamageMP = 0.0f;
                this.prevBlockDamageMP = 0.0f;
                this.h = 0.0f;
            }
        }
    }

    public void resetBlockRemoving() {
        this.curBlockDamageMP = 0.0f;
        this.isHittingBlock = false;
    }

    public void sendRemovingBlock(int i2, int j2, int k2, int l2) {
        if (!this.isHittingBlock) {
            return;
        }
        this.syncCurrentPlayItem();
        if (this.blockHitDelay > 0) {
            --this.blockHitDelay;
            return;
        }
        if (i2 == this.currentBlockX && j2 == this.currentBlockY && k2 == this.currentBlockZ) {
            int i1 = this.mc.mcWorld.getBlockId(i2, j2, k2);
            if (i1 == 0) {
                this.isHittingBlock = false;
                return;
            }
            Block block = Block.allBlocks[i1];
            this.curBlockDamageMP += block.blockStrength(this.mc.thePlayer);
            if (this.h % 4.0f == 0.0f && block != null) {
                this.mc.soundMGR.playSound(block.stepSound.func_1145_d(), (float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, (block.stepSound.getVolume() + 1.0f) / 8.0f, block.stepSound.getPitch() * 0.5f);
            }
            this.h += 1.0f;
            if (this.curBlockDamageMP >= 1.0f) {
                this.isHittingBlock = false;
                this.netClientHandler.addToSendQueue(new Packet14BlockDig(2, i2, j2, k2, l2));
                this.sendBlockRemoved(i2, j2, k2, l2);
                this.curBlockDamageMP = 0.0f;
                this.prevBlockDamageMP = 0.0f;
                this.h = 0.0f;
                this.blockHitDelay = 5;
            }
        } else {
            this.clickBlock(i2, j2, k2, l2);
        }
    }

    public void setPartialTime(float f2) {
        if (this.curBlockDamageMP <= 0.0f) {
            this.mc.ingameGUI.field_932_b = 0.0f;
            this.mc.renderGlobal.damagePartialTime = 0.0f;
        } else {
            float f1;
            this.mc.ingameGUI.field_932_b = f1 = this.prevBlockDamageMP + (this.curBlockDamageMP - this.prevBlockDamageMP) * f2;
            this.mc.renderGlobal.damagePartialTime = f1;
        }
    }

    public float getBlockReachDistance() {
        return 4.0f;
    }

    public void func_717_a(World world) {
        super.func_717_a(world);
    }

    public void updateController() {
        this.syncCurrentPlayItem();
        this.prevBlockDamageMP = this.curBlockDamageMP;
        this.mc.soundMGR.func_341_c();
    }

    private void syncCurrentPlayItem() {
        int i2 = this.mc.thePlayer.inventory.currentItem;
        if (i2 != this.currentPlayerItem) {
            this.currentPlayerItem = i2;
            this.netClientHandler.addToSendQueue(new Packet16BlockItemSwitch(this.currentPlayerItem));
        }
    }

    public void attackEntity(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet7UseEntity(entityplayer.entityId, entity.entityId, 1));
        entityplayer.attackTargetEntityWithCurrentItem(entity);
    }

    public void interactWithEntity(EntityPlayer entityplayer, Entity entity) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet7UseEntity(entityplayer.entityId, entity.entityId, 0));
        entityplayer.useCurrentItemOnEntity(entity);
    }

    public boolean sendPlaceBlock(EntityPlayer entityplayer, World world, ItemStack itemstack, int i2, int j2, int k2, int l2) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet15Place(i2, j2, k2, l2, itemstack));
        return super.sendPlaceBlock(entityplayer, world, itemstack, i2, j2, k2, l2);
    }

    public boolean sendUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        this.syncCurrentPlayItem();
        this.netClientHandler.addToSendQueue(new Packet15Place(-1, -1, -1, 255, entityplayer.inventory.getCurrentItem()));
        boolean flag = super.sendUseItem(entityplayer, world, itemstack);
        return flag;
    }

    public ItemStack func_27174_a(int window, int slot, int click, boolean flag, EntityPlayer entityplayer) {
        short act = entityplayer.craftingInventory.func_20111_a(entityplayer.inventory);
        ItemStack itemstack = super.func_27174_a(window, slot, click, flag, entityplayer);
        this.netClientHandler.addToSendQueue(new Packet102WindowClick(window, slot, click, flag, itemstack, act));
        return itemstack;
    }

    public EntityPlayer createPlayer(World world) {
        return new EntityClientPlayerMP(this.mc, world, this.mc.session, this.netClientHandler);
    }

    public void func_20086_a(int i2, EntityPlayer entityplayer) {
        if (i2 == -9999) {
            return;
        }
    }
}

