/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.networknew;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityArrow;
import com.mojang.minecraft.entity.EntityBoat;
import com.mojang.minecraft.entity.EntityFallingSand;
import com.mojang.minecraft.entity.EntityFish;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLightningBolt;
import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityMinecart;
import com.mojang.minecraft.entity.EntityOtherPlayerMP;
import com.mojang.minecraft.entity.EntityPainting;
import com.mojang.minecraft.entity.EntityPickupFX;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.EntitySnowball;
import com.mojang.minecraft.entity.EntityTNTPrimed;
import com.mojang.minecraft.entity.Explosion;
import com.mojang.minecraft.entity.item.InventoryBasic;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityFurnace;
import com.mojang.minecraft.entity.tile.TileEntityMobSpawner;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.gui.GuiConnectFailed;
import com.mojang.minecraft.gui.GuiDownloadTerrain;
import com.mojang.minecraft.level.WorldClient;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.networknew.NetHandler;
import com.mojang.minecraft.networknew.NetworkManager;
import com.mojang.minecraft.networknew.PlayerScore;
import com.mojang.minecraft.networknew.packet.Packet;
import com.mojang.minecraft.networknew.packet.Packet100OpenWindow;
import com.mojang.minecraft.networknew.packet.Packet101CloseWindow;
import com.mojang.minecraft.networknew.packet.Packet103SetSlot;
import com.mojang.minecraft.networknew.packet.Packet104WindowItems;
import com.mojang.minecraft.networknew.packet.Packet105UpdateProgressbar;
import com.mojang.minecraft.networknew.packet.Packet106Transaction;
import com.mojang.minecraft.networknew.packet.Packet10Flying;
import com.mojang.minecraft.networknew.packet.Packet130UpdateSign;
import com.mojang.minecraft.networknew.packet.Packet131MapData;
import com.mojang.minecraft.networknew.packet.Packet16BlockItemSwitch;
import com.mojang.minecraft.networknew.packet.Packet17Sleep;
import com.mojang.minecraft.networknew.packet.Packet18Animation;
import com.mojang.minecraft.networknew.packet.Packet19EntityAction;
import com.mojang.minecraft.networknew.packet.Packet1Login;
import com.mojang.minecraft.networknew.packet.Packet200Statistic;
import com.mojang.minecraft.networknew.packet.Packet20NamedEntitySpawn;
import com.mojang.minecraft.networknew.packet.Packet21PickupSpawn;
import com.mojang.minecraft.networknew.packet.Packet22Collect;
import com.mojang.minecraft.networknew.packet.Packet23VehicleSpawn;
import com.mojang.minecraft.networknew.packet.Packet24MobSpawn;
import com.mojang.minecraft.networknew.packet.Packet255KickDisconnect;
import com.mojang.minecraft.networknew.packet.Packet25EntityPainting;
import com.mojang.minecraft.networknew.packet.Packet28EntityVelocity;
import com.mojang.minecraft.networknew.packet.Packet29DestroyEntity;
import com.mojang.minecraft.networknew.packet.Packet2Handshake;
import com.mojang.minecraft.networknew.packet.Packet30Entity;
import com.mojang.minecraft.networknew.packet.Packet34EntityTeleport;
import com.mojang.minecraft.networknew.packet.Packet38EntityStatus;
import com.mojang.minecraft.networknew.packet.Packet39AttachEntity;
import com.mojang.minecraft.networknew.packet.Packet3Chat;
import com.mojang.minecraft.networknew.packet.Packet40EntityMetadata;
import com.mojang.minecraft.networknew.packet.Packet4UpdateTime;
import com.mojang.minecraft.networknew.packet.Packet50PreChunk;
import com.mojang.minecraft.networknew.packet.Packet51MapChunk;
import com.mojang.minecraft.networknew.packet.Packet52MultiBlockChange;
import com.mojang.minecraft.networknew.packet.Packet53BlockChange;
import com.mojang.minecraft.networknew.packet.Packet54PlayNoteBlock;
import com.mojang.minecraft.networknew.packet.Packet5PlayerInventory;
import com.mojang.minecraft.networknew.packet.Packet60Explosion;
import com.mojang.minecraft.networknew.packet.Packet61DoorChange;
import com.mojang.minecraft.networknew.packet.Packet69PlayerScore;
import com.mojang.minecraft.networknew.packet.Packet6SpawnPosition;
import com.mojang.minecraft.networknew.packet.Packet70Bed;
import com.mojang.minecraft.networknew.packet.Packet71Weather;
import com.mojang.minecraft.networknew.packet.Packet8UpdateHealth;
import com.mojang.minecraft.networknew.packet.Packet9Respawn;
import com.mojang.minecraft.player.controller.PlayerControllerMP;
import com.mojang.minecraft.player.inventory.Container;
import com.mojang.minecraft.util.MathHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class NetClientHandler
extends NetHandler {
    private boolean disconnected = false;
    private NetworkManager netManager;
    public String field_1209_a;
    private Minecraft mc;
    private WorldClient worldClient;
    private boolean field_1210_g = false;
    Random rand = new Random();
    public ArrayList<PlayerScore> players;

    public NetClientHandler(Minecraft minecraft, String s2, int i2) throws UnknownHostException, IOException {
        this.mc = minecraft;
        Socket socket = new Socket(InetAddress.getByName(s2), i2);
        this.netManager = new NetworkManager(socket, "Client", this);
        this.players = new ArrayList();
    }

    public void addToPlayerList(String name, int score) {
        this.players.add(new PlayerScore(name, score));
    }

    public int getIndexInPlayerList(String name) {
        int i2 = 0;
        while (i2 < this.players.size()) {
            if (this.players.get((int)i2).playerName.equals(name)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void updatePlayerScore(String name, int score) {
        if (this.getIndexInPlayerList(name) != -1) {
            this.players.get(this.getIndexInPlayerList(name)).setScore(score);
        }
    }

    public void removeFromPlayerList(String name) {
        if (this.getIndexInPlayerList(name) != -1) {
            this.players.remove(this.getIndexInPlayerList(name));
        }
    }

    public void processReadPackets() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    public void handleLogin(Packet1Login packet1login) {
        this.mc.playerController = new PlayerControllerMP(this.mc, this);
        this.worldClient = new WorldClient(this, this.mc);
        this.worldClient.multiplayerWorld = true;
        this.mc.changeWorld1(this.worldClient);
        this.worldClient.multiplayerDifficulty = packet1login.difficulty;
        this.mc.setCurrentScreen(new GuiDownloadTerrain(this));
        this.mc.thePlayer.entityId = packet1login.protocolVersion;
        System.out.println(String.valueOf(packet1login.protocolVersion) + packet1login.username + packet1login.mapSeed + packet1login.difficulty);
    }

    public void handlePlayerScore(Packet69PlayerScore packet69PlayerScore) {
        if (packet69PlayerScore.inServer) {
            if (this.getIndexInPlayerList(packet69PlayerScore.username) == -1) {
                this.addToPlayerList(packet69PlayerScore.username, packet69PlayerScore.playerScore);
            } else {
                this.updatePlayerScore(packet69PlayerScore.username, packet69PlayerScore.playerScore);
            }
        } else if (this.getIndexInPlayerList(packet69PlayerScore.username) != -1) {
            this.removeFromPlayerList(packet69PlayerScore.username);
        }
    }

    public void handlePickupSpawn(Packet21PickupSpawn packet21pickupspawn) {
        double d2 = (double)packet21pickupspawn.xPosition / 32.0;
        double d1 = (double)packet21pickupspawn.yPosition / 32.0;
        double d22 = (double)packet21pickupspawn.zPosition / 32.0;
        EntityItem entityitem = new EntityItem(this.worldClient, d2, d1, d22, new ItemStack(packet21pickupspawn.itemID, packet21pickupspawn.count, packet21pickupspawn.itemDamage));
        entityitem.motionX = (double)packet21pickupspawn.rotation / 128.0;
        entityitem.motionY = (double)packet21pickupspawn.pitch / 128.0;
        entityitem.motionZ = (double)packet21pickupspawn.roll / 128.0;
        entityitem.serverPosX = packet21pickupspawn.xPosition;
        entityitem.serverPosY = packet21pickupspawn.yPosition;
        entityitem.serverPosZ = packet21pickupspawn.zPosition;
        this.worldClient.func_712_a(packet21pickupspawn.entityId, entityitem);
    }

    public void handleVehicleSpawn(Packet23VehicleSpawn packet23vehiclespawn) {
        double d2 = (double)packet23vehiclespawn.xPosition / 32.0;
        double d1 = (double)packet23vehiclespawn.yPosition / 32.0;
        double d22 = (double)packet23vehiclespawn.zPosition / 32.0;
        Entity obj = null;
        if (packet23vehiclespawn.type == 10) {
            obj = new EntityMinecart(this.worldClient, d2, d1, d22, 0);
        }
        if (packet23vehiclespawn.type == 11) {
            obj = new EntityMinecart(this.worldClient, d2, d1, d22, 1);
        }
        if (packet23vehiclespawn.type == 12) {
            obj = new EntityMinecart(this.worldClient, d2, d1, d22, 2);
        }
        if (packet23vehiclespawn.type == 90) {
            obj = new EntityFish(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 60) {
            obj = new EntityArrow(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 61) {
            obj = new EntitySnowball(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 1) {
            obj = new EntityBoat(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 50) {
            obj = new EntityTNTPrimed(this.worldClient, d2, d1, d22);
        }
        if (packet23vehiclespawn.type == 70) {
            obj = new EntityFallingSand(this.worldClient, d2, d1, d22, Block.sand.blockID);
        }
        if (packet23vehiclespawn.type == 71) {
            obj = new EntityFallingSand(this.worldClient, d2, d1, d22, Block.gravel.blockID);
        }
        if (obj != null) {
            obj.serverPosX = packet23vehiclespawn.xPosition;
            obj.serverPosY = packet23vehiclespawn.yPosition;
            obj.serverPosZ = packet23vehiclespawn.zPosition;
            obj.rotationYaw = 0.0f;
            obj.rotationPitch = 0.0f;
            obj.entityId = packet23vehiclespawn.entityId;
            this.worldClient.func_712_a(packet23vehiclespawn.entityId, obj);
            if (packet23vehiclespawn.field_28044_i > 0) {
                Entity entity;
                if (packet23vehiclespawn.type == 60 && (entity = this.getEntityByID(packet23vehiclespawn.field_28044_i)) instanceof EntityLiving) {
                    ((EntityArrow)obj).owner = (EntityLiving)entity;
                }
                obj.setVelocity((double)packet23vehiclespawn.field_28047_e / 8000.0, (double)packet23vehiclespawn.field_28046_f / 8000.0, (double)packet23vehiclespawn.field_28045_g / 8000.0);
            }
        }
    }

    public void handleWeather(Packet71Weather packet71weather) {
        double d2 = (double)packet71weather.field_27053_b / 32.0;
        double d1 = (double)packet71weather.field_27057_c / 32.0;
        double d22 = (double)packet71weather.field_27056_d / 32.0;
        EntityLightningBolt entitylightningbolt = null;
        if (packet71weather.field_27055_e == 1) {
            entitylightningbolt = new EntityLightningBolt(this.worldClient, d2, d1, d22);
        }
        if (entitylightningbolt != null) {
            entitylightningbolt.serverPosX = packet71weather.field_27053_b;
            entitylightningbolt.serverPosY = packet71weather.field_27057_c;
            entitylightningbolt.serverPosZ = packet71weather.field_27056_d;
            entitylightningbolt.rotationYaw = 0.0f;
            entitylightningbolt.rotationPitch = 0.0f;
            entitylightningbolt.entityId = packet71weather.field_27054_a;
            this.worldClient.addWeatherEffect(entitylightningbolt);
        }
    }

    public void func_21146_a(Packet25EntityPainting packet25entitypainting) {
        EntityPainting entitypainting = new EntityPainting(this.worldClient, packet25entitypainting.xPosition, packet25entitypainting.yPosition, packet25entitypainting.zPosition, packet25entitypainting.direction, packet25entitypainting.title);
        this.worldClient.func_712_a(packet25entitypainting.entityId, entitypainting);
    }

    public void func_6498_a(Packet28EntityVelocity packet28entityvelocity) {
        Entity entity = this.getEntityByID(packet28entityvelocity.entityId);
        if (entity == null) {
            return;
        }
        entity.setVelocity((double)packet28entityvelocity.motionX / 8000.0, (double)packet28entityvelocity.motionY / 8000.0, (double)packet28entityvelocity.motionZ / 8000.0);
    }

    public void func_21148_a(Packet40EntityMetadata packet40entitymetadata) {
        Entity entity = this.getEntityByID(packet40entitymetadata.entityId);
        if (entity != null && packet40entitymetadata.func_21047_b() != null) {
            entity.getDataWatcher().updateWatchedObjectsFromList(packet40entitymetadata.func_21047_b());
        }
    }

    public void handleNamedEntitySpawn(Packet20NamedEntitySpawn packet20namedentityspawn) {
        double d2 = (double)packet20namedentityspawn.xPosition / 32.0;
        double d1 = (double)packet20namedentityspawn.yPosition / 32.0;
        double d22 = (double)packet20namedentityspawn.zPosition / 32.0;
        float f2 = (float)(packet20namedentityspawn.rotation * 360) / 256.0f;
        float f1 = (float)(packet20namedentityspawn.pitch * 360) / 256.0f;
        EntityOtherPlayerMP entityotherplayermp = new EntityOtherPlayerMP(this.mc.mcWorld, packet20namedentityspawn.name);
        entityotherplayermp.serverPosX = packet20namedentityspawn.xPosition;
        entityotherplayermp.prevPosX = entityotherplayermp.lastTickPosX = (double)entityotherplayermp.serverPosX;
        entityotherplayermp.serverPosY = packet20namedentityspawn.yPosition;
        entityotherplayermp.prevPosY = entityotherplayermp.lastTickPosY = (double)entityotherplayermp.serverPosY;
        entityotherplayermp.serverPosZ = packet20namedentityspawn.zPosition;
        entityotherplayermp.prevPosZ = entityotherplayermp.lastTickPosZ = (double)entityotherplayermp.serverPosZ;
        int i2 = packet20namedentityspawn.currentItem;
        entityotherplayermp.inventory.mainInventory[entityotherplayermp.inventory.currentItem] = i2 == 0 ? null : new ItemStack(i2, 1, 0);
        entityotherplayermp.setPositionAndRotation(d2, d1, d22, f2, f1);
        this.worldClient.func_712_a(packet20namedentityspawn.entityId, entityotherplayermp);
    }

    public void handleEntityTeleport(Packet34EntityTeleport packet34entityteleport) {
        Entity entity = this.getEntityByID(packet34entityteleport.entityId);
        if (entity == null) {
            return;
        }
        entity.serverPosX = packet34entityteleport.xPosition;
        entity.serverPosY = packet34entityteleport.yPosition;
        entity.serverPosZ = packet34entityteleport.zPosition;
        double d2 = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0 + 0.015625;
        double d22 = (double)entity.serverPosZ / 32.0;
        float f2 = (float)(packet34entityteleport.yaw * 360) / 256.0f;
        float f1 = (float)(packet34entityteleport.pitch * 360) / 256.0f;
        entity.setPositionAndRotation2(d2, d1, d22, f2, f1, 3);
    }

    public void handleEntity(Packet30Entity packet30entity) {
        Entity entity = this.getEntityByID(packet30entity.entityId);
        if (entity == null) {
            return;
        }
        entity.serverPosX += packet30entity.xPosition;
        entity.serverPosY += packet30entity.yPosition;
        entity.serverPosZ += packet30entity.zPosition;
        double d2 = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0;
        double d22 = (double)entity.serverPosZ / 32.0;
        float f2 = packet30entity.rotating ? (float)(packet30entity.yaw * 360) / 256.0f : entity.rotationYaw;
        float f1 = packet30entity.rotating ? (float)(packet30entity.pitch * 360) / 256.0f : entity.rotationPitch;
        entity.setPositionAndRotation2(d2, d1, d22, f2, f1, 3);
    }

    public void handleDestroyEntity(Packet29DestroyEntity packet29destroyentity) {
        this.worldClient.removeEntityFromWorld(packet29destroyentity.entityId);
    }

    public void handleFlying(Packet10Flying packet10flying) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        double d2 = entityplayersp.posX;
        double d1 = entityplayersp.posY;
        double d22 = entityplayersp.posZ;
        float f2 = entityplayersp.rotationYaw;
        float f1 = entityplayersp.rotationPitch;
        if (packet10flying.moving) {
            d2 = packet10flying.xPosition;
            d1 = packet10flying.yPosition;
            d22 = packet10flying.zPosition;
        }
        if (packet10flying.rotating) {
            f2 = packet10flying.yaw;
            f1 = packet10flying.pitch;
        }
        entityplayersp.ySize = 0.0f;
        entityplayersp.motionZ = 0.0;
        entityplayersp.motionY = 0.0;
        entityplayersp.motionX = 0.0;
        entityplayersp.setPositionAndRotation(d2, d1, d22, f2, f1);
        packet10flying.xPosition = entityplayersp.posX;
        packet10flying.yPosition = entityplayersp.boundingBox.minY;
        packet10flying.zPosition = entityplayersp.posZ;
        packet10flying.stance = entityplayersp.posY;
        this.netManager.addToSendQueue(packet10flying);
        if (!this.field_1210_g) {
            this.mc.thePlayer.prevPosX = this.mc.thePlayer.posX;
            this.mc.thePlayer.prevPosY = this.mc.thePlayer.posY;
            this.mc.thePlayer.prevPosZ = this.mc.thePlayer.posZ;
            this.field_1210_g = true;
            this.mc.setCurrentScreen(null);
        }
    }

    public void handlePreChunk(Packet50PreChunk packet50prechunk) {
        this.worldClient.doPreChunk(packet50prechunk.xPosition, packet50prechunk.yPosition, packet50prechunk.mode);
    }

    public void handleMultiBlockChange(Packet52MultiBlockChange packet52multiblockchange) {
        Chunk chunk = this.worldClient.getChunkFromChunkCoords(packet52multiblockchange.xPosition, packet52multiblockchange.zPosition);
        int i2 = packet52multiblockchange.xPosition * 16;
        int j2 = packet52multiblockchange.zPosition * 16;
        int k2 = 0;
        while (k2 < packet52multiblockchange.size) {
            short word0 = packet52multiblockchange.coordinateArray[k2];
            int l2 = packet52multiblockchange.typeArray[k2] & 0xFF;
            byte byte0 = packet52multiblockchange.metadataArray[k2];
            int i1 = word0 >> 12 & 0xF;
            int j1 = word0 >> 8 & 0xF;
            int k1 = word0 & 0xFF;
            chunk.setBlockIDWithMetadata(i1, k1, j1, l2, byte0);
            this.worldClient.markRangeForUpdate(i1 + i2, k1, j1 + j2, i1 + i2, k1, j1 + j2);
            this.worldClient.markBlocksDirty(i1 + i2, k1, j1 + j2, i1 + i2, k1, j1 + j2);
            ++k2;
        }
    }

    public void handleMapChunk(Packet51MapChunk packet51mapchunk) {
        this.worldClient.markRangeForUpdate(packet51mapchunk.xPosition, packet51mapchunk.yPosition, packet51mapchunk.zPosition, packet51mapchunk.xPosition + packet51mapchunk.xSize - 1, packet51mapchunk.yPosition + packet51mapchunk.ySize - 1, packet51mapchunk.zPosition + packet51mapchunk.zSize - 1);
        this.worldClient.setChunkData(packet51mapchunk.xPosition, packet51mapchunk.yPosition, packet51mapchunk.zPosition, packet51mapchunk.xSize, packet51mapchunk.ySize, packet51mapchunk.zSize, packet51mapchunk.chunk);
    }

    public void handleBlockChange(Packet53BlockChange packet53blockchange) {
        this.worldClient.func_714_c(packet53blockchange.xPosition, packet53blockchange.yPosition, packet53blockchange.zPosition, packet53blockchange.type, packet53blockchange.metadata);
    }

    public void handleKickDisconnect(Packet255KickDisconnect packet255kickdisconnect) {
        this.netManager.networkShutdown("Kicked from Server", new Object[0]);
        this.disconnected = true;
        this.mc.changeWorld1(null);
        this.players = new ArrayList();
        this.mc.setCurrentScreen(new GuiConnectFailed("Disconnected", "You've been kicked from the server:\n" + packet255kickdisconnect.reason));
    }

    public void handleErrorMessage(String s2, Object[] aobj) {
        this.players = new ArrayList();
        if (this.disconnected) {
            return;
        }
        this.disconnected = true;
        this.mc.changeWorld1(null);
        this.mc.setCurrentScreen(new GuiConnectFailed("Connection Failed", s2));
    }

    public void func_28117_a(Packet packet) {
        if (this.disconnected) {
            return;
        }
        this.netManager.addToSendQueue(packet);
        this.netManager.func_28142_c();
    }

    public void addToSendQueue(Packet packet) {
        if (this.disconnected) {
            return;
        }
        this.netManager.addToSendQueue(packet);
    }

    public void handleCollect(Packet22Collect packet22collect) {
        Entity entity = this.getEntityByID(packet22collect.collectedEntityId);
        EntityLiving obj = (EntityLiving)this.getEntityByID(packet22collect.collectorEntityId);
        if (obj == null) {
            obj = this.mc.thePlayer;
        }
        if (entity != null) {
            this.worldClient.playSoundAtEntity(entity, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.mcWorld, entity, obj, -0.5f));
            this.worldClient.removeEntityFromWorld(packet22collect.collectedEntityId);
        }
    }

    public void handleChat(Packet3Chat packet3chat) {
        this.mc.ingameGUI.addChatMessage(packet3chat.message);
    }

    public void handleArmAnimation(Packet18Animation packet18animation) {
        Entity entity = this.getEntityByID(packet18animation.entityId);
        if (entity == null) {
            return;
        }
        if (packet18animation.animate == 1) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            entityplayer.swingItem();
        } else if (packet18animation.animate == 2) {
            entity.performHurtAnimation();
        } else if (packet18animation.animate == 3) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
        } else if (packet18animation.animate == 4) {
            EntityPlayer entityplayer2 = (EntityPlayer)entity;
            entityplayer2.func_6420_o();
        }
    }

    public void handleEntityAction(Packet19EntityAction packet19entityaction) {
        EntityOtherPlayerMP playerEntity = (EntityOtherPlayerMP)this.getEntityByID(packet19entityaction.entityId);
        if (packet19entityaction.state == 1) {
            playerEntity.setSneaking(true);
        } else if (packet19entityaction.state == 2) {
            playerEntity.setSneaking(false);
        } else if (packet19entityaction.state == 3) {
            playerEntity.setRunning(true);
        } else if (packet19entityaction.state == 4) {
            playerEntity.setRunning(false);
        }
    }

    public void func_22186_a(Packet17Sleep packet17sleep) {
    }

    public void handleHandshake(Packet2Handshake packet2handshake) {
        if (packet2handshake.username.equals("-")) {
            this.addToSendQueue(new Packet1Login(this.mc.session.username, 1111));
        } else {
            try {
                URL url = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.token + "&serverId=" + packet2handshake.username);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s2 = bufferedreader.readLine();
                bufferedreader.close();
                if (s2.equalsIgnoreCase("ok")) {
                    this.addToSendQueue(new Packet1Login(this.mc.session.username, 1111));
                } else {
                    this.netManager.networkShutdown("Login Failed", new Object[]{s2});
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.netManager.networkShutdown("Disconnected", new Object[]{"Internal client error: " + exception.toString()});
            }
        }
    }

    public void disconnect() {
        this.players = new ArrayList();
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("Connection Closed", new Object[0]);
    }

    public void handleBlockItemSwitch(Packet16BlockItemSwitch packet16blockitemswitch) {
        Entity entity = this.worldClient.func_709_b(packet16blockitemswitch.id);
        if (entity == null) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        int i2 = packet16blockitemswitch.id;
        entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = i2 == 0 ? null : new ItemStack(i2);
    }

    public void handleMobSpawn(Packet24MobSpawn packet24mobspawn) {
        double d2 = (double)packet24mobspawn.xPosition / 32.0;
        double d1 = (double)packet24mobspawn.yPosition / 32.0;
        double d22 = (double)packet24mobspawn.zPosition / 32.0;
        float f2 = (float)(packet24mobspawn.yaw * 360) / 256.0f;
        float f1 = (float)(packet24mobspawn.pitch * 360) / 256.0f;
        EntityLiving entityliving = (EntityLiving)EntityList.createEntity(packet24mobspawn.type, this.mc.mcWorld);
        if (entityliving != null) {
            entityliving.serverPosX = packet24mobspawn.xPosition;
            entityliving.serverPosY = packet24mobspawn.yPosition;
            entityliving.serverPosZ = packet24mobspawn.zPosition;
            entityliving.entityId = packet24mobspawn.entityId;
            entityliving.setPositionAndRotation(d2, d1, d22, f2, f1);
            entityliving.isMultiplayerEntity = true;
            this.worldClient.func_712_a(packet24mobspawn.entityId, entityliving);
            List list = packet24mobspawn.getMetadata();
            if (list != null) {
                entityliving.getDataWatcher().updateWatchedObjectsFromList(list);
            }
        }
    }

    public void handleUpdateTime(Packet4UpdateTime packet4updatetime) {
        this.mc.mcWorld.setWorldTime(packet4updatetime.time);
    }

    public void handleSpawnPosition(Packet6SpawnPosition packet6spawnposition) {
        this.worldClient.spawnX = packet6spawnposition.xPosition;
        this.worldClient.spawnY = packet6spawnposition.yPosition;
        this.worldClient.spawnZ = packet6spawnposition.zPosition;
    }

    public void func_6497_a(Packet39AttachEntity packet39attachentity) {
        System.out.println("GOT MOUNT");
        Entity obj = this.getEntityByID(packet39attachentity.entityId);
        Entity entity = this.getEntityByID(packet39attachentity.vehicleEntityId);
        System.out.println("ATTEMPTING TO MOUNT " + obj + " TO " + entity);
        if (packet39attachentity.entityId == this.mc.thePlayer.entityId) {
            obj = this.mc.thePlayer;
        }
        if (obj == null) {
            return;
        }
        obj.mountEntity(entity);
    }

    public void func_9447_a(Packet38EntityStatus packet38entitystatus) {
        Entity entity = this.getEntityByID(packet38entitystatus.entityId);
        if (entity != null) {
            entity.handleHealthUpdate(packet38entitystatus.entityStatus);
        }
    }

    private Entity getEntityByID(int i2) {
        if (i2 == this.mc.thePlayer.entityId) {
            return this.mc.thePlayer;
        }
        return this.worldClient.func_709_b(i2);
    }

    public void handleHealth(Packet8UpdateHealth packet8updatehealth) {
        this.mc.thePlayer.setHealth(packet8updatehealth.healthMP);
    }

    public void func_9448_a(Packet9Respawn packet9respawn) {
        this.mc.respawn(true, packet9respawn.field_28048_a);
    }

    public void func_12245_a(Packet60Explosion packet60explosion) {
        Explosion explosion = new Explosion(this.mc.mcWorld, null, packet60explosion.explosionX, packet60explosion.explosionY, packet60explosion.explosionZ, packet60explosion.explosionSize);
        explosion.destroyedBlockPositions = packet60explosion.destroyedBlockPositions;
        explosion.doExplosionB(true);
    }

    public void func_20087_a(Packet100OpenWindow packet100openwindow) {
        if (packet100openwindow.inventoryType == 0) {
            InventoryBasic inventorybasic = new InventoryBasic(packet100openwindow.windowTitle, packet100openwindow.slotsCount);
            this.mc.thePlayer.displayGUIChest(inventorybasic);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 2) {
            TileEntityFurnace tileentityfurnace = new TileEntityFurnace();
            this.mc.thePlayer.displayGUIFurnace(tileentityfurnace);
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 3) {
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        } else if (packet100openwindow.inventoryType == 1) {
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            this.mc.thePlayer.displayWorkbenchGUI(MathHelper.floor_double(entityplayersp.posX), MathHelper.floor_double(entityplayersp.posY), MathHelper.floor_double(entityplayersp.posZ));
            this.mc.thePlayer.craftingInventory.windowId = packet100openwindow.windowId;
        }
    }

    public void func_20088_a(Packet103SetSlot packet103setslot) {
        if (packet103setslot.windowId == -1) {
            this.mc.thePlayer.inventory.setItemStack(packet103setslot.myItemStack);
        } else if (packet103setslot.windowId == 0 && packet103setslot.itemSlot >= 36 && packet103setslot.itemSlot < 45) {
            System.out.println(String.valueOf(packet103setslot.itemSlot) + ", " + packet103setslot.myItemStack);
            ItemStack itemstack = this.mc.thePlayer.inventorySlots.getSlot(packet103setslot.itemSlot).getStack();
            if (packet103setslot.myItemStack != null && (itemstack == null || itemstack.stackSize < packet103setslot.myItemStack.stackSize)) {
                packet103setslot.myItemStack.animationsToGo = 5;
            }
            this.mc.thePlayer.inventorySlots.putStackInSlot(packet103setslot.itemSlot, packet103setslot.myItemStack);
        } else if (packet103setslot.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            this.mc.thePlayer.craftingInventory.putStackInSlot(packet103setslot.itemSlot, packet103setslot.myItemStack);
        }
    }

    public void func_20089_a(Packet106Transaction packet106transaction) {
        Container container = null;
        if (packet106transaction.windowId == 0) {
            container = this.mc.thePlayer.inventorySlots;
        } else if (packet106transaction.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            container = this.mc.thePlayer.craftingInventory;
        }
        if (container != null) {
            if (packet106transaction.field_20030_c) {
                container.func_20113_a(packet106transaction.field_20028_b);
            } else {
                container.func_20110_b(packet106transaction.field_20028_b);
                this.addToSendQueue(new Packet106Transaction(packet106transaction.windowId, packet106transaction.field_20028_b, true));
            }
        }
    }

    public void func_20094_a(Packet104WindowItems packet104windowitems) {
        if (packet104windowitems.windowId == 0) {
            this.mc.thePlayer.inventorySlots.putStacksInSlots(packet104windowitems.itemStack);
        } else if (packet104windowitems.windowId == this.mc.thePlayer.craftingInventory.windowId) {
            this.mc.thePlayer.craftingInventory.putStacksInSlots(packet104windowitems.itemStack);
        }
    }

    public void handleSignUpdate(Packet130UpdateSign packet130updatesign) {
        if (this.mc.mcWorld.blockExists(packet130updatesign.xPosition, packet130updatesign.yPosition, packet130updatesign.zPosition)) {
            TileEntity tileentity = this.mc.mcWorld.getBlockTileEntity(packet130updatesign.xPosition, packet130updatesign.yPosition, packet130updatesign.zPosition);
            if (tileentity instanceof TileEntitySign) {
                TileEntitySign tileentitysign = (TileEntitySign)tileentity;
                int i2 = 0;
                while (i2 < 4) {
                    tileentitysign.signText[i2] = packet130updatesign.signLines[i2];
                    ++i2;
                }
                tileentitysign.onInventoryChanged();
            }
            if (tileentity instanceof TileEntityMobSpawner) {
                TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)tileentity;
                tileentitymobspawner.entityID = packet130updatesign.signLines[0];
                tileentitymobspawner.onInventoryChanged();
            }
        }
    }

    public void func_20090_a(Packet105UpdateProgressbar packet105updateprogressbar) {
        this.registerPacket(packet105updateprogressbar);
        if (this.mc.thePlayer.craftingInventory != null && this.mc.thePlayer.craftingInventory.windowId == packet105updateprogressbar.windowId) {
            this.mc.thePlayer.craftingInventory.func_20112_a(packet105updateprogressbar.progressBar, packet105updateprogressbar.progressBarValue);
        }
    }

    public void handlePlayerInventory(Packet5PlayerInventory packet5playerinventory) {
        Entity entity = this.getEntityByID(packet5playerinventory.entityID);
        if (entity != null) {
            entity.outfitWithItem(packet5playerinventory.slot, packet5playerinventory.itemID, packet5playerinventory.itemDamage);
        }
    }

    public void func_20092_a(Packet101CloseWindow packet101closewindow) {
        this.mc.thePlayer.closeScreen();
    }

    public void handleNotePlay(Packet54PlayNoteBlock packet54playnoteblock) {
    }

    public void func_25118_a(Packet70Bed packet70bed) {
    }

    public void func_28116_a(Packet131MapData packet131mapdata) {
    }

    public void func_28115_a(Packet61DoorChange packet61doorchange) {
        this.mc.mcWorld.func_28106_e(packet61doorchange.field_28050_a, packet61doorchange.field_28053_c, packet61doorchange.field_28052_d, packet61doorchange.field_28051_e, packet61doorchange.field_28049_b);
    }

    public void func_27245_a(Packet200Statistic packet200statistic) {
    }

    public boolean isServerHandler() {
        return false;
    }
}

