/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.region;

import com.mojang.minecraft.level.region.RegionFile;
import com.mojang.minecraft.level.region.RegionFileCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegionTool {
    private static boolean isConsole = false;

    RegionTool() {
    }

    public static void main(String[] args) {
        File worldDir;
        if (args.length != 2 && args.length != 3) {
            RegionTool.exitUsage();
        }
        if (System.in != null) {
            isConsole = true;
        }
        int mode = 0;
        if (args[0].equalsIgnoreCase("unpack")) {
            mode = 1;
        } else if (args[0].equalsIgnoreCase("pack")) {
            mode = 2;
        }
        if (mode == 0) {
            RegionTool.exitUsage();
        }
        if (!(worldDir = new File(args[1])).exists() || !worldDir.isDirectory()) {
            RegionTool.exit("error: " + worldDir.getPath() + " is not a directory");
        }
        File targetDir = worldDir;
        if (args.length == 3 && !(targetDir = new File(args[2])).isDirectory()) {
            targetDir.mkdirs();
        }
        if (mode == 1) {
            RegionTool.unpack(worldDir, targetDir);
        } else if (mode == 2) {
            RegionTool.pack(worldDir, targetDir);
        }
    }

    private static void unpack(File worldDir, File targetDir) {
        File regionDir = new File(worldDir, "region");
        if (!regionDir.exists()) {
            RegionTool.exit("error: region directory not found");
        }
        HashSet<File> processedFiles = null;
        if (worldDir != targetDir) {
            processedFiles = new HashSet<File>();
        }
        Pattern regionFilePattern = Pattern.compile("r\\.(-?[0-9]+)\\.(-?[0-9]+).mcr");
        File[] fileArray = regionDir.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Matcher match;
            File file = fileArray[n3];
            if (file.isFile() && (match = regionFilePattern.matcher(file.getName())).matches()) {
                try {
                    RegionTool.unpackRegionFile(targetDir, file, match);
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (processedFiles != null) {
                    processedFiles.add(file);
                }
            }
            ++n3;
        }
        if (processedFiles != null) {
            RegionTool.copyDir(worldDir, targetDir, processedFiles);
        }
    }

    private static void pack(File worldDir, File targetDir) {
        HashSet<File> processedFiles = null;
        if (worldDir != targetDir) {
            processedFiles = new HashSet<File>();
        }
        Pattern chunkFilePattern = Pattern.compile("c\\.(-?[0-9a-z]+)\\.(-?[0-9a-z]+).dat");
        Pattern chunkFolderPattern = Pattern.compile("[0-9a-z]|1[0-9a-r]");
        int chunksPacked = 0;
        int chunksSkipped = 0;
        File[] fileArray = worldDir.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File dir1 = fileArray[n3];
            if (dir1.isDirectory() && chunkFolderPattern.matcher(dir1.getName()).matches()) {
                File[] fileArray2 = dir1.listFiles();
                int n4 = fileArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    File dir2 = fileArray2[n5];
                    if (dir2.isDirectory() && chunkFolderPattern.matcher(dir2.getName()).matches()) {
                        File[] fileArray3 = dir2.listFiles();
                        int n6 = fileArray3.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            File chunkFile = fileArray3[n7];
                            Matcher m2 = chunkFilePattern.matcher(chunkFile.getName());
                            if (m2.matches()) {
                                if (RegionTool.packChunk(targetDir, chunkFile, m2)) {
                                    ++chunksPacked;
                                } else {
                                    ++chunksSkipped;
                                }
                                if (processedFiles != null) {
                                    processedFiles.add(chunkFile);
                                }
                            }
                            if (isConsole) {
                                System.out.print("\rpacked " + chunksPacked + " chunks" + (chunksSkipped > 0 ? ", skipped " + chunksSkipped + " older ones" : ""));
                            }
                            ++n7;
                        }
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        if (isConsole) {
            System.out.print("\r");
        }
        System.out.println("packed " + chunksPacked + " chunks" + (chunksSkipped > 0 ? ", skipped " + chunksSkipped + " older ones" : ""));
        if (processedFiles != null) {
            RegionTool.copyDir(worldDir, targetDir, processedFiles);
        }
    }

    private static boolean packChunk(File worldDir, File chunkFile, Matcher m2) {
        int z2;
        int x2 = Integer.parseInt(m2.group(1), 36);
        RegionFile region = RegionFileCache.getRegionFile(worldDir, x2, z2 = Integer.parseInt(m2.group(2), 36));
        if (region.lastModified() > chunkFile.lastModified()) {
            return false;
        }
        byte[] buf = new byte[4096];
        int len = 0;
        try {
            DataInputStream istream = new DataInputStream(new GZIPInputStream(new FileInputStream(chunkFile)));
            DataOutputStream out = region.getChunkDataOutputStream(x2 & 0x1F, z2 & 0x1F);
            while (len != -1) {
                out.write(buf, 0, len);
                len = istream.read(buf);
            }
            out.close();
            istream.close();
            return true;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private static void unpackRegionFile(File worldDir, File file, Matcher match) throws IOException {
        long regionModified = file.lastModified();
        RegionFile region = new RegionFile(file);
        String name = file.getName();
        int regionX = Integer.parseInt(match.group(1));
        int regionZ = Integer.parseInt(match.group(2));
        int nWritten = 0;
        int nSkipped = 0;
        int x2 = 0;
        while (x2 < 32) {
            int z2 = 0;
            while (z2 < 32) {
                DataInputStream istream = region.getChunkDataInputStream(x2, z2);
                if (istream != null) {
                    int chunkX = x2 + (regionX << 5);
                    int chunkZ = z2 + (regionZ << 5);
                    String chunkName = "c." + Integer.toString(chunkX, 36) + "." + Integer.toString(chunkZ, 36) + ".dat";
                    File chunkFile = new File(worldDir, Integer.toString(chunkX & 0x3F, 36));
                    if (!(chunkFile = new File(chunkFile, Integer.toString(chunkZ & 0x3F, 36))).exists()) {
                        chunkFile.mkdirs();
                    }
                    chunkFile = new File(chunkFile, chunkName);
                    byte[] buf = new byte[4096];
                    int len = 0;
                    if (chunkFile.lastModified() > regionModified) {
                        ++nSkipped;
                    } else {
                        try {
                            DataOutputStream out = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(chunkFile)));
                            while (len != -1) {
                                out.write(buf, 0, len);
                                len = istream.read(buf);
                            }
                            out.close();
                            ++nWritten;
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    istream.close();
                    if (isConsole) {
                        System.out.print("\r" + name + ": unpacked " + nWritten + " chunks" + (nSkipped > 0 ? ", skipped " + nSkipped + " newer ones" : ""));
                    }
                }
                ++z2;
            }
            ++x2;
        }
        if (isConsole) {
            System.out.print("\r");
        }
        System.out.println(String.valueOf(name) + ": unpacked " + nWritten + " chunks" + (nSkipped > 0 ? ", skipped " + nSkipped + " newer ones" : ""));
    }

    private static void copyDir(File srcDir, File dstDir, Set<File> skip) {
        byte[] buf = new byte[4096];
        File[] fileArray = srcDir.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block28: {
                File child = fileArray[n3];
                if (child.isDirectory()) {
                    RegionTool.copyDir(child, new File(dstDir, child.getName()), skip);
                } else if (!skip.contains(child)) {
                    FileInputStream in2 = null;
                    FileOutputStream out = null;
                    try {
                        try {
                            File dstfile = new File(dstDir, child.getName());
                            dstDir.mkdirs();
                            out = new FileOutputStream(dstfile);
                            in2 = new FileInputStream(child);
                            int len = 0;
                            while (len != -1) {
                                out.write(buf, 0, len);
                                len = in2.read(buf);
                            }
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                            if (in2 != null) {
                                try {
                                    in2.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException e4) {
                                    e4.printStackTrace();
                                }
                            }
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in2 != null) {
                            try {
                                in2.close();
                            }
                            catch (IOException e5) {
                                e5.printStackTrace();
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e6) {
                                e6.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    if (in2 != null) {
                        try {
                            in2.close();
                        }
                        catch (IOException e7) {
                            e7.printStackTrace();
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e8) {
                            e8.printStackTrace();
                        }
                    }
                }
            }
            ++n3;
        }
    }

    private static void exitUsage() {
        RegionTool.exit("regionTool: converts between chunks and regions\nusage: java -jar RegionTool.jar [un]pack <world directory> [target directory]");
    }

    private static void exit(String message) {
        System.err.println(message);
        System.exit(1);
    }
}

