/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.region;

import com.mojang.minecraft.level.region.RegionFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class RegionFileCache {
    private static final Map<File, Reference<RegionFile>> cache = new HashMap<File, Reference<RegionFile>>();

    private RegionFileCache() {
    }

    public static synchronized RegionFile getRegionFile(File basePath, int x2, int z2) {
        File regionDir = new File(basePath, "region");
        File file = new File(regionDir, "r." + (x2 >> 5) + "." + (z2 >> 5) + ".mcr");
        Reference<RegionFile> ref = cache.get(file);
        if (ref != null && ref.get() != null) {
            return ref.get();
        }
        if (!regionDir.exists()) {
            regionDir.mkdirs();
        }
        RegionFile reg = new RegionFile(file);
        cache.put(file, new SoftReference<RegionFile>(reg));
        return reg;
    }

    public static synchronized void clear() {
        for (Reference<RegionFile> ref : cache.values()) {
            try {
                if (ref.get() == null) continue;
                ref.get().close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        cache.clear();
    }

    public static int getSizeDelta(File basePath, int x2, int z2) {
        RegionFile r2 = RegionFileCache.getRegionFile(basePath, x2, z2);
        return r2.getSizeDelta();
    }

    public static DataInputStream getChunkDataInputStream(File basePath, int x2, int z2) {
        RegionFile r2 = RegionFileCache.getRegionFile(basePath, x2, z2);
        return r2.getChunkDataInputStream(x2 & 0x1F, z2 & 0x1F);
    }

    public static DataOutputStream getChunkDataOutputStream(File basePath, int x2, int z2) {
        RegionFile r2 = RegionFileCache.getRegionFile(basePath, x2, z2);
        return r2.getChunkDataOutputStream(x2 & 0x1F, z2 & 0x1F);
    }
}

