/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.chunk.ChunkProviderSky;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.generate.MapGenBase;
import com.mojang.minecraft.level.generate.MapGenCaves;
import com.mojang.minecraft.level.generate.WorldGenBigTree;
import com.mojang.minecraft.level.generate.WorldGenCactus;
import com.mojang.minecraft.level.generate.WorldGenClay;
import com.mojang.minecraft.level.generate.WorldGenCobWebs;
import com.mojang.minecraft.level.generate.WorldGenDungeons;
import com.mojang.minecraft.level.generate.WorldGenFlowers;
import com.mojang.minecraft.level.generate.WorldGenLiquids;
import com.mojang.minecraft.level.generate.WorldGenMinable;
import com.mojang.minecraft.level.generate.WorldGenReed;
import com.mojang.minecraft.level.generate.WorldGenTrees;
import com.mojang.minecraft.level.generate.WorldGenWaterDungeons;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.generate.aaa;
import com.mojang.minecraft.level.generate.noise.InfdevOldNoiseGeneratorOctaves;
import com.mojang.minecraft.level.generate.noise.NoiseGeneratorOctaves;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockSand;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class ChunkProviderGenerate
implements IChunkProvider {
    protected Random genRandom;
    protected NoiseGeneratorOctaves noiseGen1;
    protected NoiseGeneratorOctaves noiseGen2;
    protected NoiseGeneratorOctaves noiseGen3;
    protected NoiseGeneratorOctaves beachNoise;
    protected NoiseGeneratorOctaves soilNoise;
    protected InfdevOldNoiseGeneratorOctaves noiseGen1a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen2a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen3a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen4a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen5a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen6a;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves noiseGen7;
    public NoiseGeneratorOctaves treeNoise;
    protected World worldObj;
    protected double[] densities;
    protected double[] sandBeachNoise;
    protected double[] gravelBeachNoise;
    protected double[] soilThicknessNoise;
    protected MapGenBase mapGenBase;
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] heightBias1;
    double[] heightBias2;
    int[][] blockArray;

    public ChunkProviderGenerate(World world, long inputSeed) {
        if (!(this instanceof ChunkProviderSky)) {
            this.sandBeachNoise = new double[256];
            this.gravelBeachNoise = new double[256];
            this.soilThicknessNoise = new double[256];
            this.mapGenBase = new MapGenCaves();
            this.blockArray = new int[32][32];
            this.worldObj = world;
            this.genRandom = new Random(inputSeed);
            this.noiseGen1 = new NoiseGeneratorOctaves(this.genRandom, 16);
            this.noiseGen2 = new NoiseGeneratorOctaves(this.genRandom, 16);
            this.noiseGen3 = new NoiseGeneratorOctaves(this.genRandom, 8);
            this.beachNoise = new NoiseGeneratorOctaves(this.genRandom, 4);
            this.soilNoise = new NoiseGeneratorOctaves(this.genRandom, 4);
            this.noiseGen6 = new NoiseGeneratorOctaves(this.genRandom, 10);
            this.noiseGen7 = new NoiseGeneratorOctaves(this.genRandom, 16);
            this.treeNoise = new NoiseGeneratorOctaves(this.genRandom, 8);
            world.cloudHeight = 108.0f;
        }
    }

    public void generateTerrain(int chunkX, int chunkZ, byte[] blockArray) {
        int byte0 = 4;
        int seaLevel = 64;
        int k2 = byte0 + 1;
        int byte2 = 17;
        int l2 = byte0 + 1;
        this.densities = this.initializeNoiseField(this.densities, chunkX * byte0, 0, chunkZ * byte0, k2, byte2, l2);
        int genBlockSomething = 0;
        while (genBlockSomething < byte0) {
            int j1 = 0;
            while (j1 < byte0) {
                int k1 = 0;
                while (k1 < 16) {
                    double d2 = 0.125;
                    double d1 = this.densities[((genBlockSomething + 0) * l2 + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d22 = this.densities[((genBlockSomething + 0) * l2 + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d3 = this.densities[((genBlockSomething + 1) * l2 + (j1 + 0)) * byte2 + (k1 + 0)];
                    double d4 = this.densities[((genBlockSomething + 1) * l2 + (j1 + 1)) * byte2 + (k1 + 0)];
                    double d5 = (this.densities[((genBlockSomething + 0) * l2 + (j1 + 0)) * byte2 + (k1 + 1)] - d1) * d2;
                    double d6 = (this.densities[((genBlockSomething + 0) * l2 + (j1 + 1)) * byte2 + (k1 + 1)] - d22) * d2;
                    double d7 = (this.densities[((genBlockSomething + 1) * l2 + (j1 + 0)) * byte2 + (k1 + 1)] - d3) * d2;
                    double d8 = (this.densities[((genBlockSomething + 1) * l2 + (j1 + 1)) * byte2 + (k1 + 1)] - d4) * d2;
                    int l1 = 0;
                    while (l1 < 8) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d22;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d22) * d9;
                        int i2 = 0;
                        while (i2 < 4) {
                            int j2 = i2 + genBlockSomething * 4 << 11 | 0 + j1 * 4 << 7 | k1 * 8 + l1;
                            int c2 = 128;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            int k22 = 0;
                            while (k22 < 4) {
                                int l22 = 0;
                                if (k1 * 8 + l1 < seaLevel) {
                                    l22 = this.worldObj.snowCovered && k1 * 8 + l1 >= seaLevel - 1 ? Block.ice.blockID : Block.waterStill.blockID;
                                }
                                if (d15 > 0.0) {
                                    l22 = Block.stone.blockID;
                                }
                                blockArray[j2] = (byte)l22;
                                j2 += c2;
                                d15 += d16;
                                ++k22;
                            }
                            d10 += d12;
                            d11 += d13;
                            ++i2;
                        }
                        d1 += d5;
                        d22 += d6;
                        d3 += d7;
                        d4 += d8;
                        ++l1;
                    }
                    ++k1;
                }
                ++j1;
            }
            ++genBlockSomething;
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, byte[] blockArray) {
        int seaLevel = 64;
        double d2 = 0.03125;
        this.sandBeachNoise = this.beachNoise.generateNoiseOctaves_2(this.sandBeachNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2, d2, 1.0);
        this.gravelBeachNoise = this.beachNoise.generateNoiseOctaves_2(this.gravelBeachNoise, chunkZ * 16, 109.0134, chunkX * 16, 16, 1, 16, d2, 1.0, d2);
        this.soilThicknessNoise = this.soilNoise.generateNoiseOctaves_2(this.soilThicknessNoise, chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, d2 * 2.0, d2 * 2.0, d2 * 2.0);
        int xIndex = 0;
        while (xIndex < 16) {
            int zIndex = 0;
            while (zIndex < 16) {
                boolean genSandBeach = this.sandBeachNoise[zIndex + xIndex * 16] + this.genRandom.nextDouble() * 0.2 > 0.0;
                boolean genGravelBeach = this.gravelBeachNoise[xIndex + zIndex * 16] + this.genRandom.nextDouble() * 0.2 > 3.0;
                int soilThickness = (int)(this.soilThicknessNoise[zIndex + xIndex * 16] / 3.0 + 3.0 + this.genRandom.nextDouble() * 0.25);
                int surfaceIterator = -1;
                byte topLayerBlock = (byte)Block.grass.blockID;
                byte subsurfaceLayerBlock = (byte)Block.dirt.blockID;
                int yLevelIndex = 127;
                while (yLevelIndex >= 0) {
                    int currentBlock = (xIndex * 16 + zIndex) * 128 + yLevelIndex;
                    if (yLevelIndex <= 0 + this.genRandom.nextInt(6) - 1) {
                        blockArray[currentBlock] = (byte)Block.bedrock.blockID;
                    } else {
                        byte byte3 = blockArray[currentBlock];
                        if (byte3 == 0) {
                            surfaceIterator = -1;
                        } else if (byte3 == Block.stone.blockID) {
                            if (surfaceIterator == -1) {
                                if (soilThickness <= 0) {
                                    topLayerBlock = 0;
                                    subsurfaceLayerBlock = (byte)Block.stone.blockID;
                                } else if (yLevelIndex >= seaLevel - 4 && yLevelIndex <= seaLevel + 1) {
                                    topLayerBlock = (byte)Block.grass.blockID;
                                    subsurfaceLayerBlock = (byte)Block.dirt.blockID;
                                    if (genGravelBeach) {
                                        topLayerBlock = 0;
                                    }
                                    if (genGravelBeach) {
                                        subsurfaceLayerBlock = (byte)Block.gravel.blockID;
                                    }
                                    if (genSandBeach) {
                                        topLayerBlock = (byte)Block.sand.blockID;
                                    }
                                    if (genSandBeach) {
                                        subsurfaceLayerBlock = (byte)Block.sand.blockID;
                                    }
                                }
                                if (yLevelIndex < seaLevel && topLayerBlock == 0) {
                                    topLayerBlock = (byte)Block.waterStill.blockID;
                                }
                                surfaceIterator = soilThickness;
                                blockArray[currentBlock] = yLevelIndex >= seaLevel - 1 ? topLayerBlock : subsurfaceLayerBlock;
                            } else if (surfaceIterator > 0) {
                                --surfaceIterator;
                                blockArray[currentBlock] = subsurfaceLayerBlock;
                            }
                        }
                    }
                    --yLevelIndex;
                }
                ++zIndex;
            }
            ++xIndex;
        }
    }

    public Chunk provideChunk(int chunkX, int chunkZ) {
        this.genRandom.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        byte[] blockArray = new byte[32768];
        Chunk chunk = new Chunk(this.worldObj, blockArray, chunkX, chunkZ);
        this.generateTerrain(chunkX, chunkZ, blockArray);
        this.replaceBlocksForBiome(chunkX, chunkZ, blockArray);
        this.mapGenBase.func_867_a(this, this.worldObj, chunkX, chunkZ, blockArray);
        chunk.func_1024_c();
        return chunk;
    }

    protected double[] initializeNoiseField(double[] densityToInitialize, int chunkX, int chunkY, int chunkZ, int l2, int i1, int j1) {
        double noiseScaleX = 80.0;
        double noiseScaleY = 160.0;
        double noiseScaleZ = 80.0;
        double floatyness = 0.0;
        if (densityToInitialize == null) {
            densityToInitialize = new double[l2 * i1 * j1];
        }
        double coordinateScale = 684.412;
        double heightScale = 684.412;
        this.heightBias1 = this.noiseGen6.generateNoiseOctaves(this.heightBias1, chunkX, chunkY, chunkZ, l2, 1, j1, 1.0, 0.0, 1.0);
        this.heightBias2 = this.noiseGen7.generateNoiseOctaves(this.heightBias2, chunkX, chunkY, chunkZ, l2, 1, j1, 100.0, 0.0, 100.0);
        this.noiseData1 = this.noiseGen3.generateNoiseOctaves(this.noiseData1, chunkX, chunkY, chunkZ, l2, i1, j1, coordinateScale / noiseScaleX, heightScale / noiseScaleY, coordinateScale / noiseScaleZ);
        this.noiseData2 = this.noiseGen1.generateNoiseOctaves(this.noiseData2, chunkX, chunkY, chunkZ, l2, i1, j1, coordinateScale, heightScale, coordinateScale);
        this.noiseData3 = this.noiseGen2.generateNoiseOctaves(this.noiseData3, chunkX, chunkY, chunkZ, l2, i1, j1, coordinateScale, heightScale, coordinateScale);
        int k1 = 0;
        int l1 = 0;
        int i2 = 0;
        while (i2 < l2) {
            int j2 = 0;
            while (j2 < j1) {
                double monolithNess = (this.heightBias1[l1] + 256.0) / 512.0;
                if (monolithNess > 1.0) {
                    monolithNess = 1.0;
                }
                double d3 = floatyness;
                double heightBias = this.heightBias2[l1] / 8000.0;
                if (heightBias < 0.0) {
                    heightBias = -heightBias;
                }
                if ((heightBias = heightBias * 3.0 - 3.0) < 0.0) {
                    if ((heightBias /= 2.0) < -1.0) {
                        heightBias = -1.0;
                    }
                    heightBias /= 1.4;
                    heightBias /= 2.0;
                    monolithNess = 0.0;
                } else {
                    if (heightBias > 1.0) {
                        heightBias = 1.0;
                    }
                    heightBias /= 6.0;
                }
                monolithNess += 0.5;
                heightBias = heightBias * (double)i1 / 16.0;
                double d5 = (double)i1 / 2.0 + heightBias * 4.0;
                ++l1;
                int k2 = 0;
                while (k2 < i1) {
                    double d6 = 0.0;
                    double d7 = ((double)k2 - d5) * 12.0 / monolithNess;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k2 > i1 - 4) {
                        double d11 = (float)(k2 - (i1 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)k2 < d3) {
                        double d12 = (d3 - (double)k2) / 4.0;
                        if (d12 < 0.0) {
                            d12 = 0.0;
                        }
                        if (d12 > 1.0) {
                            d12 = 1.0;
                        }
                        d6 = d6 * (1.0 - d12) + -10.0 * d12;
                    }
                    densityToInitialize[k1] = d6;
                    ++k1;
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        return densityToInitialize;
    }

    public boolean chunkExists(int i2, int j2) {
        return true;
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i2, int j2) {
        int j16;
        int l13;
        int i9;
        int k12;
        int l7;
        int k5;
        int i11;
        int j6;
        int i4;
        BlockSand.fallInstantly = true;
        int tryX = i2 * 16;
        int tryZ = j2 * 16;
        this.genRandom.setSeed(this.worldObj.randomSeed);
        long l1 = this.genRandom.nextLong() / 2L * 2L + 1L;
        long l2 = this.genRandom.nextLong() / 2L * 2L + 1L;
        this.genRandom.setSeed((long)i2 * l1 + (long)j2 * l2 ^ this.worldObj.randomSeed);
        double d2 = 0.25;
        int i1 = 0;
        while (i1 < 8) {
            i4 = tryX + this.genRandom.nextInt(16) + 8;
            j6 = this.genRandom.nextInt(128);
            i11 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenDungeons().generate(this.worldObj, this.genRandom, i4, j6, i11);
            ++i1;
        }
        if ((tryX > 3000 || tryX < -3000 || tryZ > 3000 || tryZ < -3000) && this.genRandom.nextInt(10000) == 2) {
            int pyrX = tryX + this.genRandom.nextInt(16) + 8;
            int pyrY = this.genRandom.nextInt(128);
            int pyrZ = tryZ + this.genRandom.nextInt(16) + 8;
            new aaa().generate(this.worldObj, this.genRandom, pyrX, pyrY, pyrZ);
        }
        i1 = 0;
        while (i1 < 8) {
            i4 = tryX + this.genRandom.nextInt(16) + 8;
            j6 = this.genRandom.nextInt(512);
            i11 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenWaterDungeons().generate(this.worldObj, this.genRandom, i4, j6, i11);
            ++i1;
        }
        i1 = 0;
        while (i1 < 128) {
            i4 = tryX + this.genRandom.nextInt(16) + 8;
            j6 = this.genRandom.nextInt(128);
            i11 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenCobWebs().generate(this.worldObj, this.genRandom, i4, j6, i11);
            ++i1;
        }
        int j1 = 0;
        while (j1 < 10) {
            int j4 = tryX + this.genRandom.nextInt(16);
            int k6 = this.genRandom.nextInt(64);
            int j11 = tryZ + this.genRandom.nextInt(16);
            new WorldGenClay(8).generate(this.worldObj, this.genRandom, j4, k6, j11);
            ++j1;
        }
        int k1 = 0;
        while (k1 < 20) {
            int k4 = tryX + this.genRandom.nextInt(16);
            int l6 = this.genRandom.nextInt(128);
            int k11 = tryZ + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.worldObj, this.genRandom, k4, l6, k11);
            ++k1;
        }
        int i22 = 0;
        while (i22 < 10) {
            int l4 = tryX + this.genRandom.nextInt(16);
            int i7 = this.genRandom.nextInt(128);
            int l11 = tryZ + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.worldObj, this.genRandom, l4, i7, l11);
            ++i22;
        }
        int j22 = 0;
        while (j22 < 20) {
            int i5 = tryX + this.genRandom.nextInt(16);
            int j7 = this.genRandom.nextInt(128);
            int i12 = tryZ + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.worldObj, this.genRandom, i5, j7, i12);
            ++j22;
        }
        int k2 = 0;
        while (k2 < 20) {
            int j5 = tryX + this.genRandom.nextInt(16);
            int k7 = this.genRandom.nextInt(64);
            int j12 = tryZ + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.worldObj, this.genRandom, j5, k7, j12);
            ++k2;
        }
        int i3 = 0;
        while (i3 < 2) {
            k5 = tryX + this.genRandom.nextInt(16);
            l7 = this.genRandom.nextInt(32);
            k12 = tryZ + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.worldObj, this.genRandom, k5, l7, k12);
            ++i3;
        }
        i3 = 0;
        while (i3 < 6) {
            k5 = tryX + this.genRandom.nextInt(16);
            l7 = this.genRandom.nextInt(32);
            k12 = tryZ + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreCopper.blockID, 8).generate(this.worldObj, this.genRandom, k5, l7, k12);
            ++i3;
        }
        int j3 = 0;
        while (j3 < 8) {
            int l5 = tryX + this.genRandom.nextInt(16);
            int i8 = this.genRandom.nextInt(16);
            int l12 = tryZ + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreRed.blockID, 7).generate(this.worldObj, this.genRandom, l5, i8, l12);
            ++j3;
        }
        int k3 = 0;
        while (k3 < 1) {
            int i6 = tryX + this.genRandom.nextInt(16);
            int j8 = this.genRandom.nextInt(16);
            int i13 = tryZ + this.genRandom.nextInt(16);
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.worldObj, this.genRandom, i6, j8, i13);
            ++k3;
        }
        d2 = 0.5;
        int treeGenChance = (int)((this.treeNoise.func_806_a((double)tryX * d2, (double)tryZ * d2) / 8.0 + this.genRandom.nextDouble() * 4.0 + 4.0) / 3.0);
        if (treeGenChance < 0) {
            treeGenChance = 0;
        }
        if (this.genRandom.nextInt(10) == 0) {
            ++treeGenChance;
        }
        WorldGenerator treeGenerator = new WorldGenTrees();
        if (this.genRandom.nextInt(10) == 0) {
            treeGenerator = new WorldGenBigTree();
        }
        int k8 = 0;
        while (k8 < treeGenChance) {
            int j13 = tryX + this.genRandom.nextInt(16) + 8;
            int l15 = tryZ + this.genRandom.nextInt(16) + 8;
            ((WorldGenerator)treeGenerator).func_517_a(1.0, 1.0, 1.0);
            ((WorldGenerator)treeGenerator).generate(this.worldObj, this.genRandom, j13, this.worldObj.getHeightValue(j13, l15), l15);
            ++k8;
        }
        int l8 = 0;
        while (l8 < 2) {
            int k13 = tryX + this.genRandom.nextInt(16) + 8;
            int i16 = this.genRandom.nextInt(128);
            int j18 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantYellow.blockID).generate(this.worldObj, this.genRandom, k13, i16, j18);
            ++l8;
        }
        if (this.genRandom.nextInt(2) == 0) {
            i9 = tryX + this.genRandom.nextInt(16) + 8;
            l13 = this.genRandom.nextInt(128);
            j16 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantRed.blockID).generate(this.worldObj, this.genRandom, i9, l13, j16);
        }
        if (this.genRandom.nextInt(1) == 0) {
            i9 = tryX + this.genRandom.nextInt(16) + 8;
            l13 = this.genRandom.nextInt(128);
            j16 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.plantBlue.blockID).generate(this.worldObj, this.genRandom, i9, l13, j16);
        }
        if (this.genRandom.nextInt(4) == 0) {
            int j9 = tryX + this.genRandom.nextInt(16) + 8;
            int i14 = this.genRandom.nextInt(128);
            int k16 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.genRandom, j9, i14, k16);
        }
        if (this.genRandom.nextInt(8) == 0) {
            int k9 = tryX + this.genRandom.nextInt(16) + 8;
            int j14 = this.genRandom.nextInt(128);
            int l16 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.genRandom, k9, j14, l16);
        }
        int l9 = 0;
        while (l9 < 10) {
            int k14 = tryX + this.genRandom.nextInt(16) + 8;
            int i17 = this.genRandom.nextInt(128);
            int k18 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenReed().generate(this.worldObj, this.genRandom, k14, i17, k18);
            ++l9;
        }
        int i10 = 0;
        while (i10 < 1) {
            int l14 = tryX + this.genRandom.nextInt(16) + 8;
            int j17 = this.genRandom.nextInt(128);
            int l18 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenCactus().generate(this.worldObj, this.genRandom, l14, j17, l18);
            ++i10;
        }
        int j10 = 0;
        while (j10 < 50) {
            int i15 = tryX + this.genRandom.nextInt(16) + 8;
            int k17 = this.genRandom.nextInt(this.genRandom.nextInt(120) + 8);
            int i19 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.worldObj, this.genRandom, i15, k17, i19);
            ++j10;
        }
        int k10 = 0;
        while (k10 < 20) {
            int j15 = tryX + this.genRandom.nextInt(16) + 8;
            int l17 = this.genRandom.nextInt(this.genRandom.nextInt(this.genRandom.nextInt(112) + 8) + 8);
            int j19 = tryZ + this.genRandom.nextInt(16) + 8;
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.worldObj, this.genRandom, j15, l17, j19);
            ++k10;
        }
        int l10 = tryX + 8 + 0;
        while (l10 < tryX + 8 + 16) {
            int k15 = tryZ + 8 + 0;
            while (k15 < tryZ + 8 + 16) {
                int i18 = this.worldObj.getTopSolidOrLiquidBlock(l10, k15);
                if (this.worldObj.snowCovered && i18 > 0 && i18 < 128 && this.worldObj.getBlockId(l10, i18, k15) == 0 && this.worldObj.getMaterialXYZ(l10, i18 - 1, k15).blocksMovement() && this.worldObj.getMaterialXYZ(l10, i18 - 1, k15) != Material.ice) {
                    this.worldObj.setBlockWithNotify(l10, i18, k15, Block.snow.blockID);
                }
                ++k15;
            }
            ++l10;
        }
        BlockSand.fallInstantly = false;
    }

    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        return true;
    }

    public boolean unload100OldestChunks() {
        return false;
    }

    public boolean canSave() {
        return true;
    }
}

