/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;

public class ChunkCache
implements IBlockAccess {
    private int field_1060_a;
    private int field_1059_b;
    private Chunk[][] field_1062_c;
    private World field_1061_d;

    public ChunkCache(World world, int i2, int j2, int k2, int l2, int i1, int j1) {
        this.field_1061_d = world;
        this.field_1060_a = i2 >> 4;
        this.field_1059_b = k2 >> 4;
        int k1 = l2 >> 4;
        int l1 = j1 >> 4;
        this.field_1062_c = new Chunk[k1 - this.field_1060_a + 1][l1 - this.field_1059_b + 1];
        int i22 = this.field_1060_a;
        while (i22 <= k1) {
            int j22 = this.field_1059_b;
            while (j22 <= l1) {
                this.field_1062_c[i22 - this.field_1060_a][j22 - this.field_1059_b] = world.getChunkFromChunkCoords(i22, j22);
                ++j22;
            }
            ++i22;
        }
    }

    public int getBlockId(int i2, int j2, int k2) {
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= 128) {
            return 0;
        }
        int l2 = (i2 >> 4) - this.field_1060_a;
        int i1 = (k2 >> 4) - this.field_1059_b;
        return this.field_1062_c[l2][i1].getBlockId(i2 & 0xF, j2, k2 & 0xF);
    }

    public boolean isTouchingAir(int x2, int y2, int z2) {
        return this.getBlockId(x2 - 1, y2, z2) == 0 || this.getBlockId(x2 + 1, y2, z2) == 0 || this.getBlockId(x2, y2 - 1, z2) == 0 || this.getBlockId(x2, y2 + 1, z2) == 0 || this.getBlockId(x2, y2, z2 - 1) == 0 || this.getBlockId(x2, y2, z2 + 1) == 0;
    }

    public TileEntity getBlockTileEntity(int i2, int j2, int k2) {
        int l2 = (i2 >> 4) - this.field_1060_a;
        int i1 = (k2 >> 4) - this.field_1059_b;
        return this.field_1062_c[l2][i1].getChunkBlockTileEntity(i2 & 0xF, j2, k2 & 0xF);
    }

    public float getBrightness(int i2, int j2, int k2) {
        return World.field_1042_i[this.func_715_d(i2, j2, k2)];
    }

    public int func_715_d(int i2, int j2, int k2) {
        return this.func_716_a(i2, j2, k2, true);
    }

    public int func_716_a(int i2, int j2, int k2, boolean flag) {
        int l2;
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return 15;
        }
        if (flag && ((l2 = this.getBlockId(i2, j2, k2)) == Block.stairSingle.blockID || l2 == Block.tilledField.blockID)) {
            int k1 = this.func_716_a(i2, j2 + 1, k2, false);
            int i22 = this.func_716_a(i2 + 1, j2, k2, false);
            int j22 = this.func_716_a(i2 - 1, j2, k2, false);
            int k22 = this.func_716_a(i2, j2, k2 + 1, false);
            int l22 = this.func_716_a(i2, j2, k2 - 1, false);
            if (i22 > k1) {
                k1 = i22;
            }
            if (j22 > k1) {
                k1 = j22;
            }
            if (k22 > k1) {
                k1 = k22;
            }
            if (l22 > k1) {
                k1 = l22;
            }
            return k1;
        }
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= 128) {
            int i1 = 15 - this.field_1061_d.skyLightSubtracted;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        int j1 = (i2 >> 4) - this.field_1060_a;
        int l1 = (k2 >> 4) - this.field_1059_b;
        return this.field_1062_c[j1][l1].getBlockLightValue(i2 & 0xF, j2, k2 & 0xF, this.field_1061_d.skyLightSubtracted);
    }

    public int getBlockMetadata(int x2, int y2, int z2) {
        if (y2 < 0) {
            return 0;
        }
        if (y2 >= 128) {
            return 0;
        }
        int l2 = (x2 >> 4) - this.field_1060_a;
        int i1 = (z2 >> 4) - this.field_1059_b;
        return this.field_1062_c[l2][i1].getBlockMetadata(x2 & 0xF, y2, z2 & 0xF);
    }

    public Material getMaterialXYZ(int x2, int y2, int z2) {
        int l2 = this.getBlockId(x2, y2, z2);
        if (l2 == 0) {
            return Material.air;
        }
        return Block.allBlocks[l2].blockMaterial;
    }

    public boolean isBlockNormalCube(int x2, int y2, int z2) {
        Block block = Block.allBlocks[this.getBlockId(x2, y2, z2)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }
}

