/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.render.RenderItem;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.player.controller.PlayerControllerMP;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.render.RenderHelper;
import com.mojang.minecraft.util.Session;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public final class GuiBuild
extends GuiScreen {
    private int buildMenuTier = 0;
    private static RenderItem itemRenderer = new RenderItem();
    private Minecraft mc;

    public GuiBuild(Minecraft minecraft, int tier) {
        this.buildMenuTier = tier;
        this.mc = minecraft;
    }

    private int getBlockOnScreen(int var1, int var2) {
        if (this.mc.playerController instanceof PlayerControllerMP) {
            return -1;
        }
        int maxInvSize = (this.buildMenuTier + 1) * 45;
        if (maxInvSize >= Session.creativeInventory.size() + Session.creativeInventoryItems.size()) {
            maxInvSize -= 45 - (Session.creativeInventory.size() + Session.creativeInventoryItems.size()) % 45;
        }
        int var3 = this.buildMenuTier * 45;
        while (var3 < maxInvSize) {
            int normalizedPos = var3 - this.buildMenuTier * 45;
            int var4 = this.width / 2 + normalizedPos % 9 * 24 + -108 - 3;
            int var5 = this.height / 2 + normalizedPos / 9 * 24 + -60 + 3;
            if (var1 >= var4 && var1 <= var4 + 24 && var2 >= var5 - 12 && var2 <= var5 + 12) {
                return var3;
            }
            ++var3;
        }
        return -1;
    }

    public final void drawScreen(int var1, int var2, float f2) {
        var1 = this.getBlockOnScreen(var1, var2);
        this.drawGradientRect(this.width / 2 - 120, this.height / 2 - 90, this.width / 2 + 120, this.height / 2 + 80, -1878719232, -1070583712);
        if (var1 >= 0) {
            int normalizedPos = var1 - this.buildMenuTier * 45;
            var2 = this.width / 2 + normalizedPos % 9 * 24 + -108;
            int var3 = this.height / 2 + normalizedPos / 9 * 24 + -60;
            this.drawGradientRect(var2 - 3, var3 - 8, var2 + 23, var3 + 24 - 6, -1862270977, -1056964609);
        }
        if (this.buildMenuTier == 0) {
            this.drawCenteredString(this.fontRenderer, "Select block", this.width / 2, this.height / 2 - 80, 0xFFFFFF);
        } else if (this.buildMenuTier == 1) {
            this.drawCenteredString(this.fontRenderer, "Select block/item", this.width / 2, this.height / 2 - 80, 0xFFFFFF);
        } else {
            this.drawCenteredString(this.fontRenderer, "Select item", this.width / 2, this.height / 2 - 80, 0xFFFFFF);
        }
        RenderEngine renderEngine = this.mc.renderEngine;
        int maxInvSize = (this.buildMenuTier + 1) * 45;
        if (maxInvSize >= Session.creativeInventory.size() + Session.creativeInventoryItems.size()) {
            maxInvSize -= 45 - (Session.creativeInventory.size() + Session.creativeInventoryItems.size()) % 45;
        }
        var2 = this.buildMenuTier * 45;
        while (var2 < maxInvSize) {
            Block var4 = null;
            Item var5 = null;
            if (var2 < Session.creativeInventory.size()) {
                var4 = Session.creativeInventory.get(var2);
            } else if (var2 > Session.creativeInventory.size() - 1 && var2 < Session.creativeInventory.size() + Session.creativeInventoryItems.size()) {
                var5 = Session.creativeInventoryItems.get(var2 - Session.creativeInventory.size());
            }
            int normalizedPos = var2 - this.buildMenuTier * 45;
            int slotX = this.width / 2 + normalizedPos % 9 * 24 + -108;
            int slotY = this.height / 2 + normalizedPos / 9 * 24 + -60;
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderHelper.enableStandardItemLighting();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)32826);
            if (var4 != null) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
                itemRenderer.renderItemBlock(this.fontRenderer, this.mc.renderEngine, new ItemStack(var4), slotX, slotY);
                itemRenderer.renderTextDmg(this.fontRenderer, this.mc.renderEngine, new ItemStack(var4), slotX, slotY);
            }
            if (var5 != null) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
                itemRenderer.renderItemBlock(this.fontRenderer, this.mc.renderEngine, new ItemStack(var5), slotX, slotY);
                itemRenderer.renderTextDmg(this.fontRenderer, this.mc.renderEngine, new ItemStack(var5), slotX, slotY);
            }
            GL11.glDisable((int)32826);
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
            ++var2;
        }
    }

    protected final void mouseClicked(int var1, int var2, int var3) {
        if (var3 == 0) {
            if (this.getBlockOnScreen(var1, var2) >= 0 && this.getBlockOnScreen(var1, var2) < 82) {
                if (Keyboard.isKeyDown((int)42)) {
                    this.mc.thePlayer.inventory.setCurrentItem(Session.creativeInventory.get((int)this.getBlockOnScreen((int)var1, (int)var2)).blockID, new ItemStack(Session.creativeInventory.get(this.getBlockOnScreen(var1, var2))).getMaxStackSize(), true);
                } else {
                    this.mc.thePlayer.inventory.setCurrentItem(Session.creativeInventory.get((int)this.getBlockOnScreen((int)var1, (int)var2)).blockID, 1, true);
                }
            }
            if (this.getBlockOnScreen(var1, var2) >= 82) {
                if (Keyboard.isKeyDown((int)42)) {
                    this.mc.thePlayer.inventory.setCurrentItem(Session.creativeInventoryItems.get((int)(this.getBlockOnScreen((int)var1, (int)var2) - Session.creativeInventory.size())).shiftedIndex, new ItemStack(Session.creativeInventoryItems.get(this.getBlockOnScreen(var1, var2) - 81)).getMaxStackSize(), true);
                } else {
                    this.mc.thePlayer.inventory.setCurrentItem(Session.creativeInventoryItems.get((int)(this.getBlockOnScreen((int)var1, (int)var2) - Session.creativeInventory.size())).shiftedIndex, 1, true);
                }
            }
            this.mc.setCurrentScreen(null);
            System.out.println("Block selected: " + this.getBlockOnScreen(var1, var2));
        }
    }

    protected void keyTyped(char c2, int i2) {
        if (i2 == this.mc.options.keyBindBuild.keyCode && this.buildMenuTier < 4) {
            this.mc.setCurrentScreen(new GuiBuild(this.mc, this.buildMenuTier + 1));
        } else if (i2 == 1 || i2 == this.mc.options.keyBindInventory.keyCode) {
            this.mc.setCurrentScreen(null);
        } else if (i2 >= 1 && i2 < 7) {
            this.mc.setCurrentScreen(new GuiBuild(this.mc, i2 - 2));
        } else if (this.buildMenuTier >= 4 && i2 == this.mc.options.keyBindBuild.keyCode) {
            this.mc.setCurrentScreen(new GuiBuild(this.mc, 0));
        }
    }
}

