/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityCreature;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.entity.IMobs;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntityMobs
extends EntityCreature
implements IMobs {
    protected int maxHealth = 2;
    public double currentSpeed;
    public boolean field_773_g;
    public int field_772_h;

    public EntityMobs(World world) {
        super(world);
        this.health = 20;
        this.currentSpeed = 0.5;
        this.isRunning = true;
        this.field_773_g = false;
        this.field_772_h = 0;
    }

    public void swingItem() {
        this.field_772_h = -1;
        this.field_773_g = true;
    }

    protected void updateEntityActionState() {
        super.updateEntityActionState();
        if (this.field_773_g) {
            ++this.field_772_h;
            if (this.field_772_h == 8) {
                this.field_772_h = 0;
                this.field_773_g = false;
            }
        } else {
            this.field_772_h = 0;
        }
        this.swingProgress = (float)this.field_772_h / 8.0f;
    }

    public void onLivingUpdate() {
        float f2 = this.getEntityBrightness(1.0f);
        if (f2 > 0.5f) {
            this.field_701_U += 2;
        }
        super.onLivingUpdate();
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.multiplayerWorld && this.worldObj.difficulty == 0) {
            this.setEntityDead();
        }
    }

    protected Entity findPlayerToAttack() {
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, 16.0);
        if (entityplayer != null && this.canEntityBeSeen(entityplayer) && !entityplayer.isCreative) {
            return entityplayer;
        }
        return null;
    }

    public boolean attackEntityFrom(Entity entity, int i2) {
        if (super.attackEntityFrom(entity, i2)) {
            if (this.riddenByEntity == entity || this.entityBeingRidden == entity) {
                return true;
            }
            if (entity != this) {
                this.entityToAttack = entity;
            }
            return true;
        }
        return false;
    }

    protected void attackEntity(Entity entity, float f2) {
        if ((double)f2 < 2.5 && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            if (this.fire > 0 && this instanceof EntityZombie) {
                entity.fire = 100;
            }
            this.swingItem();
            entity.attackEntityFrom(this, this.maxHealth - (entity.chainArmor + entity.diamondArmor) / 2);
        }
    }

    protected float getBlockPathWeight(int i2, int j2, int k2) {
        return 0.5f - this.worldObj.getBrightness(i2, j2, k2);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    public boolean shouldSpawnOnTile() {
        int k2;
        int j2;
        int i2 = MathHelper.floor_double(this.posX);
        if (this.worldObj.getBlockLighting(EnumSkyBlock.Sky, i2, j2 = MathHelper.floor_double(this.boundingBox.minY), k2 = MathHelper.floor_double(this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int l2 = this.worldObj.getBlockLightValue(i2, j2, k2);
        return l2 <= this.rand.nextInt(8) && super.shouldSpawnOnTile();
    }

    public double getRealMoveSpeed() {
        return this.currentSpeed;
    }
}

