/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;

public class EntityMinecart
extends Entity
implements IInventory {
    private ItemStack[] cargoItems = new ItemStack[36];
    public int minecartCurrentDamage = 0;
    public int minecartTimeSinceHit = 0;
    public int minecartRockDirection = 1;
    private boolean field_856_i = false;
    public int minecartType;
    public int fuel;
    public double pushX;
    public double pushZ;
    private static final int[][][] field_855_j;
    private int field_854_k;
    private double field_853_l;
    private double field_852_m;
    private double field_851_n;
    private double field_850_o;
    private double field_849_p;

    static {
        int[][][] nArrayArray = new int[10][][];
        int[][] nArrayArray2 = new int[2][];
        int[] nArray = new int[3];
        nArray[2] = -1;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[2] = 1;
        nArrayArray2[1] = nArray2;
        nArrayArray[0] = nArrayArray2;
        int[][] nArrayArray3 = new int[2][];
        int[] nArray3 = new int[3];
        nArray3[0] = -1;
        nArrayArray3[0] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArrayArray3[1] = nArray4;
        nArrayArray[1] = nArrayArray3;
        int[][] nArrayArray4 = new int[2][];
        int[] nArray5 = new int[3];
        nArray5[0] = -1;
        nArray5[1] = -1;
        nArrayArray4[0] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArrayArray4[1] = nArray6;
        nArrayArray[2] = nArrayArray4;
        int[][] nArrayArray5 = new int[2][];
        int[] nArray7 = new int[3];
        nArray7[0] = -1;
        nArrayArray5[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[0] = 1;
        nArray8[1] = -1;
        nArrayArray5[1] = nArray8;
        nArrayArray[3] = nArrayArray5;
        int[][] nArrayArray6 = new int[2][];
        int[] nArray9 = new int[3];
        nArray9[2] = -1;
        nArrayArray6[0] = nArray9;
        int[] nArray10 = new int[3];
        nArray10[1] = -1;
        nArray10[2] = 1;
        nArrayArray6[1] = nArray10;
        nArrayArray[4] = nArrayArray6;
        int[][] nArrayArray7 = new int[2][];
        int[] nArray11 = new int[3];
        nArray11[1] = -1;
        nArray11[2] = -1;
        nArrayArray7[0] = nArray11;
        int[] nArray12 = new int[3];
        nArray12[2] = 1;
        nArrayArray7[1] = nArray12;
        nArrayArray[5] = nArrayArray7;
        int[][] nArrayArray8 = new int[2][];
        int[] nArray13 = new int[3];
        nArray13[2] = 1;
        nArrayArray8[0] = nArray13;
        int[] nArray14 = new int[3];
        nArray14[0] = 1;
        nArrayArray8[1] = nArray14;
        nArrayArray[6] = nArrayArray8;
        int[][] nArrayArray9 = new int[2][];
        int[] nArray15 = new int[3];
        nArray15[2] = 1;
        nArrayArray9[0] = nArray15;
        int[] nArray16 = new int[3];
        nArray16[0] = -1;
        nArrayArray9[1] = nArray16;
        nArrayArray[7] = nArrayArray9;
        int[][] nArrayArray10 = new int[2][];
        int[] nArray17 = new int[3];
        nArray17[2] = -1;
        nArrayArray10[0] = nArray17;
        int[] nArray18 = new int[3];
        nArray18[0] = -1;
        nArrayArray10[1] = nArray18;
        nArrayArray[8] = nArrayArray10;
        int[][] nArrayArray11 = new int[2][];
        int[] nArray19 = new int[3];
        nArray19[2] = -1;
        nArrayArray11[0] = nArray19;
        int[] nArray20 = new int[3];
        nArray20[0] = 1;
        nArrayArray11[1] = nArray20;
        nArrayArray[9] = nArrayArray11;
        field_855_j = nArrayArray;
    }

    public EntityMinecart(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.7f);
        this.yOffset = this.height / 2.0f;
        this.field_640_aG = false;
    }

    protected void entityInit() {
    }

    public AxisAlignedBB getCollisionBox(Entity entity) {
        return entity.boundingBox;
    }

    public AxisAlignedBB func_372_f_() {
        return this.boundingBox;
    }

    public boolean canBePushed() {
        return true;
    }

    public EntityMinecart(World world, double d2, double d1, double d22, int i2) {
        this(world);
        this.setPosition(d2, d1 + (double)this.yOffset, d22);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d2;
        this.prevPosY = d1;
        this.prevPosZ = d22;
        this.minecartType = i2;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    public boolean attackEntityFrom(Entity entity, int i2) {
        if (this.worldObj.multiplayerWorld || this.isDead) {
            this.minecartRockDirection = -this.minecartRockDirection;
            this.minecartTimeSinceHit = 10;
            this.minecartCurrentDamage += i2 * 10;
            return true;
        }
        this.minecartRockDirection = -this.minecartRockDirection;
        this.minecartTimeSinceHit = 10;
        this.minecartCurrentDamage += i2 * 10;
        if (this.minecartCurrentDamage > 40) {
            if (!this.worldObj.multiplayerWorld) {
                this.dropItemWithOffset(Item.minecartEmpty.shiftedIndex, 1, 0.0f);
                if (this.minecartType == 1) {
                    this.dropItemWithOffset(Block.crate.blockID, 1, 0.0f);
                } else if (this.minecartType == 2) {
                    this.dropItemWithOffset(Block.stoneOvenIdle.blockID, 1, 0.0f);
                }
            }
            this.setEntityDead();
        }
        return true;
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public void setEntityDead() {
        int i2 = 0;
        while (i2 < this.getSizeInventory()) {
            ItemStack itemstack = this.getStackInSlot(i2);
            if (itemstack != null) {
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f22 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int j2 = this.rand.nextInt(21) + 10;
                    if (j2 > itemstack.stackSize) {
                        j2 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= j2;
                    if (this.worldObj.multiplayerWorld) {
                        return;
                    }
                    EntityItem entityitem = new EntityItem(this.worldObj, this.posX + (double)f2, this.posY + (double)f1, this.posZ + (double)f22, new ItemStack(itemstack.itemID, j2, itemstack.itemDamage));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.rand.nextGaussian() * f3;
                    entityitem.motionY = (float)this.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.rand.nextGaussian() * f3;
                    this.worldObj.entityJoinedWorld(entityitem);
                }
            }
            ++i2;
        }
        super.setEntityDead();
    }

    public void onUpdate() {
        int k2;
        int j2;
        if (this.minecartTimeSinceHit > 0) {
            --this.minecartTimeSinceHit;
        }
        if (this.minecartCurrentDamage > 0) {
            --this.minecartCurrentDamage;
        }
        if (this.worldObj.multiplayerWorld && this.riddenByEntity == null) {
            if (this.field_854_k > 0) {
                double d2 = this.posX + (this.field_853_l - this.posX) / (double)this.field_854_k;
                double d1 = this.posY + (this.field_852_m - this.posY) / (double)this.field_854_k;
                double d3 = this.posZ + (this.field_851_n - this.posZ) / (double)this.field_854_k;
                double d4 = this.field_850_o - (double)this.rotationYaw;
                while (d4 < -180.0) {
                    d4 += 360.0;
                }
                while (d4 >= 180.0) {
                    d4 -= 360.0;
                }
                this.rotationYaw = (float)((double)this.rotationYaw + d4 / (double)this.field_854_k);
                this.rotationPitch = (float)((double)this.rotationPitch + (this.field_849_p - (double)this.rotationPitch) / (double)this.field_854_k);
                --this.field_854_k;
                this.setPosition(d2, d1, d3);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            } else {
                this.setPosition(this.posX, this.posY, this.posZ);
                this.setRotation(this.rotationYaw, this.rotationPitch);
            }
            return;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        int i2 = MathHelper.floor_double(this.posX);
        if (this.worldObj.getBlockId(i2, (j2 = MathHelper.floor_double(this.posY)) - 1, k2 = MathHelper.floor_double(this.posZ)) == Block.minecartTrack.blockID) {
            --j2;
        }
        double d2 = 0.4;
        boolean flag = false;
        double d5 = 0.0078125;
        if (this.worldObj.getBlockId(i2, j2, k2) == Block.minecartTrack.blockID) {
            double d29;
            Vec3D vec3d = this.func_514_g(this.posX, this.posY, this.posZ);
            int l2 = this.worldObj.getBlockMetadata(i2, j2, k2);
            this.posY = j2;
            if (l2 >= 2 && l2 <= 5) {
                this.posY = j2 + 1;
            }
            if (l2 == 2) {
                this.motionX -= d5;
            }
            if (l2 == 3) {
                this.motionX += d5;
            }
            if (l2 == 4) {
                this.motionZ += d5;
            }
            if (l2 == 5) {
                this.motionZ -= d5;
            }
            int[][] ai2 = field_855_j[l2];
            double d8 = ai2[1][0] - ai2[0][0];
            double d10 = ai2[1][2] - ai2[0][2];
            double d11 = Math.sqrt(d8 * d8 + d10 * d10);
            double d12 = this.motionX * d8 + this.motionZ * d10;
            if (d12 < 0.0) {
                d8 = -d8;
                d10 = -d10;
            }
            double d13 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.motionX = d13 * d8 / d11;
            this.motionZ = d13 * d10 / d11;
            double d16 = 0.0;
            double d17 = (double)i2 + 0.5 + (double)ai2[0][0] * 0.5;
            double d18 = (double)k2 + 0.5 + (double)ai2[0][2] * 0.5;
            double d19 = (double)i2 + 0.5 + (double)ai2[1][0] * 0.5;
            double d20 = (double)k2 + 0.5 + (double)ai2[1][2] * 0.5;
            d8 = d19 - d17;
            d10 = d20 - d18;
            if (d8 == 0.0) {
                this.posX = (double)i2 + 0.5;
                d16 = this.posZ - (double)k2;
            } else if (d10 == 0.0) {
                this.posZ = (double)k2 + 0.5;
                d16 = this.posX - (double)i2;
            } else {
                double d25;
                double d21 = this.posX - d17;
                double d23 = this.posZ - d18;
                d16 = d25 = (d21 * d8 + d23 * d10) * 2.0;
            }
            this.posX = d17 + d8 * d16;
            this.posZ = d18 + d10 * d16;
            this.setPosition(this.posX, this.posY + (double)this.yOffset, this.posZ);
            double d22 = this.motionX;
            double d24 = this.motionZ;
            if (this.riddenByEntity != null) {
                d22 *= 0.75;
                d24 *= 0.75;
            }
            if (d22 < -d2) {
                d22 = -d2;
            }
            if (d22 > d2) {
                d22 = d2;
            }
            if (d24 < -d2) {
                d24 = -d2;
            }
            if (d24 > d2) {
                d24 = d2;
            }
            this.moveEntity(d22, 0.0, d24);
            if (ai2[0][1] != 0 && MathHelper.floor_double(this.posX) - i2 == ai2[0][0] && MathHelper.floor_double(this.posZ) - k2 == ai2[0][2]) {
                this.setPosition(this.posX, this.posY + (double)ai2[0][1], this.posZ);
            } else if (ai2[1][1] != 0 && MathHelper.floor_double(this.posX) - i2 == ai2[1][0] && MathHelper.floor_double(this.posZ) - k2 == ai2[1][2]) {
                this.setPosition(this.posX, this.posY + (double)ai2[1][1], this.posZ);
            }
            if (this.riddenByEntity != null) {
                this.motionX *= (double)0.997f;
                this.motionY *= 0.0;
                this.motionZ *= (double)0.997f;
            } else {
                if (this.minecartType == 2) {
                    double d26 = MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ);
                    if (d26 > 0.01) {
                        flag = true;
                        this.pushX /= d26;
                        this.pushZ /= d26;
                        double d28 = 0.08;
                        this.motionX *= 0.8;
                        this.motionY *= 0.0;
                        this.motionZ *= 0.8;
                        this.motionX += this.pushX * d28;
                        this.motionZ += this.pushZ * d28;
                    } else {
                        this.motionX *= 0.9;
                        this.motionY *= 0.0;
                        this.motionZ *= 0.9;
                    }
                }
                this.motionX *= 0.95;
                this.motionY *= 0.0;
                this.motionZ *= 0.95;
            }
            Vec3D vec3d1 = this.func_514_g(this.posX, this.posY, this.posZ);
            if (vec3d1 != null && vec3d != null) {
                double d27 = (vec3d.yCoord - vec3d1.yCoord) * 0.05;
                double d14 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                if (d14 > 0.0) {
                    this.motionX = this.motionX / d14 * (d14 + d27);
                    this.motionZ = this.motionZ / d14 * (d14 + d27);
                }
                this.setPosition(this.posX, vec3d1.yCoord, this.posZ);
            }
            int j1 = MathHelper.floor_double(this.posX);
            int k1 = MathHelper.floor_double(this.posZ);
            if (j1 != i2 || k1 != k2) {
                double d15 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
                this.motionX = d15 * (double)(j1 - i2);
                this.motionZ = d15 * (double)(k1 - k2);
            }
            if (this.minecartType == 2 && (d29 = (double)MathHelper.sqrt_double(this.pushX * this.pushX + this.pushZ * this.pushZ)) > 0.01 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.001) {
                this.pushX /= d29;
                this.pushZ /= d29;
                if (this.pushX * this.motionX + this.pushZ * this.motionZ < 0.0) {
                    this.pushX = 0.0;
                    this.pushZ = 0.0;
                } else {
                    this.pushX = this.motionX;
                    this.pushZ = this.motionZ;
                }
            }
        } else {
            if (this.motionX < -d2) {
                this.motionX = -d2;
            }
            if (this.motionX > d2) {
                this.motionX = d2;
            }
            if (this.motionZ < -d2) {
                this.motionZ = -d2;
            }
            if (this.motionZ > d2) {
                this.motionZ = d2;
            }
            if (this.onGround) {
                this.motionX *= 0.5;
                this.motionY *= 0.5;
                this.motionZ *= 0.5;
            }
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (!this.onGround) {
                this.motionX *= (double)0.95f;
                this.motionY *= (double)0.95f;
                this.motionZ *= (double)0.95f;
            }
        }
        this.rotationPitch = 0.0f;
        double d6 = this.prevPosX - this.posX;
        double d7 = this.prevPosZ - this.posZ;
        if (d6 * d6 + d7 * d7 > 0.001) {
            this.rotationYaw = (float)(Math.atan2(d7, d6) * 180.0 / Math.PI);
            if (this.field_856_i) {
                this.rotationYaw += 180.0f;
            }
        }
        double d9 = this.rotationYaw - this.prevRotationYaw;
        while (d9 >= 180.0) {
            d9 -= 360.0;
        }
        while (d9 < -180.0) {
            d9 += 360.0;
        }
        if (d9 < -170.0 || d9 >= 170.0) {
            this.rotationYaw += 180.0f;
            this.field_856_i = !this.field_856_i;
        }
        this.setRotation(this.rotationYaw, this.rotationPitch);
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            int i1 = 0;
            while (i1 < list.size()) {
                Entity entity = list.get(i1);
                if (entity != this.riddenByEntity && entity.canBePushed() && entity instanceof EntityMinecart) {
                    entity.applyEntityCollision(this);
                }
                ++i1;
            }
        }
        if (this.riddenByEntity != null && this.riddenByEntity.isDead) {
            this.riddenByEntity = null;
        }
        if (flag && this.rand.nextInt(4) == 0) {
            --this.fuel;
            if (this.fuel < 0) {
                this.pushZ = 0.0;
                this.pushX = 0.0;
            }
            this.worldObj.spawnParticle("largesmoke", this.posX, this.posY + 0.8, this.posZ, 0.0, 0.0, 0.0);
        }
    }

    public void performHurtAnimation() {
        System.out.println("Animating hurt");
        this.minecartRockDirection = -this.minecartRockDirection;
        this.minecartTimeSinceHit = 10;
        this.minecartCurrentDamage += this.minecartCurrentDamage * 10;
    }

    public Vec3D func_515_a(double d2, double d1, double d22, double d3) {
        int k2;
        int j2;
        int i2 = MathHelper.floor_double(d2);
        if (this.worldObj.getBlockId(i2, (j2 = MathHelper.floor_double(d1)) - 1, k2 = MathHelper.floor_double(d22)) == Block.minecartTrack.blockID) {
            --j2;
        }
        if (this.worldObj.getBlockId(i2, j2, k2) == Block.minecartTrack.blockID) {
            int l2 = this.worldObj.getBlockMetadata(i2, j2, k2);
            d1 = j2;
            if (l2 >= 2 && l2 <= 5) {
                d1 = j2 + 1;
            }
            int[][] ai2 = field_855_j[l2];
            double d4 = ai2[1][0] - ai2[0][0];
            double d5 = ai2[1][2] - ai2[0][2];
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (ai2[0][1] != 0 && MathHelper.floor_double(d2 += (d4 /= d6) * d3) - i2 == ai2[0][0] && MathHelper.floor_double(d22 += (d5 /= d6) * d3) - k2 == ai2[0][2]) {
                d1 += (double)ai2[0][1];
            } else if (ai2[1][1] != 0 && MathHelper.floor_double(d2) - i2 == ai2[1][0] && MathHelper.floor_double(d22) - k2 == ai2[1][2]) {
                d1 += (double)ai2[1][1];
            }
            return this.func_514_g(d2, d1, d22);
        }
        return null;
    }

    public Vec3D func_514_g(double d2, double d1, double d22) {
        int k2;
        int j2;
        int i2 = MathHelper.floor_double(d2);
        if (this.worldObj.getBlockId(i2, (j2 = MathHelper.floor_double(d1)) - 1, k2 = MathHelper.floor_double(d22)) == Block.minecartTrack.blockID) {
            --j2;
        }
        if (this.worldObj.getBlockId(i2, j2, k2) == Block.minecartTrack.blockID) {
            int l2 = this.worldObj.getBlockMetadata(i2, j2, k2);
            d1 = j2;
            if (l2 >= 2 && l2 <= 5) {
                d1 = j2 + 1;
            }
            int[][] ai2 = field_855_j[l2];
            double d3 = 0.0;
            double d4 = (double)i2 + 0.5 + (double)ai2[0][0] * 0.5;
            double d5 = (double)j2 + 0.5 + (double)ai2[0][1] * 0.5;
            double d6 = (double)k2 + 0.5 + (double)ai2[0][2] * 0.5;
            double d7 = (double)i2 + 0.5 + (double)ai2[1][0] * 0.5;
            double d8 = (double)j2 + 0.5 + (double)ai2[1][1] * 0.5;
            double d9 = (double)k2 + 0.5 + (double)ai2[1][2] * 0.5;
            double d10 = d7 - d4;
            double d11 = (d8 - d5) * 2.0;
            double d12 = d9 - d6;
            if (d10 == 0.0) {
                d2 = (double)i2 + 0.5;
                d3 = d22 - (double)k2;
            } else if (d12 == 0.0) {
                d22 = (double)k2 + 0.5;
                d3 = d2 - (double)i2;
            } else {
                double d15;
                double d13 = d2 - d4;
                double d14 = d22 - d6;
                d3 = d15 = (d13 * d10 + d14 * d12) * 2.0;
            }
            d2 = d4 + d10 * d3;
            d1 = d5 + d11 * d3;
            d22 = d6 + d12 * d3;
            if (d11 < 0.0) {
                d1 += 1.0;
            }
            if (d11 > 0.0) {
                d1 += 0.5;
            }
            return Vec3D.createVector(d2, d1, d22);
        }
        return null;
    }

    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setInteger("Type", this.minecartType);
        if (this.minecartType == 2) {
            nbttagcompound.setDouble("PushX", this.pushX);
            nbttagcompound.setDouble("PushZ", this.pushZ);
            nbttagcompound.setShort("Fuel", (short)this.fuel);
        } else if (this.minecartType == 1) {
            NBTTagList nbttaglist = new NBTTagList();
            int i2 = 0;
            while (i2 < this.cargoItems.length) {
                if (this.cargoItems[i2] != null) {
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    nbttagcompound1.setByte("Slot", (byte)i2);
                    this.cargoItems[i2].writeToNBT(nbttagcompound1);
                    nbttaglist.setTag(nbttagcompound1);
                }
                ++i2;
            }
            nbttagcompound.func_762_a("Items", nbttaglist);
        }
    }

    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.minecartType = nbttagcompound.getInteger("Type");
        if (this.minecartType == 2) {
            this.pushX = nbttagcompound.getDouble("PushX");
            this.pushZ = nbttagcompound.getDouble("PushZ");
            this.fuel = nbttagcompound.getShort("Fuel");
        } else if (this.minecartType == 1) {
            NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
            this.cargoItems = new ItemStack[this.getSizeInventory()];
            int i2 = 0;
            while (i2 < nbttaglist.tagCount()) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i2);
                int j2 = nbttagcompound1.getByte("Slot") & 0xFF;
                if (j2 >= 0 && j2 < this.cargoItems.length) {
                    this.cargoItems[j2] = new ItemStack(nbttagcompound1);
                }
                ++i2;
            }
        }
    }

    public float getShadowSize() {
        return 0.0f;
    }

    public void applyEntityCollision(Entity entity) {
        double d1;
        double d2;
        double d22;
        if (this.worldObj.multiplayerWorld) {
            return;
        }
        if (entity == this.riddenByEntity) {
            return;
        }
        if (entity instanceof EntityLiving && !(entity instanceof EntityPlayer) && this.minecartType == 0 && this.motionX * this.motionX + this.motionZ * this.motionZ > 0.01 && this.riddenByEntity == null && entity.entityBeingRidden == null) {
            entity.mountEntity(this);
        }
        if ((d22 = (d2 = entity.posX - this.posX) * d2 + (d1 = entity.posZ - this.posZ) * d1) >= (double)1.0E-4f) {
            d22 = MathHelper.sqrt_double(d22);
            d2 /= d22;
            d1 /= d22;
            double d3 = 1.0 / d22;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d2 *= d3;
            d1 *= d3;
            d2 *= (double)0.1f;
            d1 *= (double)0.1f;
            d2 *= (double)(1.0f - this.entityCollisionReduction);
            d1 *= (double)(1.0f - this.entityCollisionReduction);
            d2 *= 0.5;
            d1 *= 0.5;
            if (entity instanceof EntityMinecart) {
                double d4 = entity.motionX + this.motionX;
                double d5 = entity.motionZ + this.motionZ;
                if (((EntityMinecart)entity).minecartType == 2 && this.minecartType != 2) {
                    this.motionX *= (double)0.2f;
                    this.motionZ *= (double)0.2f;
                    this.addVelocity(entity.motionX - d2, 0.0, entity.motionZ - d1);
                    entity.motionX *= (double)0.7f;
                    entity.motionZ *= (double)0.7f;
                } else if (((EntityMinecart)entity).minecartType != 2 && this.minecartType == 2) {
                    entity.motionX *= (double)0.2f;
                    entity.motionZ *= (double)0.2f;
                    entity.addVelocity(this.motionX + d2, 0.0, this.motionZ + d1);
                    this.motionX *= (double)0.7f;
                    this.motionZ *= (double)0.7f;
                } else {
                    this.motionX *= (double)0.2f;
                    this.motionZ *= (double)0.2f;
                    this.addVelocity((d4 /= 2.0) - d2, 0.0, (d5 /= 2.0) - d1);
                    entity.motionX *= (double)0.2f;
                    entity.motionZ *= (double)0.2f;
                    entity.addVelocity(d4 + d2, 0.0, d5 + d1);
                }
            } else {
                this.addVelocity(-d2, 0.0, -d1);
                entity.addVelocity(d2 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    public int getSizeInventory() {
        return 27;
    }

    public ItemStack getStackInSlot(int i2) {
        return this.cargoItems[i2];
    }

    public ItemStack decrStackSize(int i2, int j2) {
        if (this.cargoItems[i2] != null) {
            if (this.cargoItems[i2].stackSize <= j2) {
                ItemStack itemstack = this.cargoItems[i2];
                this.cargoItems[i2] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.cargoItems[i2].splitStack(j2);
            if (this.cargoItems[i2].stackSize == 0) {
                this.cargoItems[i2] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void setInventorySlotContents(int i2, ItemStack itemstack) {
        this.cargoItems[i2] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInvName() {
        return "Minecart";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void onInventoryChanged() {
    }

    public boolean interact(EntityPlayer entityplayer) {
        if (this.minecartType == 0) {
            if (!this.worldObj.multiplayerWorld) {
                entityplayer.mountEntity(this);
            }
        } else if (this.minecartType == 1) {
            if (!this.worldObj.multiplayerWorld) {
                entityplayer.displayGUIChest(this);
            }
        } else if (this.minecartType == 2) {
            ItemStack itemstack = entityplayer.inventory.getCurrentItem();
            if (itemstack != null && itemstack.itemID == Item.coal.shiftedIndex) {
                if (--itemstack.stackSize == 0) {
                    entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, null);
                }
                this.fuel += 1200;
            }
            this.pushX = this.posX - entityplayer.posX;
            this.pushZ = this.posZ - entityplayer.posZ;
        }
        return true;
    }

    public void setPositionAndRotation2(double d2, double d1, double d22, float f2, float f1, int i2) {
        this.field_853_l = d2;
        this.field_852_m = d1;
        this.field_851_n = d22;
        this.field_850_o = f2;
        this.field_849_p = f1;
        this.field_854_k = i2;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return true;
    }
}

