/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.gui.ChatAllowedCharacters;
import com.mojang.minecraft.player.controller.GameSettings;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.sound.CodecMus;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.Random;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class FontRenderer {
    private int[] colors;
    private byte[] basicWidth;
    private byte[] unicodeWidth;
    private final int[] unicodeTexID = new int[256];
    private final int basicTexID;
    private int lastBoundTexID;
    private RenderEngine tex;
    private float xPos;
    private float yPos;
    private Random r;

    public FontRenderer(GameSettings gamesettings, String s2, RenderEngine renderengine) {
        BufferedImage bufferedimage;
        this.colors = new int[32];
        this.basicWidth = new byte[256];
        this.unicodeWidth = new byte[65536];
        this.r = new Random();
        this.tex = renderengine;
        try {
            Class<?> class1 = Class.forName("ModLoader");
            if (class1 != null) {
                Method method = class1.getDeclaredMethod("RegisterAllTextureOverrides", RenderEngine.class);
                method.invoke(null, renderengine);
            }
        }
        catch (Throwable class1) {
            // empty catch block
        }
        try {
            bufferedimage = ImageIO.read(RenderEngine.class.getResourceAsStream(s2));
            InputStream inputstream = RenderEngine.class.getResourceAsStream("/font/glyph_sizes.bin");
            if (inputstream != null) {
                inputstream.read(this.unicodeWidth);
                inputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i2 = bufferedimage.getWidth();
        int j2 = bufferedimage.getHeight();
        int[] ai2 = new int[i2 * j2];
        bufferedimage.getRGB(0, 0, i2, j2, ai2, 0, i2);
        int k2 = 0;
        while (k2 < 256) {
            int i22;
            int i1 = k2 % 16;
            int k1 = k2 / 16;
            for (i22 = 7; i22 >= 0; --i22) {
                int k22 = i1 * 8 + i22;
                boolean flag = true;
                int j3 = 0;
                while (j3 < 8 && flag) {
                    int l3 = ai2[k22 + (k1 * 8 + j3) * i2] & 0xFF;
                    if (l3 > 0) {
                        flag = false;
                    }
                    ++j3;
                }
                if (!flag) break;
            }
            if (k2 == 32) {
                i22 = 2;
            }
            this.basicWidth[k2] = (byte)(i22 + 2);
            ++k2;
        }
        this.basicTexID = renderengine.allocateAndSetupTexture(bufferedimage);
        int l2 = 0;
        while (l2 < 32) {
            int j1 = (l2 >> 3 & 1) * 85;
            int l1 = (l2 >> 2 & 1) * 170 + j1;
            int j22 = (l2 >> 1 & 1) * 170 + j1;
            int l22 = (l2 >> 0 & 1) * 170 + j1;
            if (l2 == 6) {
                l1 += 85;
            }
            if (gamesettings.anaglyph) {
                int i3 = (l1 * 30 + j22 * 59 + l22 * 11) / 100;
                int k3 = (l1 * 30 + j22 * 70) / 100;
                int i4 = (l1 * 30 + l22 * 70) / 100;
                l1 = i3;
                j22 = k3;
                l22 = i4;
            }
            if (l2 >= 16) {
                l1 /= 4;
                j22 /= 4;
                l22 /= 4;
            }
            this.colors[l2] = (l1 & 0xFF) << 16 | (j22 & 0xFF) << 8 | l22 & 0xFF;
            ++l2;
        }
    }

    private void func_21002_o(int i2) {
        float f2 = i2 % 16 * 8;
        float f1 = i2 / 16 * 8;
        if (this.lastBoundTexID != this.basicTexID) {
            GL11.glBindTexture((int)3553, (int)this.basicTexID);
            this.lastBoundTexID = this.basicTexID;
        }
        float f22 = (float)this.basicWidth[i2] - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f2 / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)this.xPos, (float)this.yPos, (float)0.0f);
        GL11.glTexCoord2f((float)(f2 / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)this.xPos, (float)(this.yPos + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f22) / 128.0f), (float)(f1 / 128.0f));
        GL11.glVertex3f((float)(this.xPos + f22), (float)this.yPos, (float)0.0f);
        GL11.glTexCoord2f((float)((f2 + f22) / 128.0f), (float)((f1 + 7.99f) / 128.0f));
        GL11.glVertex3f((float)(this.xPos + f22), (float)(this.yPos + 7.99f), (float)0.0f);
        GL11.glEnd();
        this.xPos += (float)this.basicWidth[i2];
    }

    private void func_21003_loadUnicodePage(int i2) {
        BufferedImage bufferedimage;
        StringBuilder stringbuilder = new StringBuilder();
        Formatter f2 = new Formatter(stringbuilder);
        f2.format("/font/glyph_%02X.png", i2);
        f2.close();
        try {
            bufferedimage = ImageIO.read(CodecMus.class.getResourceAsStream(stringbuilder.toString()));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.unicodeTexID[i2] = this.tex.allocateAndSetupTexture(bufferedimage);
        this.lastBoundTexID = this.unicodeTexID[i2];
    }

    private String func_21001_a(int i2) {
        char[] ac2 = new char[i2];
        while (i2-- != 0) {
            int j2 = this.r.nextInt() & 0xF;
            ac2[i2] = j2 == 0 ? 167 : (char)(48 + j2);
        }
        return new String(ac2);
    }

    private void func_21004_a(char c2) {
        float f2;
        float f1;
        if (this.unicodeWidth[c2] == 0) {
            return;
        }
        int i2 = c2 / 256;
        if (this.unicodeTexID[i2] == 0) {
            this.func_21003_loadUnicodePage(i2);
        }
        if (this.lastBoundTexID != this.unicodeTexID[i2]) {
            GL11.glBindTexture((int)3553, (int)this.unicodeTexID[i2]);
            this.lastBoundTexID = this.unicodeTexID[i2];
        }
        int j2 = this.unicodeWidth[c2] >> 4;
        int k2 = this.unicodeWidth[c2] & 0xF;
        if (k2 > 7) {
            f1 = 16.0f;
            f2 = 0.0f;
        } else {
            f1 = k2 + 1;
            f2 = j2;
        }
        float f22 = (float)(c2 % 16 * 16) + f2;
        float f3 = (c2 & 0xFF) / 16 * 16;
        float f4 = f1 - f2 - 0.02f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(f22 / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)this.xPos, (float)this.yPos, (float)0.0f);
        GL11.glTexCoord2f((float)(f22 / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)this.xPos, (float)(this.yPos + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)((f22 + f4) / 256.0f), (float)(f3 / 256.0f));
        GL11.glVertex3f((float)(this.xPos + f4 / 2.0f), (float)this.yPos, (float)0.0f);
        GL11.glTexCoord2f((float)((f22 + f4) / 256.0f), (float)((f3 + 15.98f) / 256.0f));
        GL11.glVertex3f((float)(this.xPos + f4 / 2.0f), (float)(this.yPos + 7.99f), (float)0.0f);
        GL11.glEnd();
        this.xPos += (f1 - f2) / 2.0f + 1.0f;
    }

    private void func_21006_b(String s2, boolean flag) {
        int i2 = 0;
        while (i2 < s2.length()) {
            char c2 = s2.charAt(i2);
            if (c2 == '\u00a7' && i2 + 1 < s2.length()) {
                int j2 = "0123456789abcdef".indexOf(s2.toLowerCase().charAt(i2 + 1));
                if (j2 < 0 || j2 > 15) {
                    j2 = 15;
                }
                if (flag) {
                    j2 += 16;
                }
                int l2 = this.colors[j2];
                GL11.glColor3f((float)((float)(l2 >> 16) / 255.0f), (float)((float)(l2 >> 8 & 0xFF) / 255.0f), (float)((float)(l2 & 0xFF) / 255.0f));
                ++i2;
            } else {
                int k2 = ChatAllowedCharacters.allowedCharacters.indexOf(c2);
                if (c2 == ' ') {
                    this.xPos += 4.0f;
                } else if (k2 > 0) {
                    this.func_21002_o(k2 + 1);
                } else {
                    this.func_21004_a(c2);
                }
            }
            ++i2;
        }
    }

    private void func_21005_a(String s2, int i2, int j2, int k2, boolean flag) {
        if (s2 != null) {
            this.lastBoundTexID = 0;
            if ((k2 & 0xFF000000) == 0) {
                k2 |= 0xFF000000;
            }
            if (flag) {
                k2 = (k2 & 0xFCFCFC) >> 2 | k2 & 0xFF000000;
            }
            GL11.glColor4f((float)((float)(k2 >> 16 & 0xFF) / 255.0f), (float)((float)(k2 >> 8 & 0xFF) / 255.0f), (float)((float)(k2 & 0xFF) / 255.0f), (float)((float)(k2 >> 24 & 0xFF) / 255.0f));
            this.xPos = i2;
            this.yPos = j2;
            this.func_21006_b(s2, flag);
        }
    }

    public void drawStringWithShadow(String s2, int i2, int j2, int k2) {
        this.func_21005_a(s2, i2 + 1, j2 + 1, k2, true);
        this.func_21005_a(s2, i2, j2, k2, false);
    }

    public void drawString(String s2, int i2, int j2, int k2) {
        this.func_21005_a(s2, i2, j2, k2, false);
    }

    public int getStringWidth(String s2) {
        if (s2 == null) {
            return 0;
        }
        int i2 = 0;
        int j2 = 0;
        while (j2 < s2.length()) {
            char c2 = s2.charAt(j2);
            if (c2 == '\u00a7') {
                ++j2;
            } else {
                int k2 = ChatAllowedCharacters.allowedCharacters.indexOf(c2);
                if (k2 >= 0) {
                    i2 += this.basicWidth[k2 + 1];
                } else if (this.unicodeWidth[c2] != 0) {
                    int l2 = this.unicodeWidth[c2] >> 4;
                    int i1 = this.unicodeWidth[c2] & 0xF;
                    if (i1 > 7) {
                        i1 = 15;
                        l2 = 0;
                    }
                    i2 += (++i1 - l2) / 2 + 1;
                }
            }
            ++j2;
        }
        return i2;
    }
}

