/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.Random;

public class BlockStairs
extends Block {
    private Block modelBlock;

    protected BlockStairs(int i2, Block block) {
        super(i2, block.blockIndexInTexture, block.blockMaterial);
        this.modelBlock = block;
        this.setHardness(block.blockHardness);
        this.setResistance(block.blockResistance / 3.0f);
        this.setStepSound(block.stepSound);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return super.getCollisionBoundingBoxFromPool(world, i2, j2, k2);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public int getRenderType() {
        return 10;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return super.shouldSideBeRendered(iblockaccess, i2, j2, k2, l2);
    }

    public void getCollidingBoundingBoxes(World world, int i2, int j2, int k2, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        if (l2 == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
        } else if (l2 == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
        } else if (l2 == 2) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
        } else if (l2 == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i2, j2, k2, axisalignedbb, arraylist);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        this.modelBlock.randomDisplayTick(world, i2, j2, k2, random);
    }

    public void onBlockClicked(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        this.modelBlock.onBlockClicked(world, i2, j2, k2, entityplayer);
    }

    public float getBlockBrightness(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        return this.modelBlock.getBlockBrightness(iblockaccess, i2, j2, k2);
    }

    public float getExplosionResistance(Entity entity) {
        return this.modelBlock.getExplosionResistance(entity);
    }

    public int getRenderBlockPass() {
        return this.modelBlock.getRenderBlockPass();
    }

    public int idDropped(int i2, Random random) {
        return this.blockID;
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(i2, j2);
    }

    public int getTextureIndex(int i2) {
        return this.modelBlock.getTextureIndex(i2);
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return this.modelBlock.getTextureIndex(iblockaccess, i2, j2, k2, l2);
    }

    public int tickRate() {
        return this.modelBlock.tickRate();
    }

    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return this.modelBlock.getSelectedCollisionBoundingBoxFromPool(world, i2, j2, k2);
    }

    public void velocityToAddToEntity(World world, int i2, int j2, int k2, Entity entity, Vec3D vec3d) {
        this.modelBlock.velocityToAddToEntity(world, i2, j2, k2, entity, vec3d);
    }

    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    public boolean canCollideCheck(int i2, boolean flag) {
        return this.modelBlock.canCollideCheck(i2, flag);
    }

    public boolean canPlace(World world, int i2, int j2, int k2) {
        return this.modelBlock.canPlace(world, i2, j2, k2);
    }

    public void onBlockAdded(World world, int i2, int j2, int k2) {
        this.onNeighborBlockChange(world, i2, j2, k2, 0);
        this.modelBlock.onBlockAdded(world, i2, j2, k2);
    }

    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        this.modelBlock.onBlockRemoval(world, i2, j2, k2);
    }

    public void onEntityWalking(World world, int i2, int j2, int k2, Entity entity) {
        this.modelBlock.onEntityWalking(world, i2, j2, k2, entity);
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        this.modelBlock.updateTick(world, i2, j2, k2, random);
    }

    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        return this.modelBlock.blockActivated(world, i2, j2, k2, entityplayer);
    }

    public void onBlockDestroyedByExplosion(World world, int i2, int j2, int k2) {
    }

    public void onBlockPlacedBy(World world, int i2, int j2, int k2, EntityLiving entityliving) {
        int l2 = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (l2 == 0) {
            world.setBlockMetadataWithNotify(i2, j2, k2, 2);
        }
        if (l2 == 1) {
            world.setBlockMetadataWithNotify(i2, j2, k2, 1);
        }
        if (l2 == 2) {
            world.setBlockMetadataWithNotify(i2, j2, k2, 3);
        }
        if (l2 == 3) {
            world.setBlockMetadataWithNotify(i2, j2, k2, 0);
        }
    }
}

