/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityGear;
import com.mojang.minecraft.entity.tile.TileEntityMotor;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.material.Material;

public class BlockMotor
extends BlockContainer {
    private boolean isMotor;
    private boolean isPowered;
    private int powerLimit;

    protected BlockMotor(int i2, int j2, Material material1, boolean isMtr, int limit) {
        super(i2, j2, material1);
        this.isMotor = isMtr;
        this.powerLimit = limit;
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        TileEntityMotor motorEntity = (TileEntityMotor)world.getBlockTileEntity(i2, j2, k2);
        motorEntity.onUpdated(world);
        if (this.isMotor) {
            if (l2 > 0 && Block.allBlocks[l2].canProvidePower() && world.isBlockIndirectlyGettingPowered(i2, j2, k2)) {
                this.applyPower(world, i2, j2, k2);
            } else {
                this.removePower(world, i2, j2, k2);
            }
        }
    }

    public void onBlockAdded(World world, int i2, int j2, int k2) {
        world.func_654_a(i2, j2, k2, this.getBlockEntity());
        this.onNeighborBlockChange(world, i2, j2, k2, 0);
    }

    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        TileEntityMotor motorEntity = (TileEntityMotor)world.getBlockTileEntity(i2, j2, k2);
        motorEntity.onRemoved(world);
        if (this.isPowered) {
            this.removePower(world, i2, j2, k2);
        }
    }

    public boolean checkPower(World world, int i2, int j2, int k2) {
        TileEntityGear gearEntity = world.getGearAt(i2, j2, k2);
        return world.checkGearPower(gearEntity);
    }

    public void applyPower(World world, int i2, int j2, int k2) {
        TileEntityGear gearEntity = world.getGearAt(i2, j2, k2);
        System.out.println(world.applyGearPower(gearEntity, this.powerLimit));
        this.isPowered = true;
    }

    public void removePower(World world, int i2, int j2, int k2) {
        TileEntityGear gearEntity = world.getGearAt(i2, j2, k2);
        System.out.println(world.removeGearPower(gearEntity, this.powerLimit));
        this.isPowered = false;
    }

    public final boolean canProvidePower() {
        return !this.isMotor;
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        if (this.checkPower((World)iblockaccess, i2, j2, k2) && !this.isMotor) {
            ((World)iblockaccess).markBlocksDirty(i2, j2, k2, i2, j2, k2);
            return true;
        }
        return false;
    }

    public boolean isIndirectlyPoweringTo(World world, int i2, int j2, int k2, int l2) {
        if (this.checkPower(world, i2, j2, k2) && !this.isMotor) {
            world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
        }
        return true;
    }

    protected TileEntity getBlockEntity() {
        return new TileEntityMotor();
    }
}

