/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public abstract class BlockFluids
extends Block {
    protected int field_458_d = 1;
    protected static boolean isStationary;

    protected BlockFluids(int i2, Material material) {
        super(i2, (material != Material.lava ? 12 : 14) * 16 + 13, material);
        float f2 = 0.0f;
        float f1 = 0.0f;
        isStationary = true;
        if (material == Material.lava) {
            this.field_458_d = 2;
        }
        this.setBlockBounds(0.0f + f1, 0.0f + f2, 0.0f + f1, 1.0f + f1, 1.0f + f2, 1.0f + f1);
        this.setTickOnLoad(true);
    }

    public static float getFluidLevel(int i2) {
        if (i2 >= 8) {
            i2 = 0;
        }
        float f2 = (float)(i2 + 1) / 9.0f;
        return f2;
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int x2, int y2, int z2, int side) {
        if (BlockFluids.isFlowing(iblockaccess, x2, y2, z2)) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    public boolean getIsStationary(IBlockAccess world, int x2, int y2, int z2) {
        Vec3D flowDir = this.getFlowDirectionVector(world, x2, y2, z2);
        return flowDir.yCoord >= 0.0;
    }

    protected int func_290_h(World world, int i2, int j2, int k2) {
        if (world.getMaterialXYZ(i2, j2, k2) != this.blockMaterial) {
            return -1;
        }
        return world.getBlockMetadata(i2, j2, k2);
    }

    protected int getIfSameMaterialAndHeight(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        if (iblockaccess.getMaterialXYZ(i2, j2, k2) != this.blockMaterial) {
            return -1;
        }
        int l2 = iblockaccess.getBlockMetadata(i2, j2, k2);
        if (l2 >= 8) {
            l2 = 0;
        }
        return l2;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean canCollideCheck(int i2, boolean flag) {
        return flag && i2 == 0;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        Material material = iblockaccess.getMaterialXYZ(i2, j2, k2);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return false;
        }
        if (l2 == 1) {
            return true;
        }
        return super.shouldSideBeRendered(iblockaccess, i2, j2, k2, l2);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    public int getRenderType() {
        return 4;
    }

    public int idDropped(int i2, Random random) {
        return 0;
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    private Vec3D getFlowDirectionVector(IBlockAccess iblockaccess, int x2, int y2, int z2) {
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        int materialAndHeightCheck = this.getIfSameMaterialAndHeight(iblockaccess, x2, y2, z2);
        int sideCheck = 0;
        while (sideCheck < 4) {
            int materialAndHeightCheckSides;
            int sideCheckX = x2;
            int sideCheckY = y2;
            int sideCheckZ = z2;
            if (sideCheck == 0) {
                --sideCheckX;
            }
            if (sideCheck == 1) {
                --sideCheckZ;
            }
            if (sideCheck == 2) {
                ++sideCheckX;
            }
            if (sideCheck == 3) {
                ++sideCheckZ;
            }
            if ((materialAndHeightCheckSides = this.getIfSameMaterialAndHeight(iblockaccess, sideCheckX, sideCheckY, sideCheckZ)) < 0) {
                if (!iblockaccess.getMaterialXYZ(sideCheckX, sideCheckY, sideCheckZ).blocksMovement() && (materialAndHeightCheckSides = this.getIfSameMaterialAndHeight(iblockaccess, sideCheckX, sideCheckY - 1, sideCheckZ)) >= 0) {
                    int heightDifference = materialAndHeightCheckSides - (materialAndHeightCheck - 8);
                    vec3d = vec3d.addVector((sideCheckX - x2) * heightDifference, (sideCheckY - y2) * heightDifference, (sideCheckZ - z2) * heightDifference);
                }
            } else if (materialAndHeightCheckSides >= 0) {
                int heightDifference2 = materialAndHeightCheckSides - materialAndHeightCheck;
                vec3d = vec3d.addVector((sideCheckX - x2) * heightDifference2, (sideCheckY - y2) * heightDifference2, (sideCheckZ - z2) * heightDifference2);
            }
            ++sideCheck;
        }
        if (iblockaccess.getBlockMetadata(x2, y2, z2) >= 8) {
            boolean flag = false;
            if (flag || this.shouldSideBeRendered(iblockaccess, x2, y2, z2 - 1, 2)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x2, y2, z2 + 1, 3)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x2 - 1, y2, z2, 4)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x2 + 1, y2, z2, 5)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x2, y2 + 1, z2 - 1, 2)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x2, y2 + 1, z2 + 1, 3)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x2 - 1, y2 + 1, z2, 4)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x2 + 1, y2 + 1, z2, 5)) {
                flag = true;
            }
            if (flag) {
                vec3d = vec3d.normalize().addVector(0.0, -6.0, 0.0);
            }
        }
        vec3d = vec3d.normalize();
        return vec3d;
    }

    public void velocityToAddToEntity(World world, int i2, int j2, int k2, Entity entity, Vec3D vec3d) {
        Vec3D vec3d1 = this.getFlowDirectionVector(world, i2, j2, k2);
        vec3d.xCoord += vec3d1.xCoord;
        vec3d.yCoord += vec3d1.yCoord;
        vec3d.zCoord += vec3d1.zCoord;
    }

    public int tickRate() {
        if (this.blockMaterial == Material.water) {
            return 5;
        }
        return this.blockMaterial != Material.lava ? 0 : 30;
    }

    public float getBlockBrightness(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        float f1;
        float f2 = iblockaccess.getBrightness(i2, j2, k2);
        return f2 <= (f1 = iblockaccess.getBrightness(i2, j2 + 1, k2)) ? f1 : f2;
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        super.updateTick(world, i2, j2, k2, random);
    }

    public int getRenderBlockPass() {
        return this.blockMaterial != Material.water ? 0 : 1;
    }

    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
        int l2;
        if (this.blockMaterial == Material.water && random.nextInt(64) == 0 && (l2 = world.getBlockMetadata(i2, j2, k2)) > 0 && l2 < 8) {
            world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, "liquid.water", random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 1.0f + 0.5f);
        }
        if (this.blockMaterial == Material.lava && world.getMaterialXYZ(i2, j2 + 1, k2) == Material.air && !world.isBlockNormalCube(i2, j2 + 1, k2) && random.nextInt(100) == 0) {
            double d2 = (float)i2 + random.nextFloat();
            double d1 = (double)j2 + this.maxY;
            double d22 = (float)k2 + random.nextFloat();
            world.spawnParticle("lava", d2, d1, d22, 0.0, 0.0, 0.0);
            int l3 = world.getBlockMetadata(i2, j2, k2);
            if (l3 > 0 && l3 < 8) {
                world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, "liquid.lava", random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 1.0f + 0.5f);
            }
        }
    }

    public static double getFlowDirectionRadians(IBlockAccess iblockaccess, int i2, int j2, int k2, Material material) {
        Vec3D vec3d = null;
        if (material == Material.water) {
            vec3d = ((BlockFluids)Block.waterMoving).getFlowDirectionVector(iblockaccess, i2, j2, k2);
        }
        if (material == Material.lava) {
            vec3d = ((BlockFluids)Block.lavaMoving).getFlowDirectionVector(iblockaccess, i2, j2, k2);
        }
        if (vec3d.xCoord == 0.0 && vec3d.zCoord == 0.0) {
            return -1000.0;
        }
        return Math.atan2(vec3d.zCoord, vec3d.xCoord) - 1.5707963267948966;
    }

    public static boolean isFlowing(IBlockAccess world, int x2, int y2, int z2) {
        Vec3D vec = ((BlockFluids)Block.waterStill).getFlowDirectionVector(world, x2, y2, z2);
        if (world.getBlockId(x2, y2, z2) == Block.lavaStill.blockID || world.getBlockId(x2, y2, z2) == Block.lavaMoving.blockID) {
            vec = ((BlockFluids)Block.lavaStill).getFlowDirectionVector(world, x2, y2, z2);
        }
        return vec.xCoord != 0.0 || vec.yCoord != 0.0 || vec.zCoord != 0.0;
    }

    public void onBlockAdded(World world, int i2, int j2, int k2) {
        this.func_287_j(world, i2, j2, k2);
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        this.func_287_j(world, i2, j2, k2);
    }

    private void func_287_j(World world, int i2, int j2, int k2) {
        if (world.getBlockId(i2, j2, k2) != this.blockID) {
            return;
        }
        if (this.blockMaterial == Material.lava) {
            boolean flag = false;
            if (flag || world.getMaterialXYZ(i2, j2, k2 - 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i2, j2, k2 + 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i2 - 1, j2, k2) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i2 + 1, j2, k2) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i2, j2 + 1, k2) == Material.water) {
                flag = true;
            }
            if (flag) {
                int l2 = world.getBlockMetadata(i2, j2, k2);
                if (l2 == 0) {
                    world.setBlockWithNotify(i2, j2, k2, Block.obsidian.blockID);
                    if (new Random().nextInt(500) == 1) {
                        world.setBlockWithNotify(i2, j2, k2, Block.bleedingObsidian.blockID);
                    }
                } else if (l2 <= 4) {
                    world.setBlockWithNotify(i2, j2, k2, Block.cobblestone.blockID);
                }
                this.triggerLavaMixEffects(world, i2, j2, k2);
            }
        }
    }

    protected void triggerLavaMixEffects(World world, int i2, int j2, int k2) {
        world.playSoundEffect((float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        int l2 = 0;
        while (l2 < 8) {
            world.spawnParticle("largesmoke", (double)i2 + Math.random(), (double)j2 + 1.2, (double)k2 + Math.random(), 0.0, 0.0, 0.0);
            ++l2;
        }
    }
}

