/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemBlock;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.enums.EnumMobType;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.BlockBleedingObsidian;
import com.mojang.minecraft.level.tile.BlockBookshelf;
import com.mojang.minecraft.level.tile.BlockButton;
import com.mojang.minecraft.level.tile.BlockCactus;
import com.mojang.minecraft.level.tile.BlockChest;
import com.mojang.minecraft.level.tile.BlockClay;
import com.mojang.minecraft.level.tile.BlockCrops;
import com.mojang.minecraft.level.tile.BlockDirt;
import com.mojang.minecraft.level.tile.BlockDoor;
import com.mojang.minecraft.level.tile.BlockFence;
import com.mojang.minecraft.level.tile.BlockFire;
import com.mojang.minecraft.level.tile.BlockFlower;
import com.mojang.minecraft.level.tile.BlockFlowing;
import com.mojang.minecraft.level.tile.BlockFurnace;
import com.mojang.minecraft.level.tile.BlockGear;
import com.mojang.minecraft.level.tile.BlockGlass;
import com.mojang.minecraft.level.tile.BlockGrass;
import com.mojang.minecraft.level.tile.BlockGravel;
import com.mojang.minecraft.level.tile.BlockIce;
import com.mojang.minecraft.level.tile.BlockJukeBox;
import com.mojang.minecraft.level.tile.BlockLadder;
import com.mojang.minecraft.level.tile.BlockLeaves;
import com.mojang.minecraft.level.tile.BlockLever;
import com.mojang.minecraft.level.tile.BlockLightBulb;
import com.mojang.minecraft.level.tile.BlockLog;
import com.mojang.minecraft.level.tile.BlockMinecartTrack;
import com.mojang.minecraft.level.tile.BlockMobSpawner;
import com.mojang.minecraft.level.tile.BlockMotor;
import com.mojang.minecraft.level.tile.BlockMushroom;
import com.mojang.minecraft.level.tile.BlockObsidian;
import com.mojang.minecraft.level.tile.BlockOre;
import com.mojang.minecraft.level.tile.BlockOreBlock;
import com.mojang.minecraft.level.tile.BlockPressurePlate;
import com.mojang.minecraft.level.tile.BlockPyramidion;
import com.mojang.minecraft.level.tile.BlockRedstoneOre;
import com.mojang.minecraft.level.tile.BlockRedstoneTorch;
import com.mojang.minecraft.level.tile.BlockRedstoneWire;
import com.mojang.minecraft.level.tile.BlockReed;
import com.mojang.minecraft.level.tile.BlockSand;
import com.mojang.minecraft.level.tile.BlockSapling;
import com.mojang.minecraft.level.tile.BlockSign;
import com.mojang.minecraft.level.tile.BlockSnow;
import com.mojang.minecraft.level.tile.BlockSnowBlock;
import com.mojang.minecraft.level.tile.BlockSoil;
import com.mojang.minecraft.level.tile.BlockSponge;
import com.mojang.minecraft.level.tile.BlockSpongeInactive;
import com.mojang.minecraft.level.tile.BlockStairs;
import com.mojang.minecraft.level.tile.BlockStationary;
import com.mojang.minecraft.level.tile.BlockStep;
import com.mojang.minecraft.level.tile.BlockStone;
import com.mojang.minecraft.level.tile.BlockTNT;
import com.mojang.minecraft.level.tile.BlockTorch;
import com.mojang.minecraft.level.tile.BlockWeb;
import com.mojang.minecraft.level.tile.BlockWorkbench;
import com.mojang.minecraft.level.tile.StepSound;
import com.mojang.minecraft.level.tile.StepSoundSand;
import com.mojang.minecraft.level.tile.StepSoundStone;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block {
    public static final StepSound soundPowderFootstep;
    public static final StepSound soundWoodFootstep;
    public static final StepSound soundGravelFootstep;
    public static final StepSound soundGrassFootstep;
    public static final StepSound soundStoneFootstep;
    public static final StepSound soundMetalFootstep;
    public static final StepSound soundGlassFootstep;
    public static final StepSound soundClothFootstep;
    public static final StepSound soundSandFootstep;
    public static final StepSound soundNoFootstep;
    public static final Block[] allBlocks;
    public static final boolean[] tickOnLoad;
    public static final boolean[] opaqueCubeLookup;
    public static final boolean[] isBlockContainer;
    public static final int[] lightOpacity;
    public static final boolean[] field_340_s;
    public static final int[] lightValue;
    public static final Block stone;
    public static final BlockGrass grass;
    public static final Block dirt;
    public static final Block cobblestone;
    public static final Block planks;
    public static final Block sapling;
    public static final Block bedrock;
    public static final Block waterMoving;
    public static final Block waterStill;
    public static final Block lavaMoving;
    public static final Block lavaStill;
    public static final Block sand;
    public static final Block gravel;
    public static final Block oreGold;
    public static final Block oreIron;
    public static final Block oreCoal;
    public static final Block wood;
    public static final BlockLeaves leaves;
    public static final Block sponge;
    public static final Block glass;
    public static final Block cloth_red;
    public static final Block cloth_orange;
    public static final Block cloth_yellow;
    public static final Block cloth_lime;
    public static final Block cloth_green;
    public static final Block cloth_teal;
    public static final Block cloth_cyan;
    public static final Block cloth_blue;
    public static final Block cloth_indigo;
    public static final Block cloth_violet;
    public static final Block cloth_lilac;
    public static final Block cloth_pink;
    public static final Block cloth_magenta;
    public static final Block cloth_darkgray;
    public static final Block cloth;
    public static final Block cloth_lightgray;
    public static final BlockFlower plantYellow;
    public static final BlockFlower plantRed;
    public static final BlockFlower mushroomBrown;
    public static final BlockFlower mushroomRed;
    public static final Block blockGold;
    public static final Block blockSteel;
    public static final Block stairDouble;
    public static final Block stairSingle;
    public static final Block brick;
    public static final Block tnt;
    public static final Block bookShelf;
    public static final Block cobblestoneMossy;
    public static final Block obsidian;
    public static final Block torchWood;
    public static final BlockFire fire;
    public static final Block mobSpawner;
    public static final Block stairCompact_Wood;
    public static final Block crate;
    public static final Block redstoneWire;
    public static final Block oreDiamond;
    public static final Block blockDiamond;
    public static final Block workbench;
    public static final Block crops;
    public static final Block tilledField;
    public static final Block stoneOvenIdle;
    public static final Block stoneOvenActive;
    public static final Block signPost;
    public static final Block doorWood;
    public static final Block ladder;
    public static final Block minecartTrack;
    public static final Block stairCompactStone;
    public static final Block pressurePlateWoodIdle;
    public static final Block lever;
    public static final Block pressurePlateStone;
    public static final Block doorSteel;
    public static final Block pressurePlateWood;
    public static final Block oreRed;
    public static final Block oreRedstoneGlowing;
    public static final Block torchRedstoneIdle;
    public static final Block torchRedstoneActive;
    public static final Block button;
    public static final Block snow;
    public static final Block ice;
    public static final Block blockSnow;
    public static final Block cactus;
    public static final Block blockClay;
    public static final Block reed;
    public static final Block jukebox;
    public static final Block fence;
    public static final Block gear;
    public static final Block spongeInactive;
    public static final BlockFlower plantBlue;
    public static final Block oreCopper;
    public static final Block motor;
    public static final Block generator;
    public static final Block blockCopper;
    public static final Block brickMossy;
    public static final Block bleedingObsidian;
    public static final Block web;
    public static final Block pressurePlateSteel;
    public static final Block lightBulb;
    public static final Block lightBulbOn;
    public static final Block pyramidion;
    public static final Block test;
    public int blockIndexInTexture;
    public final int blockID;
    protected float blockHardness;
    protected float blockResistance;
    public double minX;
    public double minY;
    public double minZ;
    public double maxX;
    public double maxY;
    public double maxZ;
    public StepSound stepSound = soundPowderFootstep;
    public float field_357_bm = 1.0f;
    public final Material blockMaterial;
    public float slipperiness = 0.6f;
    public int blockGearPower = 0;
    public int primaryColor = 0xFFFFFF;
    public int secondaryColor = 0xFFFFFF;

    static {
        tickOnLoad = new boolean[256];
        opaqueCubeLookup = new boolean[256];
        isBlockContainer = new boolean[256];
        lightOpacity = new int[256];
        field_340_s = new boolean[256];
        lightValue = new int[256];
        soundPowderFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundWoodFootstep = new StepSound("wood", 1.0f, 1.0f);
        soundGravelFootstep = new StepSound("gravel", 1.0f, 1.0f);
        soundGrassFootstep = new StepSound("grass", 1.0f, 1.0f);
        soundStoneFootstep = new StepSound("stone", 1.0f, 1.0f);
        soundMetalFootstep = new StepSound("stone", 1.0f, 1.5f);
        soundGlassFootstep = new StepSoundStone("stone", 1.0f, 1.0f);
        soundClothFootstep = new StepSound("cloth", 1.0f, 1.0f);
        soundSandFootstep = new StepSoundSand("sand", 1.0f, 1.0f);
        soundNoFootstep = new StepSound("stone", 0.0f, 0.0f);
        allBlocks = new Block[256];
        stone = new BlockStone(1, 1).setHardness(1.5f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(0x747474);
        grass = (BlockGrass)new BlockGrass(2).setHardness(0.6f).setStepSound(soundGrassFootstep).setColor(7845709);
        dirt = new BlockDirt(3, 2).setHardness(0.5f).setStepSound(soundGravelFootstep).setColor(7951674);
        cobblestone = new Block(4, 16, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep).setColor(0x606060);
        planks = new Block(5, 4, Material.wood).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep).setColor(12359778);
        sapling = new BlockSapling(6, 15).setHardness(0.0f).setStepSound(soundGrassFootstep).setColor(25600);
        bedrock = new Block(7, 17, Material.rock).setHardness(-1.0f).setResistance(6000000.0f).setStepSound(soundStoneFootstep).setColor(0x333333);
        waterMoving = new BlockFlowing(8, Material.water).setHardness(100.0f).setLightOpacity(3).setStepSound(soundNoFootstep).setColor(1987581);
        waterStill = new BlockStationary(9, Material.water).setHardness(100.0f).setLightOpacity(3).setStepSound(soundNoFootstep).setColor(1987581);
        lavaMoving = new BlockFlowing(10, Material.lava).setHardness(0.0f).setLightValue(1.0f).setLightOpacity(255).setStepSound(soundNoFootstep).setColor(16537344);
        lavaStill = new BlockStationary(11, Material.lava).setHardness(100.0f).setLightValue(1.0f).setLightOpacity(255).setStepSound(soundNoFootstep).setColor(16537344);
        sand = new BlockSand(12, 18).setHardness(0.5f).setStepSound(soundSandFootstep).setColor(15129006);
        gravel = new BlockGravel(13, 19).setHardness(0.6f).setStepSound(soundGravelFootstep).setColor(10786456);
        oreGold = new BlockOre(14, 32).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(0xFFF144);
        oreIron = new BlockOre(15, 33).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(0xE9E9E9);
        oreCoal = new BlockOre(16, 34).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep).setColor(6938586);
        wood = new BlockLog(17).setHardness(2.0f).setStepSound(soundWoodFootstep).setColor(6705456);
        leaves = (BlockLeaves)new BlockLeaves(18, 52).setHardness(0.2f).setLightOpacity(1).setStepSound(soundGrassFootstep).setColor(4180006);
        sponge = new BlockSponge(19).setHardness(0.6f).setStepSound(soundGrassFootstep).setColor(13553222);
        glass = new BlockGlass(20, 49, Material.glass, false).setHardness(0.3f).setStepSound(soundGlassFootstep).setColor(0, 12645886);
        cloth_red = new Block(21, 144, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_orange = new Block(22, 145, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_yellow = new Block(23, 146, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_lime = new Block(24, 147, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_green = new Block(25, 148, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_teal = new Block(26, 149, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_cyan = new Block(27, 150, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_blue = new Block(28, 151, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_indigo = new Block(29, 152, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_violet = new Block(30, 153, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_lilac = new Block(31, 154, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_pink = new Block(32, 155, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_magenta = new Block(33, 156, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_darkgray = new Block(34, 157, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth = new Block(35, 64, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        cloth_lightgray = new Block(36, 158, Material.cloth).setHardness(0.8f).setStepSound(soundClothFootstep);
        plantYellow = (BlockFlower)new BlockFlower(37, 13).setHardness(0.0f).setStepSound(soundGrassFootstep);
        plantRed = (BlockFlower)new BlockFlower(38, 12).setHardness(0.0f).setStepSound(soundGrassFootstep);
        mushroomBrown = (BlockFlower)new BlockMushroom(39, 29).setHardness(0.0f).setStepSound(soundGrassFootstep).setLightValue(0.125f);
        mushroomRed = (BlockFlower)new BlockMushroom(40, 28).setHardness(0.0f).setStepSound(soundGrassFootstep);
        blockGold = new BlockOreBlock(41, 39).setHardness(3.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        blockSteel = new BlockOreBlock(42, 38).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        stairDouble = new BlockStep(43, true).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        stairSingle = new BlockStep(44, false).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        brick = new Block(45, 7, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        tnt = new BlockTNT(46, 8).setHardness(0.0f).setStepSound(soundGrassFootstep);
        bookShelf = new BlockBookshelf(47, 35).setHardness(1.5f).setStepSound(soundWoodFootstep);
        cobblestoneMossy = new Block(48, 36, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        obsidian = new BlockObsidian(49, 37).setHardness(10.0f).setResistance(2000.0f).setStepSound(soundStoneFootstep);
        torchWood = new BlockTorch(50, 80).setHardness(0.0f).setLightValue(0.9375f).setStepSound(soundWoodFootstep);
        fire = (BlockFire)new BlockFire(51, 31).setHardness(0.0f).setLightValue(1.0f).setStepSound(soundWoodFootstep);
        mobSpawner = new BlockMobSpawner(52, 65).setHardness(5.0f).setStepSound(soundMetalFootstep);
        stairCompact_Wood = new BlockStairs(53, planks);
        crate = new BlockChest(54).setHardness(2.5f).setStepSound(soundWoodFootstep);
        redstoneWire = new BlockRedstoneWire(55, 84).setHardness(0.0f).setStepSound(soundPowderFootstep);
        oreDiamond = new BlockOre(56, 50).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        blockDiamond = new BlockOreBlock(57, 40).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        workbench = new BlockWorkbench(58).setHardness(2.5f).setStepSound(soundWoodFootstep);
        crops = new BlockCrops(59, 88).setHardness(0.0f).setStepSound(soundGrassFootstep);
        tilledField = new BlockSoil(60).setHardness(0.6f).setStepSound(soundGravelFootstep);
        stoneOvenIdle = new BlockFurnace(61, false).setHardness(3.5f).setStepSound(soundStoneFootstep);
        stoneOvenActive = new BlockFurnace(62, true).setHardness(3.5f).setStepSound(soundStoneFootstep).setLightValue(0.875f);
        signPost = new BlockSign(63, TileEntitySign.class, true).setHardness(1.0f).setStepSound(soundWoodFootstep);
        doorWood = new BlockDoor(64, Material.wood).setHardness(3.0f).setStepSound(soundWoodFootstep);
        ladder = new BlockLadder(65, 83).setHardness(0.4f).setStepSound(soundWoodFootstep);
        minecartTrack = new BlockMinecartTrack(66, 128).setHardness(0.7f).setStepSound(soundMetalFootstep);
        stairCompactStone = new BlockStairs(67, cobblestone);
        pressurePlateWoodIdle = new BlockSign(68, TileEntitySign.class, false).setHardness(1.0f).setStepSound(soundWoodFootstep);
        lever = new BlockLever(69, 96).setHardness(0.5f).setStepSound(soundWoodFootstep);
        pressurePlateStone = new BlockPressurePlate(70, Block.stone.blockIndexInTexture, EnumMobType.mobs).setHardness(0.5f).setStepSound(soundStoneFootstep);
        doorSteel = new BlockDoor(71, Material.iron).setHardness(5.0f).setStepSound(soundMetalFootstep);
        pressurePlateWood = new BlockPressurePlate(72, Block.planks.blockIndexInTexture, EnumMobType.everything).setHardness(0.5f).setStepSound(soundWoodFootstep);
        oreRed = new BlockRedstoneOre(73, 51, false).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        oreRedstoneGlowing = new BlockRedstoneOre(74, 51, true).setLightValue(0.625f).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        torchRedstoneIdle = new BlockRedstoneTorch(75, 115, false).setHardness(0.0f).setStepSound(soundWoodFootstep);
        torchRedstoneActive = new BlockRedstoneTorch(76, 99, true).setHardness(0.0f).setLightValue(0.5f).setStepSound(soundWoodFootstep);
        button = new BlockButton(77, Block.stone.blockIndexInTexture).setHardness(0.5f).setStepSound(soundStoneFootstep);
        snow = new BlockSnow(78, 66).setHardness(0.1f).setStepSound(soundClothFootstep);
        ice = new BlockIce(79, 67).setHardness(0.5f).setLightOpacity(3).setStepSound(soundGlassFootstep);
        blockSnow = new BlockSnowBlock(80, 66).setHardness(0.2f).setStepSound(soundClothFootstep);
        cactus = new BlockCactus(81, 70).setHardness(0.4f).setStepSound(soundClothFootstep);
        blockClay = new BlockClay(82, 72).setHardness(0.6f).setStepSound(soundGravelFootstep);
        reed = new BlockReed(83, 73).setHardness(0.0f).setStepSound(soundGrassFootstep);
        jukebox = new BlockJukeBox(84, 74).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        fence = new BlockFence(85, 4).setHardness(2.0f).setResistance(5.0f).setStepSound(soundWoodFootstep);
        gear = new BlockGear(86, 62).setHardness(0.5f).setResistance(5.0f).setStepSound(soundPowderFootstep);
        spongeInactive = new BlockSpongeInactive(87).setHardness(0.6f).setStepSound(soundGrassFootstep);
        plantBlue = (BlockFlower)new BlockFlower(88, 14).setHardness(0.0f).setStepSound(soundGrassFootstep);
        oreCopper = new BlockOre(89, 76).setHardness(3.0f).setResistance(5.0f).setStepSound(soundStoneFootstep);
        motor = new BlockMotor(90, 113, Material.iron, true, 30).setHardness(3.5f).setStepSound(soundMetalFootstep).setLightValue(0.875f);
        generator = new BlockMotor(91, 114, Material.iron, false, -1).setHardness(3.5f).setStepSound(soundMetalFootstep).setLightValue(0.875f);
        blockCopper = new BlockOreBlock(92, 176).setHardness(5.0f).setResistance(10.0f).setStepSound(soundMetalFootstep);
        brickMossy = new Block(93, 77, Material.rock).setHardness(2.0f).setResistance(10.0f).setStepSound(soundStoneFootstep);
        bleedingObsidian = new BlockBleedingObsidian(94, 116).setHardness(10.0f).setResistance(2000.0f).setStepSound(soundStoneFootstep);
        web = new BlockWeb(95, 11).setHardness(2.0f).setStepSound(soundClothFootstep);
        pressurePlateSteel = new BlockPressurePlate(96, Block.blockSteel.blockIndexInTexture, EnumMobType.players).setHardness(0.5f).setStepSound(soundMetalFootstep);
        lightBulb = new BlockLightBulb(97).setHardness(0.5f).setStepSound(soundGlassFootstep);
        lightBulbOn = new BlockLightBulb(98).setHardness(0.5f).setStepSound(soundGlassFootstep).setLightValue(1.0f);
        pyramidion = new BlockPyramidion(99, 104).setHardness(0.5f).setStepSound(soundMetalFootstep).setLightValue(1.0f);
        test = new Block(100, 88, Material.iron).setHardness(0.5f).setStepSound(soundMetalFootstep).setLightValue(1.0f);
        int i2 = 0;
        while (i2 < 256) {
            if (allBlocks[i2] != null) {
                Item.itemsList[i2] = new ItemBlock(i2 - 256);
            }
            ++i2;
        }
    }

    protected Block(int i2, Material material1) {
        if (allBlocks[i2] != null) {
            throw new IllegalArgumentException("Slot " + i2 + " is already occupied by " + allBlocks[i2] + " when adding " + this);
        }
        this.blockMaterial = material1;
        Block.allBlocks[i2] = this;
        this.blockID = i2;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        Block.opaqueCubeLookup[i2] = this.isOpaqueCube();
        Block.lightOpacity[i2] = this.isOpaqueCube() ? 255 : 0;
        Block.field_340_s[i2] = this.func_212_i();
        Block.isBlockContainer[i2] = false;
    }

    protected Block(int i2, int j2, Material material1) {
        this(i2, material1);
        this.blockIndexInTexture = j2;
    }

    protected Block setColor(int color) {
        this.primaryColor = color;
        return this;
    }

    protected Block setColor(int color, int color2) {
        this.primaryColor = color;
        this.secondaryColor = color2;
        return this;
    }

    protected Block setStepSound(StepSound stepsound) {
        this.stepSound = stepsound;
        return this;
    }

    protected Block setLightOpacity(int i2) {
        Block.lightOpacity[this.blockID] = i2;
        return this;
    }

    protected Block setLightValue(float f2) {
        Block.lightValue[this.blockID] = (int)(15.0f * f2);
        return this;
    }

    protected Block setResistance(float f2) {
        this.blockResistance = f2 * 3.0f;
        return this;
    }

    private boolean func_212_i() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public int getRenderType() {
        return 0;
    }

    protected Block setHardness(float f2) {
        this.blockHardness = f2;
        if (this.blockResistance < f2 * 5.0f) {
            this.blockResistance = f2 * 5.0f;
        }
        return this;
    }

    protected void setTickOnLoad(boolean flag) {
        Block.tickOnLoad[this.blockID] = flag;
    }

    public void setBlockBounds(float f2, float f1, float f22, float f3, float f4, float f5) {
        this.minX = f2;
        this.minY = f1;
        this.minZ = f22;
        this.maxX = f3;
        this.maxY = f4;
        this.maxZ = f5;
    }

    public float getBlockBrightness(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        return iblockaccess.getBrightness(i2, j2, k2);
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int x2, int y2, int z2, int face) {
        if (face == 1 && iblockaccess.getBlockId(x2, y2, z2) == Block.snow.blockID) {
            return false;
        }
        if (face == 0 && this.minY > 0.0) {
            return true;
        }
        if (face == 1 && this.maxY < 1.0) {
            return true;
        }
        if (face == 2 && this.minZ > 0.0) {
            return true;
        }
        if (face == 3 && this.maxZ < 1.0) {
            return true;
        }
        if (face == 4 && this.minX > 0.0) {
            return true;
        }
        if (face == 5 && this.maxX < 1.0) {
            return true;
        }
        return !iblockaccess.isBlockNormalCube(x2, y2, z2);
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return this.getBlockTextureFromSideAndMetadata(l2, iblockaccess.getBlockMetadata(i2, j2, k2));
    }

    public int getBlockTextureFromSideAndMetadata(int i2, int j2) {
        return this.getTextureIndex(i2);
    }

    public int getTextureIndex(int i2) {
        return this.blockIndexInTexture;
    }

    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)i2 + this.minX, (double)j2 + this.minY, (double)k2 + this.minZ, (double)i2 + this.maxX, (double)j2 + this.maxY, (double)k2 + this.maxZ);
    }

    public void getCollidingBoundingBoxes(World world, int i2, int j2, int k2, AxisAlignedBB axisalignedbb, ArrayList<AxisAlignedBB> arraylist) {
        AxisAlignedBB axisalignedbb1 = this.getCollisionBoundingBoxFromPool(world, i2, j2, k2);
        if (axisalignedbb1 != null && axisalignedbb.intersectsWith(axisalignedbb1)) {
            arraylist.add(axisalignedbb1);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return AxisAlignedBB.getBoundingBoxFromPool((double)i2 + this.minX, (double)j2 + this.minY, (double)k2 + this.minZ, (double)i2 + this.maxX, (double)j2 + this.maxY, (double)k2 + this.maxZ);
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public boolean canCollideCheck(int i2, boolean flag) {
        return this.isCollidable();
    }

    public boolean isCollidable() {
        return true;
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
    }

    public void randomDisplayTick(World world, int i2, int j2, int k2, Random random) {
    }

    public void dropBlockAsItemWithChance(World world, int i2, int j2, int k2, int l2) {
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
    }

    public int tickRate() {
        return 10;
    }

    public void onBlockAdded(World world, int i2, int j2, int k2) {
    }

    public void onBlockRemoval(World world, int i2, int j2, int k2) {
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public int idDropped(int i2, Random random) {
        return this.blockID;
    }

    public float blockStrength(EntityPlayer entityplayer) {
        if (this.blockHardness < 0.0f) {
            return 0.0f;
        }
        if (!entityplayer.checkBreakBlock(this)) {
            return 1.0f / this.blockHardness / 100.0f;
        }
        return entityplayer.getMiningInhibitors(this) / this.blockHardness / 30.0f;
    }

    public void dropBlockAsItem(World world, int i2, int j2, int k2, int l2) {
        this.dropBlockAsItemWithChance(world, i2, j2, k2, l2, 1.0f);
    }

    public void dropBlockAsItemWithChance(World world, int i2, int j2, int k2, int l2, float f2) {
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = this.quantityDropped(world.rand);
        int j1 = 0;
        while (j1 < i1) {
            int k1;
            if (!(world.rand.nextFloat() > f2) && (k1 = this.idDropped(l2, world.rand)) > 0) {
                this.dropBlockAsItem_do(world, i2, j2, k2, new ItemStack(k1, 1, this.damageDropped(l2)));
            }
            ++j1;
        }
    }

    public void dropBlockGoldTouch(World world, int x2, int y2, int z2, int damage, float f2) {
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = 1;
        int j1 = 0;
        while (j1 < i1) {
            if (!(world.rand.nextFloat() > f2)) {
                int id2 = this.blockID;
                if (id2 > 0 && id2 != Block.crops.blockID && id2 != Block.signPost.blockID && id2 != Block.pressurePlateWoodIdle.blockID && id2 != Block.doorWood.blockID && id2 != Block.doorSteel.blockID && id2 != Block.lightBulbOn.blockID && id2 != Block.pyramidion.blockID) {
                    this.dropBlockAsItem_do(world, x2, y2, z2, new ItemStack(id2, 1, this.damageDropped(damage)));
                } else if (id2 == Block.crops.blockID || id2 == Block.signPost.blockID || id2 == Block.pressurePlateWoodIdle.blockID || id2 == Block.doorWood.blockID || id2 == Block.doorSteel.blockID || id2 == Block.lightBulbOn.blockID) {
                    this.dropBlockAsItem(world, x2, y2, z2, damage);
                }
            }
            ++j1;
        }
    }

    protected void dropBlockAsItem_do(World world, int i2, int j2, int k2, ItemStack itemstack) {
        if (world.multiplayerWorld) {
            return;
        }
        float f2 = 0.7f;
        double d2 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        double d22 = (double)(world.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i2 + d2, (double)j2 + d1, (double)k2 + d22, itemstack);
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
    }

    protected int damageDropped(int i2) {
        return 0;
    }

    public float getExplosionResistance(Entity entity) {
        return this.blockResistance / 5.0f;
    }

    public MovingObjectPosition collisionRayTrace(World world, int x2, int y2, int z2, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, x2, y2, z2);
        vec3d = vec3d.addVector(-x2, -y2, -z2);
        vec3d1 = vec3d1.addVector(-x2, -y2, -z2);
        Vec3D vec3d2 = vec3d.getIntermediateWithXValue(vec3d1, this.minX);
        Vec3D vec3d3 = vec3d.getIntermediateWithXValue(vec3d1, this.maxX);
        Vec3D vec3d4 = vec3d.getIntermediateWithYValue(vec3d1, this.minY);
        Vec3D vec3d5 = vec3d.getIntermediateWithYValue(vec3d1, this.maxY);
        Vec3D vec3d6 = vec3d.getIntermediateWithZValue(vec3d1, this.minZ);
        Vec3D vec3d7 = vec3d.getIntermediateWithZValue(vec3d1, this.maxZ);
        if (!this.isVecInsideYZBounds(vec3d2)) {
            vec3d2 = null;
        }
        if (!this.isVecInsideYZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d4)) {
            vec3d4 = null;
        }
        if (!this.isVecInsideXZBounds(vec3d5)) {
            vec3d5 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d6)) {
            vec3d6 = null;
        }
        if (!this.isVecInsideXYBounds(vec3d7)) {
            vec3d7 = null;
        }
        Vec3D vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || vec3d.distanceTo(vec3d2) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || vec3d.distanceTo(vec3d3) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || vec3d.distanceTo(vec3d4) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || vec3d.distanceTo(vec3d5) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || vec3d.distanceTo(vec3d6) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || vec3d.distanceTo(vec3d7) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d8 == vec3d2) {
            byte0 = 4;
        }
        if (vec3d8 == vec3d3) {
            byte0 = 5;
        }
        if (vec3d8 == vec3d4) {
            byte0 = 0;
        }
        if (vec3d8 == vec3d5) {
            byte0 = 1;
        }
        if (vec3d8 == vec3d6) {
            byte0 = 2;
        }
        if (vec3d8 == vec3d7) {
            byte0 = 3;
        }
        return new MovingObjectPosition(x2, y2, z2, byte0, vec3d8.addVector(x2, y2, z2));
    }

    private boolean isVecInsideYZBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXZBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.zCoord >= this.minZ && vec3d.zCoord <= this.maxZ;
    }

    private boolean isVecInsideXYBounds(Vec3D vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= this.minX && vec3d.xCoord <= this.maxX && vec3d.yCoord >= this.minY && vec3d.yCoord <= this.maxY;
    }

    public void onBlockDestroyedByExplosion(World world, int i2, int j2, int k2) {
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public boolean canPlace(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockId(i2, j2, k2);
        return l2 == 0 || Block.allBlocks[l2].blockMaterial.getIsGroundCover();
    }

    public boolean blockActivated(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
        return false;
    }

    public void onEntityWalking(World world, int i2, int j2, int k2, Entity entity) {
    }

    public void onBlockPlaced(World world, int i2, int j2, int k2, int l2) {
    }

    public void onBlockClicked(World world, int i2, int j2, int k2, EntityPlayer entityplayer) {
    }

    public void velocityToAddToEntity(World world, int i2, int j2, int k2, Entity entity, Vec3D vec3d) {
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i2, int j2, int k2) {
    }

    public int colorMultiplier(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        return 0xFFFFFF;
    }

    public int colorMultiplierSecondary(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        return this.secondaryColor;
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return false;
    }

    public boolean canProvidePower() {
        return false;
    }

    public void onEntityCollidedWithBlock(World world, int i2, int j2, int k2, Entity entity) {
    }

    public boolean isIndirectlyPoweringTo(World world, int i2, int j2, int k2, int l2) {
        return false;
    }

    public void setBlockBoundsForItemRender() {
    }

    public void harvestBlock(World world, int i2, int j2, int k2, int l2) {
        this.dropBlockAsItem(world, i2, j2, k2, l2);
    }

    public boolean canBlockStay(World world, int i2, int j2, int k2) {
        return true;
    }

    public void applyGearPower() {
    }

    public void removeGearPower() {
    }

    public boolean isGearPowered() {
        return false;
    }

    public int getConnectedGearsCount(World world, int i2, int j2, int k2) {
        return 0;
    }

    public ArrayList<Vec3D> getConnectedGears(World world, int i2, int j2, int k2) {
        ArrayList<Vec3D> blocklist = new ArrayList<Vec3D>();
        if (world.getBlockId(i2 - 1, j2, k2) == Block.gear.blockID) {
            blocklist.add(Vec3D.createVectorHelper(i2 - 1, j2, k2));
        }
        if (world.getBlockId(i2 + 1, j2, k2) == Block.gear.blockID) {
            blocklist.add(Vec3D.createVectorHelper(i2 + 1, j2, k2));
        }
        if (world.getBlockId(i2, j2, k2 - 1) == Block.gear.blockID) {
            blocklist.add(Vec3D.createVectorHelper(i2, j2, k2 - 1));
        }
        if (world.getBlockId(i2, j2, k2 + 1) == Block.gear.blockID) {
            blocklist.add(Vec3D.createVectorHelper(i2, j2, k2 + 1));
        }
        return blocklist;
    }

    public ArrayList<Vec3D> getConnectedBlocks(World world, int i2, int j2, int k2) {
        return new ArrayList<Vec3D>();
    }

    static Class<?> _mthclass$(String s2) {
        try {
            return Class.forName(s2);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    public void onBlockPlacedBy(World world, int i2, int j2, int k2, EntityLiving entityliving) {
    }

    public void goldTouch() {
    }

    public void notGoldTouch() {
    }

    public int getTextureIndex(int n2, int n22, int n3) {
        return this.getTextureIndex(0);
    }
}

