/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.generate;

import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityChest;
import com.mojang.minecraft.entity.tile.TileEntityMobSpawner;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.Block;
import java.util.Random;

public class WorldGenFloatingDungeons
extends WorldGenerator {
    public boolean generate(World world, Random random, int x2, int y2, int z2) {
        int dungeonHeight = 3;
        int randomWidthX = random.nextInt(2) + 2;
        int randomWidthZ = random.nextInt(2) + 2;
        int validSpots = 0;
        int spotCheckX = x2 - randomWidthX - 1;
        while (spotCheckX <= x2 + randomWidthX + 1) {
            int spotCheckY = y2 - 1;
            while (spotCheckY <= y2 + dungeonHeight + 1) {
                int spotCheckZ = z2 - randomWidthZ - 1;
                while (spotCheckZ <= z2 + randomWidthZ + 1) {
                    if ((spotCheckX == x2 - randomWidthX - 1 || spotCheckX == x2 + randomWidthX + 1 || spotCheckZ == z2 - randomWidthZ - 1 || spotCheckZ == z2 + randomWidthZ + 1) && spotCheckY == y2 && world.getBlockId(spotCheckX, spotCheckY, spotCheckZ) == 0 && world.getBlockId(spotCheckX, spotCheckY + 1, spotCheckZ) == 0 && world.getBlockId(spotCheckX, spotCheckY + 2, spotCheckZ) == 0 && world.getBlockId(spotCheckX, spotCheckY + 3, spotCheckZ) == 0 && world.getBlockId(spotCheckX, spotCheckY + 4, spotCheckZ) == 0 && world.getBlockId(spotCheckX, spotCheckY + 5, spotCheckZ) == 0 && world.getBlockId(spotCheckX, spotCheckY + 6, spotCheckZ) == 0) {
                        ++validSpots;
                    }
                    ++spotCheckZ;
                }
                ++spotCheckY;
            }
            ++spotCheckX;
        }
        if (validSpots < 1 || validSpots > 50) {
            return false;
        }
        int blockGenX = x2 - randomWidthX - 1;
        while (blockGenX <= x2 + randomWidthX + 1) {
            int blockGenY = y2 + dungeonHeight;
            while (blockGenY >= y2 - 1) {
                int blockGenZ = z2 - randomWidthZ - 1;
                while (blockGenZ <= z2 + randomWidthZ + 1) {
                    if (blockGenX == x2 - randomWidthX - 1 || blockGenY == y2 - 1 || blockGenZ == z2 - randomWidthZ - 1 || blockGenX == x2 + randomWidthX + 1 || blockGenY == y2 + dungeonHeight + 1 || blockGenZ == z2 + randomWidthZ + 1) {
                        if (blockGenY >= 0 && !world.getMaterialXYZ(blockGenX, blockGenY - 1, blockGenZ).isSolidMaterial()) {
                            if (world.getBlockId(blockGenX, blockGenY, blockGenZ) == 0) {
                                if (random.nextInt(4) < 2) {
                                    world.setBlockWithNotify(blockGenX, blockGenY, blockGenZ, Block.brickMossy.blockID);
                                } else {
                                    world.setBlockWithNotify(blockGenX, blockGenY, blockGenZ, Block.brick.blockID);
                                }
                            }
                            this.genVine(blockGenX, blockGenY - (dungeonHeight + 3), blockGenZ, random, world);
                        } else if (blockGenY == y2 - 1) {
                            if (random.nextInt(4) < 2) {
                                world.setBlockWithNotify(blockGenX, blockGenY, blockGenZ, Block.brickMossy.blockID);
                            } else {
                                world.setBlockWithNotify(blockGenX, blockGenY, blockGenZ, Block.brick.blockID);
                            }
                        }
                    } else if (world.getBlockId(blockGenX, blockGenY, blockGenZ) == 0) {
                        world.setBlockWithNotify(blockGenX, blockGenY, blockGenZ, 0);
                        if (random.nextInt(4) < 2) {
                            world.setBlockWithNotify(blockGenX, y2 + dungeonHeight, blockGenZ, Block.brickMossy.blockID);
                        } else {
                            world.setBlockWithNotify(blockGenX, y2 + dungeonHeight, blockGenZ, Block.brick.blockID);
                        }
                    }
                    ++blockGenZ;
                }
                --blockGenY;
            }
            ++blockGenX;
        }
        int i2 = 0;
        while (i2 < 2) {
            int l2 = 0;
            while (l2 < 3) {
                int i4;
                int l3;
                int k3 = x2 + random.nextInt(randomWidthX * 2 + 1) - randomWidthX;
                if (world.getBlockId(k3, l3 = y2, i4 = z2 + random.nextInt(randomWidthZ * 2 + 1) - randomWidthZ) != 9) {
                    int viableSpace = 0;
                    if (world.getMaterialXYZ(k3 - 1, l3, i4).isSolidMaterial()) {
                        ++viableSpace;
                    }
                    if (world.getMaterialXYZ(k3 + 1, l3, i4).isSolidMaterial()) {
                        ++viableSpace;
                    }
                    if (world.getMaterialXYZ(k3, l3, i4 - 1).isSolidMaterial()) {
                        ++viableSpace;
                    }
                    if (world.getMaterialXYZ(k3, l3, i4 + 1).isSolidMaterial()) {
                        ++viableSpace;
                    }
                    if (viableSpace == 1) {
                        world.setBlockWithNotify(k3, l3, i4, Block.crate.blockID);
                        TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(k3, l3, i4);
                        for (int k4 = 0; k4 < 8; ++k4) {
                            ItemStack itemstack = this.chestLoot(random);
                            if (itemstack == null) continue;
                            tileentitychest.setInventorySlotContents(random.nextInt(tileentitychest.getSizeInventory()), itemstack);
                        }
                        break;
                    }
                }
                ++l2;
            }
            ++i2;
        }
        world.setBlock(x2, y2 - 1, z2, Block.brick.blockID);
        world.setBlock(x2, y2, z2, 0);
        world.setBlockWithNotify(x2, y2, z2, Block.mobSpawner.blockID);
        if (y2 <= 128) {
            TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.getBlockTileEntity(x2, y2, z2);
            tileentitymobspawner.entityID = this.func_531_b(random);
        }
        return true;
    }

    private void genVine(int x2, int y2, int z2, Random rand, World world) {
        int vineLength = rand.nextInt(3);
        int i2 = 0;
        while (i2 < vineLength) {
            world.setBlock(x2, y2 - i2 + 1, z2, Block.leaves.blockID);
            ++i2;
        }
    }

    private ItemStack chestLoot(Random random) {
        int i2 = random.nextInt(12);
        if (i2 == 0) {
            return new ItemStack(Block.sponge, random.nextInt(4) + 1);
        }
        if (i2 == 1) {
            return new ItemStack(Item.ingotGold, random.nextInt(4) + 1);
        }
        if (i2 == 2) {
            return new ItemStack(Item.paper, random.nextInt(4) + 1);
        }
        if (i2 == 3) {
            return new ItemStack(Item.reed, random.nextInt(4) + 1);
        }
        if (i2 == 4) {
            return new ItemStack(Item.flint, random.nextInt(4) + 1);
        }
        if (i2 == 5) {
            int roll = random.nextInt(4);
            if (roll == 0) {
                return new ItemStack(Item.helmetChain);
            }
            if (roll == 1) {
                return new ItemStack(Item.plateChain);
            }
            if (roll == 2) {
                return new ItemStack(Item.legsChain);
            }
            if (roll == 3) {
                return new ItemStack(Item.bootsChain);
            }
        }
        if (i2 == 6) {
            return new ItemStack(Item.bucketWater);
        }
        if (i2 == 7 && random.nextInt(100) == 0) {
            return new ItemStack(Item.appleGold);
        }
        if (i2 == 8 && random.nextInt(2) == 0) {
            return new ItemStack(Item.redstone, random.nextInt(4) + 1);
        }
        if (i2 == 9 && random.nextInt(10) == 0) {
            return new ItemStack(Item.diamond);
        }
        if (i2 == 10 && random.nextInt(10) == 0) {
            return new ItemStack(Block.bleedingObsidian);
        }
        return null;
    }

    private String func_531_b(Random random) {
        int i2 = random.nextInt(4);
        if (i2 == 0) {
            return "Skeleton";
        }
        if (i2 == 1) {
            return "Zombie";
        }
        if (i2 == 2) {
            return "Zombie";
        }
        if (i2 == 3) {
            return "Spider";
        }
        return "";
    }
}

