/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.IChunkProvider;
import java.io.IOException;

public class ChunkProviderLoadOrGenerate
implements IChunkProvider {
    private Chunk localChunk;
    private IChunkProvider chunkProvider;
    private IChunkLoader chunkLoader;
    private Chunk[] chunks = new Chunk[1024];
    private World worldObj;
    int chunkX = -999999999;
    int chunkZ = -999999999;
    private Chunk workingChunk;
    private int curChunkX;
    private int curChunkY;

    public ChunkProviderLoadOrGenerate(World world, IChunkLoader ichunkloader, IChunkProvider ichunkprovider) {
        this.localChunk = new Chunk(world, new byte[32768], 0, 0);
        this.localChunk.hasEntities2 = true;
        this.localChunk.neverSave = true;
        this.worldObj = world;
        this.chunkLoader = ichunkloader;
        this.chunkProvider = ichunkprovider;
    }

    public void setCurrentChunkOver(int x2, int z2) {
        this.curChunkX = x2;
        this.curChunkY = z2;
    }

    public boolean canChunkExist(int x2, int z2) {
        int byte0 = 15;
        return x2 >= this.curChunkX - byte0 && z2 >= this.curChunkY - byte0 && x2 <= this.curChunkX + byte0 && z2 <= this.curChunkY + byte0;
    }

    public boolean chunkExists(int x2, int z2) {
        if (x2 == this.chunkX && z2 == this.chunkZ && this.workingChunk != null) {
            return true;
        }
        int k2 = x2 & 0x1F;
        int l2 = z2 & 0x1F;
        int i1 = k2 + l2 * 32;
        return this.chunks[i1] != null && (this.chunks[i1] == this.localChunk || this.chunks[i1].isAtLocation(x2, z2));
    }

    public Chunk provideChunk(int x2, int j2) {
        if (x2 == this.chunkX && j2 == this.chunkZ && this.workingChunk != null) {
            return this.workingChunk;
        }
        int k2 = x2 & 0x1F;
        int l2 = j2 & 0x1F;
        int i1 = k2 + l2 * 32;
        if (!this.chunkExists(x2, j2)) {
            Chunk chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].onChunkUnload();
                this.saveLoadedChunk(this.chunks[i1]);
                this.saveLoadedChunkData(this.chunks[i1]);
            }
            if ((chunk = this.provideLoadedChunk(x2, j2)) == null) {
                chunk = this.chunkProvider == null ? this.localChunk : this.chunkProvider.provideChunk(x2, j2);
            }
            this.chunks[i1] = chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].onChunkLoad();
            }
            if (!this.chunks[i1].isTerrainPopulated && this.chunkExists(x2 + 1, j2 + 1) && this.chunkExists(x2, j2 + 1) && this.chunkExists(x2 + 1, j2)) {
                this.generateStructures(this, x2, j2);
            }
            if (this.chunkExists(x2 - 1, j2) && !this.provideChunk((int)(x2 - 1), (int)j2).isTerrainPopulated && this.chunkExists(x2 - 1, j2 + 1) && this.chunkExists(x2, j2 + 1) && this.chunkExists(x2 - 1, j2)) {
                this.generateStructures(this, x2 - 1, j2);
            }
            if (this.chunkExists(x2, j2 - 1) && !this.provideChunk((int)x2, (int)(j2 - 1)).isTerrainPopulated && this.chunkExists(x2 + 1, j2 - 1) && this.chunkExists(x2, j2 - 1) && this.chunkExists(x2 + 1, j2)) {
                this.generateStructures(this, x2, j2 - 1);
            }
            if (this.chunkExists(x2 - 1, j2 - 1) && !this.provideChunk((int)(x2 - 1), (int)(j2 - 1)).isTerrainPopulated && this.chunkExists(x2 - 1, j2 - 1) && this.chunkExists(x2, j2 - 1) && this.chunkExists(x2 - 1, j2)) {
                this.generateStructures(this, x2 - 1, j2 - 1);
            }
        }
        this.chunkX = x2;
        this.chunkZ = j2;
        this.workingChunk = this.chunks[i1];
        return this.chunks[i1];
    }

    private Chunk provideLoadedChunk(int i2, int j2) {
        if (this.chunkLoader == null) {
            return null;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunkFromFile(this.worldObj, i2, j2);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.worldTime;
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void saveLoadedChunkData(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            this.chunkLoader.saveExtraChunkData(this.worldObj, chunk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveLoadedChunk(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.worldObj.worldTime;
            this.chunkLoader.saveChunk(this.worldObj, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    public void generateStructures(IChunkProvider ichunkprovider, int i2, int j2) {
        Chunk chunk = this.provideChunk(i2, j2);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.generateStructures(ichunkprovider, i2, j2);
                chunk.setChunkModified();
            }
        }
    }

    public boolean saveChunks(boolean flag, IProgressUpdate iprogressupdate) {
        int i2 = 0;
        int j2 = 0;
        if (iprogressupdate != null) {
            int k2 = 0;
            while (k2 < this.chunks.length) {
                if (this.chunks[k2] != null && this.chunks[k2].needsSaving(flag)) {
                    ++j2;
                }
                ++k2;
            }
        }
        int l2 = 0;
        int i1 = 0;
        while (i1 < this.chunks.length) {
            if (this.chunks[i1] != null) {
                if (flag && !this.chunks[i1].neverSave) {
                    this.saveLoadedChunkData(this.chunks[i1]);
                }
                if (this.chunks[i1].needsSaving(flag)) {
                    this.saveLoadedChunk(this.chunks[i1]);
                    this.chunks[i1].isModified = false;
                    if (++i2 == 2 && !flag) {
                        return false;
                    }
                    if (iprogressupdate != null && ++l2 % 10 == 0) {
                        iprogressupdate.setProgess(l2 * 100 / j2);
                    }
                }
            }
            ++i1;
        }
        if (flag) {
            if (this.chunkLoader == null) {
                return true;
            }
            this.chunkLoader.saveExtraData();
        }
        return true;
    }

    public boolean unload100OldestChunks() {
        if (this.chunkLoader != null) {
            this.chunkLoader.func_814_a();
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    public boolean canSave() {
        return true;
    }
}

