/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.chunk;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.generate.IChunkLoader;
import com.mojang.minecraft.level.generate.noise.NibbleArray;
import com.mojang.minecraft.level.region.RegionFileCache;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.util.CompressedStreamTools;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ChunkLoader
implements IChunkLoader {
    private File basePath;

    public ChunkLoader(File file, boolean flag) {
        this.basePath = file;
    }

    private File getChunkFile(int i2, int j2) {
        String s2 = "c." + Integer.toString(i2, 36) + "." + Integer.toString(j2, 36) + ".dat";
        String s1 = Integer.toString(i2 & 0x3F, 36);
        String s22 = Integer.toString(j2 & 0x3F, 36);
        File file = new File(this.basePath, s1);
        file = new File(file, s22);
        file = new File(file, s2);
        return file;
    }

    public Chunk loadChunkFromFile(World world, int x2, int z2) throws IOException {
        NBTTagCompound nbt;
        DataInputStream regionChunkInputStream = RegionFileCache.getChunkDataInputStream(this.basePath, x2, z2);
        File chunkFile = this.getChunkFile(x2, z2);
        if (regionChunkInputStream != null) {
            nbt = CompressedStreamTools.func_1138_a(regionChunkInputStream);
        } else if (chunkFile.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(chunkFile);
                nbt = CompressedStreamTools.func_1138_a(inputStream);
                inputStream.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        } else {
            return null;
        }
        if (!nbt.hasKey("Level")) {
            System.out.println("Chunk file at " + x2 + "," + z2 + " is missing level data, skipping");
            regionChunkInputStream.close();
            return null;
        }
        if (!nbt.getCompoundTag("Level").hasKey("Blocks")) {
            System.out.println("Chunk file at " + x2 + "," + z2 + " is missing block data, skipping");
            regionChunkInputStream.close();
            return null;
        }
        Chunk chunk = ChunkLoader.loadChunkIntoWorldFromCompound(world, nbt.getCompoundTag("Level"));
        if (!chunk.isAtLocation(x2, z2)) {
            System.out.println("Chunk file at " + x2 + "," + z2 + " is in the wrong location; relocating. (Expected " + x2 + ", " + z2 + ", got " + chunk.xPosition + ", " + chunk.zPosition + ")");
            nbt.setInteger("xPos", x2);
            nbt.setInteger("zPos", z2);
            chunk = ChunkLoader.loadChunkIntoWorldFromCompound(world, nbt.getCompoundTag("Level"));
        }
        try {
            if (regionChunkInputStream != null) {
                regionChunkInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return chunk;
    }

    public void saveChunk(World world, Chunk chunk) throws IOException {
        world.checkSessionLock();
        DataOutputStream output = RegionFileCache.getChunkDataOutputStream(this.basePath, chunk.xPosition, chunk.zPosition);
        NBTTagCompound var6 = new NBTTagCompound();
        NBTTagCompound var7 = new NBTTagCompound();
        var6.func_762_a("Level", var7);
        this.storeChunkInCompound(chunk, world, var7);
        CompressedStreamTools.writeGzippedCompoundToOutputStream(var6, output);
        try {
            output.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        world.sizeOnDisk += (long)RegionFileCache.getSizeDelta(this.basePath, chunk.xPosition, chunk.zPosition);
    }

    public void storeChunkInCompound(Chunk chunk, World world, NBTTagCompound nbttagcompound) {
        world.checkSessionLock();
        nbttagcompound.setInteger("xPos", chunk.xPosition);
        nbttagcompound.setInteger("zPos", chunk.zPosition);
        nbttagcompound.setLong("LastUpdate", world.worldTime);
        nbttagcompound.func_747_a("Blocks", chunk.blocks);
        nbttagcompound.func_747_a("Data", chunk.data.data);
        nbttagcompound.func_747_a("SkyLight", chunk.skylightMap.data);
        nbttagcompound.func_747_a("BlockLight", chunk.blocklightMap.data);
        nbttagcompound.func_747_a("HeightMap", chunk.heightMap);
        nbttagcompound.setBool("TerrainPopulated", chunk.isTerrainPopulated);
        chunk.hasEntities = false;
        NBTTagList nbttaglist = new NBTTagList();
        int i2 = 0;
        while (i2 < chunk.entities.length) {
            for (Entity entity : chunk.entities[i2]) {
                chunk.hasEntities = true;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                if (!entity.addEntityID(nbttagcompound1)) continue;
                nbttaglist.setTag(nbttagcompound1);
            }
            ++i2;
        }
        nbttagcompound.func_762_a("Entities", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (TileEntity tileentity : chunk.chunkTileEntityMap.values()) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            tileentity.func_481_b(nbttagcompound2);
            nbttaglist1.setTag(nbttagcompound2);
        }
        nbttagcompound.func_762_a("TileEntities", nbttaglist1);
    }

    public static Chunk loadChunkIntoWorldFromCompound(World world, NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist1;
        NBTTagList nbttaglist;
        int i2 = nbttagcompound.getInteger("xPos");
        int j2 = nbttagcompound.getInteger("zPos");
        Chunk chunk = new Chunk(world, i2, j2);
        chunk.blocks = nbttagcompound.getByteArray("Blocks");
        chunk.data = new NibbleArray(nbttagcompound.getByteArray("Data"));
        chunk.skylightMap = new NibbleArray(nbttagcompound.getByteArray("SkyLight"));
        chunk.blocklightMap = new NibbleArray(nbttagcompound.getByteArray("BlockLight"));
        chunk.heightMap = nbttagcompound.getByteArray("HeightMap");
        chunk.isTerrainPopulated = nbttagcompound.getBoolean("TerrainPopulated");
        if (!chunk.data.isValid()) {
            chunk.data = new NibbleArray(chunk.blocks.length);
        }
        if (chunk.heightMap == null || !chunk.skylightMap.isValid()) {
            chunk.heightMap = new byte[256];
            chunk.skylightMap = new NibbleArray(chunk.blocks.length);
            chunk.func_1024_c();
        }
        if (!chunk.blocklightMap.isValid()) {
            chunk.blocklightMap = new NibbleArray(chunk.blocks.length);
            chunk.func_1014_a();
        }
        if ((nbttaglist = nbttagcompound.getTagList("Entities")) != null) {
            int k2 = 0;
            while (k2 < nbttaglist.tagCount()) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(k2);
                Entity entity = EntityList.createEntityFromNBT(nbttagcompound1, world);
                chunk.hasEntities = true;
                if (entity != null) {
                    chunk.addEntity(entity);
                }
                ++k2;
            }
        }
        if ((nbttaglist1 = nbttagcompound.getTagList("TileEntities")) != null) {
            int l2 = 0;
            while (l2 < nbttaglist1.tagCount()) {
                NBTTagCompound nbttagcompound2 = (NBTTagCompound)nbttaglist1.tagAt(l2);
                TileEntity tileentity = TileEntity.createAndLoadEntity(nbttagcompound2);
                if (tileentity != null) {
                    chunk.addTileEntity(tileentity);
                }
                ++l2;
            }
        }
        return chunk;
    }

    public void func_814_a() {
    }

    public void saveExtraData() {
    }

    public void saveExtraChunkData(World world, Chunk chunk) {
    }
}

