/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.WorldBlockPositionType;
import com.mojang.minecraft.level.chunk.ChunkProviderClient;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.networknew.NetClientHandler;
import com.mojang.minecraft.networknew.packet.Packet255KickDisconnect;
import com.mojang.minecraft.render.IWorldAccess;
import com.mojang.minecraft.util.MCHashTable;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class WorldClient
extends World {
    private LinkedList<WorldBlockPositionType> blockPositionTypes = new LinkedList();
    private NetClientHandler sendQueue;
    private ChunkProviderClient clientChunkProvider;
    private boolean field_1056_C = false;
    private MCHashTable field_1055_D = new MCHashTable();
    private Set<Entity> field_1054_E = new HashSet<Entity>();
    private Set<Entity> field_1053_F = new HashSet<Entity>();

    public WorldClient(NetClientHandler netclienthandler, Minecraft mine) {
        super("MpServer", mine);
        this.sendQueue = netclienthandler;
        this.spawnX = 8;
        this.spawnY = 64;
        this.spawnZ = 8;
        this.mc = mine;
    }

    public void tick() {
        ++this.worldTime;
        int i2 = this.getTimeOfDayBrightness(1.0f);
        if (i2 != this.skyLightSubtracted) {
            this.skyLightSubtracted = i2;
            int j2 = 0;
            while (j2 < this.worldAccesses.size()) {
                ((IWorldAccess)this.worldAccesses.get(j2)).updateAllRenderers();
                ++j2;
            }
        }
        int k2 = 0;
        while (k2 < 10 && !this.field_1053_F.isEmpty()) {
            Entity entity = this.field_1053_F.iterator().next();
            this.entityJoinedWorld(entity);
            ++k2;
        }
        this.sendQueue.processReadPackets();
        int l2 = 0;
        while (l2 < this.blockPositionTypes.size()) {
            WorldBlockPositionType worldblockpositiontype = this.blockPositionTypes.get(l2);
            if (--worldblockpositiontype.field_1206_d == 0) {
                super.setBlockAndMetadata(worldblockpositiontype.bPosX, worldblockpositiontype.bPosY, worldblockpositiontype.bPosZ, worldblockpositiontype.field_1205_e, worldblockpositiontype.field_1204_f);
                super.markBlockNeedsUpdate(worldblockpositiontype.bPosX, worldblockpositiontype.bPosY, worldblockpositiontype.bPosZ);
                this.blockPositionTypes.remove(l2--);
            }
            ++l2;
        }
    }

    public void markRangeForUpdate(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        int index = 0;
        while (index < this.blockPositionTypes.size()) {
            WorldBlockPositionType worldblockpositiontype = this.blockPositionTypes.get(index);
            if (worldblockpositiontype.bPosX >= xMin && worldblockpositiontype.bPosY >= yMin && worldblockpositiontype.bPosZ >= zMin && worldblockpositiontype.bPosX <= xMax && worldblockpositiontype.bPosY <= yMax && worldblockpositiontype.bPosZ <= zMax) {
                this.blockPositionTypes.remove(index--);
            }
            ++index;
        }
    }

    protected IChunkProvider getWorldChunkProvider(File file) {
        this.clientChunkProvider = new ChunkProviderClient(this);
        return this.clientChunkProvider;
    }

    public void func_622_a() {
        this.spawnX = 8;
        this.spawnY = 64;
        this.spawnZ = 8;
    }

    protected void doWorldTick() {
    }

    public void scheduleUpdateTick(int i2, int j2, int k2, int l2) {
    }

    public boolean tickUpdates(boolean flag) {
        return false;
    }

    public void doPreChunk(int x2, int z2, boolean isLoading) {
        if (isLoading) {
            this.clientChunkProvider.prepareChunk(x2, z2);
        } else {
            this.clientChunkProvider.unloadChunk(x2, z2);
        }
        if (!isLoading) {
            this.markBlocksDirty(x2 * 16, 0, z2 * 16, x2 * 16 + 15, 128, z2 * 16 + 15);
        }
    }

    public boolean entityJoinedWorld(Entity entity) {
        boolean flag = super.entityJoinedWorld(entity);
        if (entity instanceof EntityPlayerSP) {
            this.field_1054_E.add(entity);
        }
        return flag;
    }

    public void setEntityDead(Entity entity) {
        super.setEntityDead(entity);
        if (entity instanceof EntityPlayerSP) {
            this.field_1054_E.remove(entity);
        }
    }

    public void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        if (this.field_1053_F.contains(entity)) {
            this.field_1053_F.remove(entity);
        }
    }

    public void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (this.field_1054_E.contains(entity)) {
            this.field_1053_F.add(entity);
        }
    }

    public void func_712_a(int i2, Entity entity) {
        Entity entity1 = this.func_709_b(i2);
        if (entity1 != null) {
            this.setEntityDead(entity1);
        }
        this.field_1054_E.add(entity);
        entity.entityId = i2;
        if (!this.entityJoinedWorld(entity)) {
            this.field_1053_F.add(entity);
        }
        this.field_1055_D.addKey(i2, entity);
    }

    public Entity func_709_b(int i2) {
        return (Entity)this.field_1055_D.func_1057_a(i2);
    }

    public Entity removeEntityFromWorld(int i2) {
        Entity entity = (Entity)this.field_1055_D.func_1052_b(i2);
        if (entity != null) {
            this.field_1054_E.remove(entity);
            this.setEntityDead(entity);
        }
        return entity;
    }

    public boolean setBlockMetadata(int i2, int j2, int k2, int l2) {
        int i1 = this.getBlockId(i2, j2, k2);
        int j1 = this.getBlockMetadata(i2, j2, k2);
        if (super.setBlockMetadata(i2, j2, k2, l2)) {
            this.blockPositionTypes.add(new WorldBlockPositionType(this, i2, j2, k2, i1, j1));
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadata(int i2, int j2, int k2, int l2, int i1) {
        int j1 = this.getBlockId(i2, j2, k2);
        int k1 = this.getBlockMetadata(i2, j2, k2);
        if (super.setBlockAndMetadata(i2, j2, k2, l2, i1)) {
            this.blockPositionTypes.add(new WorldBlockPositionType(this, i2, j2, k2, j1, k1));
            return true;
        }
        return false;
    }

    public boolean setBlock(int i2, int j2, int k2, int l2) {
        int i1 = this.getBlockId(i2, j2, k2);
        int j1 = this.getBlockMetadata(i2, j2, k2);
        if (super.setBlock(i2, j2, k2, l2)) {
            this.blockPositionTypes.add(new WorldBlockPositionType(this, i2, j2, k2, i1, j1));
            return true;
        }
        return false;
    }

    public boolean func_714_c(int i2, int j2, int k2, int l2, int i1) {
        this.markRangeForUpdate(i2, j2, k2, i2, j2, k2);
        if (super.setBlockAndMetadata(i2, j2, k2, l2, i1)) {
            this.notifyBlockChange(i2, j2, k2, l2);
            return true;
        }
        return false;
    }

    public void cacheTileEntity(int i2, int j2, int k2, TileEntity tileentity) {
        if (this.field_1056_C) {
            return;
        }
    }

    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.addToSendQueue(new Packet255KickDisconnect("Quitting"));
    }
}

