/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.gui.ChatAllowedCharacters;
import com.mojang.minecraft.gui.Gui;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.render.FontRenderer;

public class GuiTextField
extends Gui {
    private final FontRenderer fontRenderer;
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;
    private String text;
    private int maxStringLength;
    private int cursorCounter;
    public boolean isFocused = false;
    public boolean isEnabled = true;
    private GuiScreen parentGuiScreen;

    public GuiTextField(GuiScreen guiscreen, FontRenderer fontrenderer, int i2, int j2, int k2, int l2, String s2) {
        this.parentGuiScreen = guiscreen;
        this.fontRenderer = fontrenderer;
        this.xPos = i2;
        this.yPos = j2;
        this.width = k2;
        this.height = l2;
        this.setText(s2);
    }

    public void setText(String s2) {
        this.text = s2;
    }

    public String getText() {
        return this.text;
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void textboxKeyTyped(char c2, int i2) {
        if (!this.isEnabled || !this.isFocused) {
            return;
        }
        if (c2 == '\t') {
            this.parentGuiScreen.selectNextField();
        }
        if (c2 == '\u0016') {
            int j2;
            String s2 = GuiScreen.getClipboardString();
            if (s2 == null) {
                s2 = "";
            }
            if ((j2 = 32 - this.text.length()) > s2.length()) {
                j2 = s2.length();
            }
            if (j2 > 0) {
                this.text = String.valueOf(this.text) + s2.substring(0, j2);
            }
        }
        if (i2 == 14 && this.text.length() > 0) {
            this.text = this.text.substring(0, this.text.length() - 1);
        }
        if (ChatAllowedCharacters.allowedCharacters.indexOf(c2) >= 0 && (this.text.length() < this.maxStringLength || this.maxStringLength == 0)) {
            this.text = String.valueOf(this.text) + c2;
        }
    }

    public void mouseClicked(int i2, int j2, int k2) {
        boolean flag = this.isEnabled && i2 >= this.xPos && i2 < this.xPos + this.width && j2 >= this.yPos && j2 < this.yPos + this.height;
        this.setFocused(flag);
    }

    public void setFocused(boolean flag) {
        if (flag && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = flag;
    }

    public void drawTextBox() {
        this.drawRect(this.xPos - 1, this.yPos - 1, this.xPos + this.width + 1, this.yPos + this.height + 1, -6250336);
        this.drawRect(this.xPos, this.yPos, this.xPos + this.width, this.yPos + this.height, -16777216);
        if (this.isEnabled) {
            boolean flag = this.isFocused && this.cursorCounter / 6 % 2 == 0;
            this.drawString(this.fontRenderer, this.text + (flag ? "_" : ""), this.xPos + 4, this.yPos + (this.height - 8) / 2, 0xE0E0E0);
        } else {
            this.drawString(this.fontRenderer, this.text, this.xPos + 4, this.yPos + (this.height - 8) / 2, 0x707070);
        }
    }

    public void setMaxStringLength(int i2) {
        this.maxStringLength = i2;
    }
}

