/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.entity.tile.TileEntityRenderer;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.gui.ChatAllowedCharacters;
import com.mojang.minecraft.gui.GuiButton;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.networknew.packet.Packet130UpdateSign;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiEditSign
extends GuiScreen {
    protected String field_999_a = "Edit sign message:";
    private TileEntitySign entitySign;
    private int updateCounter;
    private int editLine = 0;

    public GuiEditSign(TileEntitySign tileentitysign) {
        this.entitySign = tileentitysign;
    }

    public void initGui() {
        this.controlList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 2 + 60, "Done"));
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.mc.mcWorld.multiplayerWorld) {
            this.mc.getSendQueue().addToSendQueue(new Packet130UpdateSign(this.entitySign.x, this.entitySign.y, this.entitySign.z, this.entitySign.signText));
        }
    }

    public void updateScreen() {
        ++this.updateCounter;
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 0) {
            this.entitySign.onInventoryChanged();
            this.mc.setCurrentScreen(null);
        }
    }

    protected void keyTyped(char c2, int i2) {
        if (i2 == 200) {
            this.editLine = this.editLine - 1 & 3;
        }
        if (i2 == 208 || i2 == 28) {
            this.editLine = this.editLine + 1 & 3;
        }
        if (c2 == '\u0016') {
            int j2;
            String s2 = GuiScreen.getClipboardString();
            if (s2 == null) {
                s2 = "";
            }
            if ((j2 = 15 - this.entitySign.signText[this.editLine].length()) > s2.length()) {
                j2 = s2.length();
            }
            if (j2 > 0) {
                int n2 = this.editLine;
                this.entitySign.signText[n2] = String.valueOf(this.entitySign.signText[n2]) + s2.substring(0, j2);
                int line = this.editLine + 1;
                while (line < 4) {
                    if (s2.length() - 1 > j2 && s2.substring(j2).length() >= 15) {
                        int n3 = line;
                        this.entitySign.signText[n3] = String.valueOf(this.entitySign.signText[n3]) + s2.substring(j2, j2 + 15);
                        this.editLine = line;
                    } else if (s2.length() - 1 > j2 && s2.substring(j2).length() - 1 < 15) {
                        int n4 = line;
                        this.entitySign.signText[n4] = String.valueOf(this.entitySign.signText[n4]) + s2.substring(j2);
                        this.editLine = line;
                    }
                    j2 += 15;
                    ++line;
                }
            }
        }
        if (i2 == 14 && this.entitySign.signText[this.editLine].length() > 0) {
            this.entitySign.signText[this.editLine] = this.entitySign.signText[this.editLine].substring(0, this.entitySign.signText[this.editLine].length() - 1);
        }
        if (ChatAllowedCharacters.allowedCharacters.indexOf(c2) >= 0 && this.entitySign.signText[this.editLine].length() < 15) {
            int n5 = this.editLine;
            this.entitySign.signText[n5] = String.valueOf(this.entitySign.signText[n5]) + c2;
        }
    }

    public void drawScreen(int i2, int j2, float f2) {
        try {
            this.drawDefaultBackground();
            this.drawCenteredString(this.fontRenderer, this.field_999_a, this.width / 2, this.height / 2 - 75, 0xFFFFFF);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.width / 2), (float)(this.height / 2), (float)50.0f);
            float f1 = 93.75f;
            GL11.glScalef((float)(-f1), (float)(-f1), (float)(-f1));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Block block = this.entitySign.func_478_g();
            if (block == Block.signPost) {
                float f22 = (float)(this.entitySign.func_479_f() * 360) / 16.0f;
                GL11.glRotatef((float)f22, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                int k2 = this.entitySign.func_479_f();
                float f3 = 0.0f;
                if (k2 == 2) {
                    f3 = 180.0f;
                }
                if (k2 == 4) {
                    f3 = 90.0f;
                }
                if (k2 == 5) {
                    f3 = -90.0f;
                }
                GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
            }
            if (this.updateCounter / 6 % 2 == 0) {
                this.entitySign.lineBeingEdited = this.editLine;
            }
            TileEntityRenderer.instance.renderTileEntityAt(this.entitySign, -0.5, -0.75, -0.5, 0.0f);
            this.entitySign.lineBeingEdited = -1;
            GL11.glPopMatrix();
            super.drawScreen(i2, j2, f2);
        }
        catch (NullPointerException ex2) {
            this.mc.setCurrentScreen(null);
        }
    }
}

