/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.path;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.path.Path;
import com.mojang.minecraft.entity.path.PathEntity;
import com.mojang.minecraft.entity.path.PathPoint;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.util.MCHashTable;
import com.mojang.minecraft.util.MathHelper;

public class Pathfinder {
    public static boolean oldai = false;
    private IBlockAccess worldMap;
    private Path path = new Path();
    private MCHashTable pointMap = new MCHashTable();
    private PathPoint[] pathOptions = new PathPoint[32];

    public Pathfinder(IBlockAccess iblockaccess) {
        this.worldMap = iblockaccess;
    }

    public PathEntity createEntityPathTo(Entity entity, Entity entity1, float f2) {
        return this.createEntityPathTo(entity, entity1.posX, entity1.boundingBox.minY, entity1.posZ, f2);
    }

    public PathEntity createEntityPathTo(Entity entity, int i2, int j2, int k2, float f2) {
        return this.createEntityPathTo(entity, (float)i2 + 0.5f, (float)j2 + 0.5f, (float)k2 + 0.5f, f2);
    }

    private PathEntity createEntityPathTo(Entity entity, double d2, double d1, double d22, float f2) {
        this.path.func_1038_a();
        this.pointMap.func_1058_a();
        PathPoint pathpoint = this.openPoint(MathHelper.floor_double(entity.boundingBox.minX), MathHelper.floor_double(entity.boundingBox.minY), MathHelper.floor_double(entity.boundingBox.minZ));
        PathPoint pathpoint1 = this.openPoint(MathHelper.floor_double(d2 - (double)(entity.width / 2.0f)), MathHelper.floor_double(d1), MathHelper.floor_double(d22 - (double)(entity.width / 2.0f)));
        PathPoint pathpoint2 = new PathPoint(MathHelper.floor_float(entity.width + 1.0f), MathHelper.floor_float(entity.height + 1.0f), MathHelper.floor_float(entity.width + 1.0f));
        PathEntity pathentity = this.func_1129_a(entity, pathpoint, pathpoint1, pathpoint2, f2);
        return pathentity;
    }

    private PathEntity func_1129_a(Entity entity, PathPoint pathpoint, PathPoint pathpoint1, PathPoint pathpoint2, float f2) {
        pathpoint.field_1713_f = 0.0f;
        pathpoint.field_1711_h = pathpoint.field_1712_g = pathpoint.getMagnitude(pathpoint1);
        this.path.func_1038_a();
        this.path.func_1034_a(pathpoint);
        PathPoint pathpoint3 = pathpoint;
        while (!this.path.func_1039_c()) {
            PathPoint pathpoint4 = this.path.func_1036_b();
            if (pathpoint4.posHash == pathpoint1.posHash) {
                return this.createEntityPath(pathpoint, pathpoint1);
            }
            if (pathpoint4.getMagnitude(pathpoint1) < pathpoint3.getMagnitude(pathpoint1)) {
                pathpoint3 = pathpoint4;
            }
            pathpoint4.field_1709_j = true;
            int i2 = this.findPathOptions(entity, pathpoint4, pathpoint2, pathpoint1, f2);
            int j2 = 0;
            while (j2 < i2) {
                PathPoint pathpoint5 = this.pathOptions[j2];
                float f1 = pathpoint4.field_1713_f + pathpoint4.getMagnitude(pathpoint5);
                if (!pathpoint5.func_1179_a() || f1 < pathpoint5.field_1713_f) {
                    pathpoint5.field_1710_i = pathpoint4;
                    pathpoint5.field_1713_f = f1;
                    pathpoint5.field_1712_g = pathpoint5.getMagnitude(pathpoint1);
                    if (pathpoint5.func_1179_a()) {
                        this.path.func_1035_a(pathpoint5, pathpoint5.field_1713_f + pathpoint5.field_1712_g);
                    } else {
                        pathpoint5.field_1711_h = pathpoint5.field_1713_f + pathpoint5.field_1712_g;
                        this.path.func_1034_a(pathpoint5);
                    }
                }
                ++j2;
            }
        }
        if (pathpoint3 == pathpoint) {
            return null;
        }
        return this.createEntityPath(pathpoint, pathpoint3);
    }

    private int findPathOptions(Entity entity, PathPoint pathpoint, PathPoint pathpoint1, PathPoint pathpoint2, float f2) {
        int i2 = 0;
        int j2 = 0;
        if (this.getVerticalOffset(entity, pathpoint.posX, pathpoint.posY + 1, pathpoint.posZ, pathpoint1) > 0) {
            j2 = 1;
        }
        PathPoint pathpoint3 = this.getSafePoint(entity, pathpoint.posX, pathpoint.posY, pathpoint.posZ + 1, pathpoint1, j2);
        PathPoint pathpoint4 = this.getSafePoint(entity, pathpoint.posX - 1, pathpoint.posY, pathpoint.posZ, pathpoint1, j2);
        PathPoint pathpoint5 = this.getSafePoint(entity, pathpoint.posX + 1, pathpoint.posY, pathpoint.posZ, pathpoint1, j2);
        PathPoint pathpoint6 = this.getSafePoint(entity, pathpoint.posX, pathpoint.posY, pathpoint.posZ - 1, pathpoint1, j2);
        if (pathpoint3 != null && !pathpoint3.field_1709_j && pathpoint3.getMagnitude(pathpoint2) < f2) {
            this.pathOptions[i2++] = pathpoint3;
        }
        if (pathpoint4 != null && !pathpoint4.field_1709_j && pathpoint4.getMagnitude(pathpoint2) < f2) {
            this.pathOptions[i2++] = pathpoint4;
        }
        if (pathpoint5 != null && !pathpoint5.field_1709_j && pathpoint5.getMagnitude(pathpoint2) < f2) {
            this.pathOptions[i2++] = pathpoint5;
        }
        if (pathpoint6 != null && !pathpoint6.field_1709_j && pathpoint6.getMagnitude(pathpoint2) < f2) {
            this.pathOptions[i2++] = pathpoint6;
        }
        return i2;
    }

    private PathPoint getSafePoint(Entity entity, int x2, int y2, int z2, PathPoint pathpoint, int l2) {
        PathPoint pathpoint1 = null;
        if (this.getVerticalOffset(entity, x2, y2, z2, pathpoint) > 0) {
            pathpoint1 = this.openPoint(x2, y2, z2);
        }
        if (pathpoint1 == null && this.getVerticalOffset(entity, x2, y2 + l2, z2, pathpoint) > 0) {
            pathpoint1 = this.openPoint(x2, y2 + l2, z2);
            y2 += l2;
        }
        if (pathpoint1 != null) {
            int i1 = 0;
            int j1 = 0;
            while (y2 > 0 && (j1 = this.getVerticalOffset(entity, x2, y2 - 1, z2, pathpoint)) > 0) {
                if (j1 < 0) {
                    return null;
                }
                if (++i1 >= 4) {
                    return null;
                }
                --y2;
            }
            if (y2 > 0) {
                pathpoint1 = this.openPoint(x2, y2, z2);
            }
        }
        return pathpoint1;
    }

    private final PathPoint openPoint(int x2, int y2, int z2) {
        int l2 = x2 | y2 << 10 | z2 << 20;
        PathPoint pathpoint = (PathPoint)this.pointMap.func_1057_a(l2);
        if (pathpoint == null) {
            pathpoint = new PathPoint(x2, y2, z2);
            this.pointMap.addKey(l2, pathpoint);
        }
        return pathpoint;
    }

    private int getVerticalOffset(Entity entity, int i2, int j2, int k2, PathPoint pathpoint) {
        int l2 = i2;
        while (l2 < i2 + pathpoint.posX) {
            int i1 = j2;
            while (i1 < j2 + pathpoint.posY) {
                int j1 = k2;
                while (j1 < k2 + pathpoint.posZ) {
                    Material material = this.worldMap.getMaterialXYZ(i2, j2, k2);
                    if (material.blocksMovement()) {
                        return 0;
                    }
                    if (material == Material.water || material == Material.lava) {
                        return -1;
                    }
                    ++j1;
                }
                ++i1;
            }
            ++l2;
        }
        return 1;
    }

    private PathEntity createEntityPath(PathPoint pathpoint, PathPoint pathpoint1) {
        int i2 = 1;
        PathPoint pathpoint2 = pathpoint1;
        while (pathpoint2.field_1710_i != null) {
            ++i2;
            pathpoint2 = pathpoint2.field_1710_i;
        }
        PathPoint[] apathpoint = new PathPoint[i2];
        PathPoint pathpoint3 = pathpoint1;
        apathpoint[--i2] = pathpoint3;
        while (pathpoint3.field_1710_i != null) {
            pathpoint3 = pathpoint3.field_1710_i;
            apathpoint[--i2] = pathpoint3;
        }
        return new PathEntity(apathpoint);
    }
}

