/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.item.ItemTool;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;

public class ItemPickaxe
extends ItemTool {
    private static Block[] pickaxeBreakList = new Block[]{Block.cobblestone, Block.stairDouble, Block.stairSingle, Block.stone, Block.cobblestoneMossy, Block.oreIron, Block.blockSteel, Block.oreCoal, Block.blockGold, Block.oreGold, Block.glass, Block.gear, Block.oreDiamond, Block.blockDiamond, Block.ice, Block.oreRed, Block.oreRedstoneGlowing, Block.stoneOvenIdle, Block.stoneOvenActive, Block.brick, Block.minecartTrack, Block.stairCompactStone, Block.oreCopper, Block.blockCopper, Block.brickMossy, Block.lightBulbOn, Block.lightBulb};
    private int miningPower;

    public ItemPickaxe(int i2, int miningPower) {
        super(i2, 2, miningPower, pickaxeBreakList);
        this.isGold = i2 == 27 || i2 == 28 || i2 == 29 || i2 == 30;
        this.miningPower = miningPower;
    }

    public boolean breaking(Block block) {
        if (block == Block.glass || block == Block.ice || block == Block.lightBulb || block == Block.lightBulbOn || block == Block.brickMossy) {
            return true;
        }
        if (block == Block.oreCopper) {
            return this.miningPower >= 2 && this.miningPower != 5;
        }
        if (block == Block.obsidian || block == Block.bleedingObsidian) {
            return this.miningPower >= 3;
        }
        if (block == Block.blockDiamond || block == Block.oreDiamond) {
            return this.miningPower >= 2 && this.miningPower != 5;
        }
        if (block == Block.blockGold || block == Block.oreGold) {
            return this.miningPower >= 2 && this.miningPower != 5;
        }
        if (block == Block.blockSteel || block == Block.oreIron) {
            return this.miningPower >= 1 && this.miningPower != 5;
        }
        if (block == Block.oreRed || block == Block.oreRedstoneGlowing) {
            return this.miningPower >= 2 && this.miningPower != 5;
        }
        if (block.blockMaterial == Material.rock) {
            return true;
        }
        return block.blockMaterial == Material.iron;
    }
}

