/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.IMobs;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntitySlime
extends EntityLiving
implements IMobs {
    public float field_768_a;
    public float field_767_b;
    private int slimeJumpDelay = 0;

    public EntitySlime(World world) {
        super(world);
        this.scoreYield = 25;
        int getSlimeSize = 1;
        this.texture = "/mob/slime.png";
        getSlimeSize = 1 << this.rand.nextInt(3);
        this.yOffset = 0.0f;
        this.slimeJumpDelay = this.rand.nextInt(20) + 10;
        this.setSlimeSize(getSlimeSize);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(1));
    }

    public void setSlimeSize(int i2) {
        this.dataWatcher.updateObject(16, new Byte((byte)i2));
        this.setSize(0.6f * (float)i2, 0.6f * (float)i2);
        this.health = i2 * i2;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public int getSlimeSize() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setInteger("Size", this.getSlimeSize() - 1);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSlimeSize(nbttagcompound.getInteger("Size") + 1);
    }

    public void onUpdate() {
        this.field_767_b = this.field_768_a;
        boolean flag = this.onGround;
        super.onUpdate();
        if (this.onGround && !flag) {
            int i2 = 0;
            while (i2 < this.getSlimeSize() * 8) {
                float f2 = this.rand.nextFloat() * 3.141593f * 2.0f;
                float f1 = this.rand.nextFloat() * 0.5f + 0.5f;
                float f22 = MathHelper.sin(f2) * (float)this.getSlimeSize() * 0.5f * f1;
                float f3 = MathHelper.cos(f2) * (float)this.getSlimeSize() * 0.5f * f1;
                this.worldObj.spawnParticle("slime", this.posX + (double)f22, this.boundingBox.minY, this.posZ + (double)f3, 0.0, 0.0, 0.0);
                ++i2;
            }
            if (this.getSlimeSize() > 2) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.func_413_f(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.field_768_a = -0.5f;
        }
        this.field_768_a *= 0.6f;
    }

    protected void updateEntityActionState() {
        EntityPlayer entityplayer = this.worldObj.getClosestPlayerToEntity(this, 16.0);
        if (entityplayer != null) {
            this.func_426_b(entityplayer, 10.0f);
        }
        if (this.onGround && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.rand.nextInt(20) + 10;
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.isJumping = true;
            if (this.getSlimeSize() > 1) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.func_413_f(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_768_a = 1.0f;
            this.movingLeftRight = 1.0f - this.rand.nextFloat() * 2.0f;
            this.movingForwardBack = 1 * this.getSlimeSize();
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.movingForwardBack = 0.0f;
                this.movingLeftRight = 0.0f;
            }
        }
    }

    public void setEntityDead() {
        if (!this.worldObj.multiplayerWorld && this.getSlimeSize() > 1 && this.health <= 0) {
            int i2 = 0;
            while (i2 < 4) {
                float f2 = ((float)(i2 % 2) - 0.5f) * (float)this.getSlimeSize() / 4.0f;
                float f1 = ((float)(i2 / 2) - 0.5f) * (float)this.getSlimeSize() / 4.0f;
                EntitySlime entityslime = new EntitySlime(this.worldObj);
                entityslime.setSlimeSize(this.getSlimeSize() / 2);
                entityslime.setLocationAndAngles(this.posX + (double)f2, this.posY + 0.5, this.posZ + (double)f1, this.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.entityJoinedWorld(entityslime);
                ++i2;
            }
        }
        super.setEntityDead();
    }

    public void onCollideWithPlayer(EntityPlayer entityplayer) {
        if (this.getSlimeSize() > 1 && this.canEntityBeSeen(entityplayer) && (double)this.getDistanceToEntity(entityplayer) < 0.6 * (double)this.getSlimeSize() && entityplayer.attackEntityFrom(this, this.getSlimeSize())) {
            this.worldObj.playSoundAtEntity(this, "mob.slimeattack", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected String hurtSound() {
        return "mob.slime";
    }

    protected String deathSound() {
        return "mob.slime";
    }

    protected int deathDropItem() {
        if (this.getSlimeSize() == 1) {
            return Item.slimeBall.shiftedIndex;
        }
        return 0;
    }

    public boolean func_433_a() {
        Chunk chunk = this.worldObj.getChunkFromBlockCoords(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY));
        return (this.getSlimeSize() == 1 || this.worldObj.difficulty > 0) && this.rand.nextInt(10) == 0 && chunk.func_997_a(987234911L).nextInt(10) == 0 && this.posY < 16.0;
    }

    protected float func_413_f() {
        return 0.6f;
    }
}

