/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.WorldClient;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntityTNTPrimed
extends Entity {
    public int field_689_a = 0;
    public static boolean extinguish = true;

    public EntityTNTPrimed(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.98f);
        this.yOffset = this.height / 2.0f;
    }

    public EntityTNTPrimed(World world, float f, float f1, float f2) {
        this(world);
        this.setPosition(f, f1, f2);
        float f3 = (float)(Math.random() * 3.1415927410125732 * 2.0);
        this.motionX = -MathHelper.sin(f3 * 3.141593f / 180.0f) * 0.02f;
        this.motionY = 0.2f;
        this.motionZ = -MathHelper.cos(f3 * 3.141593f / 180.0f) * 0.02f;
        this.field_640_aG = false;
        this.field_689_a = 80;
        this.prevPosX = f;
        this.prevPosY = f1;
        this.prevPosZ = f2;
    }

    protected void entityInit() {
    }

    public EntityTNTPrimed(WorldClient worldClient, double d, double d1, double d2) {
        this((World)worldClient, (float)d, (float)d1, (float)d2);
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.04f;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
        }
        if (this.field_689_a-- <= 0) {
            this.setEntityDead();
            this.explode();
        } else {
            this.worldObj.spawnParticle("smoke", this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0);
        }
    }

    public boolean attackEntityFrom(Entity damagesource, int i) {
        Entity entity = damagesource;
        if (this.isDead || !(damagesource instanceof EntityPlayer)) {
            return true;
        }
        this.worldObj.playSoundAtEntity(this, "dig.grass", 1.0f, 1.0f);
        this.setEntityDead();
        if (((EntityPlayer)entity).isCreative) {
            return true;
        }
        this.dropItemWithOffset(Block.tnt.blockID, 1, 0.0f);
        return true;
    }

    private void explode() {
        float f = 4.0f;
        this.worldObj.createExplosion(null, this.posX, this.posY, this.posZ, f);
    }

    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("Fuse", (byte)this.field_689_a);
    }

    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.field_689_a = nbttagcompound.getByte("Fuse");
    }

    public float getShadowSize() {
        return 0.0f;
    }
}

