/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.generate.WorldGenBigTree;
import com.mojang.minecraft.level.generate.WorldGenTrees;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.BlockFlower;
import java.util.Random;

public class BlockSapling
extends BlockFlower {
    protected BlockSapling(int i, int j) {
        super(i, j);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        if (world.multiplayerWorld) {
            return;
        }
        super.updateTick(world, i, j, k, random);
        if (world.getBlockLightValue(i, j + 1, k) >= 9 && random.nextInt(5) == 0) {
            int l = world.getBlockMetadata(i, j, k);
            if (l < 15) {
                world.setBlockMetadataWithNotify(i, j, k, l + 1);
            } else {
                world.setBlock(i, j, k, 0);
                WorldGenerator obj = new WorldGenTrees();
                if (random.nextInt(10) == 0) {
                    obj = new WorldGenBigTree();
                }
                if (!((WorldGenerator)obj).generate(world, random, i, j, k)) {
                    world.setBlock(i, j, k, this.blockID);
                }
            }
        }
    }

    public void growTree(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k) & 3;
        world.setBlock(i, j, k, 0);
        WorldGenerator obj = null;
        obj = new WorldGenTrees();
        if (random.nextInt(10) == 0) {
            obj = new WorldGenBigTree();
        }
        if (!((WorldGenerator)obj).generate(world, random, i, j, k)) {
            world.setBlockAndMetadata(i, j, k, this.blockID, l);
        }
    }
}

