/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;

public class ItemHoe
extends Item {
    public ItemHoe(int i, int j) {
        super(i);
        this.maxStackSize = 1;
        this.maxDamage = 32 << j;
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        int i1 = world.getBlockId(i, j, k);
        Material material = world.getMaterialXYZ(i, j + 1, k);
        if (!material.isSolidMaterial() && i1 == Block.grass.blockID || i1 == Block.dirt.blockID) {
            Block block = Block.tilledField;
            world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, block.stepSound.func_1145_d(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            if (world.multiplayerWorld) {
                return true;
            }
            world.setBlockWithNotify(i, j, k, block.blockID);
            itemstack.damageItem(1);
            if (world.rand.nextInt(8) == 0 && i1 == Block.grass.blockID) {
                int j1 = 1;
                int k1 = 0;
                while (k1 < j1) {
                    float f = 0.7f;
                    float f1 = world.rand.nextFloat() * f + (1.0f - f) * 0.5f;
                    float f2 = 1.2f;
                    float f3 = world.rand.nextFloat() * f + (1.0f - f) * 0.5f;
                    EntityItem entityitem = new EntityItem(world, (float)i + f1, (float)j + f2, (float)k + f3, new ItemStack(Item.seeds));
                    entityitem.delayBeforeCanPickup = 10;
                    world.entityJoinedWorld(entityitem);
                    ++k1;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_194_a() {
        return true;
    }
}

