/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.util.MathHelper;

public class EntityFX
extends Entity {
    protected int particleTextureIndex;
    protected float field_669_c;
    protected float field_668_d;
    protected int particleAge = 0;
    protected int particleMaxAge = 0;
    protected float particleScale;
    protected float field_664_h;
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    public static double field_660_l;
    public static double field_659_m;
    public static double field_658_n;

    public EntityFX(World world, double d, double d1, double d2, double d3, double d4, double d5) {
        super(world);
        this.setSize(0.2f, 0.2f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(d, d1, d2);
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.motionX = d3 + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.motionY = d4 + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.motionZ = d5 + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        float f = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float f1 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ);
        this.motionX = this.motionX / (double)f1 * (double)f * (double)0.4f;
        this.motionY = this.motionY / (double)f1 * (double)f * (double)0.4f + (double)0.1f;
        this.motionZ = this.motionZ / (double)f1 * (double)f * (double)0.4f;
        this.field_669_c = this.rand.nextFloat() * 3.0f;
        this.field_668_d = this.rand.nextFloat() * 3.0f;
        this.particleScale = (this.rand.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.particleMaxAge = (int)(4.0f / (this.rand.nextFloat() * 0.9f + 0.1f));
        this.particleAge = 0;
        this.field_640_aG = false;
    }

    public EntityFX func_407_b(float f) {
        this.motionX *= (double)f;
        this.motionY = (this.motionY - (double)0.1f) * (double)f + (double)0.1f;
        this.motionZ *= (double)f;
        return this;
    }

    public EntityFX func_405_d(float f) {
        this.setSize(0.2f * f, 0.2f * f);
        this.particleScale *= f;
        return this;
    }

    protected void entityInit() {
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setEntityDead();
        }
        this.motionY -= 0.04 * (double)this.field_664_h;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float f6 = (float)(this.particleTextureIndex % 16) / 16.0f;
        float f7 = f6 + 0.0624375f;
        float f8 = (float)(this.particleTextureIndex / 16) / 16.0f;
        float f9 = f8 + 0.0624375f;
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - field_660_l);
        float f12 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - field_659_m);
        float f13 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - field_658_n);
        float f14 = this.getEntityBrightness(f);
        tessellator.setColorOpaque_F(this.particleRed * f14, this.particleGreen * f14, this.particleBlue * f14);
        tessellator.addVertexWithUV(f11 - f1 * f10 - f4 * f10, f12 - f2 * f10, f13 - f3 * f10 - f5 * f10, f6, f9);
        tessellator.addVertexWithUV(f11 - f1 * f10 + f4 * f10, f12 + f2 * f10, f13 - f3 * f10 + f5 * f10, f6, f8);
        tessellator.addVertexWithUV(f11 + f1 * f10 + f4 * f10, f12 + f2 * f10, f13 + f3 * f10 + f5 * f10, f7, f8);
        tessellator.addVertexWithUV(f11 + f1 * f10 - f4 * f10, f12 - f2 * f10, f13 + f3 * f10 - f5 * f10, f7, f9);
    }

    public int func_404_c() {
        return 0;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
    }
}

