/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft;

import com.mojang.minecraft.MinecraftApplet;
import com.mojang.minecraft.MinecraftError;
import com.mojang.minecraft.MinecraftException;
import com.mojang.minecraft.MinecraftImpl;
import com.mojang.minecraft.Timer;
import com.mojang.minecraft.entity.EntityClientPlayerMP;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemRenderer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.model.ModelBiped;
import com.mojang.minecraft.enums.EnumOS2;
import com.mojang.minecraft.gui.GuiBuild;
import com.mojang.minecraft.gui.GuiChat;
import com.mojang.minecraft.gui.GuiConflictWarning;
import com.mojang.minecraft.gui.GuiConnecting;
import com.mojang.minecraft.gui.GuiGameOver;
import com.mojang.minecraft.gui.GuiGrayScreen;
import com.mojang.minecraft.gui.GuiIngame;
import com.mojang.minecraft.gui.GuiIngameMenu;
import com.mojang.minecraft.gui.GuiInventory;
import com.mojang.minecraft.gui.GuiMainMenu;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.gui.GuiUnused;
import com.mojang.minecraft.gui.LoadingScreenRenderer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkCoordinates;
import com.mojang.minecraft.level.chunk.ChunkProviderLoadOrGenerate;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.fx.TextureCompassFX;
import com.mojang.minecraft.level.tile.fx.TextureFlamesFX;
import com.mojang.minecraft.level.tile.fx.TextureGearFX;
import com.mojang.minecraft.level.tile.fx.TextureGearIdleFX;
import com.mojang.minecraft.level.tile.fx.TextureLavaFX;
import com.mojang.minecraft.level.tile.fx.TextureLavaFlowFX;
import com.mojang.minecraft.level.tile.fx.TextureWaterFX;
import com.mojang.minecraft.level.tile.fx.TextureWaterOverlayFX;
import com.mojang.minecraft.level.tile.fx.TexureWaterFlowFX;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.networknew.NetClientHandler;
import com.mojang.minecraft.player.controller.GameSettings;
import com.mojang.minecraft.player.controller.GameWindowListener;
import com.mojang.minecraft.player.controller.MouseHelper;
import com.mojang.minecraft.player.controller.MovementInputFromOptions;
import com.mojang.minecraft.player.controller.PlayerController;
import com.mojang.minecraft.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.render.EffectRenderer;
import com.mojang.minecraft.render.EntityRenderer;
import com.mojang.minecraft.render.FontRenderer;
import com.mojang.minecraft.render.GLAllocation;
import com.mojang.minecraft.render.OpenGlCapsChecker;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.render.RenderGlobal;
import com.mojang.minecraft.render.RenderManager;
import com.mojang.minecraft.render.ScaledResolution;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.render.WorldRenderer;
import com.mojang.minecraft.sound.SoundManager;
import com.mojang.minecraft.sound.ThreadDownloadResources;
import com.mojang.minecraft.util.MathHelper;
import com.mojang.minecraft.util.ScreenShotHelper;
import com.mojang.minecraft.util.Session;
import com.mojang.minecraft.util.ThreadSleepForever;
import com.mojang.minecraft.util.UnexpectedThrowable;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.File;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.util.glu.GLU;

public abstract class Minecraft
implements Runnable {
    public PlayerController playerController;
    private boolean field_184_a = false;
    public int displayWidth;
    public int displayHeight;
    private OpenGlCapsChecker field_147_L;
    private Timer field_146_M = new Timer(20.0f);
    public World mcWorld;
    public RenderGlobal field_179_f;
    public EntityPlayerSP thePlayer;
    public EntityLiving renderViewEntity;
    public EffectRenderer effectRenderer;
    public Session session = null;
    public String field_175_j;
    public Canvas field_174_k;
    public boolean field_173_l = true;
    public volatile boolean field_172_m = false;
    public RenderEngine renderEngine;
    public FontRenderer fontRender;
    public GuiScreen currentScreen = null;
    public LoadingScreenRenderer loadScreen = new LoadingScreenRenderer(this);
    public EntityRenderer field_167_r = new EntityRenderer(this);
    private ThreadDownloadResources field_145_N;
    private int field_144_O = 0;
    private int leftClickCounter = 0;
    private int field_142_Q;
    private int field_141_R;
    public String field_166_s = null;
    public int field_165_t = 0;
    public GuiIngame ingameGUI;
    public boolean field_163_v = false;
    public ModelBiped field_162_w = new ModelBiped(0.0f);
    public MovingObjectPosition objectMouseOver = null;
    public GameSettings options;
    protected MinecraftApplet field_159_z;
    public SoundManager soundMGR = new SoundManager();
    public MouseHelper field_157_B;
    public File field_156_C;
    public static long[] field_155_D = new long[512];
    public static int field_154_E = 0;
    private String field_140_S;
    private int field_139_T;
    private TextureWaterFX field_138_U = new TextureWaterFX();
    private TextureLavaFX field_137_V = new TextureLavaFX();
    private TextureWaterOverlayFX waterOverlay = new TextureWaterOverlayFX();
    private static File dataFolder = null;
    public volatile boolean field_153_F = true;
    public String field_152_G = "";
    boolean isTakingScreenshot;
    long field_151_H = -1L;
    public boolean field_150_I = false;
    private int field_135_X = 0;
    public boolean enableRain = false;
    long field_148_K = System.currentTimeMillis();
    private int field_134_Y = 0;
    private Vec3D savedPlayerPos;
    public static boolean isIRIX;
    public static boolean isMACOS;

    public Minecraft(Component component, Canvas canvas, MinecraftApplet minecraftapplet, int i, int j, boolean flag) {
        this.field_142_Q = i;
        this.field_141_R = j;
        this.field_184_a = flag;
        this.field_159_z = minecraftapplet;
        new ThreadSleepForever(this, "Timer hack thread");
        this.field_174_k = canvas;
        this.displayWidth = i;
        this.displayHeight = j;
        this.field_184_a = flag;
        this.savedPlayerPos = Vec3D.createVectorHelper(0.0, 128.0, 0.0);
        isIRIX = false;
        isMACOS = false;
    }

    public abstract void func_110_a(UnexpectedThrowable var1);

    public void func_121_a(String s, int i) {
        this.field_140_S = s;
        this.field_139_T = i;
    }

    public void startupScreen() throws LWJGLException {
        if (this.field_174_k != null) {
            Graphics g = this.field_174_k.getGraphics();
            if (g != null) {
                g.setColor(Color.BLACK);
                g.fillRect(0, 0, this.displayWidth, this.displayHeight);
                g.dispose();
            }
            Display.setParent((Canvas)this.field_174_k);
        } else if (this.field_184_a) {
            Display.setFullscreen((boolean)true);
            this.displayWidth = Display.getDisplayMode().getWidth();
            this.displayHeight = Display.getDisplayMode().getHeight();
            if (this.displayWidth <= 0) {
                this.displayWidth = 1;
            }
            if (this.displayHeight <= 0) {
                this.displayHeight = 1;
            }
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.displayWidth, this.displayHeight));
        }
        Display.setTitle((String)"Minecraft Alpha v1.1.11_11-1");
        try {
            PixelFormat pixelformat = new PixelFormat();
            pixelformat = pixelformat.withDepthBits(24);
            Display.create((PixelFormat)pixelformat);
        }
        catch (LWJGLException lwjglexception) {
            lwjglexception.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Display.create();
        }
        RenderManager.subManager.itemRenderer = new ItemRenderer(this);
        this.field_156_C = Minecraft.func_106_b();
        this.options = new GameSettings(this, this.field_156_C);
        this.renderEngine = new RenderEngine(this.options);
        this.fontRender = new FontRenderer(this.options, "/default.png", this.renderEngine);
        this.showMahjong();
        Keyboard.create();
        Mouse.create();
        this.field_157_B = new MouseHelper(this.field_174_k);
        try {
            Controllers.create();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.func_116_c("Pre startup");
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glCullFace((int)1029);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        this.func_116_c("Startup");
        this.field_147_L = new OpenGlCapsChecker();
        this.soundMGR.func_340_a(this.options);
        this.renderEngine.bindTextureFX(this.field_137_V);
        this.renderEngine.bindTextureFX(this.field_138_U);
        this.renderEngine.bindTextureFX(this.waterOverlay);
        this.renderEngine.bindTextureFX(new TextureCompassFX(this));
        this.renderEngine.bindTextureFX(new TexureWaterFlowFX());
        this.renderEngine.bindTextureFX(new TextureLavaFlowFX());
        this.renderEngine.bindTextureFX(new TextureFlamesFX(0));
        this.renderEngine.bindTextureFX(new TextureFlamesFX(1));
        this.renderEngine.bindTextureFX(new TextureGearFX(16));
        this.renderEngine.bindTextureFX(new TextureGearFX(17));
        this.renderEngine.bindTextureFX(new TextureGearIdleFX(0));
        this.renderEngine.bindTextureFX(new TextureGearIdleFX(1));
        this.field_179_f = new RenderGlobal(this, this.renderEngine);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        this.effectRenderer = new EffectRenderer(this.mcWorld, this.renderEngine);
        try {
            this.field_145_N = new ThreadDownloadResources(this.field_156_C, this);
            this.field_145_N.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.func_116_c("Post startup");
        this.ingameGUI = new GuiIngame(this);
        if (this.field_140_S != null) {
            this.setCurrentScreen(new GuiConnecting(this, this.field_140_S, this.field_139_T));
        } else {
            this.setCurrentScreen(new GuiGrayScreen());
        }
    }

    private void showMahjong() throws LWJGLException {
        ScaledResolution scaledresolution = new ScaledResolution(this.displayWidth, this.displayHeight, this);
        int i = scaledresolution.getScaledWidth();
        int j = scaledresolution.getScaledHeight();
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)i, (double)j, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)this.displayWidth, (int)this.displayHeight);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        if (!isMACOS) {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/mojang.png"));
        } else {
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/title/mojang_apple.png"));
        }
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xFFFFFF);
        tessellator.addVertexWithUV(0.0, this.displayHeight, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.displayWidth, this.displayHeight, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(this.displayWidth, 0.0, 0.0, 0.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
        int c = 256;
        int c1 = 256;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.setColorOpaque_I(0xFFFFFF);
        this.func_139_a((this.displayWidth / 2 - c) / 2, (this.displayHeight / 2 - c1) / 2, 0, 0, c, c1);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        Display.swapBuffers();
    }

    public void func_139_a(int i, int j, int k, int l, int i1, int j1) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(i + 0, j + j1, 0.0, (float)(k + 0) * f, (float)(l + j1) * f1);
        tessellator.addVertexWithUV(i + i1, j + j1, 0.0, (float)(k + i1) * f, (float)(l + j1) * f1);
        tessellator.addVertexWithUV(i + i1, j + 0, 0.0, (float)(k + i1) * f, (float)(l + 0) * f1);
        tessellator.addVertexWithUV(i + 0, j + 0, 0.0, (float)(k + 0) * f, (float)(l + 0) * f1);
        tessellator.draw();
    }

    public static File func_106_b() {
        if (dataFolder == null) {
            dataFolder = Minecraft.func_127_a("minecraft");
        }
        return dataFolder;
    }

    public static File func_127_a(String s) {
        File file;
        String s1 = System.getProperty("user.home", ".");
        switch (Minecraft.func_112_q()) {
            case linux: 
            case solaris: {
                file = new File(s1, '.' + s + '/');
                break;
            }
            case windows: {
                String s2 = System.getenv("APPDATA");
                if (s2 != null) {
                    file = new File(s2, "." + s + '/');
                    break;
                }
                file = new File(s1, '.' + s + '/');
                break;
            }
            case macos: {
                file = new File(s1, "Library/Application Support/" + s);
                break;
            }
            default: {
                file = new File(s1, s + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private static EnumOS2 func_112_q() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS2.windows;
        }
        if (s.contains("mac")) {
            isMACOS = true;
            if (s.contains("os 9")) {
                return EnumOS2.macos9;
            }
            return EnumOS2.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS2.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS2.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS2.linux;
        }
        if (s.contains("unix")) {
            return EnumOS2.linux;
        }
        if (s.contains("irix")) {
            isIRIX = true;
            return EnumOS2.irix;
        }
        return EnumOS2.unknown;
    }

    public void playChime() {
        if (isMACOS) {
            System.out.println("BONG");
            this.soundMGR.playSoundFX("random.mac_chord", 1.0f, 1.0f);
        }
    }

    public void setCurrentScreen(GuiScreen guiscreen) {
        if (this.currentScreen instanceof GuiUnused) {
            return;
        }
        if (this.currentScreen != null) {
            this.currentScreen.onGuiClosed();
        }
        if (guiscreen == null && this.mcWorld == null) {
            guiscreen = new GuiMainMenu();
        } else if (guiscreen == null && this.thePlayer.health <= 0) {
            guiscreen = new GuiGameOver();
        }
        this.currentScreen = guiscreen;
        if (guiscreen != null) {
            this.func_138_f();
            ScaledResolution scaledresolution = new ScaledResolution(this.displayWidth, this.displayHeight, this);
            int i = scaledresolution.getScaledWidth();
            int j = scaledresolution.getScaledHeight();
            guiscreen.setResolution(this, i, j);
            this.field_163_v = false;
        } else {
            this.func_123_e();
        }
    }

    private void func_116_c(String s) {
        int i = GL11.glGetError();
        if (i != 0) {
            String s1 = GLU.gluErrorString((int)i);
            System.out.println("########## GL ERROR ##########");
            System.out.println("@ " + s);
            System.out.println(i + ": " + s1);
            System.exit(0);
        }
    }

    public void func_130_c() {
        if (this.field_159_z != null) {
            this.field_159_z.func_101_c();
        }
        try {
            if (this.field_145_N != null) {
                this.field_145_N.func_1208_b();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("Stopping!");
            this.changeWorld1(null);
            try {
                GLAllocation.func_1126_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.soundMGR.func_330_b();
            Mouse.destroy();
            Keyboard.destroy();
        }
        finally {
            Display.destroy();
        }
        System.gc();
    }

    public void run() {
        this.field_153_F = true;
        try {
            this.startupScreen();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.func_110_a(new UnexpectedThrowable("Failed to start game", exception));
            return;
        }
        try {
            long l = System.currentTimeMillis();
            int i = 0;
            while (this.field_153_F && (this.field_159_z == null || this.field_159_z.isActive())) {
                AxisAlignedBB.func_1173_a();
                Vec3D.initialize();
                if (this.field_174_k == null && Display.isCloseRequested()) {
                    this.func_109_d();
                }
                if (this.field_172_m && this.mcWorld != null) {
                    float f = this.field_146_M.field_1378_c;
                    this.field_146_M.func_904_a();
                    this.field_146_M.field_1378_c = f;
                } else {
                    this.field_146_M.func_904_a();
                }
                int j = 0;
                while (j < this.field_146_M.field_1379_b) {
                    ++this.field_144_O;
                    try {
                        this.func_111_i();
                    }
                    catch (MinecraftException minecraftexception) {
                        this.mcWorld = null;
                        this.changeWorld1(null);
                        this.setCurrentScreen(new GuiConflictWarning());
                    }
                    ++j;
                }
                this.func_116_c("Pre render");
                this.soundMGR.func_338_a(this.thePlayer, this.field_146_M.field_1378_c);
                GL11.glEnable((int)3553);
                if (this.mcWorld != null) {
                    while (this.mcWorld.func_638_e()) {
                    }
                }
                if (!this.field_163_v) {
                    if (this.playerController != null) {
                        this.playerController.func_723_a(this.field_146_M.field_1378_c);
                    }
                    this.field_167_r.func_909_b(this.field_146_M.field_1378_c);
                }
                if (!Display.isActive()) {
                    if (this.field_184_a) {
                        this.func_133_h();
                    }
                    Thread.sleep(10L);
                }
                if (Keyboard.isKeyDown((int)65)) {
                    Display.update();
                }
                this.screenshotListener();
                if (Keyboard.isKeyDown((int)64)) {
                    this.func_135_r();
                } else {
                    this.field_151_H = System.nanoTime();
                }
                Thread.yield();
                Display.update();
                if (!(this.field_174_k == null || this.field_184_a || this.field_174_k.getWidth() == this.displayWidth && this.field_174_k.getHeight() == this.displayHeight)) {
                    this.displayWidth = this.field_174_k.getWidth();
                    this.displayHeight = this.field_174_k.getHeight();
                    if (this.displayWidth <= 0) {
                        this.displayWidth = 1;
                    }
                    if (this.displayHeight <= 0) {
                        this.displayHeight = 1;
                    }
                    this.func_115_a(this.displayWidth, this.displayHeight);
                }
                if (this.options.limitFramerate) {
                    Thread.sleep(10L);
                }
                this.func_116_c("Post render");
                ++i;
                this.field_172_m = !this.isServer() && this.currentScreen != null && this.currentScreen.doesGuiPauseGame();
                while (System.currentTimeMillis() >= l + 1000L) {
                    this.field_152_G = i + " fps, " + WorldRenderer.chunksUpdated + " chunk updates";
                    WorldRenderer.chunksUpdated = 0;
                    l += 1000L;
                    i = 0;
                }
            }
        }
        catch (MinecraftError l) {
        }
        catch (Throwable throwable) {
            this.mcWorld = null;
            throwable.printStackTrace();
            this.func_110_a(new UnexpectedThrowable("Unexpected error", throwable));
        }
    }

    private void screenshotListener() {
        if (Keyboard.isKeyDown((int)60)) {
            if (!this.isTakingScreenshot) {
                this.isTakingScreenshot = true;
                this.ingameGUI.addChatMessage(ScreenShotHelper.saveScreenshot(dataFolder, this.displayWidth, this.displayHeight));
            }
        } else {
            this.isTakingScreenshot = false;
        }
    }

    private void func_135_r() {
        if (this.field_151_H == -1L) {
            this.field_151_H = System.nanoTime();
        }
        long l = System.nanoTime();
        Minecraft.field_155_D[Minecraft.field_154_E++ & Minecraft.field_155_D.length - 1] = l - this.field_151_H;
        this.field_151_H = l;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.displayWidth, (double)this.displayHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_I(0x20200000);
        tessellator.addVertex(0.0, this.displayHeight - 100, 0.0);
        tessellator.addVertex(0.0, this.displayHeight, 0.0);
        tessellator.addVertex(field_155_D.length, this.displayHeight, 0.0);
        tessellator.addVertex(field_155_D.length, this.displayHeight - 100, 0.0);
        tessellator.draw();
        long l1 = 0L;
        int i = 0;
        while (i < field_155_D.length) {
            l1 += field_155_D[i];
            ++i;
        }
        int j = (int)(l1 / 200000L / (long)field_155_D.length);
        tessellator.startDrawing(7);
        tessellator.setColorOpaque_I(0x20400000);
        tessellator.addVertex(0.0, this.displayHeight - j, 0.0);
        tessellator.addVertex(0.0, this.displayHeight, 0.0);
        tessellator.addVertex(field_155_D.length, this.displayHeight, 0.0);
        tessellator.addVertex(field_155_D.length, this.displayHeight - j, 0.0);
        tessellator.draw();
        tessellator.startDrawing(1);
        int k = 0;
        while (k < field_155_D.length) {
            int i1 = (k - field_154_E & field_155_D.length - 1) * 255 / field_155_D.length;
            int j1 = i1 * i1 / 255;
            j1 = j1 * j1 / 255;
            int k1 = j1 * j1 / 255;
            k1 = k1 * k1 / 255;
            tessellator.setColorOpaque_I(-16777216 + k1 + j1 * 256 + i1 * 65536);
            long l2 = field_155_D[k] / 200000L;
            tessellator.addVertex((float)k + 0.5f, (float)((long)this.displayHeight - l2) + 0.5f, 0.0);
            tessellator.addVertex((float)k + 0.5f, (float)this.displayHeight + 0.5f, 0.0);
            ++k;
        }
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public void func_109_d() {
        this.field_153_F = false;
    }

    public void func_123_e() {
        if (!Display.isActive()) {
            return;
        }
        if (this.field_150_I) {
            return;
        }
        this.field_150_I = true;
        this.field_157_B.func_774_a();
        this.setCurrentScreen(null);
        this.field_135_X = this.field_144_O + 10000;
    }

    public void func_138_f() {
        if (!this.field_150_I) {
            return;
        }
        if (this.thePlayer != null) {
            this.thePlayer.func_458_k();
        }
        this.field_150_I = false;
        this.field_157_B.func_773_b();
    }

    public void func_117_g() {
        if (this.currentScreen != null) {
            return;
        }
        if (this.thePlayer != null && this.thePlayer.loopHandler != null) {
            this.thePlayer.loopHandler.killLoops();
        }
        this.setCurrentScreen(new GuiIngameMenu());
    }

    private void func_119_a(int i, boolean flag) {
        if (this.playerController.isCreative) {
            return;
        }
        if (i == 0 && this.leftClickCounter > 0) {
            return;
        }
        if (flag && this.objectMouseOver != null && this.objectMouseOver.typeOfHit == 0 && i == 0) {
            int j = this.objectMouseOver.blockX;
            int k = this.objectMouseOver.blockY;
            int l = this.objectMouseOver.blockZ;
            this.playerController.sendRemovingBlock(j, k, l, this.objectMouseOver.sideHit);
            this.effectRenderer.addBlockHitEffects(j, k, l, this.objectMouseOver.sideHit);
        } else {
            this.playerController.resetBlockRemoving();
        }
    }

    private void leftClick(int i) {
        ItemStack itemstack;
        if (i == 0 && this.leftClickCounter > 0) {
            return;
        }
        if (i == 0) {
            this.thePlayer.swingItem();
        }
        if (this.objectMouseOver == null) {
            if (i == 0 && !(this.playerController instanceof PlayerControllerCreative)) {
                this.leftClickCounter = 10;
            }
        } else if (this.objectMouseOver.typeOfHit == 1) {
            if (this.mcWorld.multiplayerWorld) {
                if (i == 0) {
                    this.playerController.attackEntity(this.thePlayer, this.objectMouseOver.entityHit);
                }
                if (i == 1) {
                    this.playerController.interactWithEntity(this.thePlayer, this.objectMouseOver.entityHit);
                }
            } else {
                if (i == 0) {
                    this.thePlayer.attackEntity(this.objectMouseOver.entityHit);
                }
                if (i == 1) {
                    this.thePlayer.useCurrentItemOnEntity(this.objectMouseOver.entityHit);
                }
            }
        } else if (this.objectMouseOver.typeOfHit == 0) {
            int j = this.objectMouseOver.blockX;
            int k = this.objectMouseOver.blockY;
            int i1 = this.objectMouseOver.blockZ;
            int j1 = this.objectMouseOver.sideHit;
            Block block = Block.allBlocks[this.mcWorld.getBlockId(j, k, i1)];
            if (i == 0) {
                this.mcWorld.func_612_i(j, k, i1, this.objectMouseOver.sideHit);
                if (block != Block.bedrock || this.thePlayer.field_777_c >= 100) {
                    this.playerController.clickBlock(j, k, i1, this.objectMouseOver.sideHit);
                }
            } else {
                int k1;
                ItemStack itemstack2 = this.thePlayer.inventory.getCurrentItem();
                int n = k1 = itemstack2 == null ? 0 : itemstack2.stackSize;
                if (this.playerController.sendPlaceBlock(this.thePlayer, this.mcWorld, itemstack2, j, k, i1, j1)) {
                    this.thePlayer.swingItem();
                }
                if (itemstack2 == null) {
                    return;
                }
                if (itemstack2.stackSize == 0 && !this.playerController.isCreative) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                } else if (itemstack2.stackSize != k1) {
                    this.field_167_r.field_1395_a.func_891_b();
                }
            }
        }
        if (i == 1 && (itemstack = this.thePlayer.inventory.getCurrentItem()) != null && this.playerController.sendUseItem(this.thePlayer, this.mcWorld, itemstack)) {
            int l = itemstack.stackSize;
            ItemStack itemstack1 = itemstack.useItemRightClick(this.mcWorld, this.thePlayer);
            if (this.playerController.isCreative) {
                itemstack1.stackSize = 1;
            }
            if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != l) {
                this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = itemstack1;
                this.field_167_r.field_1395_a.func_896_c();
                if (itemstack1.stackSize == 0) {
                    this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.currentItem] = null;
                }
            }
        }
    }

    public void func_133_h() {
        try {
            this.field_184_a = !this.field_184_a;
            System.out.println("Toggle fullscreen!");
            if (this.field_184_a) {
                Display.setDisplayMode((DisplayMode)Display.getDesktopDisplayMode());
                this.displayWidth = Display.getDisplayMode().getWidth();
                this.displayHeight = Display.getDisplayMode().getHeight();
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
            } else {
                if (this.field_174_k != null) {
                    this.displayWidth = this.field_174_k.getWidth();
                    this.displayHeight = this.field_174_k.getHeight();
                } else {
                    this.displayWidth = this.field_142_Q;
                    this.displayHeight = this.field_141_R;
                }
                if (this.displayWidth <= 0) {
                    this.displayWidth = 1;
                }
                if (this.displayHeight <= 0) {
                    this.displayHeight = 1;
                }
                Display.setDisplayMode((DisplayMode)new DisplayMode(this.field_142_Q, this.field_141_R));
            }
            this.func_138_f();
            Display.setFullscreen((boolean)this.field_184_a);
            Display.update();
            if (this.field_184_a) {
                this.func_123_e();
            }
            if (this.currentScreen != null) {
                this.func_138_f();
                this.func_115_a(this.displayWidth, this.displayHeight);
            }
            System.out.println("Size: " + this.displayWidth + ", " + this.displayHeight);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_115_a(int i, int j) {
        if (i <= 0) {
            i = 1;
        }
        if (j <= 0) {
            j = 1;
        }
        this.displayWidth = i;
        this.displayHeight = j;
        if (this.currentScreen != null) {
            ScaledResolution scaledresolution = new ScaledResolution(i, j, this);
            int k = scaledresolution.getScaledWidth();
            int l = scaledresolution.getScaledHeight();
            this.currentScreen.setResolution(this, k, l);
        }
    }

    private void pickBlock() {
        if (this.objectMouseOver != null) {
            int i = this.mcWorld.getBlockId(this.objectMouseOver.blockX, this.objectMouseOver.blockY, this.objectMouseOver.blockZ);
            if (i == Block.stairDouble.blockID) {
                i = Block.stairSingle.blockID;
            }
            if (i == Block.bedrock.blockID) {
                i = Block.stone.blockID;
            }
            if (i == Block.doorWood.blockID) {
                i = Item.doorWood.shiftedIndex;
            }
            if (i == Block.doorSteel.blockID) {
                i = Item.doorSteel.shiftedIndex;
            }
            if (i == Block.crops.blockID) {
                i = Item.seeds.shiftedIndex;
            }
            if (i == Block.pressurePlateWoodIdle.blockID) {
                i = Item.sign.shiftedIndex;
            }
            if (i == Block.signPost.blockID) {
                i = Item.sign.shiftedIndex;
            }
            if (i == Block.redstoneWire.blockID) {
                i = Item.redstone.shiftedIndex;
            }
            this.thePlayer.inventory.setCurrentItem(i, 1, this.playerController instanceof PlayerControllerCreative);
        }
    }

    public void func_111_i() {
        this.ingameGUI.func_555_a();
        this.field_167_r.func_910_a(1.0f);
        if (this.thePlayer != null) {
            this.thePlayer.func_462_n();
        }
        if (!this.field_172_m && this.mcWorld != null) {
            this.playerController.func_728_c();
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/terrain.png"));
        if (!this.field_172_m) {
            this.renderEngine.attachTextureFX();
        }
        if (this.currentScreen == null && this.thePlayer != null && this.thePlayer.health <= 0) {
            this.setCurrentScreen(null);
        }
        if (this.currentScreen != null) {
            this.field_135_X = this.field_144_O + 10000;
        }
        if (this.currentScreen != null) {
            this.currentScreen.func_564_d();
            if (this.currentScreen != null) {
                this.currentScreen.updateScreen();
            }
        }
        if (this.currentScreen == null || this.currentScreen.field_948_f) {
            while (Mouse.next()) {
                long l = System.currentTimeMillis() - this.field_148_K;
                if (l > 200L) continue;
                int j = Mouse.getEventDWheel();
                if (j != 0) {
                    this.thePlayer.inventory.changeCurrentItem(j);
                }
                if (this.currentScreen == null) {
                    if (!this.field_150_I && Mouse.getEventButtonState()) {
                        this.func_123_e();
                        continue;
                    }
                    if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState()) {
                        this.leftClick(0);
                        this.field_135_X = this.field_144_O;
                    }
                    if (Mouse.getEventButton() == 1 && Mouse.getEventButtonState()) {
                        this.leftClick(1);
                        this.field_135_X = this.field_144_O;
                    }
                    if (Mouse.getEventButton() != 2 || !Mouse.getEventButtonState()) continue;
                    this.pickBlock();
                    continue;
                }
                if (this.currentScreen == null) continue;
                this.currentScreen.func_566_e();
            }
            if (this.leftClickCounter > 0) {
                --this.leftClickCounter;
            }
            while (Keyboard.next()) {
                this.thePlayer.func_460_a(Keyboard.getEventKey(), Keyboard.getEventKeyState());
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 87) {
                    this.func_133_h();
                    continue;
                }
                if (this.currentScreen != null) {
                    this.currentScreen.handleKeyboardInput();
                } else {
                    if (Keyboard.getEventKey() == 1) {
                        this.func_117_g();
                    }
                    if (Keyboard.getEventKey() == 31 && Keyboard.isKeyDown((int)61)) {
                        this.func_129_t();
                    }
                    if (Keyboard.getEventKey() == 63) {
                        boolean bl = this.options.thirdPersonView = !this.options.thirdPersonView;
                    }
                    if (Keyboard.getEventKey() == 65) {
                        boolean bl = this.enableRain = !this.enableRain;
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindBuild.keyCode && this.thePlayer.isCreative) {
                        this.setCurrentScreen(new GuiBuild(this, 0));
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindInventory.keyCode) {
                        this.setCurrentScreen(new GuiInventory(this.thePlayer));
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindDrop.keyCode) {
                        if (this.thePlayer instanceof EntityClientPlayerMP) {
                            EntityClientPlayerMP entmp = (EntityClientPlayerMP)this.thePlayer;
                            entmp.dropCurrentItem();
                        } else {
                            this.thePlayer.dropInventory(this.thePlayer.inventory.decrStackSize(this.thePlayer.inventory.currentItem, 1), false);
                        }
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindChat.keyCode) {
                        this.setCurrentScreen(new GuiChat());
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindSaveLocation.keyCode && this.thePlayer.isCreative) {
                        this.savedPlayerPos = Vec3D.createVectorHelper(this.thePlayer.posX, this.thePlayer.posY, this.thePlayer.posZ);
                    }
                    if (Keyboard.getEventKey() == this.options.keyBindLoadLocation.keyCode && this.thePlayer.isCreative) {
                        this.thePlayer.setPosition(this.savedPlayerPos.xCoord, this.savedPlayerPos.yCoord, this.savedPlayerPos.zCoord);
                    }
                }
                int i = 0;
                while (i < 9) {
                    if (Keyboard.getEventKey() == 2 + i) {
                        this.thePlayer.inventory.currentItem = i;
                    }
                    ++i;
                }
                if (Keyboard.getEventKey() != this.options.keyBindToggleFog.keyCode) continue;
                this.options.func_1045_b(4, !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54) ? 1 : -1);
            }
            if (this.currentScreen == null) {
                if (Mouse.isButtonDown((int)0) && (float)(this.field_144_O - this.field_135_X) >= this.field_146_M.field_1380_a / 4.0f && this.field_150_I) {
                    this.leftClick(0);
                    this.field_135_X = this.field_144_O;
                }
                if (Mouse.isButtonDown((int)1) && (float)(this.field_144_O - this.field_135_X) >= this.field_146_M.field_1380_a / 4.0f && this.field_150_I) {
                    this.leftClick(1);
                    this.field_135_X = this.field_144_O;
                }
            }
            this.func_119_a(0, this.currentScreen == null && Mouse.isButtonDown((int)0) && this.field_150_I);
        }
        if (this.mcWorld != null) {
            if (this.thePlayer != null) {
                ++this.field_134_Y;
                if (this.field_134_Y == 30) {
                    this.field_134_Y = 0;
                    this.mcWorld.func_705_f(this.thePlayer);
                }
            }
            this.mcWorld.difficulty = this.options.difficulty;
            if (this.mcWorld.multiplayerWorld) {
                this.mcWorld.difficulty = this.mcWorld.multiplayerDifficulty;
            }
            if (!this.field_172_m) {
                this.field_167_r.func_911_a();
            }
            if (!this.field_172_m) {
                this.field_179_f.func_945_d();
            }
            if (!this.field_172_m) {
                this.mcWorld.updateEntityList();
            }
            if (!this.field_172_m || this.isServer()) {
                this.mcWorld.tick();
            }
            if (!this.field_172_m && this.mcWorld != null) {
                this.mcWorld.func_677_m(MathHelper.floor_double(this.thePlayer.posX), MathHelper.floor_double(this.thePlayer.posY), MathHelper.floor_double(this.thePlayer.posZ));
            }
            if (!this.field_172_m) {
                this.effectRenderer.updateEffects();
            }
        }
        this.field_148_K = System.currentTimeMillis();
    }

    private void func_129_t() {
        System.out.println("FORCING RELOAD!");
        this.soundMGR = new SoundManager();
        this.soundMGR.func_340_a(this.options);
        this.field_145_N.func_1210_a();
    }

    public boolean isServer() {
        return this.mcWorld != null && this.mcWorld.multiplayerWorld;
    }

    public void func_113_b(String s, boolean snowCovered, boolean cheatsEnabled, int worldType) {
        this.changeWorld1(null);
        System.gc();
        World world = new World(new File(Minecraft.func_106_b(), "NSSSsaves"), s, snowCovered, cheatsEnabled, worldType);
        if (world.field_1033_r) {
            this.func_105_a(world, "Generating level");
        } else {
            this.func_105_a(world, "Loading level");
        }
    }

    public void changeWorld1(World world) {
        this.func_105_a(world, "");
    }

    public void func_105_a(World world, String s) {
        this.soundMGR.playStreaming(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        if (this.mcWorld != null) {
            this.mcWorld.func_651_a(this.loadScreen);
        }
        this.mcWorld = world;
        if (world != null) {
            this.playerController.func_717_a(world);
            world.field_1038_m = this.fontRender;
            if (!this.isServer()) {
                this.thePlayer = (EntityPlayerSP)world.func_661_a(EntityPlayerSP.class);
            } else if (this.thePlayer != null) {
                this.thePlayer.preparePlayerToSpawn();
                if (world != null) {
                    world.entityJoinedWorld(this.thePlayer);
                }
            }
            if (!world.multiplayerWorld) {
                this.func_120_d(s);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(world);
                this.thePlayer.preparePlayerToSpawn();
                this.playerController.flipPlayer(this.thePlayer);
            }
            this.thePlayer.currentInput = new MovementInputFromOptions(this.options);
            if (this.field_179_f != null) {
                this.field_179_f.func_946_a(world);
            }
            if (this.effectRenderer != null) {
                this.effectRenderer.clearEffects(world);
            }
            this.playerController.initiateInventory(this.thePlayer);
            world.spawnPlayerWithLoadedChunks(this.thePlayer);
            if (world.field_1033_r) {
                world.func_651_a(this.loadScreen);
            }
        } else {
            this.thePlayer = null;
        }
        System.gc();
        this.field_148_K = 0L;
    }

    private void func_120_d(String s) {
        this.loadScreen.func_596_a(s);
        this.loadScreen.func_595_d("Building terrain");
        int questionMark = 128;
        int i = 0;
        int prog = questionMark * 2 / 16 + 1;
        prog *= prog;
        int k = -questionMark;
        while (k <= questionMark) {
            int spawnX = this.mcWorld.spawnX;
            int spawnZ = this.mcWorld.spawnZ;
            if (this.thePlayer != null) {
                spawnX = (int)this.thePlayer.posX;
                spawnZ = (int)this.thePlayer.posZ;
            }
            int j1 = -questionMark;
            while (j1 <= questionMark) {
                this.loadScreen.setProgess(i++ * 100 / prog);
                this.mcWorld.getBlockId(spawnX + k, 64, spawnZ + j1);
                j1 += 16;
            }
            k += 16;
        }
        System.out.println("Pass four");
        this.loadScreen.func_595_d("Simulating world for a bit");
        prog = 2000;
        this.mcWorld.func_656_j();
    }

    public void func_131_a(String s, File file) {
        int i = s.indexOf("/");
        String s1 = s.substring(0, i);
        s = s.substring(i + 1);
        if (s1.equalsIgnoreCase("sound")) {
            this.soundMGR.addToSoundPool(s, file);
        } else if (s1.equalsIgnoreCase("newsound")) {
            this.soundMGR.addToSoundPool(s, file);
        } else if (s1.equalsIgnoreCase("streaming")) {
            this.soundMGR.addToStreamingPool(s, file);
        } else if (s1.equalsIgnoreCase("music")) {
            this.soundMGR.addToMusicPool(s, file);
        } else if (s1.equalsIgnoreCase("newmusic")) {
            this.soundMGR.addToMusicPool(s, file);
        } else if (s1.equalsIgnoreCase("loops")) {
            this.soundMGR.addToLoopsPool(s, file);
        }
    }

    public OpenGlCapsChecker func_137_k() {
        return this.field_147_L;
    }

    public String func_122_l() {
        return this.field_179_f.func_953_b();
    }

    public String func_107_m() {
        return this.field_179_f.func_957_c();
    }

    public String func_125_n() {
        return "Particles: " + this.effectRenderer.func_1190_b() + (". Gfx: " + GL11.glGetString((int)7937) + " ") + this.mcWorld.func_687_d();
    }

    public void respawn() {
        this.mcWorld.func_622_a();
        if (this.thePlayer != null) {
            this.mcWorld.setEntityDead(this.thePlayer);
        }
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.mcWorld);
        this.thePlayer.preparePlayerToSpawn();
        this.playerController.flipPlayer(this.thePlayer);
        this.mcWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.currentInput = new MovementInputFromOptions(this.options);
        this.playerController.initiateInventory(this.thePlayer);
        this.func_120_d("Respawning");
    }

    public void respawn(boolean flag, int i) {
        System.out.println("RESPAWNING!");
        ChunkCoordinates chunkcoordinates = null;
        ChunkCoordinates chunkcoordinates1 = null;
        boolean flag1 = true;
        if (this.thePlayer != null && !flag && (chunkcoordinates = this.thePlayer.getPlayerSpawnCoordinate()) != null) {
            chunkcoordinates1 = EntityPlayer.func_25060_a(this.mcWorld, chunkcoordinates);
        }
        System.out.println("pass if 1");
        if (chunkcoordinates1 == null) {
            chunkcoordinates1 = this.mcWorld.getSpawnPoint();
            flag1 = false;
        }
        System.out.println("pass if 2");
        IChunkProvider ichunkprovider = this.mcWorld.chunkProvider;
        if (ichunkprovider instanceof ChunkProviderLoadOrGenerate) {
            ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)ichunkprovider;
            chunkproviderloadorgenerate.setCurrentChunkOver(chunkcoordinates1.x >> 4, chunkcoordinates1.z >> 4);
        }
        System.out.println("pass if 3");
        this.mcWorld.updateEntityList();
        int j = 0;
        if (this.thePlayer != null) {
            j = this.thePlayer.entityId;
            this.mcWorld.setEntityDead(this.thePlayer);
        }
        System.out.println("pass if 4");
        this.renderViewEntity = null;
        this.thePlayer = (EntityPlayerSP)this.playerController.createPlayer(this.mcWorld);
        this.renderViewEntity = this.thePlayer;
        this.thePlayer.preparePlayerToSpawn();
        if (flag1) {
            this.thePlayer.setPlayerSpawnCoordinate(chunkcoordinates);
            this.thePlayer.setLocationAndAngles((float)chunkcoordinates1.x + 0.5f, (float)chunkcoordinates1.y + 0.1f, (float)chunkcoordinates1.z + 0.5f, 0.0f, 0.0f);
        }
        System.out.println("pass if 5");
        this.playerController.flipPlayer(this.thePlayer);
        this.mcWorld.spawnPlayerWithLoadedChunks(this.thePlayer);
        this.thePlayer.currentInput = new MovementInputFromOptions(this.options);
        this.thePlayer.entityId = j;
        this.thePlayer.func_6420_o();
        this.playerController.initiateInventory(this.thePlayer);
        this.func_120_d("Respawning");
        if (this.currentScreen instanceof GuiGameOver) {
            this.setCurrentScreen(null);
        }
        System.out.println("pass if 6");
    }

    public static void func_132_a(String s, String s1) {
        Minecraft.func_118_a(s, s1, null);
    }

    public static void func_118_a(String s, String s1, String s2) {
        boolean flag = false;
        String s3 = s;
        Frame frame = new Frame("Minecraft");
        Canvas canvas = new Canvas();
        frame.setLayout(new BorderLayout());
        frame.add((Component)canvas, "Center");
        canvas.setPreferredSize(new Dimension(854, 480));
        frame.pack();
        frame.setLocationRelativeTo(null);
        MinecraftImpl minecraftimpl = new MinecraftImpl(frame, canvas, null, 854, 480, flag, frame);
        Thread thread = new Thread((Runnable)minecraftimpl, "Minecraft main thread");
        thread.setPriority(10);
        minecraftimpl.field_173_l = false;
        minecraftimpl.field_175_j = "www.minecraft.net";
        minecraftimpl.session = s3 != null && s1 != null ? new Session(s3, s1) : new Session("Player" + System.currentTimeMillis() % 1000L, "");
        if (s2 != null) {
            String[] as = s2.split(":");
            minecraftimpl.func_121_a(as[0], Integer.parseInt(as[1]));
        }
        frame.setVisible(true);
        frame.addWindowListener(new GameWindowListener(minecraftimpl, thread));
        thread.start();
    }

    public NetClientHandler getSendQueue() {
        if (this.thePlayer instanceof EntityClientPlayerMP) {
            return ((EntityClientPlayerMP)this.thePlayer).sendQueue;
        }
        return null;
    }

    public static void main(String[] args) {
        String s = "Player" + System.currentTimeMillis() % 1000L;
        if (args.length > 0) {
            s = args[0];
        }
        String s1 = "-";
        if (args.length > 1) {
            s1 = args[1];
        }
        Minecraft.func_132_a(s, s1);
    }
}

