/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.sound;

import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.player.controller.GameSettings;
import com.mojang.minecraft.sound.CodecMus;
import com.mojang.minecraft.sound.SoundPool;
import com.mojang.minecraft.sound.SoundPoolEntry;
import com.mojang.minecraft.util.MathHelper;
import java.io.File;
import java.util.Random;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

public class SoundManager {
    private static SoundSystem soundSystem;
    private SoundPool soundPool = new SoundPool();
    private SoundPool streamingPool = new SoundPool();
    private SoundPool musicPool = new SoundPool();
    private SoundPool loopsPool = new SoundPool();
    private int field_587_e = 0;
    public int ambienceCount = 0;
    private GameSettings settings;
    private static boolean loaded;
    private Random field_584_h = new Random();
    private int field_583_i = this.field_584_h.nextInt(12000);

    static {
        loaded = false;
    }

    public void initialize(GameSettings gamesettings) {
        this.streamingPool.field_1657_b = false;
        this.settings = gamesettings;
        if (!(loaded || gamesettings != null && gamesettings.soundVolume == 0.0f && gamesettings.musicVolume == 0.0f && gamesettings.ambienceVolume == 0.0f)) {
            this.init_second();
        }
    }

    private void init_second() {
        try {
            float soundVol = this.settings.soundVolume;
            float musicVol = this.settings.musicVolume;
            float ambienceVol = this.settings.ambienceVolume;
            this.settings.soundVolume = 0.0f;
            this.settings.musicVolume = 0.0f;
            this.settings.ambienceVolume = 0.0f;
            this.settings.save();
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            SoundSystemConfig.setCodec("ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec("mus", CodecMus.class);
            SoundSystemConfig.setCodec("wav", CodecWav.class);
            soundSystem = new SoundSystem();
            this.settings.soundVolume = soundVol;
            this.settings.musicVolume = musicVol;
            this.settings.ambienceVolume = ambienceVol;
            this.settings.save();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("error linking with the LibraryJavaSound plug-in");
        }
        loaded = true;
    }

    public void updateVolume() {
        if (soundSystem != null) {
            if (!(loaded || this.settings.soundVolume == 0.0f && this.settings.musicVolume == 0.0f && this.settings.ambienceVolume == 0.0f)) {
                this.init_second();
            }
            if (this.settings.musicVolume == 0.0f) {
                soundSystem.stop("BgMusic");
            } else {
                soundSystem.setVolume("BgMusic", this.settings.musicVolume);
                int i2 = 0;
                while (i2 <= this.ambienceCount) {
                    soundSystem.setVolume("Ambience_" + i2, this.settings.ambienceVolume);
                    ++i2;
                }
            }
        }
    }

    public void func_330_b() {
        if (loaded) {
            soundSystem.cleanup();
        }
    }

    public void addToSoundPool(String s2, File file) {
        this.soundPool.addSound(s2, file);
    }

    public void addToStreamingPool(String s2, File file) {
        this.streamingPool.addSound(s2, file);
    }

    public void addToMusicPool(String s2, File file) {
        this.musicPool.addSound(s2, file);
    }

    public void addToLoopsPool(String s2, File file) {
        this.loopsPool.addSound(s2, file);
    }

    public void func_341_c() {
        if (!loaded || this.settings.musicVolume == 0.0f) {
            return;
        }
        if (!soundSystem.playing("BgMusic") && !soundSystem.playing("streaming")) {
            if (this.field_583_i > 0) {
                --this.field_583_i;
                return;
            }
            SoundPoolEntry soundpoolentry = this.musicPool.func_1116_a();
            if (soundpoolentry != null) {
                this.field_583_i = this.field_584_h.nextInt(24000) + 24000;
                soundSystem.backgroundMusic("BgMusic", soundpoolentry.uniformResourceLocator, soundpoolentry.string, false);
                soundSystem.setVolume("BgMusic", this.settings.musicVolume);
                soundSystem.play("BgMusic");
            }
        }
    }

    public void func_338_a(EntityLiving entityliving, float f2) {
        if (!loaded || this.settings.soundVolume == 0.0f) {
            return;
        }
        if (entityliving == null) {
            return;
        }
        float f1 = entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * f2;
        double d2 = entityliving.prevPosX + (entityliving.posX - entityliving.prevPosX) * (double)f2;
        double d1 = entityliving.prevPosY + (entityliving.posY - entityliving.prevPosY) * (double)f2;
        double d22 = entityliving.prevPosZ + (entityliving.posZ - entityliving.prevPosZ) * (double)f2;
        float f22 = MathHelper.cos(-f1 * 0.01745329f - 3.141593f);
        float f3 = MathHelper.sin(-f1 * 0.01745329f - 3.141593f);
        float f4 = -f3;
        float f5 = 0.0f;
        float f6 = -f22;
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f9 = 0.0f;
        soundSystem.setListenerPosition((float)d2, (float)d1, (float)d22);
        soundSystem.setListenerOrientation(f4, f5, f6, f7, f8, f9);
    }

    public void playStreaming(String s2, float f2, float f1, float f22, float f3, float f4) {
        if (!loaded || this.settings.soundVolume == 0.0f) {
            return;
        }
        String s1 = "streaming";
        if (soundSystem.playing("streaming")) {
            soundSystem.stop("streaming");
        }
        if (s2 == null) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.streamingPool.cramIntoSoundPool(s2);
        if (soundpoolentry != null && f3 > 0.0f) {
            if (soundSystem.playing("BgMusic")) {
                soundSystem.stop("BgMusic");
            }
            float f5 = 16.0f;
            soundSystem.newStreamingSource(true, s1, soundpoolentry.uniformResourceLocator, soundpoolentry.string, false, f2, f1, f22, 2, f5 * 4.0f);
            soundSystem.setVolume(s1, 0.5f * this.settings.soundVolume);
            soundSystem.play(s1);
        }
    }

    public void playLoop(String loopName, float x2, float y2, float z2, float volume, float pitch) {
        if (!loaded || this.settings.ambienceVolume == 0.0f) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPool.cramIntoSoundPool(loopName);
        if (soundpoolentry != null) {
            this.field_587_e = (this.field_587_e + 1) % 256;
            String soundName = loopName;
            float volumeScale = 16.0f;
            if (volume > 1.0f) {
                volumeScale *= volume;
            }
            soundSystem.newSource(volume > 1.0f, soundName, soundpoolentry.uniformResourceLocator, soundpoolentry.string, false, x2, y2, z2, 2, volumeScale);
            soundSystem.setPitch(soundName, pitch);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            soundSystem.setVolume(soundName, volume * this.settings.ambienceVolume / 4.0f);
            soundSystem.play(soundName);
            soundSystem.setLooping(soundName, true);
            ++this.ambienceCount;
        }
    }

    public boolean isAmbienceEnabled() {
        return this.settings.ambienceVolume != 0.0f;
    }

    public void updateLoop(String loopName, float x2, float y2, float z2, float volume, float pitch) {
        if (!loaded || this.settings.ambienceVolume == 0.0f) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPool.cramIntoSoundPool(loopName);
        if (soundpoolentry != null && volume > 0.0f) {
            this.field_587_e = (this.field_587_e + 1) % 256;
            soundSystem.setPosition(loopName, x2, y2, z2);
            soundSystem.setPitch(loopName, pitch);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            soundSystem.setVolume(loopName, volume * this.settings.ambienceVolume / 4.0f);
            ++this.ambienceCount;
        }
        if (soundpoolentry == null) {
            System.out.println("The sound died! Trying to replay...");
            this.playLoop(loopName, x2, y2, z2, volume, pitch);
        }
    }

    public void playSound(String soundURL, float sourceX, float sourceY, float sourceZ, float volume, float pitch) {
        if (!loaded || this.settings.soundVolume == 0.0f) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPool.cramIntoSoundPool(soundURL);
        if (soundpoolentry != null && volume > 0.0f) {
            this.field_587_e = (this.field_587_e + 1) % 256;
            String s1 = "sound_" + this.field_587_e;
            float f5 = 16.0f;
            if (volume > 1.0f) {
                f5 *= volume;
            }
            soundSystem.newSource(volume > 1.0f, s1, soundpoolentry.uniformResourceLocator, soundpoolentry.string, false, sourceX, sourceY, sourceZ, 2, f5);
            soundSystem.setPitch(s1, pitch);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            soundSystem.setVolume(s1, volume * this.settings.soundVolume);
            soundSystem.play(s1);
        }
    }

    public void playSoundFX(String soundURL, float volume, float pitch) {
        if (!loaded || this.settings.soundVolume == 0.0f) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPool.cramIntoSoundPool(soundURL);
        if (soundpoolentry != null) {
            this.field_587_e = (this.field_587_e + 1) % 256;
            String s1 = "sound_" + this.field_587_e;
            soundSystem.newSource(false, s1, soundpoolentry.uniformResourceLocator, soundpoolentry.string, false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            soundSystem.setPitch(s1, pitch);
            soundSystem.setVolume(s1, (volume *= 0.25f) * this.settings.soundVolume);
            soundSystem.play(s1);
        }
    }

    public boolean getLoaded() {
        return loaded;
    }
}

