/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.render.RenderItem;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityRenderer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.chunk.ChunkCache;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.ICamera;
import com.mojang.minecraft.render.RenderBlocks;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldRenderer {
    public float distance;
    public World worldObj;
    private int glRenderList = -1;
    private static Tessellator tessellator;
    public static int chunksUpdated;
    public int posX;
    public int posY;
    public int posZ;
    public int sizeWidth;
    public int sizeHeight;
    public int sizeDepth;
    public int field_1755_i;
    public int field_1754_j;
    public int field_1753_k;
    public int field_1752_l;
    public int field_1751_m;
    public int field_1750_n;
    public boolean isInFrustrum = false;
    public boolean[] skipRenderPass = new boolean[2];
    public int field_1746_q;
    public int field_1743_r;
    public int field_1741_s;
    public float rendererRadius;
    public boolean needsUpdate;
    public AxisAlignedBB field_1736_v;
    public int chunkIndex;
    public boolean isVisible = true;
    public boolean isWaitingOnOcclusionQuery;
    public int field_1732_z;
    public boolean field_1747_A;
    private boolean isInitialized = false;
    public List<TileEntity> tileEntityRenderers = new ArrayList<TileEntity>();
    private List<TileEntity> tileEntities;
    static boolean traceDone;
    public int levelOfDetail;

    static {
        chunksUpdated = 0;
        traceDone = false;
        tessellator = Tessellator.instance;
    }

    public WorldRenderer(World world, List<TileEntity> list, int x2, int y2, int z2, int size, int renderList, int LOD) {
        this.worldObj = world;
        this.tileEntities = list;
        this.sizeHeight = this.sizeDepth = size;
        this.sizeWidth = this.sizeDepth;
        this.rendererRadius = MathHelper.sqrt_float(this.sizeWidth * this.sizeWidth + this.sizeHeight * this.sizeHeight + this.sizeDepth * this.sizeDepth) / 2.0f;
        this.glRenderList = renderList;
        this.posX = -999;
        this.setPosition(x2, y2, z2);
        this.needsUpdate = false;
        this.levelOfDetail = LOD;
    }

    public void setPosition(int i2, int j2, int k2) {
        if (i2 != this.posX || j2 != this.posY || k2 != this.posZ) {
            this.func_1195_b();
            this.posX = i2;
            this.posY = j2;
            this.posZ = k2;
            this.field_1746_q = i2 + this.sizeWidth / 2;
            this.field_1743_r = j2 + this.sizeHeight / 2;
            this.field_1741_s = k2 + this.sizeDepth / 2;
            this.field_1752_l = i2 & 0x3FF;
            this.field_1751_m = j2;
            this.field_1750_n = k2 & 0x3FF;
            this.field_1755_i = i2 - this.field_1752_l;
            this.field_1754_j = j2 - this.field_1751_m;
            this.field_1753_k = k2 - this.field_1750_n;
            float f2 = 2.0f;
            this.field_1736_v = AxisAlignedBB.getBoundingBox((float)i2 - f2, (float)j2 - f2, (float)k2 - f2, (float)(i2 + this.sizeWidth) + f2, (float)(j2 + this.sizeHeight) + f2, (float)(k2 + this.sizeDepth) + f2);
            GL11.glNewList((int)(this.glRenderList + 2), (int)4864);
            RenderItem.renderAABB(AxisAlignedBB.getBoundingBoxFromPool((float)this.field_1752_l - f2, (float)this.field_1751_m - f2, (float)this.field_1750_n - f2, (float)(this.field_1752_l + this.sizeWidth) + f2, (float)(this.field_1751_m + this.sizeHeight) + f2, (float)(this.field_1750_n + this.sizeDepth) + f2));
            GL11.glEndList();
            this.markDirty();
        }
    }

    private void setupGLTranslation() {
        GL11.glTranslatef((float)this.field_1752_l, (float)this.field_1751_m, (float)this.field_1750_n);
    }

    public void updateRenderer() {
        if (this.needsUpdate) {
            ++chunksUpdated;
            int minX = this.posX;
            int minY = this.posY;
            int minZ = this.posZ;
            int maxX = this.posX + this.sizeWidth;
            int maxY = this.posY + this.sizeHeight;
            int maxZ = this.posZ + this.sizeDepth;
            int k1 = 0;
            while (k1 < 2) {
                this.skipRenderPass[k1] = true;
                ++k1;
            }
            Chunk.isLit = false;
            HashSet<TileEntity> hashset = new HashSet<TileEntity>();
            hashset.addAll(this.tileEntityRenderers);
            this.tileEntityRenderers.clear();
            int bufferZone = 1;
            ChunkCache chunkcache = new ChunkCache(this.worldObj, minX - bufferZone, minY - bufferZone, minZ - bufferZone, maxX + bufferZone, maxY + bufferZone, maxZ + bufferZone);
            RenderBlocks renderblocks = new RenderBlocks(chunkcache);
            for (int passNumber = 0; passNumber < 2; ++passNumber) {
                boolean flag = false;
                boolean flag1 = false;
                boolean madeList = false;
                int y2 = minY;
                while (y2 < maxY) {
                    int z2 = minZ;
                    while (z2 < maxZ) {
                        int x2 = minX;
                        while (x2 < maxX) {
                            int i3 = chunkcache.getBlockId(x2, y2, z2);
                            if (i3 > 0) {
                                Block block;
                                int j3;
                                TileEntity tileentity;
                                if (!madeList) {
                                    madeList = true;
                                    GL11.glNewList((int)(this.glRenderList + passNumber), (int)4864);
                                    tessellator.setRenderingChunk(true);
                                    tessellator.startDrawingQuads();
                                }
                                if (passNumber == 0 && Block.isBlockContainer[i3] && TileEntityRenderer.instance.checkIfTileEntity(tileentity = chunkcache.getBlockTileEntity(x2, y2, z2))) {
                                    this.tileEntityRenderers.add(tileentity);
                                }
                                if ((j3 = (block = Block.allBlocks[i3]).getRenderBlockPass()) != passNumber) {
                                    flag = true;
                                } else if (j3 == passNumber) {
                                    flag1 |= renderblocks.renderBlockByRenderType(block, x2, y2, z2);
                                }
                            }
                            ++x2;
                        }
                        ++z2;
                    }
                    ++y2;
                }
                if (madeList) {
                    tessellator.draw();
                    GL11.glEndList();
                    tessellator.setRenderingChunk(false);
                } else {
                    flag1 = false;
                }
                if (flag1) {
                    this.skipRenderPass[passNumber] = false;
                }
                if (!flag) break;
            }
            HashSet<TileEntity> hashset1 = new HashSet<TileEntity>();
            hashset1.addAll(this.tileEntityRenderers);
            hashset1.removeAll(hashset);
            this.tileEntities.addAll(hashset1);
            hashset.removeAll(this.tileEntityRenderers);
            this.tileEntities.removeAll(hashset);
            this.field_1747_A = Chunk.isLit;
            this.isInitialized = true;
        }
    }

    public void updateRenderer_() {
        if (!this.needsUpdate) {
            return;
        }
        ++chunksUpdated;
        int minX = this.posX;
        int minY = this.posY;
        int minZ = this.posZ;
        int maxX = this.posX + this.sizeWidth;
        int maxY = this.posY + this.sizeHeight;
        int maxZ = this.posZ + this.sizeDepth;
        int k1 = 0;
        while (k1 < 2) {
            this.skipRenderPass[k1] = true;
            ++k1;
        }
        Chunk.isLit = false;
        HashSet<TileEntity> hashset = new HashSet<TileEntity>();
        hashset.addAll(this.tileEntityRenderers);
        this.tileEntityRenderers.clear();
        int bufferZone = 1;
        ChunkCache chunkcache = new ChunkCache(this.worldObj, minX - bufferZone, minY - bufferZone, minZ - bufferZone, maxX + bufferZone, maxY + bufferZone, maxZ + bufferZone);
        RenderBlocks renderblocks = new RenderBlocks(chunkcache);
        for (int passNumber = 0; passNumber < 2; ++passNumber) {
            boolean flag = false;
            boolean flag1 = false;
            boolean madeList = false;
            int y2 = minY;
            while (y2 < maxY) {
                int z2 = minZ;
                while (z2 < maxZ) {
                    int x2 = minX;
                    while (x2 < maxX) {
                        int blockId = chunkcache.getBlockId(x2, y2, z2);
                        if (blockId > 0) {
                            Block block;
                            int j3;
                            TileEntity tileentity;
                            if (!madeList) {
                                madeList = true;
                                GL11.glNewList((int)(this.glRenderList + passNumber), (int)4864);
                                GL11.glPushMatrix();
                                this.setupGLTranslation();
                                float f2 = 1.000001f;
                                GL11.glTranslatef((float)((float)(-this.sizeDepth) / 2.0f), (float)((float)(-this.sizeHeight) / 2.0f), (float)((float)(-this.sizeDepth) / 2.0f));
                                GL11.glScalef((float)f2, (float)f2, (float)f2);
                                GL11.glTranslatef((float)((float)this.sizeDepth / 2.0f), (float)((float)this.sizeHeight / 2.0f), (float)((float)this.sizeDepth / 2.0f));
                                tessellator.startDrawingQuads();
                                tessellator.setTranslationD(-this.posX, -this.posY, -this.posZ);
                            }
                            if (passNumber == 0 && Block.isBlockContainer[blockId] && TileEntityRenderer.instance.checkIfTileEntity(tileentity = chunkcache.getBlockTileEntity(x2, y2, z2))) {
                                this.tileEntityRenderers.add(tileentity);
                            }
                            if ((j3 = (block = Block.allBlocks[blockId]).getRenderBlockPass()) != passNumber) {
                                flag = true;
                            } else if (j3 == passNumber) {
                                flag1 |= renderblocks.renderBlockByRenderType(block, x2, y2, z2);
                            }
                        }
                        ++x2;
                    }
                    ++z2;
                }
                ++y2;
            }
            if (madeList) {
                tessellator.draw();
                GL11.glPopMatrix();
                GL11.glEndList();
                tessellator.setTranslationD(0.0, 0.0, 0.0);
            } else {
                flag1 = false;
            }
            if (flag1) {
                this.skipRenderPass[passNumber] = false;
            }
            if (!flag) break;
        }
        HashSet<TileEntity> hashset1 = new HashSet<TileEntity>();
        hashset1.addAll(this.tileEntityRenderers);
        hashset1.removeAll(hashset);
        this.tileEntities.addAll(hashset1);
        hashset.removeAll(this.tileEntityRenderers);
        this.tileEntities.removeAll(hashset);
        this.field_1747_A = Chunk.isLit;
        this.isInitialized = true;
        traceDone = true;
    }

    public float distanceToEntitySquared(Entity entity) {
        float f2 = (float)(entity.posX - (double)this.field_1746_q);
        float f1 = (float)(entity.posY - (double)this.field_1743_r);
        float f22 = (float)(entity.posZ - (double)this.field_1741_s);
        return f2 * f2 + f1 * f1 + f22 * f22;
    }

    public void func_1195_b() {
        int i2 = 0;
        while (i2 < 2) {
            this.skipRenderPass[i2] = true;
            ++i2;
        }
        this.isInFrustrum = false;
        this.isInitialized = false;
    }

    public void func_1204_c() {
        this.func_1195_b();
        this.worldObj = null;
    }

    public int getGLCallListForPass(int i2) {
        return this.isInFrustrum ? (this.skipRenderPass[i2] ? -1 : this.glRenderList + i2) : -1;
    }

    public void updateInFrustrum(ICamera icamera) {
        this.isInFrustrum = icamera.func_342_a(this.field_1736_v);
    }

    public void callOcclusionQueryList() {
        GL11.glCallList((int)(this.glRenderList + 2));
    }

    public boolean canRender() {
        return this.isInitialized ? this.skipRenderPass[0] && this.skipRenderPass[1] : false;
    }

    public void markDirty() {
        this.needsUpdate = true;
    }
}

