/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockSpongeInactive
extends Block {
    static final byte radius = 3;

    protected BlockSpongeInactive(int i2) {
        super(i2, Material.sponge);
        this.blockIndexInTexture = 48;
    }

    public int idDropped(int i2, Random random) {
        return Block.sponge.blockID;
    }

    public void onBlockAdded(World world, int a2, int b2, int c2) {
        super.onBlockAdded(world, a2, b2, c2);
        int x2 = a2 - 3;
        while (x2 <= a2 + 3) {
            int y2 = b2 - 3;
            while (y2 <= b2 + 3) {
                int z2 = c2 - 3;
                while (z2 <= c2 + 3) {
                    if (world.getBlockId(x2, y2, z2) == Block.waterMoving.blockID || world.getBlockId(x2, y2, z2) == Block.waterStill.blockID) {
                        world.setBlockAndMetadataWithNotify(x2, y2, z2, Block.waterMoving.blockID, world.getBlockMetadata(x2, y2, z2));
                    }
                    ++z2;
                }
                ++y2;
            }
            ++x2;
        }
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        if (!this.isReceivingRedstonePower(world, i2, j2, k2, l2)) {
            this.dropBlockAsItemWithChance(world, i2, j2, k2, 19);
            world.setBlockWithNotify(i2, j2, k2, 19);
        }
    }

    private boolean isReceivingRedstonePower(World world, int i2, int j2, int k2, int l2) {
        if (l2 != 0 && world.isBlockIndirectlyProvidingPowerTo(i2, j2 - 1, k2, 0)) {
            return true;
        }
        if (l2 != 1 && world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2, 1)) {
            return true;
        }
        if (l2 != 2 && world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 - 1, 2)) {
            return true;
        }
        if (l2 != 3 && world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 + 1, 3)) {
            return true;
        }
        if (l2 != 5 && world.isBlockIndirectlyProvidingPowerTo(i2 + 1, j2, k2, 5)) {
            return true;
        }
        if (l2 != 4 && world.isBlockIndirectlyProvidingPowerTo(i2 - 1, j2, k2, 4)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2, k2, 0)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 2, k2, 1)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2 - 1, 2)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2 + 1, 3)) {
            return true;
        }
        if (world.isBlockIndirectlyProvidingPowerTo(i2 - 1, j2 + 1, k2, 4)) {
            return true;
        }
        return world.isBlockIndirectlyProvidingPowerTo(i2 + 1, j2 + 1, k2, 5);
    }
}

