/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.enums.EnumMobType;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.List;
import java.util.Random;

public class BlockPressurePlate
extends Block {
    private EnumMobType field_467_a;

    protected BlockPressurePlate(int i2, int j2, EnumMobType enummobtype) {
        super(i2, j2, Material.rock);
        this.field_467_a = enummobtype;
        this.setTickOnLoad(true);
        float f2 = 0.0625f;
        this.setBlockBounds(f2, 0.0f, f2, 1.0f - f2, 0.03125f, 1.0f - f2);
    }

    public int tickRate() {
        return 20;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i2, int j2, int k2) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public boolean canPlace(World world, int i2, int j2, int k2) {
        if (world.getBlockId(i2, j2 - 1, k2) == Block.fence.blockID) {
            return true;
        }
        return world.isBlockNormalCube(i2, j2 - 1, k2);
    }

    public void onBlockAdded(World world, int i2, int j2, int k2) {
    }

    public void onNeighborBlockChange(World world, int i2, int j2, int k2, int l2) {
        boolean flag = false;
        if (!world.isBlockNormalCube(i2, j2 - 1, k2) && world.getBlockId(i2, j2 - 1, k2) != Block.fence.blockID) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(world, i2, j2, k2, world.getBlockMetadata(i2, j2, k2));
            world.setBlockWithNotify(i2, j2, k2, 0);
        }
    }

    public void updateTick(World world, int i2, int j2, int k2, Random random) {
        if (world.multiplayerWorld) {
            return;
        }
        if (world.getBlockMetadata(i2, j2, k2) == 0) {
            return;
        }
        this.func_318_h(world, i2, j2, k2);
    }

    public void onEntityCollidedWithBlock(World world, int i2, int j2, int k2, Entity entity) {
        if (world.multiplayerWorld) {
            return;
        }
        if (world.getBlockMetadata(i2, j2, k2) == 1) {
            return;
        }
        this.func_318_h(world, i2, j2, k2);
    }

    private void func_318_h(World world, int i2, int j2, int k2) {
        boolean flag = world.getBlockMetadata(i2, j2, k2) == 1;
        boolean flag1 = false;
        float f2 = 0.125f;
        List<Entity> list = null;
        if (this.field_467_a == EnumMobType.everything) {
            list = world.getEntitiesWithinAABBExcludingEntity(null, AxisAlignedBB.getBoundingBoxFromPool((float)i2 + f2, j2, (float)k2 + f2, (float)(i2 + 1) - f2, (double)j2 + 0.25, (float)(k2 + 1) - f2));
        }
        if (this.field_467_a == EnumMobType.mobs) {
            list = world.getEntitiesWithinAABB(EntityLiving.class, AxisAlignedBB.getBoundingBoxFromPool((float)i2 + f2, j2, (float)k2 + f2, (float)(i2 + 1) - f2, (double)j2 + 0.25, (float)(k2 + 1) - f2));
        }
        if (this.field_467_a == EnumMobType.players) {
            list = world.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBoxFromPool((float)i2 + f2, j2, (float)k2 + f2, (float)(i2 + 1) - f2, (double)j2 + 0.25, (float)(k2 + 1) - f2));
        }
        if (list.size() > 0) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            world.setBlockMetadataWithNotify(i2, j2, k2, 1);
            world.notifyBlocksOfNeighborChange(i2, j2, k2, this.blockID);
            world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
            world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
            world.playSoundEffect((double)i2 + 0.5, (double)j2 + 0.1, (double)k2 + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!flag1 && flag) {
            world.setBlockMetadataWithNotify(i2, j2, k2, 0);
            world.notifyBlocksOfNeighborChange(i2, j2, k2, this.blockID);
            world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
            world.markBlocksDirty(i2, j2, k2, i2, j2, k2);
            world.playSoundEffect((double)i2 + 0.5, (double)j2 + 0.1, (double)k2 + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (flag1) {
            world.scheduleUpdateTick(i2, j2, k2, this.blockID);
        }
    }

    public void onBlockRemoval(World world, int i2, int j2, int k2) {
        int l2 = world.getBlockMetadata(i2, j2, k2);
        if (l2 > 0) {
            world.notifyBlocksOfNeighborChange(i2, j2, k2, this.blockID);
            world.notifyBlocksOfNeighborChange(i2, j2 - 1, k2, this.blockID);
        }
        super.onBlockRemoval(world, i2, j2, k2);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i2, int j2, int k2) {
        boolean flag = iblockaccess.getBlockMetadata(i2, j2, k2) == 1;
        float f2 = 0.0625f;
        if (flag) {
            this.setBlockBounds(f2, 0.0f, f2, 1.0f - f2, 0.03125f, 1.0f - f2);
        } else {
            this.setBlockBounds(f2, 0.0f, f2, 1.0f - f2, 0.0625f, 1.0f - f2);
        }
    }

    public boolean isPoweringTo(IBlockAccess iblockaccess, int i2, int j2, int k2, int l2) {
        return iblockaccess.getBlockMetadata(i2, j2, k2) > 0;
    }

    public boolean isIndirectlyPoweringTo(World world, int i2, int j2, int k2, int l2) {
        if (world.getBlockMetadata(i2, j2, k2) == 0) {
            return false;
        }
        return l2 == 1;
    }

    public boolean canProvidePower() {
        return true;
    }

    public void setBlockBoundsForItemRender() {
        float f2 = 0.5f;
        float f1 = 0.125f;
        float f22 = 0.5f;
        this.setBlockBounds(0.5f - f2, 0.5f - f1, 0.5f - f22, 0.5f + f2, 0.5f + f1, 0.5f + f22);
    }
}

