/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFlower;
import java.util.Random;

public class BlockMushroom
extends BlockFlower {
    public static boolean spreading = true;

    protected BlockMushroom(int i2, int j2) {
        super(i2, j2);
        float f2 = 0.2f;
        this.setBlockBounds(0.5f - f2, 0.0f, 0.5f - f2, 0.5f + f2, f2 * 2.0f, 0.5f + f2);
        this.setTickOnLoad(true);
    }

    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par5Random.nextInt(25) == 0 && spreading) {
            int byte0 = 4;
            int i2 = 15;
            int j2 = par2 - byte0;
            while (j2 <= par2 + byte0) {
                int l2 = par4 - byte0;
                while (l2 <= par4 + byte0) {
                    int j1 = par3 - 1;
                    while (j1 <= par3 + 1) {
                        if (par1World.getBlockId(j2, j1, l2) == this.blockID && --i2 <= 0) {
                            return;
                        }
                        ++j1;
                    }
                    ++l2;
                }
                ++j2;
            }
            int k2 = par2 + par5Random.nextInt(3) - 1;
            int i1 = par3 + par5Random.nextInt(2) - par5Random.nextInt(2);
            int k1 = par4 + par5Random.nextInt(3) - 1;
            int l1 = 0;
            while (l1 < 4) {
                if (par1World.isAirBlock(k2, i1, k1) && this.canBlockStay(par1World, k2, i1, k1)) {
                    par2 = k2;
                    par3 = i1;
                    par4 = k1;
                }
                k2 = par2 + par5Random.nextInt(3) - 1;
                i1 = par3 + par5Random.nextInt(2) - par5Random.nextInt(2);
                k1 = par4 + par5Random.nextInt(3) - 1;
                ++l1;
            }
            if (par1World.isAirBlock(k2, i1, k1) && this.canBlockStay(par1World, k2, i1, k1)) {
                par1World.setBlockWithNotify(k2, i1, k1, this.blockID);
            }
        }
    }

    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return super.canPlace(par1World, par2, par3, par4) && this.canBlockStay(par1World, par2, par3, par4);
    }

    protected boolean canThisPlantGrowOnThisBlockID(int i2) {
        return Block.opaqueCubeLookup[i2];
    }

    public boolean canBlockStay(World world, int i2, int j2, int k2) {
        return world.getBlockLightValue(i2, j2, k2) <= 13 && this.canThisPlantGrowOnThisBlockID(world.getBlockId(i2, j2 - 1, k2));
    }
}

